/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.modularity;

import com.clarkparsia.modularity.locality.LocalityClass;
import com.clarkparsia.modularity.locality.SyntacticLocalityEvaluator;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.modularity.OntologySegmenter;
import org.semanticweb.owl.util.OWLEntityCollector;
import uk.ac.manchester.cs.owl.modularity.ModuleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntacticLocalityModuleExtractor
implements OntologySegmenter {
    protected ModuleType moduleType;
    protected OntologyAxiomSet ontologyAxiomSet;
    protected OWLOntology ontology;
    protected OWLOntologyManager manager;

    public SyntacticLocalityModuleExtractor(OWLOntologyManager man, OWLOntology ont, ModuleType moduleType) {
        this.setModuleType(moduleType);
        this.manager = man;
        this.ontology = ont;
        this.ontologyAxiomSet = new OntologyAxiomSet(ont);
    }

    public void setModuleType(ModuleType moduleType) {
        this.moduleType = moduleType;
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    protected boolean[] extract(boolean[] subOnt, Set<OWLEntity> signature, LocalityClass localityClass) {
        boolean[] mod = this.ontologyAxiomSet.getSubset(false);
        boolean[] q2 = this.ontologyAxiomSet.cloneSubset(subOnt);
        SyntacticLocalityEvaluator sle = new SyntacticLocalityEvaluator(localityClass);
        boolean change = true;
        while (change) {
            change = false;
            for (int i = 0; i < q2.length; ++i) {
                if (!q2[i] || sle.isLocal(this.ontologyAxiomSet.getAxiom(i), signature)) continue;
                mod[i] = true;
                q2[i] = false;
                int oldSize = signature.size();
                signature.addAll(this.ontologyAxiomSet.getAxiom(i).getSignature());
                if (signature.size() <= oldSize) continue;
                change = true;
            }
        }
        return mod;
    }

    protected Set<OWLAxiom> extract(Set<OWLAxiom> subOnt, Set<OWLEntity> signature, LocalityClass localityClass) {
        HashSet<OWLAxiom> mod = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> q2 = new HashSet<OWLAxiom>(subOnt);
        SyntacticLocalityEvaluator sle = new SyntacticLocalityEvaluator(localityClass);
        boolean change = true;
        while (change) {
            change = false;
            HashSet<OWLAxiom> q2remove = new HashSet<OWLAxiom>();
            for (OWLAxiom ax : q2) {
                if (sle.isLocal(ax, signature)) continue;
                mod.add(ax);
                q2remove.add(ax);
                int oldSize = signature.size();
                OWLEntityCollector entcoll = new OWLEntityCollector();
                ax.accept(entcoll);
                signature.addAll(entcoll.getObjects());
                if (signature.size() <= oldSize) continue;
                change = true;
            }
            q2.removeAll(q2remove);
        }
        return mod;
    }

    @Override
    public Set<OWLAxiom> extract(Set<OWLEntity> sig) {
        boolean[] mod;
        HashSet<OWLEntity> signature = new HashSet<OWLEntity>(sig);
        boolean[] subOnt = this.ontologyAxiomSet.getSubset(true);
        switch (this.moduleType) {
            case TOP: {
                mod = this.extract(subOnt, signature, LocalityClass.TOP_TOP);
                break;
            }
            case BOT: {
                mod = this.extract(subOnt, signature, LocalityClass.BOTTOM_BOTTOM);
                break;
            }
            case BOT_OF_TOP: {
                HashSet<OWLEntity> seedSig = new HashSet<OWLEntity>(signature);
                mod = this.extract(subOnt, seedSig, LocalityClass.TOP_TOP);
                subOnt = mod;
                mod = this.extract(subOnt, signature, LocalityClass.BOTTOM_BOTTOM);
                break;
            }
            case TOP_OF_BOT: {
                HashSet<OWLEntity> seedSig = new HashSet<OWLEntity>(signature);
                mod = this.extract(subOnt, seedSig, LocalityClass.BOTTOM_BOTTOM);
                subOnt = mod;
                mod = this.extract(subOnt, signature, LocalityClass.TOP_TOP);
                break;
            }
            default: {
                throw new RuntimeException("Undefined module type: " + (Object)((Object)this.moduleType));
            }
        }
        return this.ontologyAxiomSet.toSet(mod);
    }

    @Override
    public OWLOntology extractAsOntology(Set<OWLEntity> signature, URI uri) throws OWLOntologyCreationException, OWLOntologyChangeException {
        Set<OWLAxiom> axs = this.extract(signature);
        OWLOntology newOnt = this.manager.createOntology(uri);
        LinkedList<AddAxiom> addaxs = new LinkedList<AddAxiom>();
        for (OWLAxiom ax : axs) {
            addaxs.add(new AddAxiom(newOnt, ax));
        }
        this.manager.applyChanges(addaxs);
        return newOnt;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OntologyAxiomSet {
        protected OWLAxiom[] ax;
        protected OWLEntity[][] ent;

        public OntologyAxiomSet(OWLOntology ont) {
            this.ax = ont.getAxioms().toArray(new OWLAxiom[1]);
            this.ent = new OWLEntity[this.ax.length][];
        }

        public int size() {
            return this.ax.length;
        }

        public OWLAxiom getAxiom(int i) {
            return this.ax[i];
        }

        public OWLAxiom[] getAllAxioms() {
            return this.ax;
        }

        public OWLEntity[] getEntities(int i) {
            if (this.ent[i] == null) {
                OWLEntityCollector entcoll = new OWLEntityCollector();
                this.ax[i].accept(entcoll);
                this.ent[i] = entcoll.getObjects().toArray(new OWLEntity[1]);
            }
            return this.ent[i];
        }

        public Set<OWLAxiom> getAxiomSet(boolean[] isIn) {
            HashSet<OWLAxiom> gas = new HashSet<OWLAxiom>();
            for (int i = 0; i < isIn.length; ++i) {
                if (!isIn[i]) continue;
                gas.add(this.ax[i]);
            }
            return gas;
        }

        public boolean[] getSubset(boolean init) {
            boolean[] subset = new boolean[this.ax.length];
            for (int i = 0; i < this.ax.length; ++i) {
                subset[i] = init;
            }
            return subset;
        }

        public boolean[] cloneSubset(boolean[] oldSubset) {
            boolean[] newSubset = new boolean[this.ax.length];
            System.arraycopy(oldSubset, 0, newSubset, 0, this.ax.length);
            return newSubset;
        }

        public int subsetCardinality(boolean[] subset) {
            int card = 0;
            for (int i = 0; i < this.ax.length; ++i) {
                if (!subset[i]) continue;
                ++card;
            }
            return card;
        }

        public Set<OWLAxiom> toSet(boolean[] subset) {
            HashSet<OWLAxiom> axs = new HashSet<OWLAxiom>();
            for (int i = 0; i < this.ax.length; ++i) {
                if (!subset[i]) continue;
                axs.add(this.ax[i]);
            }
            return axs;
        }
    }
}

