/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app;

import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import nextapp.echo2.app.Style;

public class MutableStyle
implements Style {
    private static final int GROW_RATE = 10;
    private static final Object[] EMPTY = new Object[0];
    private Object[] data = EMPTY;
    int length = 0;

    public void addStyleContent(Style style) {
        Iterator nameIt = style.getPropertyNames();
        while (nameIt.hasNext()) {
            String name = (String)nameIt.next();
            Object value = style.getProperty(name);
            if (value instanceof IndexedPropertyValue) {
                IndexedPropertyValue indexedPropertyValue = (IndexedPropertyValue)value;
                Iterator indexIt = indexedPropertyValue.getIndices();
                while (indexIt.hasNext()) {
                    int index = (Integer)indexIt.next();
                    this.setIndexedProperty(name, index, indexedPropertyValue.getValue(index));
                }
                continue;
            }
            this.setProperty(name, value);
        }
    }

    public Object getIndexedProperty(String propertyName, int propertyIndex) {
        Object value = this.retrieveProperty(propertyName);
        if (!(value instanceof IndexedPropertyValue)) {
            return null;
        }
        return ((IndexedPropertyValue)value).getValue(propertyIndex);
    }

    public Object getProperty(String propertyName) {
        return this.retrieveProperty(propertyName);
    }

    public Iterator getPropertyIndices(String propertyName) {
        Object value = this.getProperty(propertyName);
        if (!(value instanceof IndexedPropertyValue)) {
            return null;
        }
        return ((IndexedPropertyValue)value).getIndices();
    }

    public Iterator getPropertyNames() {
        return new PropertyNameIterator();
    }

    public boolean isIndexedPropertySet(String propertyName, int index) {
        Object value = this.retrieveProperty(propertyName);
        if (!(value instanceof IndexedPropertyValue)) {
            return false;
        }
        return ((IndexedPropertyValue)value).hasValue(index);
    }

    public boolean isPropertySet(String propertyName) {
        int propertyNameHashCode = propertyName.hashCode();
        for (int i = 0; i < this.length; i += 2) {
            if (propertyNameHashCode != this.data[i].hashCode() || !propertyName.equals(this.data[i])) continue;
            return true;
        }
        return false;
    }

    public void removeIndexedProperty(String propertyName, int propertyIndex) {
        Object value = this.retrieveProperty(propertyName);
        if (!(value instanceof IndexedPropertyValue)) {
            return;
        }
        ((IndexedPropertyValue)value).removeValue(propertyIndex);
    }

    public void removeProperty(String propertyName) {
        int propertyNameHashCode = propertyName.hashCode();
        for (int i = 0; i < this.length; i += 2) {
            if (propertyNameHashCode != this.data[i].hashCode() || !propertyName.equals(this.data[i])) continue;
            this.data[i] = this.data[this.length - 2];
            this.data[i + 1] = this.data[this.length - 1];
            this.data[this.length - 2] = null;
            this.data[this.length - 1] = null;
            this.length -= 2;
            break;
        }
        if (this.length == 0) {
            this.data = EMPTY;
        }
    }

    private Object retrieveProperty(String propertyName) {
        int propertyNameHashCode = propertyName.hashCode();
        for (int i = 0; i < this.length; i += 2) {
            if (propertyNameHashCode != this.data[i].hashCode() || !propertyName.equals(this.data[i])) continue;
            return this.data[i + 1];
        }
        return null;
    }

    public void setIndexedProperty(String propertyName, int propertyIndex, Object propertyValue) {
        Object value = this.retrieveProperty(propertyName);
        if (!(value instanceof IndexedPropertyValue)) {
            value = new IndexedPropertyValue();
            this.setProperty(propertyName, value);
        }
        ((IndexedPropertyValue)value).setValue(propertyIndex, propertyValue);
    }

    public void setProperty(String propertyName, Object propertyValue) {
        if (propertyValue == null) {
            this.removeProperty(propertyName);
            return;
        }
        if (this.data == EMPTY) {
            this.data = new Object[10];
        }
        int propertyNameHashCode = propertyName.hashCode();
        for (int i = 0; i < this.data.length; i += 2) {
            if (this.data[i] == null) {
                this.data[i] = propertyName;
                this.data[i + 1] = propertyValue;
                this.length += 2;
                return;
            }
            if (propertyNameHashCode != this.data[i].hashCode() || !propertyName.equals(this.data[i])) continue;
            this.data[i + 1] = propertyValue;
            return;
        }
        Object[] newData = new Object[this.data.length + 10];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        newData[this.data.length] = propertyName;
        newData[this.data.length + 1] = propertyValue;
        this.length += 2;
        this.data = newData;
    }

    public int size() {
        return this.length / 2;
    }

    public String toString() {
        StringBuffer out = new StringBuffer("MutableStyle {");
        for (int i = 0; i < this.length; i += 2) {
            out.append(this.data[i]);
            out.append("=");
            out.append(this.data[i + 1]);
            if (i >= this.length - 2) continue;
            out.append(", ");
        }
        out.append("}");
        return out.toString();
    }

    public class IndexedPropertyValue
    implements Serializable {
        private SortedMap indicesToValues;

        public Object getValue(int index) {
            if (this.indicesToValues == null) {
                return null;
            }
            return this.indicesToValues.get(new Integer(index));
        }

        public Iterator getIndices() {
            return this.indicesToValues.keySet().iterator();
        }

        public boolean hasValue(int index) {
            return this.indicesToValues != null && this.indicesToValues.containsKey(new Integer(index));
        }

        private void removeValue(int index) {
            if (this.indicesToValues != null) {
                this.indicesToValues.remove(new Integer(index));
                if (this.indicesToValues.size() == 0) {
                    this.indicesToValues = null;
                }
            }
        }

        private void setValue(int index, Object value) {
            if (this.indicesToValues == null) {
                this.indicesToValues = new TreeMap();
            }
            this.indicesToValues.put(new Integer(index), value);
        }
    }

    private class PropertyNameIterator
    implements Iterator {
        private int index = 0;

        private PropertyNameIterator() {
        }

        public boolean hasNext() {
            return this.index < MutableStyle.this.length;
        }

        public Object next() {
            Object value = MutableStyle.this.data[this.index];
            this.index += 2;
            return value;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

