/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.StreamImageReference;

public class ResourceImageReference
extends StreamImageReference {
    private static final int BUFFER_SIZE = 4096;
    private static final Map extensionToContentType;
    private Extent width;
    private Extent height;
    private String contentType;
    private String resource;
    private String id;

    private static final String getContentType(String resourceName) {
        int extensionDelimiterPosition = resourceName.lastIndexOf(".");
        if (extensionDelimiterPosition == -1) {
            throw new IllegalArgumentException("Invalid file extension (resource has no extension: " + resourceName + ")");
        }
        String extension = resourceName.substring(extensionDelimiterPosition + 1).toLowerCase();
        String contentType = (String)extensionToContentType.get(extension);
        if (contentType == null) {
            throw new IllegalArgumentException("Invalid file extension (no matching content type: " + resourceName + ")");
        }
        return contentType;
    }

    public ResourceImageReference(String resource) {
        this(resource, null, null, null);
    }

    public ResourceImageReference(String resource, String contentType) {
        this(resource, contentType, null, null);
    }

    public ResourceImageReference(String resource, Extent width, Extent height) {
        this(resource, null, width, height);
    }

    public ResourceImageReference(String resource, String contentType, Extent width, Extent height) {
        this.resource = resource.charAt(0) == '/' ? resource.substring(1) : resource;
        this.contentType = contentType == null ? ResourceImageReference.getContentType(resource) : contentType;
        this.width = width;
        this.height = height;
        this.id = ApplicationInstance.generateSystemId();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResourceImageReference)) {
            return false;
        }
        ResourceImageReference that = (ResourceImageReference)o;
        if (!(this.resource == that.resource || this.resource != null && this.resource.equals(that.resource))) {
            return false;
        }
        if (!(this.contentType == that.contentType || this.contentType != null && this.contentType.equals(that.contentType))) {
            return false;
        }
        if (!(this.width == that.width || this.width != null && this.width.equals(that.width))) {
            return false;
        }
        return this.height == that.height || this.height != null && this.height.equals(that.height);
    }

    public String getContentType() {
        return this.contentType;
    }

    public Extent getHeight() {
        return this.height;
    }

    public String getRenderId() {
        return this.id;
    }

    public String getResource() {
        return this.resource;
    }

    public Extent getWidth() {
        return this.width;
    }

    public int hashCode() {
        return this.resource == null ? 0 : this.resource.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void render(OutputStream out) throws IOException {
        InputStream in = null;
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.resource);
            if (in == null) {
                throw new IllegalArgumentException("Specified resource does not exist: " + this.resource + ".");
            }
            do {
                if ((bytesRead = in.read(buffer)) <= 0) continue;
                out.write(buffer, 0, bytesRead);
            } while (bytesRead > 0);
            Object var6_5 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return;
        }
        catch (IOException ex) {}
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("gif", "image/gif");
        map.put("png", "image/png");
        map.put("jpeg", "image/jpeg");
        map.put("jpg", "image/jpg");
        map.put("bmp", "image/bmp");
        extensionToContentType = Collections.unmodifiableMap(map);
    }
}

