/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.componentxml;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ComponentIntrospector {
    private static final int CONSTANT_MODIFERS = 25;
    private static final Map classLoaderCache = new HashMap();
    private Class componentClass;
    private BeanInfo beanInfo;
    private Map constants;
    private Map propertyDescriptorMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentIntrospector forName(String typeName, ClassLoader classLoader) throws ClassNotFoundException {
        ComponentIntrospector ci;
        HashMap<String, ComponentIntrospector> ciStore;
        Map map = classLoaderCache;
        synchronized (map) {
            ciStore = (HashMap<String, ComponentIntrospector>)classLoaderCache.get(classLoader);
            if (ciStore == null) {
                ciStore = new HashMap<String, ComponentIntrospector>();
                classLoaderCache.put(classLoader, ciStore);
            }
        }
        HashMap<String, ComponentIntrospector> hashMap = ciStore;
        synchronized (hashMap) {
            ci = (ComponentIntrospector)ciStore.get(typeName);
            if (ci == null) {
                ci = new ComponentIntrospector(typeName, classLoader);
                ciStore.put(typeName, ci);
            }
        }
        return ci;
    }

    private ComponentIntrospector(String typeName, ClassLoader classLoader) throws ClassNotFoundException {
        this.componentClass = Class.forName(typeName, true, classLoader);
        try {
            this.beanInfo = Introspector.getBeanInfo(this.componentClass, 3);
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException("Introspection Error", ex);
        }
        this.loadConstants();
        this.loadPropertyData();
    }

    public Iterator getConstantNames() {
        return this.constants.keySet().iterator();
    }

    public Object getConstantValue(String constantName) {
        return this.constants.get(constantName);
    }

    public Class getObjectClass() {
        return this.componentClass;
    }

    public Class getPropertyClass(String propertyName) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(propertyName);
        if (propertyDescriptor == null) {
            return null;
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedPropertyType();
        }
        return propertyDescriptor.getPropertyType();
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return (PropertyDescriptor)this.propertyDescriptorMap.get(propertyName);
    }

    public Method getWriteMethod(String propertyName) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(propertyName);
        if (propertyDescriptor == null) {
            return null;
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedWriteMethod();
        }
        return propertyDescriptor.getWriteMethod();
    }

    public boolean isIndexedProperty(String propertyName) {
        return this.propertyDescriptorMap.get(propertyName) instanceof IndexedPropertyDescriptor;
    }

    private void loadConstants() {
        this.constants = new HashMap();
        Field[] fields = this.componentClass.getFields();
        for (int index = 0; index < fields.length; ++index) {
            if ((fields[index].getModifiers() & 0x19) == 0) continue;
            String constantName = fields[index].getName();
            try {
                Object constantValue = fields[index].get(null);
                this.constants.put(constantName, constantValue);
                continue;
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
    }

    private void loadPropertyData() {
        PropertyDescriptor[] propertyDescriptors = this.beanInfo.getPropertyDescriptors();
        for (int index = 0; index < propertyDescriptors.length; ++index) {
            String name;
            if (propertyDescriptors[index] instanceof IndexedPropertyDescriptor) {
                if (((IndexedPropertyDescriptor)propertyDescriptors[index]).getIndexedWriteMethod() == null) continue;
                name = propertyDescriptors[index].getName();
                this.propertyDescriptorMap.put(name, propertyDescriptors[index]);
                continue;
            }
            if (propertyDescriptors[index].getWriteMethod() == null) continue;
            name = propertyDescriptors[index].getName();
            this.propertyDescriptorMap.put(name, propertyDescriptors[index]);
        }
    }
}

