/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.BorderEx;
import echopointng.ComponentEx;
import echopointng.EPNG;
import echopointng.MutableStyleEx;
import echopointng.able.Attributeable;
import echopointng.able.Borderable;
import echopointng.able.Insetable;
import echopointng.able.MouseCursorable;
import echopointng.able.ScrollBarProperties;
import echopointng.able.Scrollable;
import echopointng.able.Sizeable;
import echopointng.able.ToolTipable;
import echopointng.table.DefaultLiveTableRenderer;
import echopointng.table.LiveTableRenderer;
import echopointng.table.LiveTableService;
import echopointng.util.ColorKit;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nextapp.echo2.app.table.DefaultTableModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import nextapp.echo2.app.table.TableModel;

public class LiveTable
extends Table
implements Sizeable,
Scrollable,
Borderable,
Insetable,
MouseCursorable,
ToolTipable,
Attributeable {
    public static final Style DEFAULT_STYLE;
    public static final String PROPERTY_PAGE_FETCH_SIZE = "pageFetchSize";
    public static final String PROPERTY_RENDERER = "renderer";
    public static final String PROPERTY_ROW_HEIGHT = "rowsHeight";
    public static final String PROPERTY_ROWS_PER_PAGE = "rowsPerPage";
    private Map attributeMap;

    public LiveTable() {
        this((TableModel)new DefaultTableModel());
    }

    public LiveTable(int columns, int rows) {
        this((TableModel)new DefaultTableModel(columns, rows));
    }

    public LiveTable(TableModel model) {
        this(model, null);
    }

    public LiveTable(TableModel model, TableColumnModel columnModel) {
        super(model, columnModel);
        this.setFocusTraversalParticipant(false);
    }

    public void dispose() {
        super.dispose();
        LiveTableService.INSTANCE.deregister(this);
    }

    protected void doRender() {
        int columnIndex;
        TableModel model = this.getModel();
        TableColumnModel columnModel = this.getColumnModel();
        this.removeAll();
        int columnCount = columnModel.getColumnCount();
        TableColumn[] tableColumns = new TableColumn[columnCount];
        for (columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            tableColumns[columnIndex] = columnModel.getColumn(columnIndex);
        }
        if (this.isHeaderVisible()) {
            for (columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                Component renderedComponent;
                TableCellRenderer headerRenderer;
                int modelColumnIndex = tableColumns[columnIndex].getModelIndex();
                Object headerValue = tableColumns[columnIndex].getHeaderValue();
                if (headerValue == null) {
                    headerValue = model.getColumnName(modelColumnIndex);
                }
                if ((headerRenderer = tableColumns[columnIndex].getHeaderRenderer()) == null && (headerRenderer = this.getDefaultHeaderRenderer()) == null) {
                    headerRenderer = DEFAULT_TABLE_CELL_RENDERER;
                }
                if ((renderedComponent = headerRenderer.getTableCellRendererComponent((Table)this, headerValue, modelColumnIndex, -1)) == null) {
                    renderedComponent = new Label();
                }
                this.add(renderedComponent);
            }
        }
    }

    private void fireActionEvent(Object value) {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
        ActionEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ActionEvent((Object)this, String.valueOf(value));
            }
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    public Object getAttribute(String attributeName) {
        if (this.attributeMap != null) {
            return this.attributeMap.get(attributeName);
        }
        return null;
    }

    public String[] getAttributeNames() {
        if (this.attributeMap == null) {
            return new String[0];
        }
        int count = 0;
        String[] attributeNames = new String[this.attributeMap.keySet().size()];
        Iterator iter = this.attributeMap.keySet().iterator();
        while (iter.hasNext()) {
            attributeNames[count++] = (String)iter.next();
        }
        return attributeNames;
    }

    public Extent getHeight() {
        return (Extent)this.getProperty("height");
    }

    public int getMouseCursor() {
        return ComponentEx.getProperty((Component)this, "mouseCursor", 0);
    }

    public String getMouseCursorUri() {
        return (String)this.getProperty("mouseCursorUri");
    }

    public Insets getOutsets() {
        return (Insets)this.getProperty("outsets");
    }

    public int getPageFetchSize() {
        return ComponentEx.getProperty((Component)this, PROPERTY_PAGE_FETCH_SIZE, 1);
    }

    public LiveTableRenderer getRenderer() {
        return (LiveTableRenderer)this.getProperty(PROPERTY_RENDERER);
    }

    public Extent getRowHeight() {
        return (Extent)this.getProperty(PROPERTY_ROW_HEIGHT);
    }

    public int getRowsPerPage() {
        return ComponentEx.getProperty((Component)this, PROPERTY_ROWS_PER_PAGE, 100);
    }

    public Color getScrollBarBaseColor() {
        return (Color)this.getProperty("scrollBarBaseColor");
    }

    public int getScrollBarPolicy() {
        return ComponentEx.getProperty((Component)this, "scrollBarPolicy", 4);
    }

    public ScrollBarProperties getScrollBarProperties() {
        return (ScrollBarProperties)this.getProperty("scrollBarProperties");
    }

    public String getToolTipText() {
        return (String)this.getProperty("toolTipText");
    }

    public void init() {
        super.init();
        LiveTableService.INSTANCE.register(this);
    }

    public void processInput(String name, Object value) {
        super.processInput(name, value);
        if ("click".equals(name)) {
            this.fireActionEvent(value);
        }
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap();
        }
        this.attributeMap.put(attributeName, attributeValue);
    }

    public void setHeight(Extent newValue) {
        this.setProperty("height", newValue);
    }

    public void setMouseCursor(int mouseCursor) {
        ComponentEx.setProperty((Component)this, "mouseCursor", mouseCursor);
    }

    public void setMouseCursorUri(String mouseCursorURI) {
        this.setProperty("mouseCursorUri", mouseCursorURI);
    }

    public void setOutsets(Insets newValue) {
        this.setProperty("outsets", newValue);
    }

    public void setPageFetchSize(int newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_PAGE_FETCH_SIZE, newValue);
    }

    public void setRenderer(LiveTableRenderer newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("You must provide a non null LiveTableRenderer to LiveTable!");
        }
        this.setProperty(PROPERTY_RENDERER, newValue);
    }

    public void setRowHeight(Extent newValue) {
        this.setProperty(PROPERTY_ROW_HEIGHT, newValue);
    }

    public void setRowsPerPage(int newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_ROWS_PER_PAGE, newValue);
    }

    public void setScrollBarBaseColor(Color newValue) {
        this.setProperty("scrollBarBaseColor", newValue);
    }

    public void setScrollBarPolicy(int newScrollBarPolicy) {
        ComponentEx.setProperty((Component)this, "scrollBarPolicy", newScrollBarPolicy);
    }

    public void setScrollBarProperties(ScrollBarProperties newValue) {
        this.setProperty("scrollBarProperties", newValue);
    }

    public void setToolTipText(String newValue) {
        this.setProperty("toolTipText", newValue);
    }

    public void validate() {
        super.validate();
        Style fallbackStyle = EPNG.getFallBackStyle((Component)this);
        Extent heightExtent = (Extent)this.getRenderProperty(PROPERTY_ROW_HEIGHT);
        if (heightExtent == null && fallbackStyle != null) {
            heightExtent = (Extent)fallbackStyle.getProperty(PROPERTY_ROW_HEIGHT);
        }
        if (heightExtent == null) {
            throw new IllegalStateException("The LiveTable must have a row height set in order to function correctly");
        }
        heightExtent = (Extent)this.getRenderProperty("height");
        if (heightExtent == null && fallbackStyle != null) {
            heightExtent = (Extent)fallbackStyle.getProperty("height");
        }
        if (heightExtent == null) {
            throw new IllegalStateException("The LiveTable must have a height set in order to function correctly");
        }
        LiveTableRenderer renderer = (LiveTableRenderer)this.getRenderProperty(PROPERTY_RENDERER);
        if (renderer == null && fallbackStyle != null) {
            renderer = (LiveTableRenderer)fallbackStyle.getProperty(PROPERTY_RENDERER);
        }
        if (renderer == null) {
            throw new IllegalStateException("The LiveTable must have LiveTableRenderer!");
        }
    }

    static {
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty("border", (Object)new BorderEx(ColorKit.makeColor("#ACBCDC")));
        style.setProperty("height", new Extent(400, 1));
        style.setProperty(PROPERTY_ROWS_PER_PAGE, 100);
        style.setProperty(PROPERTY_PAGE_FETCH_SIZE, 2);
        style.setProperty(PROPERTY_ROW_HEIGHT, new Extent(25));
        style.setProperty(PROPERTY_RENDERER, new DefaultLiveTableRenderer());
        style.setProperty("scrollBarPolicy", 4);
        DEFAULT_STYLE = style;
    }
}

