/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.AbleComponent;
import echopointng.BorderEx;
import echopointng.MutableStyleEx;
import echopointng.able.Expandable;
import echopointng.model.DefaultExpansionModel;
import echopointng.model.ExpansionGroup;
import echopointng.model.ExpansionModel;
import echopointng.util.ColorKit;
import echopointng.util.ComponentTracker;
import java.io.Serializable;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;

public class PopUp
extends AbleComponent
implements Expandable {
    public static final Alignment DEFAULT_ALIGNMENT = new Alignment(5, 6);
    public static final Style DEFAULT_STYLE;
    public static final ImageReference DEFAULT_TOGGLE_ICON;
    public static final ImageReference DEFAULT_TOGGLE_ROLLOVER_ICON;
    public static final ImageReference DEFAULT_TOGGLE_PRESSED_ICON;
    public static final String PROPERTY_FOCUS_COMPONENT = "focusComponent";
    public static final String PROPERTY_FOCUS_ON_EXPAND = "focusOnExpand";
    public static final String PROPERTY_POPUP = "popUp";
    public static final String PROPERTY_POPUP_ALIGNMENT = "popUpAlignment";
    public static final String PROPERTY_POPUP_ALWAYS_ON_TOP = "popUpAlwaysOnTop";
    public static final String PROPERTY_POPUP_BACKGROUND = "popUpBackground";
    public static final String PROPERTY_POPUP_BORDER = "popUpBorder";
    public static final String PROPERTY_POPUP_INSETS = "popUpInsets";
    public static final String PROPERTY_POPUP_LEFT_OFFSET = "popUpLeftOffset";
    public static final String PROPERTY_POPUP_NEXT_TO_TOGGLE = "popUpNextToToggle";
    public static final String PROPERTY_POPUP_ON_ROLLOVER = "popUpOnRollover";
    public static final String PROPERTY_POPUP_OUTSETS = "popUpOutSets";
    public static final String PROPERTY_POPUP_TOP_OFFSET = "popUpTopOffset";
    public static final String PROPERTY_ROLLOVER_BACKGROUND = "rolloverBackground";
    public static final String PROPERTY_ROLLOVER_BORDER = "rolloverRolloverBorder";
    public static final String PROPERTY_ROLLOVER_ENABLED = "rolloverEnabled";
    public static final String PROPERTY_TARGET = "target";
    public static final String PROPERTY_TARGET_BACKGROUND = "targetBackground";
    public static final String PROPERTY_TARGET_BORDER = "targetBorder";
    public static final String PROPERTY_TARGET_INSETS = "targetInsets";
    public static final String PROPERTY_TARGET_ROLLOVER_BACKGROUND = "targetRolloverBackground";
    public static final String PROPERTY_TARGET_ROLLOVER_BORDER = "targetRolloverBorder";
    public static final String PROPERTY_TOGGLE_BACKGROUND = "toggleBackground";
    public static final String PROPERTY_TOGGLE_BORDER = "toggleBorder";
    public static final String PROPERTY_TOGGLE_ICON = "toggleIcon";
    public static final String PROPERTY_TOGGLE_INSETS = "toggleInsets";
    public static final String PROPERTY_TOGGLE_PRESSED_BACKGROUND = "togglePressedBackground";
    public static final String PROPERTY_TOGGLE_PRESSED_BORDER = "togglePressedBorder";
    public static final String PROPERTY_TOGGLE_PRESSED_ENABLED = "togglePressedEnabled";
    public static final String PROPERTY_TOGGLE_PRESSED_ICON = "togglePressedIcon";
    public static final String PROPERTY_TOGGLE_ROLLOVER_BACKGROUND = "toggleRolloverBackground";
    public static final String PROPERTY_TOGGLE_ROLLOVER_BORDER = "toggleRolloverBorder";
    public static final String PROPERTY_TOGGLE_ROLLOVER_ICON = "toggleRolloverIcon";
    private InternallListener internalListener = new InternallListener();
    private ComponentTracker popUpTracker = new ComponentTracker(this);
    private ComponentTracker targetTracker = new ComponentTracker(this);

    public PopUp() {
        this(null, null);
    }

    public PopUp(Component targetComponent, Component popUpComponent) {
        this.setExpansionModel(new DefaultExpansionModel(false));
        this.setTarget(targetComponent);
        this.setPopUp(popUpComponent);
        this.setFocusComponent(popUpComponent);
    }

    public ExpansionGroup getExpansionGroup() {
        return (ExpansionGroup)this.getProperty("expansionGroup");
    }

    public ExpansionModel getExpansionModel() {
        return (ExpansionModel)this.getProperty("expansionModel");
    }

    public Component getPopUp() {
        return (Component)this.getProperty(PROPERTY_POPUP);
    }

    public Alignment getPopUpAlignment() {
        return (Alignment)this.getProperty(PROPERTY_POPUP_ALIGNMENT);
    }

    public boolean getPopUpAlwaysOnTop() {
        return this.getProperty(PROPERTY_POPUP_ALWAYS_ON_TOP, false);
    }

    public Color getPopUpBackground() {
        return (Color)this.getProperty(PROPERTY_POPUP_BACKGROUND);
    }

    public Border getPopUpBorder() {
        return (Border)this.getProperty(PROPERTY_POPUP_BORDER);
    }

    public Insets getPopUpInsets() {
        return (Insets)this.getProperty(PROPERTY_POPUP_INSETS);
    }

    public int getPopUpLeftOffset() {
        return this.getProperty(PROPERTY_POPUP_LEFT_OFFSET, 0);
    }

    public Insets getPopUpOutsets() {
        return (Insets)this.getProperty(PROPERTY_POPUP_OUTSETS);
    }

    public int getPopUpTopOffset() {
        return this.getProperty(PROPERTY_POPUP_TOP_OFFSET, 0);
    }

    public Color getRolloverBackground() {
        return (Color)this.getProperty(PROPERTY_ROLLOVER_BACKGROUND);
    }

    public Border getRolloverBorder() {
        return (Border)this.getProperty(PROPERTY_ROLLOVER_BORDER);
    }

    public Component getTarget() {
        return (Component)this.getProperty(PROPERTY_TARGET);
    }

    public Color getTargetBackground() {
        return (Color)this.getProperty(PROPERTY_TARGET_BACKGROUND);
    }

    public Border getTargetBorder() {
        return (Border)this.getProperty(PROPERTY_TARGET_BORDER);
    }

    public Insets getTargetInsets() {
        return (Insets)this.getProperty(PROPERTY_TARGET_INSETS);
    }

    public Color getTargetRolloverBackground() {
        return (Color)this.getProperty(PROPERTY_TARGET_ROLLOVER_BACKGROUND);
    }

    public Border getTargetRolloverBorder() {
        return (Border)this.getProperty(PROPERTY_TARGET_ROLLOVER_BORDER);
    }

    public Color getToggleBackground() {
        return (Color)this.getProperty(PROPERTY_TOGGLE_BACKGROUND);
    }

    public Border getToggleBorder() {
        return (Border)this.getProperty(PROPERTY_TOGGLE_BORDER);
    }

    public ImageReference getToggleIcon() {
        return (ImageReference)this.getProperty(PROPERTY_TOGGLE_ICON);
    }

    public Insets getToggleInsets() {
        return (Insets)this.getProperty(PROPERTY_TOGGLE_INSETS);
    }

    public Color getTogglePressedBackground() {
        return (Color)this.getProperty(PROPERTY_TOGGLE_PRESSED_BACKGROUND);
    }

    public Border getTogglePressedBorder() {
        return (Border)this.getProperty(PROPERTY_TOGGLE_PRESSED_BORDER);
    }

    public ImageReference getTogglePressedIcon() {
        return (ImageReference)this.getProperty(PROPERTY_TOGGLE_PRESSED_ICON);
    }

    public Color getToggleRolloverBackground() {
        return (Color)this.getProperty(PROPERTY_TOGGLE_ROLLOVER_BACKGROUND);
    }

    public Border getToggleRolloverBorder() {
        return (Border)this.getProperty(PROPERTY_TOGGLE_ROLLOVER_BORDER);
    }

    public ImageReference getToggleRolloverIcon() {
        return (ImageReference)this.getProperty(PROPERTY_TOGGLE_ROLLOVER_ICON);
    }

    public boolean isExpanded() {
        return this.getExpansionModel() == null ? false : this.getExpansionModel().isExpanded();
    }

    public boolean isPopUpNextToToggle() {
        return this.getProperty(PROPERTY_POPUP_NEXT_TO_TOGGLE, true);
    }

    public boolean isPopUpOnRollover() {
        return this.getProperty(PROPERTY_POPUP_ON_ROLLOVER, true);
    }

    public boolean isRolloverEnabled() {
        Boolean value = (Boolean)this.getProperty(PROPERTY_ROLLOVER_ENABLED);
        return value == null ? false : value;
    }

    public boolean isTogglePressedEnabled() {
        Boolean value = (Boolean)this.getProperty(PROPERTY_TOGGLE_PRESSED_ENABLED);
        return value == null ? false : value;
    }

    public void processInput(String inputName, Object inputValue) {
        boolean expanded = (Boolean)inputValue;
        this.setExpanded(expanded);
    }

    public void setExpanded(boolean isExpanded) {
        if (this.getExpansionModel() != null) {
            this.getExpansionModel().setExpanded(isExpanded);
        }
    }

    public void setExpansionGroup(ExpansionGroup newExpansionGroup) {
        ExpansionGroup oldValue = this.getExpansionGroup();
        if (oldValue != null) {
            oldValue.removeExpandable(this);
        }
        if (newExpansionGroup != null) {
            newExpansionGroup.addExpandable(this);
        }
        this.setProperty("expansionGroup", newExpansionGroup);
    }

    public void setExpansionModel(ExpansionModel newValue) {
        ExpansionModel oldValue = this.getExpansionModel();
        if (oldValue != null) {
            oldValue.removeChangeListener(this.internalListener);
        }
        if (newValue != null) {
            newValue.addChangeListener(this.internalListener);
        }
        this.setProperty("expansionModel", newValue);
    }

    public void setPopUp(Component newValue) {
        this.setProperty(PROPERTY_POPUP, newValue);
        this.popUpTracker.removeAll();
        this.setFocusComponent(newValue);
        if (newValue != null) {
            this.popUpTracker.add(newValue);
        }
    }

    public void setPopUpAlignment(Alignment newValue) {
        if (newValue == null) {
            newValue = DEFAULT_ALIGNMENT;
        }
        switch (newValue.getHorizontal()) {
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The horizontal alignment must be LEFT, CENTER or RIGHT");
            }
        }
        switch (newValue.getVertical()) {
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The vertical alignment must be TOP, CENTER or BOTTOM");
            }
        }
        this.setProperty(PROPERTY_POPUP_ALIGNMENT, newValue);
    }

    public void setPopUpAlwaysOnTop(boolean newValue) {
        this.setProperty(PROPERTY_POPUP_ALWAYS_ON_TOP, newValue);
    }

    public void setPopUpBackground(Color newValue) {
        this.setProperty(PROPERTY_POPUP_BACKGROUND, newValue);
    }

    public void setPopUpBorder(Border newValue) {
        this.setProperty(PROPERTY_POPUP_BORDER, newValue);
    }

    public void setPopUpInsets(Insets newValue) {
        this.setProperty(PROPERTY_POPUP_INSETS, newValue);
    }

    public void setPopUpLeftOffset(int newValue) {
        this.setProperty(PROPERTY_POPUP_LEFT_OFFSET, newValue);
    }

    public void setPopUpNextToToggle(boolean newValue) {
        this.setProperty(PROPERTY_POPUP_NEXT_TO_TOGGLE, newValue);
    }

    public void setPopUpOnRollover(boolean newValue) {
        this.setProperty(PROPERTY_POPUP_ON_ROLLOVER, newValue);
    }

    public void setPopUpOutsets(Insets newValue) {
        this.setProperty(PROPERTY_POPUP_OUTSETS, newValue);
    }

    public void setPopUpTopOffset(int newValue) {
        this.setProperty(PROPERTY_POPUP_TOP_OFFSET, newValue);
    }

    public void setRolloverBackground(Color newValue) {
        this.setProperty(PROPERTY_ROLLOVER_BACKGROUND, newValue);
    }

    public void setRolloverBorder(Border newValue) {
        this.setProperty(PROPERTY_ROLLOVER_BORDER, newValue);
    }

    public void setRolloverEnabled(boolean newValue) {
        this.setProperty(PROPERTY_ROLLOVER_ENABLED, newValue);
    }

    public void setTarget(Component newValue) {
        this.setProperty(PROPERTY_TARGET, newValue);
        this.targetTracker.removeAll();
        if (newValue != null) {
            this.targetTracker.add(newValue);
        }
    }

    public void setTargetBackground(Color newValue) {
        this.setProperty(PROPERTY_TARGET_BACKGROUND, newValue);
    }

    public void setTargetBorder(Border newValue) {
        this.setProperty(PROPERTY_TARGET_BORDER, newValue);
    }

    public void setTargetInsets(Insets newValue) {
        this.setProperty(PROPERTY_TARGET_INSETS, newValue);
    }

    public void setTargetRolloverBackground(Color newValue) {
        this.setProperty(PROPERTY_TARGET_ROLLOVER_BACKGROUND, newValue);
    }

    public void setTargetRolloverBorder(Border newValue) {
        this.setProperty(PROPERTY_TARGET_ROLLOVER_BORDER, newValue);
    }

    public void setToggleBackground(Color newValue) {
        this.setProperty(PROPERTY_TOGGLE_BACKGROUND, newValue);
    }

    public void setToggleBorder(Border newValue) {
        this.setProperty(PROPERTY_TOGGLE_BORDER, newValue);
    }

    public void setToggleIcon(ImageReference newValue) {
        this.setProperty(PROPERTY_TOGGLE_ICON, newValue);
    }

    public void setToggleInsets(Insets newValue) {
        this.setProperty(PROPERTY_TOGGLE_INSETS, newValue);
    }

    public void setTogglePressedBackground(Color newValue) {
        this.setProperty(PROPERTY_TOGGLE_PRESSED_BACKGROUND, newValue);
    }

    public void setTogglePressedBorder(Border newValue) {
        this.setProperty(PROPERTY_TOGGLE_PRESSED_BORDER, newValue);
    }

    public void setTogglePressedEnabled(boolean newValue) {
        this.setProperty(PROPERTY_TOGGLE_PRESSED_ENABLED, newValue);
    }

    public void setTogglePressedIcon(ImageReference newValue) {
        this.setProperty(PROPERTY_TOGGLE_PRESSED_ICON, newValue);
    }

    public void setToggleRolloverBackground(Color newValue) {
        this.setProperty(PROPERTY_TOGGLE_ROLLOVER_BACKGROUND, newValue);
    }

    public void setToggleRolloverBorder(Border newValue) {
        this.setProperty(PROPERTY_TOGGLE_ROLLOVER_BORDER, newValue);
    }

    public void setToggleRolloverIcon(ImageReference newValue) {
        this.setProperty(PROPERTY_TOGGLE_ROLLOVER_ICON, newValue);
    }

    public void validate() {
    }

    public void setFocusComponent(Component component) {
        if (component != null) {
            this.setProperty(PROPERTY_FOCUS_COMPONENT, component);
        }
    }

    public void setFocusOnExpand(boolean showFocus) {
        this.setProperty(PROPERTY_FOCUS_ON_EXPAND, showFocus);
    }

    static {
        DEFAULT_TOGGLE_ICON = new ResourceImageReference("/echopointng/resource/images/popup_normal_icon.gif", new Extent(15), new Extent(16));
        DEFAULT_TOGGLE_ROLLOVER_ICON = new ResourceImageReference("/echopointng/resource/images/popup_rollover_icon.gif", new Extent(15), new Extent(16));
        DEFAULT_TOGGLE_PRESSED_ICON = new ResourceImageReference("/echopointng/resource/images/popup_pressed_icon.gif", new Extent(15), new Extent(16));
        MutableStyleEx style = new MutableStyleEx();
        Color GRAYISH = ColorKit.makeColor("#D6D3CE");
        Color BLUEISH = ColorKit.makeColor("#3169C6");
        style.setProperty("insets", new Insets(0));
        style.setProperty("border", (Object)new BorderEx(GRAYISH));
        style.setProperty(PROPERTY_ROLLOVER_ENABLED, true);
        style.setProperty(PROPERTY_ROLLOVER_BORDER, (Object)new BorderEx(BLUEISH));
        style.setProperty(PROPERTY_POPUP_ALWAYS_ON_TOP, false);
        style.setProperty(PROPERTY_POPUP_BACKGROUND, Color.WHITE);
        style.setProperty(PROPERTY_POPUP_BORDER, (Object)new BorderEx(GRAYISH));
        style.setProperty(PROPERTY_POPUP_INSETS, new Insets(2));
        style.setProperty(PROPERTY_TOGGLE_INSETS, new Insets(1));
        style.setProperty(PROPERTY_TOGGLE_ICON, DEFAULT_TOGGLE_ICON);
        style.setProperty(PROPERTY_TOGGLE_ROLLOVER_ICON, DEFAULT_TOGGLE_ROLLOVER_ICON);
        style.setProperty(PROPERTY_TOGGLE_PRESSED_ICON, DEFAULT_TOGGLE_PRESSED_ICON);
        style.setProperty(PROPERTY_TOGGLE_PRESSED_ENABLED, true);
        DEFAULT_STYLE = style;
    }

    private class InternallListener
    implements ChangeListener,
    Serializable {
        private InternallListener() {
        }

        public void stateChanged(ChangeEvent e) {
            PopUp.this.firePropertyChange("expanded", null, null);
        }
    }
}

