/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.AbleComponent;
import echopointng.MutableStyleEx;
import echopointng.tree.DefaultMutableTreeNode;
import echopointng.tree.DefaultTreeCellRenderer;
import echopointng.tree.DefaultTreeIcons;
import echopointng.tree.DefaultTreeModel;
import echopointng.tree.DefaultTreeSelectionModel;
import echopointng.tree.EmptyTreeSelectionModel;
import echopointng.tree.ExpandVetoException;
import echopointng.tree.RowMapper;
import echopointng.tree.TreeActionEventEx;
import echopointng.tree.TreeCellRenderer;
import echopointng.tree.TreeExpansionEvent;
import echopointng.tree.TreeExpansionListener;
import echopointng.tree.TreeIcons;
import echopointng.tree.TreeModel;
import echopointng.tree.TreeModelEvent;
import echopointng.tree.TreeModelListener;
import echopointng.tree.TreeNode;
import echopointng.tree.TreePath;
import echopointng.tree.TreeSelectionEvent;
import echopointng.tree.TreeSelectionListener;
import echopointng.tree.TreeSelectionModel;
import echopointng.tree.TreeWillExpandListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.WeakHashMap;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class Tree
extends AbleComponent {
    public static final String INPUT_TOGGLE = "toggle";
    public static final String INPUT_SELECT = "select";
    public static final String PROPERTY_ACTION_COMMAND = "actionCommand";
    public static final String PROPERTY_CELL_RENDERER = "cellRenderer";
    public static final String PROPERTY_LINES_DRAWN = "linesDrawn";
    public static final String PROPERTY_NULL_ACTION_COMMANDS_RAISE_EVENTS = "nullActionCommandsRaiseEvents";
    public static final String PROPERTY_ROOT_VISIBLE = "rootVisible";
    public static final String PROPERTY_ROW_HEIGHT = "rowHeight";
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";
    public static final String PROPERTY_SHOWS_ROOT_HANDLES = "showsRootHandles";
    public static final String PROPERTY_TREE_ICONS = "treeIcons";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_ROOT_AUTO_EXPANDED = "rootAutoExpanded";
    public static final String PROPERTY_PARTIAL_UPDATE_SUPPORT = "partialUpdateSupport";
    public static final String PROPERTY_CELL_WIDTH_CONTRAINED = "cellWidthContrained";
    public static final String PROPERTY_SELECTION_INCLUDES_ICON = "selectionIncludesIcon";
    public static final String PROPERTY_SCROLL_INTO_VIEW_USED = "scrollIntoViewUsed";
    public static final String NODE_CHANGED_PROPERTY = "nodeChanged";
    public static final String MODEL_STRUCTURE_CHANGED_PROPERTY = "modelStructureChanged";
    private static int TEMP_STACK_SIZE = 15;
    private transient Map componentMap = new WeakHashMap();
    private transient Stack expandedStack;
    private transient Hashtable expandedState;
    private transient Collection lastExpandedPaths = new ArrayList();
    private TreeExpansionHandler expansionForwarder;
    private TreeSelectionForwarder selectionForwarder;
    private TreeModelListener treeModelListener;
    private ArrayList dirtyPaths = new ArrayList();
    private boolean valid;
    public static final Style DEFAULT_STYLE;

    public Tree() {
        this(new DefaultMutableTreeNode("root"), false);
    }

    public Tree(TreeNode root) {
        this(root, false);
    }

    public Tree(TreeNode root, boolean asksAllowsChildren) {
        this(new DefaultTreeModel(root, asksAllowsChildren));
    }

    public Tree(TreeModel newModel) {
        this.expandedStack = new Stack();
        this.expandedState = new Hashtable();
        DefaultTreeSelectionModel tempSelectionModel = new DefaultTreeSelectionModel();
        tempSelectionModel.setRowMapper(new TreeRowMapper());
        this.setSelectionModel(tempSelectionModel);
        this.expansionForwarder = new TreeExpansionHandler();
        this.addTreeExpansionListener(this.expansionForwarder);
        this.setModel(newModel);
    }

    public void processInput(String name, Object value) {
        super.processInput(name, value);
        if (this.getModel() == null) {
            return;
        }
        TreePath path = (TreePath)value;
        if (name.startsWith(INPUT_TOGGLE)) {
            if (this.isExpanded(path)) {
                this.collapsePath(path);
            } else {
                this.expandPath(path);
            }
        } else if (name.startsWith(INPUT_SELECT)) {
            Object[] nodes;
            TreeSelectionModel selectionModel = this.getSelectionModel();
            if (selectionModel != null) {
                if (selectionModel.isPathSelected(path)) {
                    selectionModel.removeSelectionPath(path);
                } else {
                    selectionModel.addSelectionPath(path);
                }
            }
            if ((nodes = path.getPath()).length > 0 && nodes[nodes.length - 1] instanceof TreeNode) {
                Object originalNode = nodes[nodes.length - 1];
                TreeNode node = (TreeNode)originalNode;
                String actionCommand = node.getActionCommand();
                while (actionCommand == null && node.getParent() != null) {
                    node = node.getParent();
                    actionCommand = node.getActionCommand();
                }
                if (actionCommand == null) {
                    actionCommand = this.getActionCommand();
                }
                TreeActionEventEx e = new TreeActionEventEx(this, actionCommand, 0, originalNode);
                this.fireActionPerformed(e);
            }
        }
        this.invalidate();
    }

    public void addActionListener(ActionListener l) {
        this.getEventListenerList().addListener(ActionListener.class, (EventListener)l);
    }

    public void addSelectionPath(TreePath path) {
        this.makeVisible(path);
        this.getSelectionModel().addSelectionPath(path);
    }

    public void addSelectionPaths(TreePath[] paths) {
        if (paths != null) {
            for (int counter = paths.length - 1; counter >= 0; --counter) {
                this.makeVisible(paths[counter]);
            }
        }
        this.getSelectionModel().addSelectionPaths(paths);
    }

    public void addTreeExpansionListener(TreeExpansionListener tel) {
        this.getEventListenerList().addListener(TreeExpansionListener.class, (EventListener)tel);
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.getEventListenerList().addListener(TreeSelectionListener.class, (EventListener)tsl);
        if (this.getEventListenerList().getListenerCount(TreeSelectionListener.class) != 0 && this.selectionForwarder == null) {
            this.selectionForwarder = new TreeSelectionForwarder();
            this.getSelectionModel().addTreeSelectionListener(this.selectionForwarder);
        }
    }

    public void addTreeWillExpandListener(TreeWillExpandListener tel) {
        this.getEventListenerList().addListener(TreeWillExpandListener.class, (EventListener)tel);
    }

    public void collapseAll() {
        TreeModel model = this.getModel();
        if (model != null) {
            this.toggleAllNodes(new TreePath(model.getRoot()), false);
        }
    }

    public void collapsePath(TreePath path) {
        this.setExpandedState(path, false);
    }

    public void expandAll() {
        TreeModel model = this.getModel();
        if (model != null) {
            this.toggleAllNodes(new TreePath(model.getRoot()), true);
        }
    }

    public void expandPath(TreePath path) {
        TreeModel model = this.getModel();
        if (path != null && model != null && !model.isLeaf(path.getLastPathComponent())) {
            this.setExpandedState(path, true);
        }
    }

    public void fireActionPerformed(ActionEvent e) {
        EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            ((ActionListener)listeners[index]).actionPerformed(e);
        }
    }

    public void fireTreeCollapsed(TreePath path) {
        EventListener[] listeners = this.getEventListenerList().getListeners(TreeExpansionListener.class);
        TreeExpansionEvent e = null;
        for (int index = 0; index < listeners.length; ++index) {
            if (e == null) {
                e = new TreeExpansionEvent(this, path);
            }
            ((TreeExpansionListener)listeners[index]).treeCollapsed(e);
        }
    }

    public void fireTreeExpanded(TreePath path) {
        EventListener[] listeners = this.getEventListenerList().getListeners(TreeExpansionListener.class);
        TreeExpansionEvent e = null;
        for (int index = 0; index < listeners.length; ++index) {
            if (e == null) {
                e = new TreeExpansionEvent(this, path);
            }
            ((TreeExpansionListener)listeners[index]).treeExpanded(e);
        }
    }

    public void fireTreeWillCollapse(TreePath path) throws ExpandVetoException {
        EventListener[] listeners = this.getEventListenerList().getListeners(TreeWillExpandListener.class);
        TreeExpansionEvent e = null;
        for (int index = 0; index < listeners.length; ++index) {
            if (e == null) {
                e = new TreeExpansionEvent(this, path);
            }
            ((TreeWillExpandListener)listeners[index]).treeWillCollapse(e);
        }
    }

    public void fireTreeWillExpand(TreePath path) throws ExpandVetoException {
        EventListener[] listeners = this.getEventListenerList().getListeners(TreeWillExpandListener.class);
        TreeExpansionEvent e = null;
        for (int index = 0; index < listeners.length; ++index) {
            if (e == null) {
                e = new TreeExpansionEvent(this, path);
            }
            ((TreeWillExpandListener)listeners[index]).treeWillExpand(e);
        }
    }

    public String getActionCommand() {
        return (String)this.getProperty(PROPERTY_ACTION_COMMAND);
    }

    public TreeCellRenderer getCellRenderer() {
        return (TreeCellRenderer)this.getRenderProperty(PROPERTY_CELL_RENDERER, DEFAULT_STYLE.getProperty(PROPERTY_CELL_RENDERER));
    }

    public Component getComponent(Object treeNode) {
        WeakReference wr = (WeakReference)this.componentMap.get(treeNode);
        return wr != null ? (Component)wr.get() : null;
    }

    public Enumeration getExpandedDescendants(TreePath parent) {
        if (!this.isExpanded(parent)) {
            return null;
        }
        Enumeration toggledPaths = this.expandedState.keys();
        Vector<TreePath> elements = new Vector<TreePath>();
        if (toggledPaths != null) {
            while (toggledPaths.hasMoreElements()) {
                TreePath path = (TreePath)toggledPaths.nextElement();
                Object value = this.expandedState.get(path);
                if (value == null || !((Boolean)value).booleanValue() || !parent.isDescendant(path) || !this.isVisible(path)) continue;
                elements.addElement(path);
            }
        }
        return elements.elements();
    }

    public Object getLastSelectedPathComponent() {
        TreePath selPath = this.getSelectionModel().getSelectionPath();
        if (selPath != null) {
            return selPath.getLastPathComponent();
        }
        return null;
    }

    public TreePath getLeadSelectionPath() {
        return this.getSelectionModel().getLeadSelectionPath();
    }

    public TreeModel getModel() {
        return (TreeModel)this.getProperty(PROPERTY_MODEL);
    }

    public Collection getLastExpandedPaths() {
        return this.lastExpandedPaths;
    }

    public int getRowForPath(TreePath path) {
        Object[] nodes = null;
        if (this.getModel() != null) {
            nodes = path.getPath();
        }
        if (nodes.length == 0 || !this.isExpanded(path)) {
            return -1;
        }
        TreePath rootPath = new TreePath(this.getModel().getRoot());
        Enumeration enumeration = this.getDescendantToggledPaths(rootPath);
        Vector pathsVec = this.orderPathEnumeration(rootPath, enumeration);
        for (int i = 0; i < pathsVec.size(); ++i) {
            TreePath testPath = (TreePath)pathsVec.get(i);
            if (!testPath.equals(path)) continue;
            return i;
        }
        return -1;
    }

    public int[] getRowsForPaths(TreePath[] paths) {
        if (paths == null) {
            return null;
        }
        int numPaths = paths.length;
        int[] rows = new int[numPaths];
        for (int counter = 0; counter < numPaths; ++counter) {
            rows[counter] = this.getRowForPath(paths[counter]);
        }
        return rows;
    }

    public int getRowHeight() {
        return this.getProperty(PROPERTY_ROW_HEIGHT, -1);
    }

    public int getSelectionCount() {
        return this.getSelectionModel().getSelectionCount();
    }

    public TreeSelectionModel getSelectionModel() {
        return (TreeSelectionModel)this.getProperty(PROPERTY_SELECTION_MODEL);
    }

    public TreePath getSelectionPath() {
        return this.getSelectionModel().getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        return this.getSelectionModel().getSelectionPaths();
    }

    public boolean getShowsRootHandles() {
        return this.getProperty(PROPERTY_SHOWS_ROOT_HANDLES, true);
    }

    public TreeIcons getTreeIcons() {
        return (TreeIcons)this.getRenderProperty(PROPERTY_TREE_ICONS, DEFAULT_STYLE.getProperty(PROPERTY_TREE_ICONS));
    }

    public boolean hasEverBeenExpanded(TreePath path) {
        return path != null && this.expandedState.get(path) != null;
    }

    public void invalidate() {
        this.valid = false;
    }

    public boolean isCollapsed(TreePath path) {
        return !this.isExpanded(path);
    }

    public boolean isExpanded(TreePath path) {
        if (path == null) {
            return false;
        }
        Object value = this.expandedState.get(path);
        if (value == null || !((Boolean)value).booleanValue()) {
            return false;
        }
        TreePath parentPath = path.getParentPath();
        if (parentPath != null) {
            return this.isExpanded(parentPath);
        }
        return true;
    }

    public TreePath getPathForRow(final int row) {
        if (row < 0) {
            return null;
        }
        TreePathNavigationListener pathNavigationListener = new TreePathNavigationListener(){
            TreePath targetPath = null;

            public boolean onTreePath(TreePath path, int pathRow) {
                if (pathRow == row) {
                    this.targetPath = path;
                    return false;
                }
                return true;
            }

            public TreePath getLastEncounteredPath() {
                return this.targetPath;
            }
        };
        this.findAllVisibleRows(pathNavigationListener);
        return pathNavigationListener.getLastEncounteredPath();
    }

    public int getRowCount() {
        int rowCount = 0;
        if (this.getModel().getRoot() == null) {
            return 0;
        }
        TreePath rootPath = new TreePath(this.getModel().getRoot());
        if (!this.isExpanded(rootPath)) {
            return 1;
        }
        rowCount = this.findAllVisibleRows(null);
        return rowCount;
    }

    private int findAllVisibleRows(TreePathNavigationListener pathNavigationListener) {
        TreeModel model = this.getModel();
        Object rootNode = model.getRoot();
        TreePath rootPath = new TreePath(rootNode);
        int rowCount = 0;
        if (this.isRootVisible() && pathNavigationListener != null && !pathNavigationListener.onTreePath(rootPath, ++rowCount - 1)) {
            return -1;
        }
        if (!model.isLeaf(model.getRoot()) && this.isExpanded(rootPath)) {
            int childRowCount = this.findAllVisibleRows(rootNode, rootPath, pathNavigationListener, rowCount);
            if (childRowCount == -1) {
                return -1;
            }
            rowCount = childRowCount;
        }
        return rowCount;
    }

    private int findAllVisibleRows(Object parentNode, TreePath parentPath, TreePathNavigationListener pathNavigationListener, int currentRowCount) {
        TreeModel model = this.getModel();
        int rowCount = currentRowCount;
        int cc = model.getChildCount(parentNode);
        for (int i = 0; i < cc; ++i) {
            Object childNode = model.getChild(parentNode, i);
            TreePath childPath = new TreePath(parentPath, childNode);
            if (pathNavigationListener != null && !pathNavigationListener.onTreePath(childPath, ++rowCount - 1)) {
                return -1;
            }
            if (model.isLeaf(childNode) || !this.isExpanded(childPath)) continue;
            int childRowCount = this.findAllVisibleRows(childNode, childPath, pathNavigationListener, rowCount);
            if (childRowCount == -1) {
                return -1;
            }
            rowCount = childRowCount;
        }
        return rowCount;
    }

    public boolean isExpanded(int row) {
        TreePath path = this.getPathForRow(row);
        if (path != null) {
            Boolean value = (Boolean)this.expandedState.get(path);
            return value != null && value != false;
        }
        return false;
    }

    public boolean isCollapsed(int row) {
        return !this.isExpanded(row);
    }

    public void expandRow(int row) {
        this.expandPath(this.getPathForRow(row));
    }

    public void collapseRow(int row) {
        this.collapsePath(this.getPathForRow(row));
    }

    public boolean isLinesDrawn() {
        return this.getProperty(PROPERTY_LINES_DRAWN, true);
    }

    public boolean isScrollIntoViewUsed() {
        return this.getProperty(PROPERTY_SCROLL_INTO_VIEW_USED, true);
    }

    public void setScrollIntoViewUsed(boolean newValue) {
        this.setProperty(PROPERTY_SCROLL_INTO_VIEW_USED, newValue);
    }

    public boolean isNullActionCommandsRaiseEvents() {
        return this.getProperty(PROPERTY_NULL_ACTION_COMMANDS_RAISE_EVENTS, true);
    }

    public boolean isPathSelected(TreePath path) {
        return this.getSelectionModel().isPathSelected(path);
    }

    public boolean isRootVisible() {
        return this.getProperty(PROPERTY_ROOT_VISIBLE, true);
    }

    public boolean isRootAutoExpanded() {
        return this.getProperty(PROPERTY_ROOT_AUTO_EXPANDED, true);
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public boolean isCellWidthConstrained() {
        return this.getProperty(PROPERTY_CELL_WIDTH_CONTRAINED, false);
    }

    public void setCellWidthConstrained(boolean newValue) {
        this.setProperty(PROPERTY_CELL_WIDTH_CONTRAINED, newValue);
    }

    public boolean isSelectionIncludesIcon() {
        return this.getProperty(PROPERTY_SELECTION_INCLUDES_ICON, true);
    }

    public void setSelectionIncludesIcon(boolean newValue) {
        this.setProperty(PROPERTY_SELECTION_INCLUDES_ICON, newValue);
    }

    public boolean isVisible(TreePath path) {
        if (path != null) {
            TreePath parentPath = path.getParentPath();
            if (parentPath != null) {
                return this.isExpanded(parentPath);
            }
            return true;
        }
        return false;
    }

    public void makeVisible(TreePath path) {
        TreePath parentPath;
        if (path != null && (parentPath = path.getParentPath()) != null) {
            this.expandPath(parentPath);
        }
    }

    public void removeActionListener(ActionListener l) {
        this.getEventListenerList().removeListener(ActionListener.class, (EventListener)l);
    }

    protected void removeDescendantToggledPaths(Enumeration toRemove) {
        if (toRemove != null) {
            while (toRemove.hasMoreElements()) {
                Enumeration descendants = this.getDescendantToggledPaths((TreePath)toRemove.nextElement());
                if (descendants == null) continue;
                while (descendants.hasMoreElements()) {
                    this.expandedState.remove(descendants.nextElement());
                }
            }
        }
    }

    public void removeSelectionPath(TreePath path) {
        this.getSelectionModel().removeSelectionPath(path);
    }

    public void removeSelectionPaths(TreePath[] paths) {
        this.getSelectionModel().removeSelectionPaths(paths);
    }

    public void removeTreeExpansionListener(TreeExpansionListener tel) {
        this.getEventListenerList().removeListener(TreeExpansionListener.class, (EventListener)tel);
    }

    public void removeTreeSelectionListener(TreeSelectionListener tsl) {
        this.getEventListenerList().removeListener(TreeSelectionListener.class, (EventListener)tsl);
        if (this.getEventListenerList().getListenerCount(TreeSelectionListener.class) == 0 && this.selectionForwarder != null) {
            this.getSelectionModel().removeTreeSelectionListener(this.selectionForwarder);
            this.selectionForwarder = null;
        }
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener tel) {
        this.getEventListenerList().removeListener(TreeWillExpandListener.class, (EventListener)tel);
    }

    public void setActionCommand(String newActionCommand) {
        this.setProperty(PROPERTY_ACTION_COMMAND, newActionCommand);
    }

    public void setCellRenderer(TreeCellRenderer newCellRenderer) {
        if (newCellRenderer == null) {
            throw new IllegalArgumentException("The TreeCellRenderer must not be null");
        }
        if (!newCellRenderer.equals(this.getCellRenderer())) {
            this.setProperty(PROPERTY_CELL_RENDERER, newCellRenderer);
            this.componentMap.clear();
            this.invalidate();
        }
    }

    public void setEnabled(boolean newValue) {
        if (newValue != this.isEnabled()) {
            super.setEnabled(newValue);
            this.invalidate();
        }
    }

    public void setLinesDrawn(boolean newDrawLines) {
        this.setProperty(PROPERTY_LINES_DRAWN, newDrawLines);
    }

    public void setPartialUpdateSupport(boolean newValue) {
        this.setProperty(PROPERTY_PARTIAL_UPDATE_SUPPORT, newValue);
    }

    public boolean getPartialUpdateSupport() {
        return this.getProperty(PROPERTY_PARTIAL_UPDATE_SUPPORT, true);
    }

    public void setModel(TreeModel newTreeModel) {
        TreeModel oldModel = this.getModel();
        if (newTreeModel == null || !newTreeModel.equals(oldModel)) {
            if (oldModel != null && this.treeModelListener != null) {
                oldModel.removeTreeModelListener(this.treeModelListener);
            }
            this.setProperty(PROPERTY_MODEL, newTreeModel);
            this.clearToggledPaths();
            if (newTreeModel != null) {
                if (this.treeModelListener == null) {
                    this.treeModelListener = this.createTreeModelListener();
                }
                if (this.treeModelListener != null) {
                    newTreeModel.addTreeModelListener(this.treeModelListener);
                }
                if (newTreeModel.getRoot() != null && this.isRootAutoExpanded() && !newTreeModel.isLeaf(newTreeModel.getRoot())) {
                    this.expandedState.put(new TreePath(newTreeModel.getRoot()), Boolean.TRUE);
                }
            }
            this.invalidate();
        }
    }

    public void setNullActionCommandsRaiseEvents(boolean newValue) {
        this.setProperty(PROPERTY_NULL_ACTION_COMMANDS_RAISE_EVENTS, newValue);
    }

    public void setRootVisible(boolean rootVisible) {
        if (rootVisible != this.isRootVisible()) {
            this.setProperty(PROPERTY_ROOT_VISIBLE, rootVisible);
            this.invalidate();
        }
    }

    public void setRootAutoExpanded(boolean rootExpanded) {
        if (rootExpanded != this.isRootAutoExpanded()) {
            this.setProperty(PROPERTY_ROOT_AUTO_EXPANDED, rootExpanded);
            this.invalidate();
        }
    }

    public void setRowHeight(int newRowHeight) {
        this.setProperty(PROPERTY_ROW_HEIGHT, newRowHeight);
    }

    public void setSelectionModel(TreeSelectionModel newSelectionModel) {
        TreeSelectionModel oldValue;
        if (newSelectionModel == null) {
            newSelectionModel = EmptyTreeSelectionModel.getInstance();
        }
        if (!newSelectionModel.equals(oldValue = this.getSelectionModel())) {
            if (oldValue != null && this.selectionForwarder != null) {
                oldValue.removeTreeSelectionListener(this.selectionForwarder);
            }
            this.setProperty(PROPERTY_SELECTION_MODEL, newSelectionModel);
            if (this.selectionForwarder == null) {
                this.selectionForwarder = new TreeSelectionForwarder();
            }
            newSelectionModel.addTreeSelectionListener(this.selectionForwarder);
            this.invalidate();
        }
    }

    public void setSelectionPath(TreePath path) {
        this.makeVisible(path);
        this.getSelectionModel().setSelectionPath(path);
    }

    public void setSelectionPaths(TreePath[] paths) {
        if (paths != null) {
            for (int counter = paths.length - 1; counter >= 0; --counter) {
                this.makeVisible(paths[counter]);
            }
        }
        this.getSelectionModel().setSelectionPaths(paths);
    }

    public void setShowsRootHandles(boolean newValue) {
        this.setProperty(PROPERTY_SHOWS_ROOT_HANDLES, newValue);
        TreeModel model = this.getModel();
        if (model != null && model.getRoot() != null) {
            this.expandPath(new TreePath(model.getRoot()));
        }
    }

    public void setTreeIcons(TreeIcons newTreeIcons) {
        if (newTreeIcons == null) {
            throw new IllegalArgumentException("Non null TreeIcons required");
        }
        if (!newTreeIcons.equals(this.getTreeIcons())) {
            this.setProperty(PROPERTY_TREE_ICONS, newTreeIcons);
            this.invalidate();
        }
    }

    public void setVisible(boolean newValue) {
        if (newValue != this.isVisible()) {
            super.setVisible(newValue);
            this.invalidate();
        }
    }

    public void toggleAllNodes(TreePath parentPath, boolean expand) {
        Object parent = parentPath.getLastPathComponent();
        this.toggleAllNodesImpl(parent, parentPath, expand);
    }

    private void toggleAllNodesImpl(Object parent, TreePath parentPath, boolean expand) {
        TreeModel model = this.getModel();
        if (model == null) {
            return;
        }
        if (!model.isLeaf(parent)) {
            int cc = model.getChildCount(parent);
            for (int i = 0; i < cc; ++i) {
                Object node = model.getChild(parent, i);
                TreePath childPath = new TreePath(parentPath, node);
                if (!model.isLeaf(node)) {
                    this.toggleAllNodesImpl(node, childPath, expand);
                    continue;
                }
                this.setExpandedState(childPath, expand);
            }
            if (!expand) {
                this.setExpandedState(parentPath, false);
            }
        }
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler();
    }

    protected void clearToggledPaths() {
        if (this.expandedState != null) {
            this.expandedState.clear();
        }
    }

    protected void fireValueChanged(TreeSelectionEvent e) {
        EventListener[] listeners = this.getEventListenerList().getListeners(TreeSelectionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((TreeSelectionListener)listeners[i]).valueChanged(e);
        }
    }

    protected Enumeration getDescendantToggledPaths(TreePath parent) {
        if (parent == null) {
            return null;
        }
        Vector<TreePath> descendants = new Vector<TreePath>();
        Enumeration nodes = this.expandedState.keys();
        while (nodes.hasMoreElements()) {
            TreePath path = (TreePath)nodes.nextElement();
            if (!parent.isDescendant(path)) continue;
            descendants.addElement(path);
        }
        return descendants.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExpandedState(TreePath path, boolean state) {
        block18: {
            if (path == null) break block18;
            TreePath parentPath = path.getParentPath();
            Stack stack = this.expandedStack.size() == 0 ? new Stack() : (Stack)this.expandedStack.pop();
            try {
                while (parentPath != null) {
                    if (this.isExpanded(parentPath)) {
                        parentPath = null;
                        continue;
                    }
                    stack.push(parentPath);
                    parentPath = parentPath.getParentPath();
                }
                for (int counter = stack.size() - 1; counter >= 0; --counter) {
                    parentPath = (TreePath)stack.pop();
                    if (this.isExpanded(parentPath)) continue;
                    try {
                        this.fireTreeWillExpand(parentPath);
                    }
                    catch (ExpandVetoException eve) {
                        Object var8_11 = null;
                        if (this.expandedStack.size() < TEMP_STACK_SIZE) {
                            stack.removeAllElements();
                            this.expandedStack.push(stack);
                        }
                        return;
                    }
                    this.expandedState.put(parentPath, Boolean.TRUE);
                    this.fireTreeExpanded(parentPath);
                }
                Object var8_12 = null;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                if (this.expandedStack.size() < TEMP_STACK_SIZE) {
                    stack.removeAllElements();
                    this.expandedStack.push(stack);
                }
                throw throwable;
            }
            if (this.expandedStack.size() < TEMP_STACK_SIZE) {
                stack.removeAllElements();
                this.expandedStack.push(stack);
            }
            if (!state) {
                Object cValue = this.expandedState.get(path);
                if (cValue != null && ((Boolean)cValue).booleanValue()) {
                    try {
                        this.fireTreeWillCollapse(path);
                    }
                    catch (ExpandVetoException eve) {
                        return;
                    }
                    this.expandedState.put(path, Boolean.FALSE);
                    this.fireTreeCollapsed(path);
                }
            } else {
                Object cValue = this.expandedState.get(path);
                if (cValue == null || !((Boolean)cValue).booleanValue()) {
                    try {
                        this.fireTreeWillExpand(path);
                    }
                    catch (ExpandVetoException eve) {
                        return;
                    }
                    this.expandedState.put(path, Boolean.TRUE);
                    this.fireTreeExpanded(path);
                }
            }
        }
    }

    private boolean orderContainsTreePath(Hashtable hash, TreePath path) {
        Enumeration enumeration = hash.elements();
        while (enumeration.hasMoreElements()) {
            TreePath testPath = (TreePath)enumeration.nextElement();
            if (!testPath.equals(path)) continue;
            return true;
        }
        return false;
    }

    private Vector orderPathEnumeration(TreePath parentPath, Enumeration enumeration) {
        Hashtable<String, TreePath> unsortedSet = new Hashtable<String, TreePath>();
        Vector<TreePath> sortedSet = new Vector<TreePath>();
        if (this.getModel() == null) {
            return sortedSet;
        }
        while (enumeration.hasMoreElements()) {
            TreePath path = (TreePath)enumeration.nextElement();
            unsortedSet.put(path.toString(), path);
        }
        if (this.orderContainsTreePath(unsortedSet, parentPath)) {
            sortedSet.add(parentPath);
        }
        this.orderPathSet(parentPath, unsortedSet, sortedSet);
        return sortedSet;
    }

    private void orderPathSet(TreePath parentPath, Hashtable unsortedSet, Vector sortedSet) {
        Object node = parentPath.getLastPathComponent();
        if (!this.getModel().isLeaf(node) && this.isExpanded(parentPath)) {
            int cc = this.getModel().getChildCount(node);
            for (int i = 0; i < cc; ++i) {
                Object child = this.getModel().getChild(node, i);
                TreePath targetPath = parentPath.pathByAddingChild(child);
                if (this.orderContainsTreePath(unsortedSet, targetPath)) {
                    sortedSet.add(targetPath);
                }
                if (this.getModel().isLeaf(child)) continue;
                this.orderPathSet(targetPath, unsortedSet, sortedSet);
            }
        }
    }

    private void doComponentCheck(TreePath path, TreeModel model, Map referenceMap) {
        Object node = path.getLastPathComponent();
        Component cellComponent = this.getComponent(node);
        if (cellComponent != null) {
            if (this.dirtyPaths.contains(path)) {
                this.componentMap.remove(node);
                this.remove(cellComponent);
            } else {
                referenceMap.put(cellComponent, cellComponent);
                return;
            }
        }
        boolean isExpanded = this.isExpanded(path);
        boolean isSelected = this.isPathSelected(path);
        boolean isLeaf = model.isLeaf(node);
        Label l = this.getCellRenderer().getTreeCellRendererText(this, node, isSelected, isExpanded, isLeaf);
        if (l == null && (cellComponent = this.getCellRenderer().getTreeCellRendererComponent(this, node, isSelected, isExpanded, isLeaf)) != null) {
            if (!this.isAncestorOf(cellComponent)) {
                this.add(cellComponent);
            }
            this.componentMap.put(node, new WeakReference<Component>(cellComponent));
            if (referenceMap != null) {
                referenceMap.put(cellComponent, cellComponent);
            }
        }
    }

    private void doPathValidation(TreePath path, Map referenceMap) {
        if (path == null) {
            return;
        }
        TreeModel model = this.getModel();
        this.doComponentCheck(path, model, referenceMap);
        boolean isExpanded = this.isExpanded(path);
        Object node = path.getLastPathComponent();
        if (!model.isLeaf(node) && isExpanded) {
            int cc = model.getChildCount(node);
            for (int i = 0; i < cc; ++i) {
                Object nodeChild = model.getChild(node, i);
                TreePath childPath = new TreePath(path, nodeChild);
                this.doComponentCheck(childPath, model, referenceMap);
                isExpanded = this.isExpanded(childPath);
                if (!isExpanded) continue;
                this.doPathValidation(childPath, referenceMap);
            }
        }
    }

    public void validate() {
        super.validate();
        if (!this.valid) {
            this.valid = true;
            TreeModel model = this.getModel();
            if (model == null) {
                return;
            }
            Object root = model.getRoot();
            if (root == null) {
                return;
            }
            TreeCellRenderer renderer = this.getCellRenderer();
            if (renderer == null) {
                throw new IllegalStateException("The Tree has no TreeCellRenderer");
            }
            HashMap referenceMap = new HashMap();
            TreePath path = new TreePath(root);
            this.doPathValidation(path, referenceMap);
            Iterator iter = this.componentMap.values().iterator();
            while (iter.hasNext()) {
                WeakReference wr = (WeakReference)iter.next();
                Component component = (Component)wr.get();
                if (referenceMap.containsKey(component)) continue;
                iter.remove();
                this.remove(component);
            }
        }
    }

    public Collection getDirtyPaths() {
        return this.dirtyPaths;
    }

    private void markPathsDirty(TreePath parentPath, Object[] nodes, boolean markChildren) {
        if (nodes != null) {
            for (int i = nodes.length - 1; i >= 0; --i) {
                TreePath path = parentPath.pathByAddingChild(nodes[i]);
                this.markPathDirty(path, markChildren);
            }
        } else {
            this.markPathDirty(parentPath, markChildren);
        }
    }

    private void markPathDirty(TreePath path, boolean markChildren) {
        this.invalidate();
        if (!this.dirtyPaths.contains(path)) {
            this.dirtyPaths.add(path);
            this.firePropertyChange(NODE_CHANGED_PROPERTY, null, null);
        }
        Object node = path.getLastPathComponent();
        TreeModel model = this.getModel();
        if (markChildren && !model.isLeaf(node)) {
            int cc = model.getChildCount(node);
            for (int i = 0; i < cc; ++i) {
                Object nodeChild = model.getChild(node, i);
                this.markPathDirty(new TreePath(path, nodeChild), true);
            }
        }
    }

    static {
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty(PROPERTY_CELL_RENDERER, new DefaultTreeCellRenderer());
        style.setProperty(PROPERTY_ROOT_VISIBLE, true);
        style.setProperty(PROPERTY_LINES_DRAWN, true);
        style.setProperty(PROPERTY_SHOWS_ROOT_HANDLES, true);
        style.setProperty(PROPERTY_SCROLL_INTO_VIEW_USED, true);
        style.setProperty(PROPERTY_NULL_ACTION_COMMANDS_RAISE_EVENTS, true);
        style.setProperty(PROPERTY_TREE_ICONS, new DefaultTreeIcons());
        DEFAULT_STYLE = style;
    }

    private static interface TreePathNavigationListener {
        public boolean onTreePath(TreePath var1, int var2);

        public TreePath getLastEncounteredPath();
    }

    protected class TreeSelectionForwarder
    implements Serializable,
    TreeSelectionListener {
        protected TreeSelectionForwarder() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] paths = e.getPaths();
            for (int i = 0; i < paths.length; ++i) {
                Tree.this.markPathDirty(paths[i], false);
            }
            TreeSelectionEvent newE = (TreeSelectionEvent)e.cloneWithSource(Tree.this);
            Tree.this.fireValueChanged(newE);
        }
    }

    protected class TreeRowMapper
    implements Serializable,
    RowMapper {
        protected TreeRowMapper() {
        }

        public int[] getRowsForPaths(TreePath[] paths) {
            return Tree.this.getRowsForPaths(paths);
        }
    }

    protected class TreeModelHandler
    implements TreeModelListener,
    Serializable {
        protected TreeModelHandler() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            Tree.this.markPathsDirty(e.getTreePath(), e.getChildren(), false);
        }

        public void treeNodesInserted(TreeModelEvent e) {
            Tree.this.markPathsDirty(e.getTreePath(), e.getChildren(), true);
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            TreeModel model;
            if (e == null) {
                return;
            }
            TreePath parent = e.getTreePath();
            Object[] children = e.getChildren();
            if (children == null) {
                return;
            }
            Vector<TreePath> toRemove = new Vector<TreePath>(Math.max(1, children.length));
            for (int counter = children.length - 1; counter >= 0; --counter) {
                TreePath rPath = parent.pathByAddingChild(children[counter]);
                if (Tree.this.expandedState.get(rPath) == null) continue;
                toRemove.addElement(rPath);
            }
            if (toRemove.size() > 0) {
                Tree.this.removeDescendantToggledPaths(toRemove.elements());
            }
            if ((model = Tree.this.getModel()) == null || model.isLeaf(parent.getLastPathComponent())) {
                Tree.this.expandedState.remove(parent);
            }
            Object parentNode = parent.getLastPathComponent();
            if (model != null && model.getChildCount(parentNode) == 0) {
                Tree.this.markPathDirty(parent, false);
            }
            Tree.this.invalidate();
            Tree.this.firePropertyChange(Tree.NODE_CHANGED_PROPERTY, null, null);
        }

        public void treeStructureChanged(TreeModelEvent e) {
            if (e == null) {
                return;
            }
            TreePath parent = e.getTreePath();
            if (parent == null) {
                return;
            }
            if (parent.getPathCount() == 1) {
                Tree.this.clearToggledPaths();
                TreeModel model = Tree.this.getModel();
                if (model != null && !model.isLeaf(model.getRoot())) {
                    Tree.this.expandedState.put(parent, Boolean.TRUE);
                }
            } else if (Tree.this.expandedState.get(parent) != null) {
                Vector<TreePath> toRemove = new Vector<TreePath>(1);
                boolean isExpanded = Tree.this.isExpanded(parent);
                toRemove.addElement(parent);
                Tree.this.removeDescendantToggledPaths(toRemove.elements());
                if (isExpanded) {
                    TreeModel model = Tree.this.getModel();
                    if (model == null || model.isLeaf(parent.getLastPathComponent())) {
                        Tree.this.collapsePath(parent);
                    } else {
                        Tree.this.expandedState.put(parent, Boolean.TRUE);
                    }
                }
            }
            Tree.this.invalidate();
            Tree.this.firePropertyChange(Tree.MODEL_STRUCTURE_CHANGED_PROPERTY, null, null);
        }
    }

    private class TreeExpansionHandler
    implements Serializable,
    TreeExpansionListener {
        private TreeExpansionHandler() {
        }

        public void treeCollapsed(TreeExpansionEvent e) {
            Tree.this.markPathDirty(e.getPath(), false);
        }

        public void treeExpanded(TreeExpansionEvent e) {
            Tree.this.markPathDirty(e.getPath(), false);
            Tree.this.lastExpandedPaths.add(e.getPath());
        }
    }
}

