/*
 * Decompiled with CFR 0.152.
 */
package echopointng.tabbedpane;

import echopointng.TabbedPane;
import echopointng.image.ImageKit;
import echopointng.image.TextImageReference;
import echopointng.tabbedpane.TabImageRenderer;
import echopointng.ui.resource.Resources;
import echopointng.util.ColorKit;
import echopointng.util.reflect.ReflectionKit;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.AttributedString;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;

public class DefaultTabImageRenderer
implements TabImageRenderer,
Serializable {
    public static final Insets DEFAULT_INSETS = new Insets(5);
    private ImageReference leadInImage;
    private ImageReference leadOutImage;
    private transient Image activeTabImage;
    private transient Image inactiveTabImage;
    private Insets insets = DEFAULT_INSETS;
    private int borderWidth = 0;
    private Color borderColor = null;
    private Color activeColor = ColorKit.makeColor(192, 192, 192);
    private Color inactiveColor = ColorKit.makeColor(224, 224, 224);
    private int tabPlacement = 6;

    public DefaultTabImageRenderer() {
        this.activeTabImage = DefaultTabImageRenderer._loadResImage("tabTemplateC0C0C0.gif");
        this.inactiveTabImage = DefaultTabImageRenderer._loadResImage("tabTemplateE0E0E0.gif");
    }

    public DefaultTabImageRenderer(Image activeTabImage, Image inactiveTabImage) {
        if (activeTabImage == null) {
            throw new IllegalArgumentException("The active tab image must be non null!");
        }
        if (inactiveTabImage == null) {
            throw new IllegalArgumentException("The inactive tab image must be non null!");
        }
        this.activeTabImage = activeTabImage;
        this.inactiveTabImage = inactiveTabImage;
    }

    public ImageReference getLeadInImage(TabbedPane tp) {
        return this.leadInImage;
    }

    public ImageReference getLeadOutImage(TabbedPane tp) {
        return this.leadOutImage;
    }

    public ImageReference getTabImage(TabbedPane tp, int tabIndex, Component tabComponent, boolean isSelected) {
        Image imagetoUse;
        AttributedString as;
        String tabText = (String)ReflectionKit.invokeIfPresent("getText", new Class[]{}, String.class, tabComponent, new Object[0]);
        if (tabText == null) {
            tabText = "Tab " + tabIndex;
        }
        if (isSelected) {
            as = TextImageReference.getAttributedString(tabText, tabComponent.getForeground(), tp.getFont());
            imagetoUse = this.activeTabImage;
        } else {
            as = TextImageReference.getAttributedString(tabText, tabComponent.getForeground(), tp.getFont());
            imagetoUse = this.inactiveTabImage;
        }
        TextImageReference imageRef = new TextImageReference(as, imagetoUse, 32);
        if (this.insets != null) {
            imageRef.setInsets(this.insets);
        }
        return imageRef;
    }

    public int getImageBorderWidth() {
        return this.borderWidth;
    }

    public Color getImageBorderColor() {
        return this.borderColor;
    }

    public Image getActiveTabImage() {
        return this.activeTabImage;
    }

    public Image getInactiveTabImage() {
        return this.inactiveTabImage;
    }

    public ImageReference getLeadInImage() {
        return this.leadInImage;
    }

    public ImageReference getLeadOutImage() {
        return this.leadOutImage;
    }

    public void setActiveTabImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("The active tab image must be non null!");
        }
        this.activeTabImage = image;
    }

    public void setInactiveTabImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("The inactive tab image must be non null!");
        }
        this.inactiveTabImage = image;
    }

    public void setLeadInImage(ImageReference reference) {
        this.leadInImage = reference;
    }

    public void setLeadOutImage(ImageReference reference) {
        this.leadOutImage = reference;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public void setBorderWidth(int i) {
        this.borderWidth = i;
    }

    public void prime(TabbedPane tp) {
        Component content;
        if (tp == null) {
            throw new IllegalArgumentException("The TabbedPane must be non null!");
        }
        Border border = new Border(this.borderWidth, this.borderColor, 1);
        tp.setBorder(border);
        tp.setBackground(this.inactiveColor);
        tp.setTabPlacement(this.tabPlacement);
        int selectedIndex = tp.getSelectedIndex();
        if (selectedIndex >= 0 && (content = tp.getModel().getTabContentAt(selectedIndex)) != null) {
            content.setBackground(this.activeColor);
        }
    }

    public static DefaultTabImageRenderer getInstance() {
        return DefaultTabImageRenderer.getInstance(ColorKit.makeColor("#C0C0C0"), ColorKit.makeColor("#E0E0E0"), Color.BLACK, 6);
    }

    public static DefaultTabImageRenderer getInstance(int tabPlacement) {
        return DefaultTabImageRenderer.getInstance(ColorKit.makeColor("#C0C0C0"), ColorKit.makeColor("#E0E0E0"), Color.BLACK, tabPlacement);
    }

    public static DefaultTabImageRenderer getInstance(Color activeTabColor, Color inactiveTabColor, Color borderColor, int tabPlacement) {
        if (activeTabColor == null) {
            throw new IllegalArgumentException("The activeTabColor must be non null");
        }
        if (inactiveTabColor == null) {
            throw new IllegalArgumentException("The inactiveTabColor must be non null");
        }
        if (borderColor == null) {
            throw new IllegalArgumentException("The borderColor must be non null");
        }
        Image activeImage = DefaultTabImageRenderer._loadResImage("tabTemplateC0C0C0.gif");
        Image inactiveImage = DefaultTabImageRenderer._loadResImage("tabTemplateE0E0E0.gif");
        activeImage = DefaultTabImageRenderer._makeSmartTabImage(activeImage, ColorKit.makeColor("#C0C0C0"), activeTabColor, Color.BLACK, borderColor, tabPlacement);
        inactiveImage = DefaultTabImageRenderer._makeSmartTabImage(inactiveImage, ColorKit.makeColor("#E0E0E0"), inactiveTabColor, Color.BLACK, borderColor, tabPlacement);
        DefaultTabImageRenderer renderer = new DefaultTabImageRenderer(activeImage, inactiveImage);
        renderer.setBorderColor(borderColor);
        renderer.setBorderWidth(1);
        renderer.activeColor = activeTabColor;
        renderer.inactiveColor = inactiveTabColor;
        renderer.tabPlacement = tabPlacement;
        return renderer;
    }

    private static Image _makeSmartTabImage(Image currentImage, Color currentColor, Color backgroundColor, Color currentBorderColor, Color borderColor, int tabPlacement) {
        if (!currentColor.equals((Object)backgroundColor) || !currentBorderColor.equals((Object)borderColor)) {
            currentImage = ImageKit.copyImage(currentImage);
            currentImage = ImageKit.swapImageColors(currentImage, currentColor, backgroundColor);
            if (!Color.BLACK.equals((Object)borderColor)) {
                currentImage = ImageKit.swapImageColors(currentImage, currentBorderColor, borderColor);
            }
            if (tabPlacement == 7) {
                currentImage = ImageKit.flipImage(currentImage);
            }
        }
        return currentImage;
    }

    private static Image _loadResImage(String imageFileName) {
        URL url = Resources.class.getResource("images/" + imageFileName);
        return ImageKit.loadCachedImage(url);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.activeTabImage = ImageKit.readSerializedImage(in);
        this.inactiveTabImage = ImageKit.readSerializedImage(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ImageKit.writeSerializedImage(out, this.activeTabImage);
        ImageKit.writeSerializedImage(out, this.inactiveTabImage);
    }
}

