/*
 * Decompiled with CFR 0.152.
 */
package echopointng.tabbedpane.test;

import echopointng.TabbedPane;
import echopointng.tabbedpane.AbstractTabModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;

public class LazyTabModel
extends AbstractTabModel {
    private Map tabMap = new HashMap();
    private Map contentMap = new HashMap();
    private int currentIndex = -1;

    public int size() {
        return 10;
    }

    public Component getTabAt(TabbedPane tabbedPane, int index, boolean isSelected) {
        Component tabComponent = (Component)this.contentMap.get(new Integer(index));
        if (tabComponent == null) {
            tabComponent = new Label("Tab " + index);
            this.contentMap.put(new Integer(index), tabComponent);
        }
        if (isSelected) {
            tabComponent.setForeground(Color.ORANGE);
        } else {
            tabComponent.setForeground(Color.BLACK);
        }
        return tabComponent;
    }

    public Component getTabContentAt(int index) {
        if (this.currentIndex != -1 && this.currentIndex != index) {
            throw new IllegalStateException("getTabContentAt called without a corresponding releaseTabAt");
        }
        Component content = (Component)this.contentMap.get(new Integer(index));
        if (content == null) {
            content = new Label("Content for Tab" + index);
            this.contentMap.put(new Integer(index), content);
            this.currentIndex = index;
        }
        return content;
    }

    public void releaseTabAt(int index) {
        this.currentIndex = -1;
    }

    public int indexOfTab(Component tabComponent) {
        return this.getIndexOfComponent(this.tabMap, tabComponent);
    }

    public int indexOfTabContent(Component tabContent) {
        return this.getIndexOfComponent(this.contentMap, tabContent);
    }

    private int getIndexOfComponent(Map map, Component component) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Integer index = (Integer)iter.next();
            Component componentTest = (Component)this.tabMap.get(index);
            if (component != componentTest) continue;
            return index;
        }
        return -1;
    }
}

