/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webrender;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.ServiceRegistry;
import nextapp.echo2.webrender.UserInstance;
import nextapp.echo2.webrender.service.CoreServices;
import nextapp.echo2.webrender.service.DebugPaneService;

public abstract class WebRenderServlet
extends HttpServlet {
    private static final ThreadLocal activeConnection = new ThreadLocal();
    public static final boolean DISABLE_CACHING = false;
    public static final String SERVICE_ID_PARAMETER = "serviceId";
    public static final String SERVICE_ID_DEFAULT = "Echo.Default";
    public static final String SERVICE_ID_NEW_INSTANCE = "Echo.NewInstance";
    public static final String SERVICE_ID_SESSION_EXPIRED = "Echo.Expired";
    private static MultipartRequestWrapper multipartRequestWrapper;
    private static final long startupTime;
    private static final ServiceRegistry services;

    public static final Connection getActiveConnection() {
        return (Connection)activeConnection.get();
    }

    public static MultipartRequestWrapper getMultipartRequestWrapper() {
        return multipartRequestWrapper;
    }

    public static final void setMultipartRequestWrapper(MultipartRequestWrapper multipartRequestWrapper) {
        if (WebRenderServlet.multipartRequestWrapper == null) {
            WebRenderServlet.multipartRequestWrapper = multipartRequestWrapper;
        } else if (multipartRequestWrapper == null || !WebRenderServlet.multipartRequestWrapper.getClass().getName().equals(multipartRequestWrapper.getClass().getName())) {
            throw new IllegalStateException("MultipartRequestWrapper already set.");
        }
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(request, response);
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(request, response);
    }

    private static Service getService(UserInstance userInstance, String id) {
        Service service = services.get(id);
        if (id == null) {
            id = userInstance == null ? SERVICE_ID_NEW_INSTANCE : SERVICE_ID_DEFAULT;
        } else if (userInstance == null) {
            id = SERVICE_ID_SESSION_EXPIRED;
        }
        service = services.get(id);
        if (service == null) {
            if (SERVICE_ID_DEFAULT.equals(id)) {
                throw new RuntimeException("Service not registered: SERVICE_ID_DEFAULT");
            }
            if (SERVICE_ID_NEW_INSTANCE.equals(id)) {
                throw new RuntimeException("Service not registered: SERVICE_ID_NEW_INSTANCE");
            }
            if (SERVICE_ID_SESSION_EXPIRED.equals(id)) {
                throw new RuntimeException("Service not registered: SERVICE_ID_SESSION_EXPIRED");
            }
        }
        return service;
    }

    public static ServiceRegistry getServiceRegistry() {
        return services;
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Connection conn = null;
        try {
            conn = new Connection(this, request, response);
            activeConnection.set(conn);
            String serviceId = request.getParameter(SERVICE_ID_PARAMETER);
            Service service = WebRenderServlet.getService(conn.getUserInstance(), serviceId);
            if (service == null) {
                throw new ServletException("Service id \"" + serviceId + "\" not registered.");
            }
            int version = service.getVersion();
            if (version != -1) {
                response.setHeader("Cache-Control", "max-age=3600");
                response.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
                response.setDateHeader("Last-Modified", startupTime);
            } else {
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Cache-Control", "no-store");
                response.setHeader("Expires", "0");
            }
            service.service(conn);
        }
        catch (ServletException ex) {
            if (conn != null) {
                conn.disposeUserInstance();
            }
            throw ex;
        }
        catch (IOException ex) {
            if (conn != null) {
                conn.disposeUserInstance();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (conn != null) {
                conn.disposeUserInstance();
            }
            throw ex;
        }
        finally {
            activeConnection.set(null);
        }
    }

    static {
        startupTime = System.currentTimeMillis();
        services = new ServiceRegistry();
        CoreServices.install(services);
        services.add(DebugPaneService.INSTANCE);
    }

    public static interface MultipartRequestWrapper {
        public HttpServletRequest getWrappedRequest(HttpServletRequest var1) throws IOException, ServletException;
    }
}

