/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.filetransfer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import javax.servlet.http.HttpServletResponse;
import nextapp.echo2.app.filetransfer.Download;
import nextapp.echo2.app.filetransfer.DownloadProvider;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.filetransfer.DownloadPeer;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ContentType;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;

class DownloadService
implements Service,
Serializable {
    private static final String SERVICE_ID = "Echo.Download";
    private static final String PARAMETER_DOWNLOAD_UID = "downloaduid";
    private static final String[] URL_PARAMETERS = new String[]{"downloaduid"};
    public static final DownloadService INSTANCE = new DownloadService();

    DownloadService() {
    }

    public String createUri(ContainerInstance containerInstance, String downloadId) {
        return containerInstance.getServiceUri((Service)this, URL_PARAMETERS, new String[]{downloadId});
    }

    public String getId() {
        return SERVICE_ID;
    }

    public int getVersion() {
        return -1;
    }

    public void service(Connection conn) throws IOException {
        ContainerInstance containerInstance = (ContainerInstance)conn.getUserInstance();
        if (containerInstance == null) {
            this.serviceBadRequest(conn, "No container available.");
            return;
        }
        String downloadId = conn.getRequest().getParameter(PARAMETER_DOWNLOAD_UID);
        if (downloadId == null) {
            this.serviceBadRequest(conn, "Download UID not specified.");
            return;
        }
        Download download = DownloadPeer.getDownload(downloadId);
        if (download == null) {
            this.serviceBadRequest(conn, "Download UID is not valid.");
            return;
        }
        this.service(conn, download);
    }

    public void service(Connection conn, Download download) throws IOException {
        String contentType;
        OutputStream out = conn.getOutputStream();
        DownloadProvider provider = download.getProvider();
        HttpServletResponse response = conn.getResponse();
        if (provider.getFileName() == null) {
            response.setHeader("Content-Disposition", "attachment");
        } else {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + provider.getFileName() + "\"");
        }
        if (provider.getSize() > 0) {
            response.setIntHeader("Content-Length", provider.getSize());
        }
        if ((contentType = provider.getContentType()) == null) {
            response.setContentType("application/octet-stream");
        } else {
            response.setContentType(provider.getContentType());
        }
        provider.writeFile(out);
    }

    public void serviceBadRequest(Connection conn, String message) {
        conn.getResponse().setStatus(400);
        conn.setContentType(ContentType.TEXT_PLAIN);
        conn.getWriter().write(message);
    }

    static {
        WebRenderServlet.getServiceRegistry().add((Service)INSTANCE);
    }
}

