/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.core.ontology;

import ch.uzh.ifi.attempto.acewiki.core.ontology.Individual;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Ontology;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Concept
extends OntologyElement {
    private List<Individual> individualsCache;
    private long individualsCacheStateID = -1L;
    private List<Concept> superConceptsCache;
    private long superConceptsCacheStateID = -1L;
    private List<Concept> subConceptsCache;
    private long subConceptsCacheStateID = -1L;

    protected Concept() {
    }

    public synchronized List<Individual> getIndividuals() {
        Ontology ontology = this.getOntology();
        if (this.individualsCacheStateID != ontology.getStateID()) {
            this.individualsCache = ontology.getIndividuals(this);
            this.individualsCacheStateID = ontology.getStateID();
        }
        return new ArrayList<Individual>(this.individualsCache);
    }

    public boolean areIndividualsCached() {
        return this.individualsCacheStateID == this.getOntology().getStateID();
    }

    public synchronized List<Concept> getSuperConcepts() {
        Ontology ontology = this.getOntology();
        if (this.superConceptsCacheStateID != ontology.getStateID()) {
            this.superConceptsCache = ontology.getSuperConcepts(this);
            this.superConceptsCacheStateID = ontology.getStateID();
        }
        return new ArrayList<Concept>(this.superConceptsCache);
    }

    public boolean areSuperConceptsCached() {
        return this.superConceptsCacheStateID == this.getOntology().getStateID();
    }

    public synchronized List<Concept> getSubConcepts() {
        Ontology ontology = this.getOntology();
        if (this.subConceptsCacheStateID != ontology.getStateID()) {
            this.subConceptsCache = ontology.getSubConcepts(this);
            this.subConceptsCacheStateID = ontology.getStateID();
        }
        return new ArrayList<Concept>(this.subConceptsCache);
    }

    public boolean areSubConceptsCached() {
        return this.subConceptsCacheStateID == this.getOntology().getStateID();
    }
}

