/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.core.ontology;

import ch.uzh.ifi.attempto.acewiki.Logger;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Concept;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Individual;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Sentence;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.coode.owlapi.owlxml.renderer.OWLXMLRenderer;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.io.OWLOntologyInputSource;
import org.semanticweb.owl.io.StringInputSource;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologySetProvider;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.util.OWLOntologyMerger;
import uk.ac.manchester.cs.owl.OWLClassImpl;
import uk.ac.manchester.cs.owl.OWLDataFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ontology {
    private static final HashMap<String, Ontology> ontologies = new HashMap();
    private ArrayList<OntologyElement> elements = new ArrayList();
    private Hashtable<String, OntologyElement> wordIndex = new Hashtable();
    private Hashtable<Long, OntologyElement> idIndex = new Hashtable();
    private final String name;
    private final String baseURI;
    private long idCount = 0L;
    private long stateID = 0L;
    private OWLReasoner reasoner;
    private OWLOntology differentIndividualsAxiom;

    private Ontology(String string, String string2) {
        this.name = string.toString();
        this.baseURI = string2;
        if (string2 == null) {
            string2 = "";
        }
        ontologies.put(string, this);
    }

    public static synchronized Ontology loadOntology(String string, String string2) {
        if (ontologies.get(string) != null) {
            return ontologies.get(string);
        }
        Ontology ontology = new Ontology(string, string2);
        ontology.log("loading ontology");
        File file = new File("data/" + string);
        if (file.exists()) {
            for (File file2 : file.listFiles()) {
                try {
                    long l = new Long(file2.getName());
                    ontology.log("reading file: " + file2.getName());
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    byte[] byArray = new byte[fileInputStream.available()];
                    fileInputStream.read(byArray);
                    fileInputStream.close();
                    String string3 = new String(byArray);
                    OntologyElement.loadOntologyElement(string3, l, ontology);
                }
                catch (NumberFormatException numberFormatException) {
                    ontology.log("ignoring file: " + file2.getName());
                }
                catch (IOException iOException) {
                    ontology.log("cannot read file: " + file2.getName());
                }
            }
        } else {
            ontology.log("no data found; blank ontology is created");
        }
        ontology.refreshReasoner();
        return ontology;
    }

    synchronized void save(OntologyElement ontologyElement) {
        if (!new File("data").exists()) {
            new File("data").mkdir();
        }
        if (!new File("data/" + this.name).exists()) {
            new File("data/" + this.name).mkdir();
        }
        if (!this.elements.contains(ontologyElement)) {
            new File("data/" + this.name + "/" + ontologyElement.getId()).delete();
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("data/" + this.name + "/" + ontologyElement.getId());
            fileOutputStream.write(ontologyElement.serialize().getBytes("UTF-8"));
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    synchronized void register(OntologyElement ontologyElement) {
        if (this.elements.contains(ontologyElement)) {
            this.log("error: element already registered");
            throw new RuntimeException("Registration failed: Element is already registered.");
        }
        this.log("register: " + ontologyElement);
        ++this.stateID;
        if (ontologyElement.getId() == -1L) {
            ontologyElement.setId(this.nextId());
        }
        this.elements.add(ontologyElement);
        this.idIndex.put(ontologyElement.getId(), ontologyElement);
        if (ontologyElement.getId() > this.idCount) {
            this.idCount = ontologyElement.getId();
        }
        for (String string : ontologyElement.getWords()) {
            if (string == null) continue;
            if (this.wordIndex.get(string) == null) {
                this.wordIndex.put(string, ontologyElement);
                continue;
            }
            if (this.wordIndex.get(string) == ontologyElement) continue;
            this.log("error: word already used");
            throw new RuntimeException("Registration failed: The word '" + string + "' is already used.");
        }
        if (ontologyElement instanceof Individual) {
            this.updateDifferentIndividualsAxiom();
        }
    }

    synchronized void removeFromWordIndex(OntologyElement ontologyElement) {
        for (String string : ontologyElement.getWords()) {
            if (string == null) continue;
            this.wordIndex.remove(string);
        }
    }

    synchronized void addToWordIndex(OntologyElement ontologyElement) {
        for (String string : ontologyElement.getWords()) {
            if (string == null) continue;
            if (this.wordIndex.get(string) == null) {
                this.wordIndex.put(string, ontologyElement);
                continue;
            }
            if (this.wordIndex.get(string) == ontologyElement) continue;
            throw new RuntimeException("Word update failed: The word '" + string + "' is already used.");
        }
    }

    public synchronized void remove(OntologyElement ontologyElement) {
        if (!this.elements.contains(ontologyElement)) {
            this.log("error: unknown element");
            return;
        }
        this.log("remove: " + ontologyElement.getWord());
        ++this.stateID;
        for (String string : ontologyElement.getWords()) {
            if (string == null) continue;
            this.wordIndex.remove(string);
        }
        this.elements.remove(ontologyElement);
        this.idIndex.remove(ontologyElement.getId());
        for (Sentence sentence : ontologyElement.getSentences()) {
            this.retractSentence(sentence);
        }
        this.save(ontologyElement);
        if (ontologyElement instanceof Individual) {
            this.updateDifferentIndividualsAxiom();
        }
    }

    public synchronized List<Sentence> getReferences(OntologyElement ontologyElement, int n) {
        ArrayList<Sentence> arrayList = new ArrayList<Sentence>();
        for (OntologyElement ontologyElement2 : this.elements) {
            for (Sentence sentence : ontologyElement2.getSentences()) {
                if ((n != -1 || !sentence.contains(ontologyElement)) && (n <= -1 || !sentence.contains(ontologyElement, n))) continue;
                arrayList.add(sentence);
            }
        }
        return arrayList;
    }

    public synchronized List<Sentence> getReferences(OntologyElement ontologyElement) {
        return this.getReferences(ontologyElement, -1);
    }

    public OntologyElement get(String string) {
        return this.wordIndex.get(string);
    }

    OntologyElement get(long l) {
        return this.idIndex.get(l);
    }

    public Collection<OntologyElement> getOntologyElements() {
        return new ArrayList<OntologyElement>(this.elements);
    }

    public boolean contains(OntologyElement ontologyElement) {
        return this.elements.contains(ontologyElement);
    }

    public String getName() {
        return this.name;
    }

    public String getURI() {
        return this.baseURI + this.name;
    }

    public synchronized String getOWLOntologyAsXML() {
        StringWriter stringWriter = new StringWriter();
        try {
            OWLXMLRenderer oWLXMLRenderer = new OWLXMLRenderer(OWLManager.createOWLOntologyManager());
            oWLXMLRenderer.render(this.getOWLOntology(), (Writer)stringWriter);
            stringWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringWriter.toString();
    }

    public synchronized OWLOntology getOWLOntology() {
        OWLOntologySetProvider oWLOntologySetProvider = new OWLOntologySetProvider(){

            public Set<OWLOntology> getOntologies() {
                HashSet<OWLOntology> hashSet = new HashSet<OWLOntology>();
                for (OntologyElement ontologyElement : Ontology.this.elements) {
                    for (Sentence sentence : ontologyElement.getSentences()) {
                        OWLOntology oWLOntology;
                        if (!sentence.isReasonerParticipant() || !sentence.isIntegrated() || (oWLOntology = sentence.getOWLOntology()) == null) continue;
                        hashSet.add(oWLOntology);
                    }
                }
                hashSet.add(Ontology.this.differentIndividualsAxiom);
                return hashSet;
            }
        };
        URI uRI = null;
        try {
            uRI = new URI("http://attempto.ifi.uzh.ch/default/");
            uRI = new URI(this.getURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        OWLOntology oWLOntology = null;
        try {
            OWLOntologyMerger oWLOntologyMerger = new OWLOntologyMerger(oWLOntologySetProvider);
            oWLOntology = oWLOntologyMerger.createMergedOntology(OWLManager.createOWLOntologyManager(), uRI);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return oWLOntology;
    }

    private synchronized void refreshReasoner() {
        this.log("refresh reasoner");
        if (this.reasoner == null) {
            this.reasoner = new Reasoner(OWLManager.createOWLOntologyManager());
        } else {
            this.clearOntologies();
        }
        this.updateDifferentIndividualsAxiom();
        this.log("reasoner: loading statements");
        HashSet<OWLOntology> hashSet = new HashSet<OWLOntology>();
        for (OntologyElement ontologyElement : this.elements) {
            for (Sentence sentence : ontologyElement.getSentences()) {
                OWLOntology oWLOntology;
                if (!sentence.isReasonerParticipant() || !sentence.isIntegrated() || (oWLOntology = sentence.getOWLOntology()) == null) continue;
                hashSet.add(oWLOntology);
            }
        }
        try {
            this.reasoner.loadOntologies(hashSet);
        }
        catch (OWLReasonerException oWLReasonerException) {
            oWLReasonerException.printStackTrace();
        }
        this.log("reasoner: statements loaded");
    }

    synchronized void refresh(OntologyElement ontologyElement) {
        for (Sentence sentence : this.getReferences(ontologyElement)) {
            if (sentence.isIntegrated()) {
                this.retractSentence(sentence);
                sentence.parse();
                this.commitSentence(sentence);
                continue;
            }
            sentence.parse();
        }
        this.save(ontologyElement);
    }

    public OWLOntology readOWLOntology(String string) throws OWLOntologyCreationException {
        return OWLManager.createOWLOntologyManager().loadOntology((OWLOntologyInputSource)new StringInputSource(string));
    }

    synchronized int commitSentence(Sentence sentence) {
        if (this.reasoner == null || sentence == null || sentence.isIntegrated()) {
            return 0;
        }
        if (!sentence.isReasonerParticipant()) {
            sentence.setIntegrated(true);
            return 0;
        }
        this.log("commit sentence");
        try {
            this.loadOntology(sentence.getOWLOntology());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.log("error: out of memory");
            System.gc();
            this.refreshReasoner();
            return 2;
        }
        this.log("check for consistency");
        if (this.isConsistent()) {
            this.log("consistent!");
            sentence.setIntegrated(true);
            ++this.stateID;
            return 0;
        }
        this.log("not consistent!");
        this.unloadOntology(sentence.getOWLOntology());
        return 1;
    }

    synchronized void retractSentence(Sentence sentence) {
        if (this.reasoner == null || sentence == null || !sentence.isIntegrated() || !sentence.isReasonerParticipant()) {
            return;
        }
        this.log("retract sentence");
        ++this.stateID;
        this.unloadOntology(sentence.getOWLOntology());
        sentence.setIntegrated(false);
    }

    void log(String string) {
        Logger.log(this.name, "onto", 0, "onto", string);
    }

    private synchronized void updateDifferentIndividualsAxiom() {
        if (this.reasoner == null) {
            return;
        }
        if (this.differentIndividualsAxiom != null) {
            this.unloadOntology(this.differentIndividualsAxiom);
        }
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<Ontology xml:base=\"http://www.w3.org/2006/12/owl11-xml#\" xmlns=\"http://www.w3.org/2006/12/owl11-xml#\" URI=\"" + this.getURI() + "/different_individuals/" + this.stateID + "\">\n" + "\t<DifferentIndividuals>\n";
        for (OntologyElement ontologyElement : this.getOntologyElements()) {
            if (!(ontologyElement instanceof Individual)) continue;
            String string2 = ((Individual)ontologyElement).getWord();
            if (string2.startsWith("the ")) {
                string2 = string2.substring(4);
            }
            string = string + "\t\t<Individual URI=\"" + ((Individual)ontologyElement).getURI() + "\" />\n";
        }
        string = string + "\t</DifferentIndividuals>\n</Ontology>";
        try {
            this.differentIndividualsAxiom = this.readOWLOntology(string);
            this.loadOntology(this.differentIndividualsAxiom);
        }
        catch (OWLOntologyCreationException oWLOntologyCreationException) {
            this.log("unexpected error");
            oWLOntologyCreationException.printStackTrace();
        }
    }

    public synchronized List<Concept> getConcepts(Individual individual) {
        OWLIndividual oWLIndividual = new OWLDataFactoryImpl().getOWLIndividual(individual.getURI());
        ArrayList<Concept> arrayList = new ArrayList<Concept>();
        try {
            Set set = this.reasoner.getTypes(oWLIndividual, false);
            for (Set set2 : set) {
                for (OWLClass oWLClass : set2) {
                    if (oWLClass.isOWLThing() || oWLClass.isOWLNothing()) continue;
                    String string = oWLClass.getURI().toASCIIString();
                    String string2 = string.substring(string.indexOf("#") + 1);
                    arrayList.add((Concept)this.get(string2));
                }
            }
        }
        catch (OWLReasonerException oWLReasonerException) {
            oWLReasonerException.printStackTrace();
        }
        return arrayList;
    }

    public synchronized List<Individual> getIndividuals(Concept concept) {
        OWLClassImpl oWLClassImpl = new OWLClassImpl((OWLDataFactory)new OWLDataFactoryImpl(), concept.getURI());
        ArrayList<Individual> arrayList = new ArrayList<Individual>();
        try {
            Set set = this.reasoner.getIndividuals((OWLDescription)oWLClassImpl, false);
            for (OWLIndividual oWLIndividual : set) {
                String string = oWLIndividual.getURI().toASCIIString();
                String string2 = string.substring(string.indexOf("#") + 1);
                if (string2.matches("I[0-9]+")) continue;
                arrayList.add((Individual)this.get(string2));
            }
        }
        catch (OWLReasonerException oWLReasonerException) {
            oWLReasonerException.printStackTrace();
        }
        return arrayList;
    }

    public synchronized List<Concept> getSuperConcepts(Concept concept) {
        OWLClassImpl oWLClassImpl = new OWLClassImpl((OWLDataFactory)new OWLDataFactoryImpl(), concept.getURI());
        ArrayList<Concept> arrayList = new ArrayList<Concept>();
        try {
            Set set = this.reasoner.getAncestorClasses((OWLDescription)oWLClassImpl);
            for (Set set2 : set) {
                for (OWLClass oWLClass : set2) {
                    if (oWLClass.isOWLThing() || oWLClass.isOWLNothing()) continue;
                    String string = oWLClass.getURI().toASCIIString();
                    String string2 = string.substring(string.indexOf("#") + 1);
                    arrayList.add((Concept)this.get(string2));
                }
            }
        }
        catch (OWLReasonerException oWLReasonerException) {
            oWLReasonerException.printStackTrace();
        }
        return arrayList;
    }

    public synchronized List<Concept> getSubConcepts(Concept concept) {
        OWLClassImpl oWLClassImpl = new OWLClassImpl((OWLDataFactory)new OWLDataFactoryImpl(), concept.getURI());
        ArrayList<Concept> arrayList = new ArrayList<Concept>();
        try {
            Set set = this.reasoner.getDescendantClasses((OWLDescription)oWLClassImpl);
            for (Set set2 : set) {
                for (OWLClass oWLClass : set2) {
                    if (oWLClass.isOWLThing() || oWLClass.isOWLNothing()) continue;
                    String string = oWLClass.getURI().toASCIIString();
                    String string2 = string.substring(string.indexOf("#") + 1);
                    arrayList.add((Concept)this.get(string2));
                }
            }
        }
        catch (OWLReasonerException oWLReasonerException) {
            oWLReasonerException.printStackTrace();
        }
        return arrayList;
    }

    public synchronized List<Individual> getAnswer(Sentence sentence) {
        if (!sentence.isQuestion()) {
            return null;
        }
        ArrayList<Individual> arrayList = new ArrayList<Individual>();
        OWLOntology oWLOntology = sentence.getOWLOntology();
        if (oWLOntology == null || oWLOntology.isEmpty()) {
            return null;
        }
        try {
            OWLSubClassAxiom oWLSubClassAxiom = (OWLSubClassAxiom)oWLOntology.getAxioms().iterator().next();
            Set set = this.reasoner.getIndividuals(oWLSubClassAxiom.getSubClass(), false);
            for (OWLIndividual oWLIndividual : set) {
                String string = oWLIndividual.getURI().toASCIIString();
                String string2 = string.substring(string.indexOf("#") + 1);
                if (string2.matches("I[0-9]+")) continue;
                arrayList.add((Individual)this.get(string2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public synchronized boolean isConsistent() {
        boolean bl = true;
        try {
            bl = this.reasoner.isSatisfiable((OWLDescription)new OWLDataFactoryImpl().getOWLThing());
        }
        catch (OWLReasonerException oWLReasonerException) {
            oWLReasonerException.printStackTrace();
        }
        return bl;
    }

    public synchronized boolean isSatisfiable(Concept concept) {
        OWLClassImpl oWLClassImpl = new OWLClassImpl((OWLDataFactory)new OWLDataFactoryImpl(), concept.getURI());
        boolean bl = false;
        try {
            bl = !this.reasoner.isDefined((OWLClass)oWLClassImpl) || this.reasoner.isSatisfiable((OWLDescription)oWLClassImpl);
        }
        catch (OWLReasonerException oWLReasonerException) {
            oWLReasonerException.printStackTrace();
        }
        return bl;
    }

    private void loadOntology(OWLOntology oWLOntology) {
        if (oWLOntology == null) {
            return;
        }
        HashSet<OWLOntology> hashSet = new HashSet<OWLOntology>();
        hashSet.add(oWLOntology);
        try {
            this.reasoner.loadOntologies(hashSet);
        }
        catch (OWLReasonerException oWLReasonerException) {
            oWLReasonerException.printStackTrace();
        }
    }

    private void unloadOntology(OWLOntology oWLOntology) {
        if (oWLOntology == null) {
            return;
        }
        HashSet<OWLOntology> hashSet = new HashSet<OWLOntology>();
        hashSet.add(oWLOntology);
        try {
            this.reasoner.unloadOntologies(hashSet);
        }
        catch (OWLReasonerException oWLReasonerException) {
            oWLReasonerException.printStackTrace();
        }
    }

    private void clearOntologies() {
        try {
            this.reasoner.clearOntologies();
        }
        catch (OWLReasonerException oWLReasonerException) {
            oWLReasonerException.printStackTrace();
        }
    }

    private long nextId() {
        return ++this.idCount;
    }

    long getStateID() {
        return this.stateID;
    }
}

