/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.core.ontology;

import ch.uzh.ifi.attempto.acewiki.core.ontology.Individual;
import ch.uzh.ifi.attempto.acewiki.core.ontology.NounConcept;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OfRole;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Ontology;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Sentence;
import ch.uzh.ifi.attempto.acewiki.core.ontology.TrAdjRole;
import ch.uzh.ifi.attempto.acewiki.core.ontology.VerbRole;
import ch.uzh.ifi.attempto.ape.LexiconEntry;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OntologyElement
implements Comparable<OntologyElement> {
    private Ontology ontology;
    private final Vector<Sentence> text = new Vector();
    private long id = -1L;

    protected OntologyElement() {
    }

    static OntologyElement loadOntologyElement(String string, long l, Ontology ontology) {
        OntologyElement ontologyElement;
        String[] stringArray = string.split("\n");
        if (!stringArray[0].startsWith("type:") || !stringArray[1].startsWith("words:")) {
            System.err.println("Cannot read ontology element " + l);
            return null;
        }
        String string2 = stringArray[0].substring("type:".length());
        String[] stringArray2 = stringArray[1].substring("words:".length()).split(";");
        if (string2.equals("propername")) {
            ontologyElement = new Individual();
        } else if (string2.equals("noun")) {
            ontologyElement = new NounConcept();
        } else if (string2.equals("nounof")) {
            ontologyElement = new OfRole();
        } else if (string2.equals("trverb")) {
            ontologyElement = new VerbRole();
        } else if (string2.equals("tradj")) {
            ontologyElement = new TrAdjRole();
        } else {
            System.err.println("Cannot read ontology element " + l);
            return null;
        }
        ontologyElement.setId(l);
        ontologyElement.setWords(stringArray2);
        for (int i = 2; i < stringArray.length; ++i) {
            Sentence sentence = Sentence.loadSentence(stringArray[i], ontologyElement);
            ontologyElement.text.add(sentence);
        }
        ontologyElement.ontology = ontology;
        ontology.register(ontologyElement);
        return ontologyElement;
    }

    public abstract String[] getWords();

    public String getWord(int n) {
        return this.getWords()[n];
    }

    public String getWord() {
        return this.getWord(0);
    }

    public String getPrettyWord(int n) {
        String string = this.getWord(n);
        if (string == null) {
            return null;
        }
        return string.replace("_", " ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWords(String ... stringArray) {
        if (this.ontology == null) {
            this.changeWords(stringArray);
        } else {
            Ontology ontology = this.ontology;
            synchronized (ontology) {
                this.ontology.removeFromWordIndex(this);
                this.changeWords(stringArray);
                this.ontology.addToWordIndex(this);
                this.ontology.refresh(this);
            }
        }
    }

    protected abstract void changeWords(String ... var1);

    public String getHeadword() {
        return this.getPrettyWord(0);
    }

    public String[] getIndexEntries() {
        return new String[]{this.getHeadword()};
    }

    public abstract String getType();

    public abstract String getInternalType();

    public Ontology getOntology() {
        return this.ontology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAt(Ontology ontology) {
        if (this.ontology != null) {
            throw new RuntimeException("Cannot change the ontology for element " + this.toString());
        }
        if (ontology == null) {
            return;
        }
        this.ontology = ontology;
        Ontology ontology2 = ontology;
        synchronized (ontology2) {
            ontology.register(this);
            ontology.save(this);
        }
    }

    public List<Sentence> getSentences() {
        return new ArrayList<Sentence>(this.text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int edit(Sentence sentence, List<Sentence> list) {
        this.log("edit sentence of " + this.getWord() + ": " + sentence.getText() + " > " + this.getSentencesString(list));
        Ontology ontology = this.ontology;
        synchronized (ontology) {
            int n;
            if (this.text.contains(sentence)) {
                n = this.text.indexOf(sentence);
                this.text.remove(n);
                this.text.addAll(n, list);
            } else {
                this.log("error: sentence is not around anymore");
                this.text.addAll(0, list);
            }
            n = 0;
            if (this.ontology != null) {
                this.ontology.retractSentence(sentence);
                for (Sentence sentence2 : list) {
                    int n2 = this.ontology.commitSentence(sentence2);
                    if (n2 <= n) continue;
                    n = n2;
                }
                this.ontology.save(this);
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(Sentence sentence, List<Sentence> list) {
        this.log("add sentences of " + this.getWord() + ": " + this.getSentencesString(list));
        Ontology ontology = this.ontology;
        synchronized (ontology) {
            if (this.text.contains(sentence)) {
                this.text.addAll(this.text.indexOf(sentence), list);
            } else {
                if (sentence != null) {
                    this.log("error: sentence is not around anymore");
                }
                this.text.addAll(list);
            }
            int n = 0;
            if (this.ontology != null) {
                for (Sentence sentence2 : list) {
                    int n2 = this.ontology.commitSentence(sentence2);
                    if (n2 <= n) continue;
                    n = n2;
                }
                this.ontology.save(this);
            }
            return n;
        }
    }

    private String getSentencesString(List<Sentence> list) {
        String string = "";
        for (Sentence sentence : list) {
            string = string + sentence.getText() + " ";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Sentence sentence) {
        Ontology ontology = this.ontology;
        synchronized (ontology) {
            if (this.text.contains(sentence)) {
                this.log("remove sentence: " + sentence.getText());
                this.text.remove(sentence);
            }
            if (this.ontology != null) {
                this.ontology.retractSentence(sentence);
                this.ontology.save(this);
            }
        }
    }

    List<LexiconEntry> getLexiconEntries() {
        return null;
    }

    public final URI getURI() {
        String string = "";
        if (this.ontology != null) {
            string = this.ontology.getURI();
        }
        URI uRI = null;
        try {
            uRI = new URI(string + this.getURISuffix());
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        return uRI;
    }

    public String getURISuffix() {
        return "#" + this.getWord();
    }

    final void setId(long l) {
        this.id = l;
    }

    final long getId() {
        return this.id;
    }

    protected void log(String string) {
        if (this.ontology != null) {
            this.ontology.log(string);
        }
    }

    String serialize() {
        String string = "type:";
        string = string + this.getInternalType() + "\nwords:";
        for (String string2 : this.getWords()) {
            string = string2 == null ? string + ";" : string + string2 + ";";
        }
        string = string + "\n";
        for (Sentence sentence : this.text) {
            string = string + sentence.serialize();
        }
        return string;
    }

    @Override
    public int compareTo(OntologyElement ontologyElement) {
        return this.getHeadword().toLowerCase().compareTo(ontologyElement.getHeadword().toLowerCase());
    }

    public String toString() {
        String string = "";
        for (String string2 : this.getWords()) {
            string = string2 == null ? string + "," : string + string2 + ",";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return this.getType() + "{" + string + "}";
    }
}

