/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.core.text;

import ch.uzh.ifi.attempto.acewiki.core.ontology.Individual;
import ch.uzh.ifi.attempto.acewiki.core.ontology.NounConcept;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OfRole;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.core.ontology.TrAdjRole;
import ch.uzh.ifi.attempto.acewiki.core.ontology.VerbRole;
import ch.uzh.ifi.attempto.acewiki.core.text.NounTextElem;
import ch.uzh.ifi.attempto.acewiki.core.text.OntoTextElem;
import ch.uzh.ifi.attempto.acewiki.core.text.OntologyTextElement;
import ch.uzh.ifi.attempto.preditor.text.TextElement;

public class TextElemFactory {
    private TextElemFactory() {
    }

    public static OntologyTextElement createTextElement(OntologyElement ontologyElement, int n) {
        if (ontologyElement instanceof NounConcept) {
            if (n == 0) {
                return new NounTextElem((NounConcept)ontologyElement);
            }
            if (n == 1) {
                return new OntoTextElem(ontologyElement, 1, "NOUNPL");
            }
        } else {
            if (ontologyElement instanceof Individual) {
                return new OntoTextElem(ontologyElement, n, "PROPERNAME");
            }
            if (ontologyElement instanceof VerbRole) {
                if (n == 0) {
                    return new OntoTextElem(ontologyElement, 0, "VERB");
                }
                if (n == 1) {
                    return new OntoTextElem(ontologyElement, 1, "VERBINF");
                }
                if (n == 2) {
                    return new OntoTextElem(ontologyElement, 2, "PVERB");
                }
            } else if (ontologyElement instanceof OfRole) {
                if (n == 0) {
                    return new OntoTextElem(ontologyElement, 0, "NOUNOF");
                }
            } else if (ontologyElement instanceof TrAdjRole && n == 0) {
                return new OntoTextElem(ontologyElement, 0, "TRADJ");
            }
        }
        return null;
    }

    public static TextElement createTextElement(OntologyElement ontologyElement) {
        return TextElemFactory.createTextElement(ontologyElement, 0);
    }
}

