/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui;

import ch.uzh.ifi.attempto.echocomp.SmallButton;
import ch.uzh.ifi.attempto.echocomp.SolidLabel;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class IndexBar
extends Column
implements ActionListener {
    private static final long serialVersionUID = -1496012516474073170L;
    private ActionListener actionListener;
    private SmallButton activeButton;
    private Row row;

    private IndexBar(String string) {
        Row row = new Row();
        row.setInsets(new Insets(10, 2, 5, 2));
        row.setCellSpacing(new Extent(5));
        row.add((Component)new SolidLabel(string, 2, 10));
        this.row = new Row();
        row.add((Component)this.row);
        this.add((Component)row);
    }

    public IndexBar(String string, ActionListener actionListener) {
        this(string);
        this.actionListener = actionListener;
        this.setLetters();
    }

    public IndexBar(String string, int n, ActionListener actionListener) {
        this(string);
        this.actionListener = actionListener;
        this.setNumbers(n);
    }

    public void setLetters() {
        this.row.removeAll();
        for (char c = 'A'; c <= 'Z'; c = (char)((char)(c + 1))) {
            SmallButton smallButton = new SmallButton(new String(new char[]{c}), (ActionListener)this, 12);
            smallButton.setBorder(new Border(1, Color.WHITE, 1));
            this.row.add((Component)smallButton);
        }
        this.activeButton = null;
        this.setActiveButton((SmallButton)this.row.getComponent(0));
    }

    public void setNumbers(int n) {
        this.row.removeAll();
        for (int i = 0; i < n; ++i) {
            SmallButton smallButton = new SmallButton(i + 1 + "", (ActionListener)this, 12);
            smallButton.setBorder(new Border(1, Color.WHITE, 1));
            this.row.add((Component)smallButton);
        }
        this.activeButton = null;
        if (n > 0) {
            this.setActiveButton((SmallButton)this.row.getComponent(0));
        }
    }

    public void setActiveButton(int n) {
        if (n >= 0 && n < this.row.getComponentCount()) {
            this.setActiveButton((SmallButton)this.row.getComponent(n));
        }
    }

    private void setActiveButton(SmallButton smallButton) {
        if (this.activeButton == smallButton) {
            return;
        }
        if (this.activeButton != null) {
            this.activeButton.setBorder(new Border(1, Color.WHITE, 1));
        }
        this.activeButton = smallButton;
        this.activeButton.setBorder(new Border(1, Color.DARKGRAY, 1));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setActiveButton((SmallButton)actionEvent.getSource());
        this.actionListener.actionPerformed(new ActionEvent((Object)this, actionEvent.getActionCommand()));
    }
}

