/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.editor;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Individual;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.core.text.TextElemFactory;
import ch.uzh.ifi.attempto.acewiki.gui.editor.NounForm;
import ch.uzh.ifi.attempto.acewiki.gui.editor.NounOfForm;
import ch.uzh.ifi.attempto.acewiki.gui.editor.ProperNameForm;
import ch.uzh.ifi.attempto.acewiki.gui.editor.TrAdjForm;
import ch.uzh.ifi.attempto.acewiki.gui.editor.VerbForm;
import ch.uzh.ifi.attempto.chartparser.Terminal;
import ch.uzh.ifi.attempto.preditor.MenuCreator;
import ch.uzh.ifi.attempto.preditor.MenuEntry;
import ch.uzh.ifi.attempto.preditor.MenuItem;
import ch.uzh.ifi.attempto.preditor.SpecialMenuItem;
import ch.uzh.ifi.attempto.preditor.text.BasicTextElement;
import ch.uzh.ifi.attempto.preditor.text.TextElement;
import nextapp.echo2.app.event.ActionListener;

class AceWikiMenuCreator
extends MenuCreator {
    private Wiki wiki;
    private OntologyElement highlightedElement;
    private ActionListener actionListener;

    public AceWikiMenuCreator(Wiki wiki, OntologyElement ontologyElement, ActionListener actionListener) {
        this.wiki = wiki;
        this.highlightedElement = ontologyElement;
        this.actionListener = actionListener;
    }

    public void initMenuCreation() {
        this.prepareMenuBlock("function word", true);
        this.prepareMenuBlock("noun", true);
        this.prepareMenuBlock("plural noun", true);
        this.prepareMenuBlock("proper name", true);
        this.prepareMenuBlock("of-construct", true);
        this.prepareMenuBlock("verb", true);
        this.prepareMenuBlock("passive verb", true);
        this.prepareMenuBlock("transitive adjective", true);
        this.prepareMenuBlock("reference", false);
        this.prepareMenuBlock("new variable", false);
    }

    public void processCategory(Terminal terminal) {
        if (terminal.getName().equals("PROPERNAME")) {
            SpecialMenuItem specialMenuItem = new SpecialMenuItem("new..."){
                private static final long serialVersionUID = -350111458598367634L;

                public void action() {
                    AceWikiMenuCreator.this.wiki.showWindow(ProperNameForm.createCreatorWindow(AceWikiMenuCreator.this.wiki, AceWikiMenuCreator.this.actionListener));
                }
            };
            this.addMenuItem("proper name", (MenuItem)specialMenuItem);
            this.addMenuEntries("proper name", "Proper Name", 0);
            for (OntologyElement ontologyElement : this.wiki.getOntologyElements()) {
                Individual individual;
                if (!(ontologyElement instanceof Individual) || (individual = (Individual)ontologyElement).getAbbreviation() == null) continue;
                MenuEntry menuEntry = new MenuEntry((TextElement)TextElemFactory.createTextElement(ontologyElement, 2));
                menuEntry.setHighlighted(ontologyElement == this.highlightedElement);
                this.addMenuItem("proper name", (MenuItem)menuEntry);
            }
        } else if (terminal.getName().equals("NOUN")) {
            SpecialMenuItem specialMenuItem = new SpecialMenuItem("new..."){
                private static final long serialVersionUID = -1231084311228714943L;

                public void action() {
                    AceWikiMenuCreator.this.wiki.showWindow(NounForm.createCreatorWindow(0, AceWikiMenuCreator.this.wiki, AceWikiMenuCreator.this.actionListener));
                }
            };
            this.addMenuItem("noun", (MenuItem)specialMenuItem);
            this.addMenuEntries("noun", "Noun", 0);
        } else if (terminal.getName().equals("NOUNPL")) {
            SpecialMenuItem specialMenuItem = new SpecialMenuItem("new..."){
                private static final long serialVersionUID = -2417333739773492518L;

                public void action() {
                    AceWikiMenuCreator.this.wiki.showWindow(NounForm.createCreatorWindow(1, AceWikiMenuCreator.this.wiki, AceWikiMenuCreator.this.actionListener));
                }
            };
            this.addMenuItem("plural noun", (MenuItem)specialMenuItem);
            this.addMenuEntries("plural noun", "Noun", 1);
        } else if (terminal.getName().equals("NOUNOF")) {
            SpecialMenuItem specialMenuItem = new SpecialMenuItem("new..."){
                private static final long serialVersionUID = 1177809888334571322L;

                public void action() {
                    AceWikiMenuCreator.this.wiki.showWindow(NounOfForm.createCreatorWindow(AceWikiMenuCreator.this.wiki, AceWikiMenuCreator.this.actionListener));
                }
            };
            this.addMenuItem("of-construct", (MenuItem)specialMenuItem);
            this.addMenuEntries("of-construct", "Of-Construct", 0);
        } else if (terminal.getName().equals("VERB")) {
            SpecialMenuItem specialMenuItem = new SpecialMenuItem("new..."){
                private static final long serialVersionUID = -7240634464592044263L;

                public void action() {
                    AceWikiMenuCreator.this.wiki.showWindow(VerbForm.createCreatorWindow(0, AceWikiMenuCreator.this.wiki, AceWikiMenuCreator.this.actionListener));
                }
            };
            this.addMenuItem("verb", (MenuItem)specialMenuItem);
            this.addMenuEntries("verb", "Verb", 0);
        } else if (terminal.getName().equals("VERBINF")) {
            SpecialMenuItem specialMenuItem = new SpecialMenuItem("new..."){
                private static final long serialVersionUID = -3700453740738053228L;

                public void action() {
                    AceWikiMenuCreator.this.wiki.showWindow(VerbForm.createCreatorWindow(1, AceWikiMenuCreator.this.wiki, AceWikiMenuCreator.this.actionListener));
                }
            };
            this.addMenuItem("verb", (MenuItem)specialMenuItem);
            this.addMenuEntries("verb", "Verb", 1);
        } else if (terminal.getName().equals("PVERB")) {
            SpecialMenuItem specialMenuItem = new SpecialMenuItem("new..."){
                private static final long serialVersionUID = -1474626348181083481L;

                public void action() {
                    AceWikiMenuCreator.this.wiki.showWindow(VerbForm.createCreatorWindow(2, AceWikiMenuCreator.this.wiki, AceWikiMenuCreator.this.actionListener));
                }
            };
            this.addMenuItem("passive verb", (MenuItem)specialMenuItem);
            this.addMenuEntries("passive verb", "Verb", 2);
        } else if (terminal.getName().equals("TRADJ")) {
            SpecialMenuItem specialMenuItem = new SpecialMenuItem("new..."){
                private static final long serialVersionUID = 1928452310225044129L;

                public void action() {
                    AceWikiMenuCreator.this.wiki.showWindow(TrAdjForm.createCreatorWindow(AceWikiMenuCreator.this.wiki, AceWikiMenuCreator.this.actionListener));
                }
            };
            this.addMenuItem("transitive adjective", (MenuItem)specialMenuItem);
            this.addMenuEntries("transitive adjective", "Transitive Adjective", 0);
        } else if (terminal.getName().equals("REFERENCE")) {
            this.addReferenceEntries("reference", "REFERENCE");
        } else if (terminal.getName().equals("VARIABLE")) {
            this.addVariableEntries("new variable", 3, "VARIABLE");
        } else if (terminal.getName().equals("NUMBER")) {
            for (int i = 2; i <= 100; ++i) {
                this.addMenuEntry("function word", (TextElement)new BasicTextElement(i, "NUMBER"));
            }
        } else {
            this.addMenuEntry("function word", (TextElement)new BasicTextElement(terminal.getName()));
        }
    }

    private void addMenuEntries(String string, String string2, int n) {
        for (OntologyElement ontologyElement : this.wiki.getOntologyElements()) {
            if (!string2.equals(ontologyElement.getType()) || ontologyElement.getWord(n) == null) continue;
            MenuEntry menuEntry = new MenuEntry((TextElement)TextElemFactory.createTextElement(ontologyElement, n));
            menuEntry.setHighlighted(ontologyElement == this.highlightedElement);
            this.addMenuItem(string, (MenuItem)menuEntry);
        }
    }
}

