/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.editor;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OfRole;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.gui.editor.FormPane;
import ch.uzh.ifi.attempto.acewiki.gui.editor.WordEditorWindow;
import ch.uzh.ifi.attempto.ape.FunctionWords;
import ch.uzh.ifi.attempto.echocomp.TextField;
import ch.uzh.ifi.attempto.echocomp.WindowPane;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionListener;

public class NounOfForm
extends FormPane {
    private static final long serialVersionUID = -6544810970331235077L;
    private TextField nounField = new TextField((ActionListener)this);
    private OfRole role;

    public NounOfForm(OfRole ofRole, WindowPane windowPane, Wiki wiki, ActionListener actionListener) {
        super(windowPane, wiki, actionListener);
        this.role = ofRole;
        this.setIconRow("role", "Every of-construct represents a certain relation between things. For example, the of-construct \"child of\" relates persons to their parents. Every of-construct consists of a noun plus the preposition \"of\", for example \"part of\", \"child of\", \"owner of\", etc.");
        this.addRow("noun", (Component)this.nounField, "examples: part, child, owner", true);
        this.nounField.setText(ofRole.getPrettyNoun());
        ApplicationInstance.getActive().setFocusedComponent((Component)this.nounField);
    }

    public static WordEditorWindow createCreatorWindow(Wiki wiki, ActionListener actionListener) {
        WordEditorWindow wordEditorWindow = WordEditorWindow.createCreatorWindow();
        wordEditorWindow.addTab(new NounOfForm(new OfRole(), wordEditorWindow, wiki, actionListener));
        return wordEditorWindow;
    }

    public static WordEditorWindow createEditorWindow(OfRole ofRole, Wiki wiki) {
        WordEditorWindow wordEditorWindow = WordEditorWindow.createEditorWindow();
        wordEditorWindow.addTab(new NounOfForm(ofRole, wordEditorWindow, wiki, wiki));
        return wordEditorWindow;
    }

    protected void save() {
        Wiki wiki = this.getWiki();
        String string = NounOfForm.normalize(this.nounField.getText());
        if (string.toLowerCase().endsWith("_of")) {
            string = string.substring(0, string.length() - 3);
        }
        String string2 = string.replace("_", " ");
        if (string.equals("")) {
            wiki.log("edit", "error: no word defined");
            this.showErrorMessage("No noun defined: Please specify the singular form of a noun.");
            return;
        }
        if (!NounOfForm.isValidString(string)) {
            wiki.log("edit", "error: word contains invalid character");
            this.showErrorMessage("Invalid character: Only a-z, A-Z, 0-9, -, and spaces are allowed, and the first character must be one of a-z A-Z.");
            return;
        }
        if (FunctionWords.isFunctionWord((String)string)) {
            wiki.log("edit", "error: word is predefined");
            this.showErrorMessage("'" + string2 + "' is a predefined word and cannot be used here.");
            return;
        }
        OntologyElement ontologyElement = wiki.getOntology().get(string + " of");
        if (ontologyElement != null && ontologyElement != this.role) {
            wiki.log("edit", "error: word is already used");
            this.showErrorMessage("The word '" + string2 + "' is already used. Please use a different one.");
            return;
        }
        this.role.setWords(string);
        wiki.log("edit", "of-construct: " + string);
        if (this.role.getOntology() == null) {
            this.role.registerAt(this.getWiki().getOntology());
        }
        this.finished(this.role);
    }

    public String toString() {
        return "Of-Construct";
    }
}

