/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.editor;

import ch.uzh.ifi.attempto.acewiki.Task;
import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Sentence;
import ch.uzh.ifi.attempto.acewiki.gui.editor.AceWikiMenuCreator;
import ch.uzh.ifi.attempto.acewiki.gui.page.ArticlePage;
import ch.uzh.ifi.attempto.echocomp.MessageWindow;
import ch.uzh.ifi.attempto.echocomp.WindowPane;
import ch.uzh.ifi.attempto.preditor.MenuCreator;
import ch.uzh.ifi.attempto.preditor.PreditorWindow;
import ch.uzh.ifi.attempto.preditor.text.TextContainer;
import ch.uzh.ifi.attempto.preditor.text.TextElement;
import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class SentenceEditorHandler
implements ActionListener {
    private static final long serialVersionUID = -2083910385095284075L;
    private PreditorWindow editorWindow;
    private MessageWindow messageWindow;
    private ArticlePage page;
    private Wiki wiki;
    private boolean edit;
    private Sentence sentence;
    private List<Sentence> newSentences = new ArrayList<Sentence>();
    private int checked = 0;

    private SentenceEditorHandler(Sentence sentence, ArticlePage articlePage, boolean bl) {
        this.page = articlePage;
        this.wiki = articlePage.getWiki();
        this.edit = bl;
        this.sentence = sentence;
        AceWikiMenuCreator aceWikiMenuCreator = new AceWikiMenuCreator(this.wiki, articlePage.getOntologyElement(), this);
        this.editorWindow = new PreditorWindow("Sentence Editor", this.wiki.getGrammar(), (MenuCreator)aceWikiMenuCreator);
        this.editorWindow.addActionListener((ActionListener)this);
        if (bl) {
            String string = sentence.getPrettyText();
            this.editorWindow.addText(string.substring(0, string.length() - 1) + " ");
        }
    }

    public static PreditorWindow generatePreditorAddWindow(Sentence sentence, ArticlePage articlePage) {
        SentenceEditorHandler sentenceEditorHandler = new SentenceEditorHandler(sentence, articlePage, false);
        return sentenceEditorHandler.getPreditorWindow();
    }

    public static PreditorWindow generatePreditorEditWindow(Sentence sentence, ArticlePage articlePage) {
        SentenceEditorHandler sentenceEditorHandler = new SentenceEditorHandler(sentence, articlePage, true);
        return sentenceEditorHandler.getPreditorWindow();
    }

    private PreditorWindow getPreditorWindow() {
        return this.editorWindow;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.editorWindow && actionEvent.getActionCommand().equals("OK")) {
            ArrayList arrayList;
            TextContainer textContainer = this.editorWindow.getTextContainer();
            TextElement textElement = this.editorWindow.getPossibleNextToken(".");
            if (textElement == null) {
                textElement = this.editorWindow.getPossibleNextToken("?");
            }
            if (textElement != null) {
                textContainer.addElement(textElement);
            }
            if ((arrayList = textContainer.getTextElements()).isEmpty() || ((TextElement)arrayList.get(arrayList.size() - 1)).getText().matches("[.?]")) {
                this.newSentences = Sentence.generateSentences(textContainer, this.page.getOntologyElement());
                this.checkSentence();
            } else {
                this.wiki.log("edit", "error: unfinished sentences");
                MessageWindow messageWindow = new MessageWindow("Error", "There are unfinished sentences.", (WindowPane)this.editorWindow, new String[]{"OK"});
                this.page.getWiki().showWindow((WindowPane)messageWindow);
            }
        } else if (actionEvent.getSource() == this.editorWindow && actionEvent.getActionCommand().equals("Cancel")) {
            this.editorWindow.setVisible(false);
            this.editorWindow.dispose();
        } else if (actionEvent.getSource() == this.messageWindow && actionEvent.getActionCommand().equals("a ...")) {
            ++this.checked;
            this.checkSentence();
        } else if (actionEvent.getSource() == this.messageWindow && actionEvent.getActionCommand().equals("every ...")) {
            String string = this.newSentences.get(this.checked).getText();
            string = string.replaceFirst("^(A|a)n? ", "Every ");
            this.newSentences.remove(this.checked);
            this.newSentences.add(this.checked, new Sentence(string, this.page.getOntologyElement()));
            ++this.checked;
            this.checkSentence();
        } else if (actionEvent.getSource() == this.messageWindow && actionEvent.getActionCommand().equals("Close")) {
            this.checked = 0;
        } else if (actionEvent.getSource() instanceof TextElement) {
            this.editorWindow.addTextElement((TextElement)actionEvent.getSource());
        }
    }

    private void checkSentence() {
        if (this.checked >= this.newSentences.size()) {
            this.assertSentences();
        } else {
            List<TextElement> list = this.newSentences.get(this.checked).getTextElements();
            String string = list.get(0).getText();
            String string2 = list.get(1).getText();
            String string3 = list.get(list.size() - 1).getText();
            if (string.matches("(A|a)n?") && !string2.matches(".* of") && string3.equals(".")) {
                String string4 = list.get(1).getText();
                this.messageWindow = new MessageWindow("Warning", "Your sentence \"a " + string4 + " ...\" is interpreted as \"there is a " + string4 + " that ...\". " + "Do you want to say \"every " + string4 + " ...\"?", (WindowPane)this.editorWindow, (ActionListener)this, new String[]{"a ...", "every ..."});
                this.wiki.showWindow((WindowPane)this.messageWindow);
            } else {
                ++this.checked;
                this.checkSentence();
            }
        }
    }

    private void assertSentences() {
        final TextContainer textContainer = this.editorWindow.getTextContainer();
        final OntologyElement ontologyElement = this.page.getOntologyElement();
        Task task = new Task(){
            int success;

            public void run() {
                if (SentenceEditorHandler.this.edit) {
                    SentenceEditorHandler.this.wiki.log("edit", "sentence updated: " + textContainer.getText());
                    this.success = ontologyElement.edit(SentenceEditorHandler.this.sentence, SentenceEditorHandler.this.newSentences);
                } else {
                    SentenceEditorHandler.this.wiki.log("edit", "sentence created: " + textContainer.getText());
                    this.success = ontologyElement.add(SentenceEditorHandler.this.sentence, SentenceEditorHandler.this.newSentences);
                }
            }

            public void updateGUI() {
                SentenceEditorHandler.this.page.update();
                if (this.success == 1) {
                    SentenceEditorHandler.this.wiki.showWindow((WindowPane)new MessageWindow("Conflict", "A sentence is in conflict with the current knowledge. For that reason, it cannot be added to the knowledge base.", new String[]{"OK"}));
                } else if (this.success == 2) {
                    SentenceEditorHandler.this.wiki.showWindow((WindowPane)new MessageWindow("Error", "A sentence could not be added to the knowledge base because the knowledge base got too complex.", new String[]{"OK"}));
                }
                if (SentenceEditorHandler.this.page != null) {
                    SentenceEditorHandler.this.page.update();
                    SentenceEditorHandler.this.page.getWiki().update();
                }
            }
        };
        if (this.edit) {
            this.wiki.enqueueTaskShowingWaitWindow("Updating", "The knowledge base is being updated...", task);
        } else {
            this.wiki.enqueueTaskShowingWaitWindow("Updating", "The sentence is being added to the knowledge base...", task);
        }
        this.editorWindow.setVisible(false);
    }
}

