/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.editor;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.core.ontology.TrAdjRole;
import ch.uzh.ifi.attempto.acewiki.gui.editor.FormPane;
import ch.uzh.ifi.attempto.acewiki.gui.editor.WordEditorWindow;
import ch.uzh.ifi.attempto.ape.FunctionWords;
import ch.uzh.ifi.attempto.echocomp.TextField;
import ch.uzh.ifi.attempto.echocomp.WindowPane;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionListener;

public class TrAdjForm
extends FormPane {
    private static final long serialVersionUID = -4367996031949560664L;
    private TextField trAdjField = new TextField((ActionListener)this);
    private TrAdjRole role;

    public TrAdjForm(TrAdjRole trAdjRole, WindowPane windowPane, Wiki wiki, ActionListener actionListener) {
        super(windowPane, wiki, actionListener);
        this.role = trAdjRole;
        this.setIconRow("role", "Every transitive adjective represents a certain relation between things. For example, the transitive adjective \"located in\" relates things to their location. Transitive adjectives should consists of an adjective that is followed by a preposition.");
        this.addRow("tr. adjective", (Component)this.trAdjField, "examples: located in, matched with, fond of", true);
        this.trAdjField.setText(trAdjRole.getPrettyWord(0));
        ApplicationInstance.getActive().setFocusedComponent((Component)this.trAdjField);
    }

    public static WordEditorWindow createCreatorWindow(Wiki wiki, ActionListener actionListener) {
        WordEditorWindow wordEditorWindow = WordEditorWindow.createCreatorWindow();
        wordEditorWindow.addTab(new TrAdjForm(new TrAdjRole(), wordEditorWindow, wiki, actionListener));
        return wordEditorWindow;
    }

    public static WordEditorWindow createEditorWindow(TrAdjRole trAdjRole, Wiki wiki) {
        WordEditorWindow wordEditorWindow = WordEditorWindow.createEditorWindow();
        wordEditorWindow.addTab(new TrAdjForm(trAdjRole, wordEditorWindow, wiki, wiki));
        return wordEditorWindow;
    }

    protected void save() {
        Wiki wiki = this.getWiki();
        String string = TrAdjForm.normalize(this.trAdjField.getText());
        String string2 = string.replace("_", " ");
        if (string.equals("")) {
            wiki.log("edit", "error: no word defined");
            this.showErrorMessage("No word defined: Please specify the transitive adjective.");
            return;
        }
        if (!TrAdjForm.isValidString(string)) {
            wiki.log("edit", "error: word contains invalid character");
            this.showErrorMessage("Invalid character: Only a-z, A-Z, 0-9, -, and spaces are allowed, and the first character must be one of a-z A-Z.");
            return;
        }
        if (FunctionWords.isFunctionWord((String)string)) {
            wiki.log("edit", "error: word is predefined");
            this.showErrorMessage("'" + string2 + "' is a predefined word and cannot be used here.");
            return;
        }
        OntologyElement ontologyElement = wiki.getOntology().get(string);
        if (ontologyElement != null && ontologyElement != this.role) {
            wiki.log("edit", "error: word is already used");
            this.showErrorMessage("The word '" + string2 + "' is already used. Please use a different one.");
            return;
        }
        this.role.setWords(string);
        wiki.log("edit", "transitive adjective: " + string);
        if (this.role.getOntology() == null) {
            this.role.registerAt(this.getWiki().getOntology());
        }
        this.finished(this.role);
    }

    public String toString() {
        return "Transitive Adjective";
    }
}

