/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.page;

import ch.uzh.ifi.attempto.acewiki.core.ontology.Concept;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Individual;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Sentence;
import ch.uzh.ifi.attempto.acewiki.gui.IndexBar;
import ch.uzh.ifi.attempto.acewiki.gui.TextRow;
import ch.uzh.ifi.attempto.acewiki.gui.Title;
import ch.uzh.ifi.attempto.acewiki.gui.page.IndividualPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.ReferencesPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.WikiPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.WordPage;
import ch.uzh.ifi.attempto.echocomp.DelayedComponent;
import ch.uzh.ifi.attempto.echocomp.Label;
import ch.uzh.ifi.attempto.echocomp.SolidLabel;
import ch.uzh.ifi.attempto.echocomp.VSpace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class AssignmentsPage
extends WikiPage
implements ActionListener {
    private static final long serialVersionUID = -6955789540998283993L;
    private static final int pageSize = 20;
    private IndividualPage page;
    private Column assignmentsColumn = new Column();
    private int chosenPage = 0;

    public AssignmentsPage(IndividualPage individualPage) {
        super(individualPage.getWiki(), new Title(individualPage.getOntologyElement().getHeadword(), "- Assignments"));
        this.page = individualPage;
        this.addTab("Article", this);
        this.addTab("Proper Name", this);
        this.addTab("References", this);
        this.addSelectedTab("Assignments");
        this.add((Component)new VSpace(18));
        this.add((Component)this.assignmentsColumn);
    }

    protected void doUpdate() {
        this.getTitle().setText(this.page.getOntologyElement().getHeadword());
        this.assignmentsColumn.removeAll();
        Column column = new Column();
        column.setInsets(new Insets(10, 0, 0, 0));
        column.add((Component)new Label((ImageReference)new ResourceImageReference("ch/uzh/ifi/attempto/acewiki/gui/img/wait.gif")));
        if (((Individual)this.page.getOntologyElement()).areConceptsCached()) {
            this.assignmentsColumn.add((Component)new AssignmentsComponent());
        } else {
            this.assignmentsColumn.add((Component)new DelayedComponent((Component)column){
                private static final long serialVersionUID = 5909558908521223531L;

                public Component initComponent() {
                    return new AssignmentsComponent();
                }
            });
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("Article".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: article");
            this.getWiki().showPage(this.page);
        } else if ("Proper Name".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: word");
            this.getWiki().showPage(new WordPage(this.page));
        } else if ("References".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: references");
            this.getWiki().showPage(new ReferencesPage(this.page));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof AssignmentsPage) {
            return this.page.equals((Object)((AssignmentsPage)((Object)object)).page);
        }
        return false;
    }

    public boolean isExpired() {
        return this.page.isExpired();
    }

    public String toString() {
        return "-ASS- " + this.page.getOntologyElement().getWord();
    }

    private class AssignmentsComponent
    extends Column
    implements ActionListener {
        private static final long serialVersionUID = -441448088305771435L;
        private Column sentencesColumn = new Column();
        private IndexBar indexBar = new IndexBar("Page:", 0, this);
        private ArrayList<Sentence> sentences;

        public AssignmentsComponent() {
            this.add((Component)this.indexBar);
            this.sentencesColumn.setInsets(new Insets(10, 2, 5, 20));
            this.sentencesColumn.setCellSpacing(new Extent(2));
            this.add((Component)this.sentencesColumn);
            Individual individual = (Individual)AssignmentsPage.this.page.getOntologyElement();
            List<Concept> list = individual.getConcepts();
            this.sentences = new ArrayList();
            Collections.sort(list);
            for (Concept concept : list) {
                this.sentences.add(new Sentence(individual.getWord(2) + " is a " + concept.getWord() + ".", individual.getOntology()));
            }
            if (this.sentences.size() == 0) {
                this.indexBar.setVisible(false);
                this.sentencesColumn.add((Component)new SolidLabel("(no assignment found)", 2, 10));
            } else {
                int n = (this.sentences.size() - 1) / 20 + 1;
                if (AssignmentsPage.this.chosenPage > n) {
                    AssignmentsPage.this.chosenPage = 0;
                }
                this.indexBar.setNumbers(n);
                this.indexBar.setActiveButton(AssignmentsPage.this.chosenPage);
                this.updatePage();
            }
        }

        private void updatePage() {
            this.sentencesColumn.removeAll();
            this.indexBar.setVisible(this.sentences.size() > 20);
            int n = this.sentences.size();
            if (n > (AssignmentsPage.this.chosenPage + 1) * 20) {
                n = (AssignmentsPage.this.chosenPage + 1) * 20;
            }
            for (int i = AssignmentsPage.this.chosenPage * 20; i < n; ++i) {
                Row row = new Row();
                row.add((Component)new TextRow(this.sentences.get(i), AssignmentsPage.this));
                this.sentencesColumn.add((Component)row);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.indexBar) {
                AssignmentsPage.this.chosenPage = Integer.parseInt(actionEvent.getActionCommand()) - 1;
                AssignmentsPage.this.log("page", "pressed: page " + (AssignmentsPage.this.chosenPage + 1));
                this.updatePage();
            }
        }
    }
}

