/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.page;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Sentence;
import ch.uzh.ifi.attempto.acewiki.gui.Title;
import ch.uzh.ifi.attempto.acewiki.gui.page.SentencePage;
import ch.uzh.ifi.attempto.acewiki.gui.page.WikiPage;
import ch.uzh.ifi.attempto.ape.OutputType;
import ch.uzh.ifi.attempto.echocomp.VSpace;
import echopointng.DirectHtml;
import echopointng.util.HtmlKit;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class LogicPage
extends WikiPage
implements ActionListener {
    private static final long serialVersionUID = 61958212885537L;
    private Sentence sentence;

    public LogicPage(Wiki wiki, Sentence sentence) {
        super(wiki, new Title(sentence.toString(), "- Logic"));
        this.sentence = sentence;
        this.addTab("Sentence", this);
        this.addSelectedTab("Logic");
        this.add((Component)new VSpace(15));
        this.addHeadline("Logical representation");
        Column column = new Column();
        column.setInsets(new Insets(10, 0, 5, 15));
        column.add((Component)new DirectHtml("<i><pre>" + sentence.getParserResult().get(OutputType.DRSPP) + "</pre></i>"));
        this.add((Component)column);
        if (sentence.isOWLSWRL()) {
            if (sentence.isOWL()) {
                this.addHeadline("OWL (XML syntax)");
            } else {
                this.addHeadline("OWL+SWRL (RDF/XML syntax)");
            }
            Column column2 = new Column();
            column2.setInsets(new Insets(10, 0, 5, 25));
            column2.add((Component)new DirectHtml("<i><pre>" + HtmlKit.encode((String)sentence.getOWLXML()) + "</pre></i>"));
            this.add((Component)column2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("Sentence".equals(actionEvent.getActionCommand())) {
            this.getWiki().showPage(new SentencePage(this.getWiki(), this.sentence));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof LogicPage) {
            return this.sentence == ((LogicPage)((Object)object)).sentence;
        }
        return false;
    }

    public String toString() {
        return "Logic: " + this.sentence.getText();
    }
}

