/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.page;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.gui.Title;
import ch.uzh.ifi.attempto.acewiki.gui.page.ErrorPage;
import ch.uzh.ifi.attempto.echocomp.HSpace;
import ch.uzh.ifi.attempto.echocomp.Label;
import ch.uzh.ifi.attempto.echocomp.SmallButton;
import ch.uzh.ifi.attempto.echocomp.Style;
import ch.uzh.ifi.attempto.echocomp.VSpace;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionListener;

public abstract class WikiPage
extends Column {
    private Wiki wiki;
    private Title title;
    private Row tabRow;

    public WikiPage(Wiki wiki, Title title) {
        this.wiki = wiki;
        this.title = title;
        this.tabRow = new Row();
        this.tabRow.setInsets(new Insets(10, 0, 0, 0));
        this.add((Component)this.tabRow);
        this.add((Component)new VSpace(20));
        this.add((Component)title);
        this.addHorizontalLine();
    }

    public final void update() {
        if (this.isExpired()) {
            this.removeAll();
            this.add((Component)new ErrorPage(this.wiki, "This article does no longer exist."));
        } else {
            this.doUpdate();
        }
    }

    protected void doUpdate() {
    }

    public Wiki getWiki() {
        return this.wiki;
    }

    protected Title getTitle() {
        return this.title;
    }

    protected void log(String string, String string2) {
        this.wiki.log(string, string2);
    }

    public boolean isExpired() {
        return false;
    }

    protected void addTab(String string, String string2, ActionListener actionListener) {
        SmallButton smallButton = new SmallButton(string, actionListener, true);
        if (string2 != null) {
            smallButton.setActionCommand(string2);
        }
        this.tabRow.add((Component)smallButton);
        this.tabRow.add((Component)new HSpace(8));
        this.tabRow.add((Component)this.createTabSeparator());
        this.tabRow.add((Component)new HSpace(8));
    }

    protected void addTab(String string, ActionListener actionListener) {
        this.addTab(string, null, actionListener);
    }

    protected void addSelectedTab(String string) {
        this.tabRow.add((Component)new SmallButton(string, null, false));
        this.tabRow.add((Component)new HSpace(8));
        this.tabRow.add((Component)this.createTabSeparator());
        this.tabRow.add((Component)new HSpace(8));
    }

    private Button createTabSeparator() {
        Button button = new Button();
        button.setBorder(new Border(1, Color.DARKGRAY, 1));
        button.setHeight(new Extent(12));
        return button;
    }

    protected void addHorizontalLine() {
        Column column = new Column();
        column.setInsets(new Insets(10, 0, 10, 0));
        Column column2 = new Column();
        column2.setBackground(Color.DARKGRAY);
        column2.setInsets(new Insets(0, 1, 0, 0));
        column.add((Component)column2);
        this.add((Component)column);
    }

    protected void addHeadline(String string) {
        Row row = new Row();
        row.setInsets(new Insets(10, 10, 0, 0));
        Label label = new Label(string);
        label.setFont(new Font(Style.fontTypeface, 6, new Extent(13)));
        label.setLineWrap(false);
        row.add((Component)label);
        this.add((Component)row);
    }

    public abstract boolean equals(Object var1);
}

