/*
 * Decompiled with CFR 0.152.
 */
package com.lre.graph;

import com.lre.graph.Edge;
import com.lre.graph.Vertex;
import com.lre.graph.VertexClass;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Graph {
    private Hashtable vertices = new Hashtable();
    private static Vector mVisited;

    public void connect(Vertex start, Vertex end, String edgeLabel) {
        start.addEdge(new Edge(edgeLabel, end));
    }

    public boolean hasPath(Vertex start, Vertex end) {
        mVisited = new Vector();
        return this.pathExists(start, end);
    }

    private boolean pathExists(Vertex start, Vertex end) {
        mVisited.addElement(start);
        if (start.hasNeighbor(end)) {
            return true;
        }
        Vector v = start.listNeighbors();
        for (int i = 0; i < v.size(); ++i) {
            Vertex vert = (Vertex)v.elementAt(i);
            if (mVisited.contains(vert) || !this.pathExists(vert, end)) continue;
            return true;
        }
        return false;
    }

    public Vertex getVertex(String name) {
        if (this.vertices.containsKey(name)) {
            return (Vertex)this.vertices.get(name);
        }
        return null;
    }

    public Enumeration getVertexKeys() {
        return this.vertices.keys();
    }

    public void addVertex(Vertex v) {
        this.vertices.put(v.getName(), v);
    }

    public int numVertices() {
        return this.vertices.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.vertices.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            Vertex v = (Vertex)this.vertices.get(key);
            sb.append(v.toString() + "\n");
        }
        return sb.toString();
    }

    protected Vector classify() {
        Vector<VertexClass> classes = new Vector<VertexClass>();
        Hashtable<Integer, VertexClass> temp = new Hashtable<Integer, VertexClass>();
        Enumeration e = this.vertices.keys();
        while (e.hasMoreElements()) {
            VertexClass vc;
            Vertex curr = (Vertex)this.vertices.get(e.nextElement().toString());
            Integer key = new Integer(curr.countEdges());
            if (temp.containsKey(key)) {
                vc = (VertexClass)temp.get(key);
            } else {
                vc = new VertexClass(curr.countEdges());
                classes.addElement(vc);
            }
            vc.addVertexToClass(curr);
            temp.put(key, vc);
        }
        return classes;
    }
}

