/*
 * Decompiled with CFR 0.152.
 */
package com.lre.graph;

import com.lre.graph.Vertex;
import java.util.Vector;

public class VertexClass {
    private Vector vertices;
    private int num;

    public VertexClass(int n) {
        this.num = n;
        this.vertices = new Vector();
    }

    public VertexClass(int n, Vector v) {
        this.num = n;
        this.vertices = v;
    }

    public void addVertexToClass(Vertex v) {
        this.vertices.addElement(v);
    }

    public boolean isInClass(Vertex v) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            Vertex curr = (Vertex)this.vertices.elementAt(i);
            if (!curr.matches(v)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(VertexClass vc) {
        int j;
        int i;
        if (vc.getNum() != this.getNum()) {
            return false;
        }
        if (vc.getVertices().size() != this.getVertices().size()) {
            return false;
        }
        boolean match = true;
        Vector<Vertex> oneUnmatched = new Vector<Vertex>();
        Vector twoUnmatched = (Vector)vc.getVertices().clone();
        for (i = 0; i < this.getVertices().size(); ++i) {
            boolean matchCurr = false;
            Vertex local = (Vertex)this.getVertices().elementAt(i);
            for (j = 0; j < vc.getVertices().size(); ++j) {
                Vertex other = (Vertex)vc.getVertices().elementAt(j);
                if (!local.matches(other)) continue;
                twoUnmatched.remove(other);
                matchCurr = true;
                break;
            }
            if (matchCurr) continue;
            oneUnmatched.addElement(local);
        }
        if (oneUnmatched.size() == 0 && twoUnmatched.size() == 0) {
            return true;
        }
        for (i = 0; i < oneUnmatched.size(); ++i) {
            Vertex one = (Vertex)oneUnmatched.elementAt(i);
            boolean matchCurr = false;
            for (j = 0; j < twoUnmatched.size(); ++j) {
                Vertex two = (Vertex)twoUnmatched.elementAt(j);
                if (!one.similar(two)) continue;
                matchCurr = true;
                break;
            }
            if (matchCurr) continue;
            return false;
        }
        return match;
    }

    public int getNum() {
        return this.num;
    }

    public Vector getVertices() {
        return this.vertices;
    }
}

