/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.BranchAddDependency;
import org.mindswap.pellet.ClashDependency;
import org.mindswap.pellet.CloseBranchDependency;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.ContinuousRulesStrategy;
import org.mindswap.pellet.DependencyEntry;
import org.mindswap.pellet.DependencyIndex;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.EmptySHNStrategy;
import org.mindswap.pellet.Expressivity;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KRSSLoader;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.MergeDependency;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.RuleStrategy;
import org.mindswap.pellet.SHINStrategy;
import org.mindswap.pellet.SHNStrategy;
import org.mindswap.pellet.SHOINStrategy;
import org.mindswap.pellet.SHOIQStrategy;
import org.mindswap.pellet.SHONStrategy;
import org.mindswap.pellet.SROIQStrategy;
import org.mindswap.pellet.TypeDependency;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.exceptions.InconsistentOntologyException;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.exceptions.UndefinedEntityException;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.output.ATermBaseVisitor;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.rules.UsableRuleFilter;
import org.mindswap.pellet.rules.model.Rule;
import org.mindswap.pellet.taxonomy.CDOptimizedTaxonomyBuilder;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.tbox.TBoxFactory;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.SizeEstimate;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeBase {
    public static final Log log = LogFactory.getLog(KnowledgeBase.class);
    public static boolean DEBUG = false;
    protected ABox abox;
    protected TBox tbox;
    protected RBox rbox;
    private Set<ATermAppl> individuals;
    protected TaxonomyBuilder builder;
    protected Taxonomy taxonomy;
    protected Taxonomy roleTaxonomy;
    private boolean consistent;
    private SizeEstimate estimate;
    protected int status;
    protected static final int UNCHANGED = 0;
    protected static final int ABOX_CHANGED = 1;
    protected static final int TBOX_CHANGED = 2;
    protected static final int RBOX_CHANGED = 4;
    protected static final int ALL_CHANGED = 7;
    protected static final int CONSISTENCY = 8;
    protected static final int CLASSIFICATION = 16;
    protected static final int REALIZATION = 32;
    private Map<ATermAppl, Set<ATermAppl>> instances;
    private Expressivity expressivity;
    public Timers timers = new Timers();
    private UsableRuleFilter rules;
    protected Set<ATermAppl> deletedAssertions;
    protected boolean aboxDeletion = false;
    protected boolean aboxAddition = false;
    private DependencyIndex dependencyIndex;
    private Set<ATermAppl> syntacticAssertions;
    protected MultiValueMap<AssertionType, ATermAppl> aboxAssertions;
    FullyDefinedClassVisitor fullyDefinedVisitor = new FullyDefinedClassVisitor();

    public KnowledgeBase() {
        this.clear();
        this.timers.createTimer("preprocessing");
        this.timers.createTimer("consistency");
        this.status = 7;
        this.deletedAssertions = new HashSet<ATermAppl>();
        this.dependencyIndex = new DependencyIndex(this);
        this.syntacticAssertions = new HashSet<ATermAppl>();
        this.aboxAssertions = new MultiValueMap();
    }

    protected KnowledgeBase(KnowledgeBase kb, boolean emptyABox) {
        this.tbox = kb.tbox;
        this.rbox = kb.rbox;
        this.aboxAssertions = new MultiValueMap();
        if (emptyABox) {
            this.abox = new ABox(this);
            this.individuals = new HashSet<ATermAppl>();
            this.instances = new HashMap<ATermAppl, Set<ATermAppl>>();
            Set nominals = kb.getExpressivity().getNominals();
            for (ATermAppl nominal : nominals) {
                this.addIndividual(nominal);
            }
            this.deletedAssertions = new HashSet<ATermAppl>();
            this.dependencyIndex = new DependencyIndex(this);
            this.syntacticAssertions = new HashSet<ATermAppl>();
        } else {
            this.abox = kb.abox.copy(this);
            if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
                for (AssertionType assertionType : AssertionType.values()) {
                    Set assertions = (Set)kb.aboxAssertions.get((Object)assertionType);
                    if (assertions.isEmpty()) continue;
                    this.aboxAssertions.put(assertionType, new HashSet(assertions));
                }
            }
            this.individuals = new HashSet<ATermAppl>(kb.individuals);
            this.instances = new HashMap<ATermAppl, Set<ATermAppl>>(kb.instances);
            this.deletedAssertions = new HashSet<ATermAppl>(kb.deletedAssertions);
            if (PelletOptions.USE_INCREMENTAL_CONSISTENCY && PelletOptions.USE_INCREMENTAL_DELETION) {
                this.dependencyIndex = new DependencyIndex(this, this.dependencyIndex);
            }
            this.syntacticAssertions = new HashSet<ATermAppl>(kb.syntacticAssertions);
        }
        this.expressivity = kb.expressivity;
        this.status = 7;
        this.timers = kb.timers;
    }

    public Expressivity getExpressivity() {
        if (this.canUseIncConsistency()) {
            return this.expressivity;
        }
        this.prepare();
        return this.expressivity;
    }

    public void clear() {
        this.abox = new ABox(this);
        this.tbox = TBoxFactory.createTBox(this);
        this.rbox = new RBox();
        this.expressivity = new Expressivity(this);
        this.individuals = new HashSet<ATermAppl>();
        this.aboxAssertions = new MultiValueMap();
        this.instances = new HashMap<ATermAppl, Set<ATermAppl>>();
        this.builder = null;
        this.status = 7;
    }

    public KnowledgeBase copy() {
        return this.copy(false);
    }

    public KnowledgeBase copy(boolean emptyABox) {
        return new KnowledgeBase(this, emptyABox);
    }

    public void loadKRSS(Reader reader) throws IOException {
        KRSSLoader loader = new KRSSLoader();
        loader.load(reader, this);
    }

    public void addClass(ATermAppl c) {
        if (c.equals(ATermUtils.TOP) || ATermUtils.isComplexClass(c)) {
            return;
        }
        boolean added = this.tbox.addClass(c);
        if (added) {
            this.status |= 2;
            if (log.isDebugEnabled()) {
                log.debug((Object)("class " + c));
            }
        }
    }

    public void addSubClass(ATermAppl sub, ATermAppl sup) {
        ATermAppl subAxiom = ATermUtils.makeSub(sub, sup);
        Set<ATermAppl> explain = null;
        explain = PelletOptions.USE_TRACING ? Collections.singleton(subAxiom) : Collections.emptySet();
        this.addSubClass(sub, sup, explain);
    }

    private void addSubClass(ATermAppl sub, ATermAppl sup, Set<ATermAppl> explain) {
        if (sub.equals(sup)) {
            return;
        }
        this.status |= 2;
        ATermAppl subAxiom = ATermUtils.makeSub(sub, sup);
        this.tbox.addAxiom(subAxiom, explain);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sub-class " + sub + " " + sup));
        }
    }

    public void addSameClass(ATermAppl c1, ATermAppl c2) {
        this.addEquivalentClass(c1, c2);
    }

    public void addEquivalentClass(ATermAppl c1, ATermAppl c2) {
        if (c1.equals(c2)) {
            return;
        }
        this.status |= 2;
        ATermAppl sameAxiom = ATermUtils.makeEqClasses(c1, c2);
        Set<ATermAppl> explanation = Collections.emptySet();
        if (PelletOptions.USE_TRACING) {
            explanation = Collections.singleton(sameAxiom);
        }
        this.tbox.addAxiom(sameAxiom, explanation);
        if (log.isDebugEnabled()) {
            log.debug((Object)("eq-class " + c1 + " " + c2));
        }
    }

    public void addDisjointClasses(ATermList classes) {
        Set<ATermAppl> explain = null;
        explain = PelletOptions.USE_TRACING ? Collections.singleton(ATermUtils.makeDisjoints(classes)) : Collections.emptySet();
        ATermList l1 = classes;
        while (!l1.isEmpty()) {
            ATermAppl c1 = (ATermAppl)l1.getFirst();
            ATermList l2 = l1.getNext();
            while (!l2.isEmpty()) {
                ATermAppl c2 = (ATermAppl)l2.getFirst();
                this.addDisjointClass(c1, c2, explain);
                l2 = l2.getNext();
            }
            l1 = l1.getNext();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("disjoints " + classes));
        }
    }

    public void addDisjointClasses(List classes) {
        this.addDisjointClasses(ATermUtils.toSet(classes));
    }

    public void addDisjointClass(ATermAppl c1, ATermAppl c2) {
        Set<ATermAppl> explain = null;
        explain = PelletOptions.USE_TRACING ? Collections.singleton(ATermUtils.makeDisjoint(c1, c2)) : Collections.emptySet();
        this.addDisjointClass(c1, c2, explain);
    }

    public void addDisjointClass(ATermAppl c1, ATermAppl c2, Set<ATermAppl> explain) {
        this.status |= 2;
        ATermAppl notC2 = ATermUtils.makeNot(c2);
        ATermAppl notC1 = ATermUtils.makeNot(c1);
        this.tbox.addAxiom(ATermUtils.makeSub(c1, notC2), explain);
        this.tbox.addAxiom(ATermUtils.makeSub(c2, notC1), explain);
        if (log.isDebugEnabled()) {
            log.debug((Object)("disjoint " + c1 + " " + c2));
        }
    }

    public void addComplementClass(ATermAppl c1, ATermAppl c2) {
        this.status |= 2;
        ATermAppl notC2 = ATermUtils.makeNot(c2);
        if (c1.equals(notC2)) {
            return;
        }
        Set<ATermAppl> ds = null;
        ds = PelletOptions.USE_TRACING ? Collections.singleton(ATermUtils.makeComplement(c1, c2)) : Collections.emptySet();
        ATermAppl notC1 = ATermUtils.makeNot(c1);
        this.tbox.addAxiom(ATermUtils.makeEqClasses(c1, notC2), ds);
        this.tbox.addAxiom(ATermUtils.makeEqClasses(c2, notC1), ds);
        if (log.isDebugEnabled()) {
            log.debug((Object)("complement " + c1 + " " + c2));
        }
    }

    public void addDataPropertyValue(ATermAppl p, ATermAppl s, ATermAppl o) {
        this.addPropertyValue(p, s, o);
    }

    public Individual addIndividual(ATermAppl i) {
        Node node = this.abox.getNode(i);
        if (node == null) {
            this.abox.setSyntacticUpdate(true);
            this.status |= 1;
            node = this.abox.addIndividual(i);
            this.individuals.add(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("individual " + i));
            }
            this.abox.setSyntacticUpdate(false);
        } else if (node instanceof Literal) {
            throw new UnsupportedFeatureException("Trying to use a literal as an individual. Literal ID: " + i.getName());
        }
        this.aboxAddition = true;
        if (this.canUseIncConsistency()) {
            this.abox.getPseudoModel().setSyntacticUpdate(true);
            Node pNode = this.abox.getPseudoModel().getNode(i);
            if (pNode == null) {
                this.status |= 1;
                int branch = this.abox.getPseudoModel().getBranch();
                this.abox.getPseudoModel().setBranch(0);
                pNode = this.abox.getPseudoModel().addIndividual(i);
                this.abox.getPseudoModel().setBranch(branch);
                for (int j = 0; j < this.abox.getPseudoModel().getBranches().size(); ++j) {
                    ++this.abox.getPseudoModel().getBranches().get((int)j).nodeCount;
                }
            }
            this.abox.updatedIndividuals.add(this.abox.getPseudoModel().getIndividual(i));
            this.abox.newIndividuals.add(this.abox.getPseudoModel().getIndividual(i));
            this.abox.getPseudoModel().setSyntacticUpdate(false);
        }
        return (Individual)node;
    }

    public void addType(ATermAppl i, ATermAppl c) {
        DependencySet ds;
        ATermAppl typeAxiom = ATermUtils.makeTypeAtom(i, c);
        DependencySet dependencySet = ds = PelletOptions.USE_TRACING ? new DependencySet(typeAxiom) : DependencySet.INDEPENDENT;
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.syntacticAssertions.add(typeAxiom);
            this.dependencyIndex.addTypeDependency(i, c, ds);
        }
        if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
            this.aboxAssertions.add(AssertionType.TYPE, typeAxiom);
        }
        this.addType(i, c, ds);
    }

    public void addType(ATermAppl i, ATermAppl c, DependencySet ds) {
        this.status |= 1;
        this.aboxAddition = true;
        this.abox.setSyntacticUpdate(true);
        this.abox.addType(i, c, ds);
        this.abox.setSyntacticUpdate(false);
        if (this.canUseIncConsistency()) {
            this.abox.updatedIndividuals.add(this.abox.getPseudoModel().getIndividual(i));
            int branch = this.abox.getPseudoModel().getBranch();
            this.abox.getPseudoModel().setSyntacticUpdate(true);
            this.abox.getPseudoModel().setBranch(0);
            this.abox.getPseudoModel().addType(i, c);
            this.abox.getPseudoModel().setBranch(branch);
            this.abox.getPseudoModel().setSyntacticUpdate(false);
            this.updateExpressivity(i, c);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("type " + i + " " + c));
        }
    }

    public void addSame(ATermAppl i1, ATermAppl i2) {
        this.status |= 1;
        this.aboxAddition = true;
        if (this.canUseIncConsistency()) {
            this.abox.updatedIndividuals.add(this.abox.getPseudoModel().getIndividual(i1));
            this.abox.updatedIndividuals.add(this.abox.getPseudoModel().getIndividual(i2));
            this.abox.getPseudoModel().addSame(i1, i2);
        }
        this.abox.addSame(i1, i2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("same " + i1 + " " + i2));
        }
    }

    public void addAllDifferent(ATermList list) {
        this.status |= 1;
        this.aboxAddition = true;
        if (this.canUseIncConsistency()) {
            ATermList outer = list;
            while (!outer.isEmpty()) {
                ATermList inner = outer.getNext();
                while (!inner.isEmpty()) {
                    this.abox.updatedIndividuals.add(this.abox.getPseudoModel().getIndividual(outer.getFirst()));
                    this.abox.updatedIndividuals.add(this.abox.getPseudoModel().getIndividual(inner.getFirst()));
                    inner = inner.getNext();
                }
                outer = outer.getNext();
            }
            int branch = this.abox.getPseudoModel().getBranch();
            this.abox.getPseudoModel().setBranch(0);
            this.abox.getPseudoModel().addAllDifferent(list);
            this.abox.getPseudoModel().setBranch(branch);
        }
        this.abox.addAllDifferent(list);
        if (log.isDebugEnabled()) {
            log.debug((Object)("all diff " + list));
        }
    }

    public void addDifferent(ATermAppl i1, ATermAppl i2) {
        this.status |= 1;
        this.aboxAddition = true;
        if (this.canUseIncConsistency()) {
            this.abox.updatedIndividuals.add(this.abox.getPseudoModel().getIndividual(i1));
            this.abox.updatedIndividuals.add(this.abox.getPseudoModel().getIndividual(i2));
            int branch = this.abox.getPseudoModel().getBranch();
            this.abox.getPseudoModel().setBranch(0);
            this.abox.getPseudoModel().addDifferent(i1, i2);
            this.abox.getPseudoModel().setBranch(branch);
        }
        this.abox.addDifferent(i1, i2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("diff " + i1 + " " + i2));
        }
    }

    public void addObjectPropertyValue(ATermAppl p, ATermAppl s, ATermAppl o) {
        this.addPropertyValue(p, s, o);
    }

    public boolean addPropertyValue(ATermAppl p, ATermAppl s, ATermAppl o) {
        DependencySet ds;
        Individual subj = this.abox.getIndividual(s);
        Role role = this.getRole(p);
        Node obj = null;
        if (subj == null) {
            log.warn((Object)(s + " is not a known individual!"));
            return false;
        }
        if (role == null) {
            log.warn((Object)(p + " is not a known property!"));
            return false;
        }
        if (!role.isObjectRole() && !role.isDatatypeRole()) {
            return false;
        }
        ATermAppl propAxiom = ATermUtils.makePropAtom(p, s, o);
        DependencySet dependencySet = ds = PelletOptions.USE_TRACING ? new DependencySet(propAxiom) : DependencySet.INDEPENDENT;
        if (role.isObjectRole()) {
            obj = this.abox.getIndividual(o);
            if (obj == null) {
                if (ATermUtils.isLiteral(o)) {
                    log.warn((Object)("Ignoring literal value " + o + " for object property " + p));
                    return false;
                }
                log.warn((Object)(o + " is not a known individual!"));
                return false;
            }
            if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
                this.aboxAssertions.add(AssertionType.OBJ_ROLE, propAxiom);
            }
        } else if (role.isDatatypeRole()) {
            obj = this.abox.addLiteral(o, ds);
            if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
                this.aboxAssertions.add(AssertionType.DATA_ROLE, propAxiom);
            }
        }
        this.status |= 1;
        this.aboxAddition = true;
        Edge edge = subj.addEdge(role, obj, ds);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.syntacticAssertions.add(propAxiom);
            this.dependencyIndex.addEdgeDependency(edge, ds);
        }
        if (this.canUseIncConsistency()) {
            Individual subj2;
            this.abox.updatedIndividuals.add(this.abox.getPseudoModel().getIndividual(s));
            if (!role.isDatatypeRole()) {
                this.abox.updatedIndividuals.add(this.abox.getPseudoModel().getIndividual(o));
            }
            if (role.isObjectRole()) {
                obj = this.abox.getPseudoModel().getIndividual(o);
                if (obj.isPruned() || obj.isMerged()) {
                    obj = obj.getSame();
                }
            } else if (role.isDatatypeRole()) {
                obj = this.abox.getPseudoModel().addLiteral(o);
            }
            if ((subj2 = this.abox.getPseudoModel().getIndividual(s)).isPruned() || subj2.isMerged()) {
                subj2 = subj2.getSame();
            }
            ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makePropAtom(p, s, o)) : DependencySet.INDEPENDENT;
            int branch = this.abox.getPseudoModel().getBranch();
            this.abox.getPseudoModel().setBranch(0);
            subj2.addEdge(role, obj, ds);
            this.abox.getPseudoModel().setBranch(branch);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("prop-value " + s + " " + p + " " + o));
        }
        return true;
    }

    public boolean addNegatedPropertyValue(ATermAppl p, ATermAppl s, ATermAppl o) {
        this.status |= 1;
        Individual subj = this.abox.getIndividual(s);
        Role role = this.getRole(p);
        Node obj = null;
        if (subj == null) {
            log.warn((Object)(s + " is not a known individual!"));
            return false;
        }
        if (role == null) {
            log.warn((Object)(p + " is not a known property!"));
            return false;
        }
        if (role.isObjectRole()) {
            obj = this.abox.getIndividual(o);
            if (obj == null) {
                if (ATermUtils.isLiteral(o)) {
                    log.warn((Object)("Ignoring literal value " + o + " for object property " + p));
                    return false;
                }
                log.warn((Object)(o + " is not a known individual!"));
                return false;
            }
        } else if (role.isDatatypeRole()) {
            obj = this.abox.addLiteral(o);
        }
        ATermAppl propAxiom = ATermUtils.makeNot(ATermUtils.makePropAtom(p, s, o));
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(propAxiom) : DependencySet.INDEPENDENT;
        ATermAppl C = ATermUtils.makeNot(ATermUtils.makeHasValue(p, o));
        this.abox.addType(s, C, ds);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.syntacticAssertions.add(propAxiom);
            this.dependencyIndex.addTypeDependency(s, C, ds);
        }
        if (this.canUseIncConsistency()) {
            this.abox.updatedIndividuals.add(this.abox.getPseudoModel().getIndividual(s));
            int branch = this.abox.getPseudoModel().getBranch();
            this.abox.getPseudoModel().setSyntacticUpdate(true);
            this.abox.getPseudoModel().setBranch(0);
            this.abox.getPseudoModel().addType(s, C);
            this.abox.getPseudoModel().setBranch(branch);
            this.abox.getPseudoModel().setSyntacticUpdate(false);
            this.updateExpressivity(s, C);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("not-prop-value " + s + " " + p + " " + o));
        }
        return true;
    }

    public void addProperty(ATermAppl p) {
        this.status |= 4;
        this.rbox.addRole(p);
        if (log.isDebugEnabled()) {
            log.debug((Object)("prop " + p));
        }
    }

    public boolean addObjectProperty(ATerm p) {
        boolean exists = this.getPropertyType(p) == 1;
        Role role = this.rbox.addObjectRole((ATermAppl)p);
        if (!exists) {
            this.status |= 4;
            if (log.isDebugEnabled()) {
                log.debug((Object)("object-prop " + p));
            }
        }
        return role != null;
    }

    public boolean addDatatypeProperty(ATerm p) {
        boolean exists = this.getPropertyType(p) == 2;
        Role role = this.rbox.addDatatypeRole((ATermAppl)p);
        if (!exists) {
            this.status |= 4;
            if (log.isDebugEnabled()) {
                log.debug((Object)("data-prop " + p));
            }
        }
        return role != null;
    }

    public void addOntologyProperty(ATermAppl p) {
        this.status |= 4;
        this.rbox.addOntologyRole(p);
        if (log.isDebugEnabled()) {
            log.debug((Object)("onto-prop " + p));
        }
    }

    public boolean addAnnotationProperty(ATermAppl p) {
        this.status |= 4;
        Role role = this.rbox.addAnnotationRole(p);
        if (log.isDebugEnabled()) {
            log.debug((Object)("annotation-prop " + p));
        }
        return role != null;
    }

    public void addSubProperty(ATerm sub, ATermAppl sup) {
        this.status |= 4;
        this.rbox.addSubRole(sub, sup);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sub-prop " + sub + " " + sup));
        }
    }

    public void addSameProperty(ATermAppl p1, ATermAppl p2) {
        this.addEquivalentProperty(p1, p2);
    }

    public void addEquivalentProperty(ATermAppl p1, ATermAppl p2) {
        this.status |= 4;
        this.rbox.addEquivalentRole(p1, p2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("same-prop " + p1 + " " + p2));
        }
    }

    public void addDisjointProperty(ATermAppl p1, ATermAppl p2) {
        this.status |= 4;
        this.rbox.addDisjointRole(p1, p2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("dis-prop " + p1 + " " + p2));
        }
    }

    public void addInverseProperty(ATermAppl p1, ATermAppl p2) {
        if (PelletOptions.IGNORE_INVERSES) {
            log.warn((Object)("Ignoring inverseOf(" + p1 + " " + p2 + ") axiom due to the IGNORE_INVERSES option"));
            return;
        }
        this.status |= 4;
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeInvProp(p1, p2)) : DependencySet.INDEPENDENT;
        this.rbox.addInverseRole(p1, p2, ds);
        if (log.isDebugEnabled()) {
            log.debug((Object)("inv-prop " + p1 + " " + p2));
        }
    }

    public void addTransitiveProperty(ATermAppl p) {
        this.status |= 4;
        Role r = this.rbox.getDefinedRole(p);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeTransitive(p)) : DependencySet.INDEPENDENT;
        r.addSubRoleChain(ATermUtils.makeList(new ATerm[]{p, p}), ds);
        if (log.isDebugEnabled()) {
            log.debug((Object)("trans-prop " + p));
        }
    }

    public void addSymmetricProperty(ATermAppl p) {
        if (PelletOptions.IGNORE_INVERSES) {
            log.warn((Object)("Ignoring SymmetricProperty(" + p + ") axiom due to the IGNORE_INVERSES option"));
            return;
        }
        this.status |= 4;
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSymmetric(p)) : DependencySet.INDEPENDENT;
        this.rbox.addInverseRole(p, p, ds);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sym-prop " + p));
        }
    }

    public void addAntisymmetricProperty(ATermAppl p) {
        this.status |= 4;
        Role r = this.rbox.getDefinedRole(p);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeAntisymmetric(p)) : DependencySet.INDEPENDENT;
        r.setAntisymmetric(true, ds);
        if (log.isDebugEnabled()) {
            log.debug((Object)("anti-sym-prop " + p));
        }
    }

    public void addReflexiveProperty(ATermAppl p) {
        this.status |= 4;
        Role r = this.rbox.getDefinedRole(p);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeReflexive(p)) : DependencySet.INDEPENDENT;
        r.setReflexive(true, ds);
        if (log.isDebugEnabled()) {
            log.debug((Object)("reflexive-prop " + p));
        }
    }

    public void addIrreflexiveProperty(ATermAppl p) {
        this.status |= 4;
        Role r = this.rbox.getDefinedRole(p);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeIrreflexive(p)) : DependencySet.INDEPENDENT;
        r.setIrreflexive(true, ds);
        if (log.isDebugEnabled()) {
            log.debug((Object)("irreflexive-prop " + p));
        }
    }

    public void addFunctionalProperty(ATermAppl p) {
        this.status |= 4;
        Role r = this.rbox.getDefinedRole(p);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeFunctional(p)) : DependencySet.INDEPENDENT;
        r.setFunctional(true, ds);
        if (log.isDebugEnabled()) {
            log.debug((Object)("func-prop " + p));
        }
    }

    public void addInverseFunctionalProperty(ATerm p) {
        if (PelletOptions.IGNORE_INVERSES) {
            log.warn((Object)("Ignoring InverseFunctionalProperty(" + p + ") axiom due to the IGNORE_INVERSES option"));
            return;
        }
        this.status |= 4;
        Role role = this.rbox.getDefinedRole(p);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeInverseFunctional(p)) : DependencySet.INDEPENDENT;
        role.setInverseFunctional(true, ds);
        if (log.isDebugEnabled()) {
            log.debug((Object)("inv-func-prop " + p));
        }
    }

    public void addDomain(ATerm p, ATermAppl c) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeDomain(p, c)) : DependencySet.INDEPENDENT;
        this.addDomain(p, c, ds);
    }

    public void addDomain(ATerm p, ATermAppl c, DependencySet ds) {
        this.status |= 4;
        Role r = this.rbox.getDefinedRole(p);
        r.addDomain(c, ds);
        if (log.isDebugEnabled()) {
            log.debug((Object)("domain " + p + " " + c + " (" + r.getDomain() + ")"));
        }
    }

    public void addRange(ATerm p, ATermAppl c) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeRange(p, c)) : DependencySet.INDEPENDENT;
        this.addRange(p, c, ds);
    }

    public void addRange(ATerm p, ATermAppl c, DependencySet ds) {
        this.status |= 4;
        Role r = this.rbox.getDefinedRole(p);
        r.addRange(c, ds);
        if (log.isDebugEnabled()) {
            log.debug((Object)("range " + p + " " + c));
        }
    }

    public void addDatatype(ATerm p) {
        DatatypeReasoner dtReasoner = this.getDatatypeReasoner();
        if (!dtReasoner.isDefined(((Object)p).toString())) {
            this.status |= 2;
            dtReasoner.defineUnknownDatatype(((Object)p).toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)("datatype " + p));
            }
        }
    }

    public String addDatatype(Datatype datatype) {
        DatatypeReasoner dtReasoner = this.getDatatypeReasoner();
        this.status |= 2;
        String name = dtReasoner.defineDatatype(datatype);
        if (log.isDebugEnabled()) {
            log.debug((Object)("datatype " + name + " " + datatype));
        }
        return name;
    }

    public void addDatatype(String datatypeURI, Datatype datatype) {
        DatatypeReasoner dtReasoner = this.getDatatypeReasoner();
        if (!dtReasoner.isDefined(datatypeURI)) {
            this.status |= 2;
            dtReasoner.defineDatatype(datatypeURI, datatype);
            if (log.isDebugEnabled()) {
                log.debug((Object)("datatype " + datatypeURI + " " + datatype));
            }
        }
    }

    public void loadDatatype(ATerm p) {
        DatatypeReasoner dtReasoner = this.getDatatypeReasoner();
        if (!dtReasoner.isDefined(((Object)p).toString())) {
            this.status |= 2;
            dtReasoner.loadUserDefinedDatatype(((Object)p).toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)("datatype " + p));
            }
        }
    }

    public void addDataRange(String datatypeURI, ATermList values) {
        DatatypeReasoner dtReasoner = this.getDatatypeReasoner();
        if (!dtReasoner.isDefined(datatypeURI.toString())) {
            this.status |= 2;
            Datatype dataRange = dtReasoner.enumeration(ATermUtils.listToSet(values));
            this.getDatatypeReasoner().defineDatatype(datatypeURI.toString(), dataRange);
            if (log.isDebugEnabled()) {
                log.debug((Object)("datarange " + datatypeURI.toString() + " " + values));
            }
        }
    }

    public boolean removePropertyValue(ATermAppl p, ATermAppl i1, ATermAppl i2) {
        boolean removed = false;
        this.aboxDeletion = true;
        Individual subj = this.abox.getIndividual(i1);
        Node obj = this.abox.getNode(i2);
        Role role = this.getRole(p);
        if (subj == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                throw new UnsupportedFeatureException(i1 + " is not an individual!");
            }
            return false;
        }
        if (obj == null) {
            KnowledgeBase.handleUndefinedEntity(i2 + " is not an individual!");
            return false;
        }
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a property!");
            return false;
        }
        EdgeList edges = subj.getEdgesTo(obj, role);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            if (!edge.getRole().equals(role)) continue;
            subj.removeEdge(edge);
            if (!edge.getTo().getInEdges().removeEdge(edge)) {
                throw new InternalReasonerException("Trying to remove a non-existing edge " + edge);
            }
            this.status |= 1;
            removed = true;
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remove ObjectPropertyValue " + i1 + " " + p + " " + i2));
        }
        if (this.canUseIncConsistency()) {
            this.deletedAssertions.add(ATermUtils.makePropAtom(p, i1, i2));
            this.abox.updatedIndividuals.add(this.abox.getPseudoModel().getIndividual(i1));
            if (!role.isDatatypeRole()) {
                this.abox.updatedIndividuals.add(this.abox.getPseudoModel().getIndividual(i2));
            }
        }
        if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
            ATermAppl propAxiom = ATermUtils.makePropAtom(p, i1, i2);
            if (ATermUtils.isLiteral(i2)) {
                this.aboxAssertions.remove(AssertionType.DATA_ROLE, propAxiom);
            } else {
                this.aboxAssertions.remove(AssertionType.OBJ_ROLE, propAxiom);
            }
        }
        return removed;
    }

    public void removeType(ATermAppl ind, ATermAppl c) {
        this.aboxDeletion = true;
        this.status |= 1;
        Individual subj = this.abox.getIndividual(ind);
        if (subj == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return;
            }
            throw new UnsupportedFeatureException(ind + " is not an individual!");
        }
        subj.removeType(ATermUtils.normalize(c));
        if (this.canUseIncConsistency()) {
            this.deletedAssertions.add(ATermUtils.makeTypeAtom(ind, c));
            this.abox.updatedIndividuals.add(this.abox.getPseudoModel().getIndividual(ind));
        }
        if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
            ATermAppl typeAxiom = ATermUtils.makeTypeAtom(ind, c);
            this.aboxAssertions.remove(AssertionType.TYPE, typeAxiom);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remove Type " + ind + " " + c));
        }
    }

    public boolean removeAxiom(ATermAppl axiom) {
        boolean removed = false;
        try {
            removed = this.tbox.removeAxiom(axiom);
        }
        catch (Exception e) {
            log.error((Object)("Removal failed for axiom " + axiom), (Throwable)e);
        }
        if (removed) {
            this.status |= 2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remove " + axiom + ": " + removed));
        }
        return removed;
    }

    public void prepare() {
        Timer t;
        boolean reuseTaxonomy;
        if (!this.isChanged()) {
            return;
        }
        boolean explain = this.abox.doExplanation();
        this.abox.setDoExplanation(true);
        Timer timer = this.timers.startTimer("preprocessing");
        boolean bl = reuseTaxonomy = this.taxonomy != null && !this.isTBoxChanged() && (!this.expressivity.hasNominal() || PelletOptions.USE_PSEUDO_NOMINALS);
        if (this.isTBoxChanged()) {
            if (PelletOptions.USE_ABSORPTION) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Absorbing...");
                }
                this.tbox.absorb();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Normalizing...");
            }
            t = this.timers.startTimer("normalize");
            this.tbox.normalize();
            t.stop();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Internalizing...");
            }
            this.tbox.internalize();
        }
        if (this.isRBoxChanged()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Role hierarchy...");
            }
            t = this.timers.startTimer("rbox");
            this.rbox.prepare();
            t.stop();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("TBox:\n" + this.tbox));
        }
        this.status = 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Expressivity...");
        }
        this.expressivity.compute();
        if (log.isDebugEnabled()) {
            log.debug((Object)"ABox init...");
        }
        this.instances.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)"done.");
        }
        this.estimate = new SizeEstimate(this);
        this.abox.setDoExplanation(explain);
        this.abox.clearCaches(!reuseTaxonomy);
        this.abox.cache.setMaxSize(2 * this.getClasses().size());
        if (reuseTaxonomy) {
            this.status |= 0x10;
        } else {
            this.taxonomy = null;
        }
        timer.stop();
        if (log.isInfoEnabled()) {
            StringBuffer info = new StringBuffer();
            info.append("Expressivity: " + this.expressivity + ", ");
            info.append("Classes: " + this.getClasses().size() + " ");
            info.append("Properties: " + this.getProperties().size() + " ");
            info.append("Individuals: " + this.individuals.size());
            info.append(" Strategy: " + this.chooseStrategy(this.abox));
            log.info((Object)info);
        }
    }

    public void updateExpressivity(ATermAppl i, ATermAppl c) {
        if (!this.isChanged() || this.isTBoxChanged() || this.isRBoxChanged()) {
            return;
        }
        this.status = 0;
        this.expressivity.processIndividual(i, c);
        this.estimate = new SizeEstimate(this);
    }

    public String getInfo() {
        this.prepare();
        StringBuffer buffer = new StringBuffer();
        buffer.append("Expressivity: " + this.expressivity + " ");
        buffer.append("Classes: " + this.getClasses().size() + " ");
        buffer.append("Properties: " + this.getProperties().size() + " ");
        buffer.append("Individuals: " + this.individuals.size() + " ");
        if (this.expressivity.hasNominal()) {
            buffer.append("Nominals: " + this.expressivity.getNominals().size() + " ");
        }
        return buffer.toString();
    }

    public boolean isConsistencyDone() {
        return (this.status & 0xF) == 8;
    }

    public boolean isClassified() {
        return (this.status & 0x17) == 16;
    }

    public boolean isRealized() {
        return (this.status & 0x27) == 32;
    }

    public boolean isChanged() {
        return (this.status & 7) != 0;
    }

    public boolean isTBoxChanged() {
        return (this.status & 2) != 0;
    }

    public boolean isRBoxChanged() {
        return (this.status & 4) != 0;
    }

    public boolean isABoxChanged() {
        return (this.status & 1) != 0;
    }

    private void consistency() {
        if (this.isConsistencyDone()) {
            return;
        }
        boolean explain = this.abox.doExplanation();
        this.abox.setDoExplanation(true);
        if (!this.canUseIncConsistency()) {
            this.prepare();
        }
        Timer timer = this.timers.startTimer("consistency");
        this.consistent = this.abox.isConsistent();
        this.abox.setDoExplanation(explain);
        if (!this.consistent) {
            log.warn((Object)("Inconsistent ontology. Reason: " + this.getExplanation()));
            if (PelletOptions.USE_TRACING) {
                log.warn((Object)("ExplanationSet: " + this.getExplanationSet()));
            }
        }
        timer.stop();
        this.status |= 8;
        this.aboxDeletion = false;
        this.aboxAddition = false;
        this.deletedAssertions.clear();
    }

    public boolean isConsistent() {
        this.consistency();
        return this.consistent;
    }

    public void ensureConsistency() {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException("Cannot do reasoning with inconsistent ontologies!");
        }
    }

    public void classify() {
        this.ensureConsistency();
        if (this.isClassified()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Classifying...");
        }
        Timer timer = this.timers.startTimer("classify");
        this.builder = this.getTaxonomyBuilder();
        this.taxonomy = this.builder.classify();
        timer.stop();
        if (this.taxonomy == null) {
            this.builder = null;
            return;
        }
        this.status |= 0x10;
    }

    public void realize() {
        if (this.isRealized()) {
            return;
        }
        this.classify();
        if (!this.isClassified()) {
            return;
        }
        Timer timer = this.timers.startTimer("realize");
        this.taxonomy = this.builder.realize();
        timer.stop();
        if (this.taxonomy == null) {
            this.builder = null;
            return;
        }
        this.status |= 0x20;
    }

    public Set<ATermAppl> getClasses() {
        return Collections.unmodifiableSet(this.tbox.getClasses());
    }

    public Set<ATermAppl> getAllClasses() {
        return Collections.unmodifiableSet(this.tbox.getAllClasses());
    }

    public Set<ATermAppl> getProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isObjectRole() && !role.isDatatypeRole()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getObjectProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isObjectRole()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getTransitiveProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isTransitive()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getSymmetricProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isSymmetric()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getAntisymmetricProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isAntisymmetric()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getReflexiveProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isReflexive()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getIrreflexiveProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isIrreflexive()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getFunctionalProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isFunctional()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getInverseFunctionalProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isInverseFunctional()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getDataProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isDatatypeRole()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getIndividuals() {
        return Collections.unmodifiableSet(this.individuals);
    }

    public Role getProperty(ATerm r) {
        return this.rbox.getRole(r);
    }

    public int getPropertyType(ATerm r) {
        Role role = this.getProperty(r);
        return role == null ? 0 : role.getType();
    }

    public boolean isClass(ATerm c) {
        if (this.tbox.getClasses().contains(c) || ((Object)c).equals(ATermUtils.TOP)) {
            return true;
        }
        if (ATermUtils.isComplexClass(c)) {
            return this.fullyDefinedVisitor.isFullyDefined((ATermAppl)c);
        }
        return false;
    }

    public boolean isProperty(ATerm p) {
        return this.rbox.isRole(p);
    }

    public boolean isDatatypeProperty(ATerm p) {
        return this.getPropertyType(p) == 2;
    }

    public boolean isObjectProperty(ATerm p) {
        return this.getPropertyType(p) == 1;
    }

    public boolean isABoxProperty(ATerm p) {
        int type = this.getPropertyType(p);
        return type == 1 || type == 2;
    }

    public boolean isAnnotationProperty(ATerm p) {
        return this.getPropertyType(p) == 3;
    }

    public boolean isOntologyProperty(ATerm p) {
        return this.getPropertyType(p) == 4;
    }

    public boolean isIndividual(ATerm ind) {
        return this.getIndividuals().contains(ind);
    }

    public boolean isTransitiveProperty(ATermAppl r) {
        Role role = this.getRole(r);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(r + " is not a known property");
            return false;
        }
        if (role.isTransitive()) {
            return true;
        }
        if (!role.isObjectRole() || role.isFunctional() || role.isInverseFunctional()) {
            return false;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot(c);
        ATermAppl test = ATermUtils.makeAnd(ATermUtils.makeSomeValues(r, ATermUtils.makeSomeValues(r, c)), ATermUtils.makeAllValues(r, notC));
        return !this.abox.isSatisfiable(test);
    }

    public boolean isSymmetricProperty(ATermAppl p) {
        return this.isInverse(p, p);
    }

    public boolean isFunctionalProperty(ATermAppl p) {
        Role role = this.getRole(p);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a known property");
            return false;
        }
        if (role.isFunctional()) {
            return true;
        }
        if (!role.isSimple()) {
            return false;
        }
        ATermAppl min2P = role.isDatatypeRole() ? ATermUtils.makeMin((ATerm)p, 2, (ATerm)ATermUtils.TOP_LIT) : ATermUtils.makeMin((ATerm)p, 2, (ATerm)ATermUtils.TOP);
        return !this.isSatisfiable(min2P);
    }

    public boolean isInverseFunctionalProperty(ATermAppl p) {
        Role role = this.getRole(p);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a known property");
            return false;
        }
        if (!role.isObjectRole()) {
            return false;
        }
        if (role.isInverseFunctional()) {
            return true;
        }
        ATermAppl invP = role.getInverse().getName();
        ATermAppl max1invP = role.isDatatypeRole() ? ATermUtils.makeMax((ATerm)invP, 1, (ATerm)ATermUtils.TOP_LIT) : ATermUtils.makeMax((ATerm)invP, 1, (ATerm)ATermUtils.TOP);
        return this.isSubClassOf(ATermUtils.TOP, max1invP);
    }

    public boolean isReflexiveProperty(ATermAppl p) {
        Role role = this.getRole(p);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a known property");
            return false;
        }
        if (!role.isObjectRole() || role.isIrreflexive()) {
            return false;
        }
        if (role.isReflexive()) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot(c);
        ATermAppl test = ATermUtils.makeAnd(c, ATermUtils.makeAllValues(p, notC));
        return !this.abox.isSatisfiable(test);
    }

    public boolean isIrreflexiveProperty(ATermAppl p) {
        Role role = this.getRole(p);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a known property");
            return false;
        }
        if (!role.isObjectRole() || role.isReflexive()) {
            return false;
        }
        if (role.isIrreflexive() || role.isAntisymmetric()) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl test = ATermUtils.makeSelf(p);
        return !this.abox.isSatisfiable(test);
    }

    public boolean isAntisymmetricProperty(ATermAppl p) {
        Role role = this.getRole(p);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a known property");
            return false;
        }
        if (!role.isObjectRole()) {
            return false;
        }
        if (role.isAntisymmetric()) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl o = ATermUtils.makeAnonNominal("_o_");
        ATermAppl nom = ATermUtils.makeValue(o);
        ATermAppl test = ATermUtils.makeAnd(nom, ATermUtils.makeSomeValues(p, ATermUtils.makeAnd(ATermUtils.makeNot(nom), ATermUtils.makeSomeValues(p, nom))));
        return !this.abox.isSatisfiable(test);
    }

    public boolean isSubPropertyOf(ATermAppl sub, ATermAppl sup) {
        Role roleSub = this.rbox.getRole(sub);
        Role roleSup = this.rbox.getRole(sup);
        if (roleSub == null) {
            KnowledgeBase.handleUndefinedEntity(sub + " is not a known property");
            return false;
        }
        if (roleSup == null) {
            KnowledgeBase.handleUndefinedEntity(sup + " is not a known property");
            return false;
        }
        if (roleSub.isSubRoleOf(roleSup)) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot(c);
        ATermAppl test = ATermUtils.makeAnd(ATermUtils.makeSomeValues(sub, c), ATermUtils.makeAllValues(sup, notC));
        return !this.abox.isSatisfiable(test);
    }

    public boolean isEquivalentProperty(ATermAppl p1, ATermAppl p2) {
        return this.isSubPropertyOf(p1, p2) && this.isSubPropertyOf(p2, p1);
    }

    public boolean isInverse(ATermAppl r1, ATermAppl r2) {
        Role role1 = this.getRole(r1);
        Role role2 = this.getRole(r2);
        if (role1 == null) {
            KnowledgeBase.handleUndefinedEntity(r1 + " is not a known property");
            return false;
        }
        if (role2 == null) {
            KnowledgeBase.handleUndefinedEntity(r2 + " is not a known property");
            return false;
        }
        if (!role1.isObjectRole() || !role2.isObjectRole()) {
            return false;
        }
        if (role1.getInverse().equals(role2)) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot(c);
        ATermAppl test = ATermUtils.makeAnd(c, ATermUtils.makeSomeValues(r1, ATermUtils.makeAllValues(r2, notC)));
        return !this.abox.isSatisfiable(test);
    }

    public boolean hasDomain(ATermAppl p, ATermAppl c) {
        Role r = this.rbox.getRole(p);
        if (r == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a property!");
            return false;
        }
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a valid class expression");
            return false;
        }
        ATermAppl someP = ATermUtils.makeSomeValues(p, ATermUtils.getTop(r));
        return this.isSubClassOf(someP, c);
    }

    public boolean hasRange(ATermAppl p, ATermAppl c) {
        if (!this.isClass(c) && !this.isDatatype(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a valid class expression");
            return false;
        }
        ATermAppl allValues = ATermUtils.makeAllValues(p, c);
        return this.isSubClassOf(ATermUtils.TOP, allValues);
    }

    public boolean isDatatype(ATerm p) {
        DatatypeReasoner dtReasoner = this.getDatatypeReasoner();
        return dtReasoner.isDefined(((Object)p).toString());
    }

    public boolean isDatatype(ATermAppl c) {
        return this.abox.getDatatypeReasoner().isDefined(c.getName());
    }

    public boolean isSatisfiable(ATermAppl c) {
        this.ensureConsistency();
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a known class!");
            return false;
        }
        return this.abox.isSatisfiable(c);
    }

    public boolean hasInstance(ATerm d) {
        this.ensureConsistency();
        ATermAppl c = ATermUtils.normalize((ATermAppl)d);
        ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            ATermAppl x = ((Individual)i.next()).getName();
            Bool knownType = this.abox.isKnownType(x, c);
            if (knownType.isTrue()) {
                return true;
            }
            if (!knownType.isUnknown()) continue;
            unknowns.add(x);
        }
        boolean hasInstance = !unknowns.isEmpty() && this.abox.isType(unknowns, c);
        return hasInstance;
    }

    public boolean isSubTypeOf(ATermAppl d1, ATermAppl d2) {
        if (!this.isDatatype(d1)) {
            KnowledgeBase.handleUndefinedEntity(d1 + " is not a known datatype");
            return false;
        }
        if (!this.isDatatype(d2)) {
            KnowledgeBase.handleUndefinedEntity(d2 + " is not a known datatype");
            return false;
        }
        return this.getDatatypeReasoner().isSubTypeOf(d1, d2);
    }

    public boolean isSubClassOf(ATermAppl c1, ATermAppl c2) {
        Bool isSubNode;
        this.ensureConsistency();
        if (!this.isClass(c1)) {
            KnowledgeBase.handleUndefinedEntity(c1 + " is not a known class");
            return false;
        }
        if (!this.isClass(c2)) {
            KnowledgeBase.handleUndefinedEntity(c2 + " is not a known class");
            return false;
        }
        if (c1.equals(c2)) {
            return true;
        }
        c1 = ATermUtils.normalize(c1);
        c2 = ATermUtils.normalize(c2);
        if (this.isClassified() && !this.doExplanation() && (isSubNode = this.taxonomy.isSubNodeOf(c1, c2)).isKnown()) {
            return isSubNode.isTrue();
        }
        return this.abox.isSubClassOf(c1, c2);
    }

    public boolean isEquivalentClass(ATermAppl c1, ATermAppl c2) {
        ATermAppl c2NotC1;
        this.ensureConsistency();
        if (!this.isClass(c1)) {
            KnowledgeBase.handleUndefinedEntity(c1 + " is not a known class");
            return false;
        }
        if (!this.isClass(c2)) {
            KnowledgeBase.handleUndefinedEntity(c2 + " is not a known class");
            return false;
        }
        if (c1.equals(c2)) {
            return true;
        }
        c1 = ATermUtils.normalize(c1);
        c2 = ATermUtils.normalize(c2);
        if (!this.doExplanation()) {
            Bool isEquivalent = Bool.UNKNOWN;
            if (this.isClassified()) {
                isEquivalent = this.taxonomy.isEquivalent(c1, c2);
            }
            if (isEquivalent.isKnown()) {
                isEquivalent = this.abox.isKnownSubClassOf(c1, c2).and(this.abox.isKnownSubClassOf(c2, c1));
            }
            if (isEquivalent.isKnown()) {
                return isEquivalent.isTrue();
            }
        }
        ATermAppl notC2 = ATermUtils.negate(c2);
        ATermAppl notC1 = ATermUtils.negate(c1);
        ATermAppl c1NotC2 = ATermUtils.makeAnd(c1, notC2);
        ATermAppl test = ATermUtils.makeOr(c1NotC2, c2NotC1 = ATermUtils.makeAnd(c2, notC1));
        return !this.isSatisfiable(test);
    }

    public boolean isDisjoint(ATermAppl c1, ATermAppl c2) {
        if (this.isClass(c1) && this.isClass(c2)) {
            return this.isDisjointClass(c1, c2);
        }
        if (this.isProperty(c1) && this.isProperty(c2)) {
            return this.isDisjointProperty(c1, c2);
        }
        return false;
    }

    public boolean isDisjointClass(ATermAppl c1, ATermAppl c2) {
        ATermAppl notC2 = ATermUtils.makeNot(c2);
        return this.isSubClassOf(c1, notC2);
    }

    public boolean isDisjointProperty(ATermAppl r1, ATermAppl r2) {
        Role role1 = this.getRole(r1);
        Role role2 = this.getRole(r2);
        if (role1 == null) {
            KnowledgeBase.handleUndefinedEntity(r1 + " is not a known property");
            return false;
        }
        if (role2 == null) {
            KnowledgeBase.handleUndefinedEntity(r2 + " is not a known property");
            return false;
        }
        if (role1.getDisjointRoles().contains(role2)) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl o = ATermUtils.makeAnonNominal("_o_");
        ATermAppl nom = ATermUtils.makeValue(o);
        ATermAppl test = ATermUtils.makeAnd(ATermUtils.makeSomeValues(r1, nom), ATermUtils.makeSomeValues(r2, nom));
        return !this.abox.isSatisfiable(test);
    }

    public boolean isComplement(ATermAppl c1, ATermAppl c2) {
        ATermAppl notC2 = ATermUtils.makeNot(c2);
        return this.isEquivalentClass(c1, notC2);
    }

    public Bool isKnownType(ATermAppl x, ATermAppl c) {
        this.ensureConsistency();
        if (!this.isIndividual(x)) {
            KnowledgeBase.handleUndefinedEntity(x + " is not an individual!");
            return Bool.FALSE;
        }
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a valid class expression");
            return Bool.FALSE;
        }
        c = ATermUtils.normalize(c);
        return this.abox.isKnownType(x, c);
    }

    public boolean isType(ATermAppl x, ATermAppl c) {
        this.ensureConsistency();
        if (!this.isIndividual(x)) {
            KnowledgeBase.handleUndefinedEntity(x + " is not an individual!");
            return false;
        }
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a valid class expression");
            return false;
        }
        boolean isType = this.isRealized() && this.taxonomy.contains(c) && !this.doExplanation() ? this.taxonomy.isType(x, c) : this.abox.isType(x, c);
        return isType;
    }

    public boolean isSameAs(ATermAppl t1, ATermAppl t2) {
        this.ensureConsistency();
        if (!this.isIndividual(t1)) {
            KnowledgeBase.handleUndefinedEntity(t1 + " is not an individual!");
            return false;
        }
        if (!this.isIndividual(t2)) {
            KnowledgeBase.handleUndefinedEntity(t2 + " is not an individual!");
            return false;
        }
        if (t1.equals(t2)) {
            return true;
        }
        HashSet<ATermAppl> knowns = new HashSet<ATermAppl>();
        HashSet<ATermAppl> unknowns = new HashSet<ATermAppl>();
        Individual ind = this.abox.getPseudoModel().getIndividual(t1);
        if (ind.isMerged() && !ind.getMergeDependency(true).isIndependent()) {
            this.abox.getSames(ind.getSame(), unknowns, unknowns);
        } else {
            this.abox.getSames(ind.getSame(), knowns, unknowns);
        }
        if (knowns.contains(t2)) {
            return true;
        }
        if (!unknowns.contains(t2)) {
            return false;
        }
        return this.abox.isSameAs(t1, t2);
    }

    public boolean isDifferentFrom(ATermAppl t1, ATermAppl t2) {
        Individual ind1 = this.abox.getIndividual(t1);
        Individual ind2 = this.abox.getIndividual(t2);
        if (ind1 == null) {
            KnowledgeBase.handleUndefinedEntity(t1 + " is not an individual!");
            return false;
        }
        if (ind2 == null) {
            KnowledgeBase.handleUndefinedEntity(t2 + " is not an individual!");
            return false;
        }
        if (ind1.isDifferent(ind2)) {
            return true;
        }
        ATermAppl c = ATermUtils.makeNot(ATermUtils.makeValue(t2));
        return this.isType(t1, c);
    }

    public Set<ATermAppl> getDifferents(ATermAppl name) {
        Individual ind = this.abox.getIndividual(name);
        if (ind == null) {
            KnowledgeBase.handleUndefinedEntity(name + " is not an individual!");
            return Collections.emptySet();
        }
        ATermAppl c = ATermUtils.makeNot(ATermUtils.makeValue(name));
        return this.getInstances(c);
    }

    public boolean hasPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        this.ensureConsistency();
        if (!this.isIndividual(s)) {
            KnowledgeBase.handleUndefinedEntity(s + " is not an individual!");
            return false;
        }
        if (!this.isProperty(p)) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a known property!");
            return false;
        }
        if (o != null && (this.isDatatypeProperty(p) ? !ATermUtils.isLiteral(o) : !this.isIndividual(o))) {
            return false;
        }
        return this.abox.hasPropertyValue(s, p, o);
    }

    public Bool hasKnownPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        this.ensureConsistency();
        return this.abox.hasObviousPropertyValue(s, p, o);
    }

    public ABox getABox() {
        return this.abox;
    }

    public RBox getRBox() {
        return this.rbox;
    }

    public TBox getTBox() {
        return this.tbox;
    }

    public DatatypeReasoner getDatatypeReasoner() {
        return this.abox.getDatatypeReasoner();
    }

    public Set<Set<ATermAppl>> getSuperClasses(ATermAppl c, boolean direct) {
        if (!this.isClass(c = ATermUtils.normalize(c))) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        this.classify();
        if (!this.taxonomy.contains(c)) {
            this.builder.classify(c);
        }
        return this.taxonomy.getSupers(c, direct);
    }

    public Set<Set<ATermAppl>> getSubClasses(ATermAppl c) {
        return this.getSubClasses(c, false);
    }

    public Set<Set<ATermAppl>> getDisjoints(ATermAppl c) {
        if (this.isClass(c)) {
            return this.getDisjointClasses(c);
        }
        if (this.isProperty(c)) {
            return this.getDisjointProperties(c);
        }
        KnowledgeBase.handleUndefinedEntity(c + " is not a property nor a class!");
        return Collections.emptySet();
    }

    public Set<Set<ATermAppl>> getDisjointClasses(ATermAppl c) {
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        ATermAppl notC = ATermUtils.normalize(ATermUtils.makeNot(c));
        Set<Set<ATermAppl>> disjoints = this.getSubClasses(notC);
        if (this.tbox.getAllClasses().contains(notC)) {
            disjoints.add(this.getAllEquivalentClasses(notC));
        }
        return disjoints;
    }

    public Set<Set<ATermAppl>> getDisjointProperties(ATermAppl p) {
        if (!this.isProperty(p)) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a property!");
            return Collections.emptySet();
        }
        Role role = this.rbox.getRole(p);
        HashSet<Set<ATermAppl>> disjoints = new HashSet<Set<ATermAppl>>();
        for (Role disjointRole : role.getDisjointRoles()) {
            if (disjointRole.isAnon()) continue;
            disjoints.add(this.getAllEquivalentProperties(disjointRole.getName()));
        }
        return disjoints;
    }

    public Set<ATermAppl> getComplements(ATermAppl c) {
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        ATermAppl notC = ATermUtils.normalize(ATermUtils.makeNot(c));
        Set<ATermAppl> complements = this.getEquivalentClasses(notC);
        if (this.tbox.getAllClasses().contains(notC)) {
            complements.add(notC);
        }
        return complements;
    }

    public Set<Set<ATermAppl>> getTypes(ATermAppl ind, boolean direct) {
        if (!this.isIndividual(ind)) {
            KnowledgeBase.handleUndefinedEntity(ind + " is not an individual!");
            return Collections.emptySet();
        }
        this.realize();
        return this.taxonomy.getTypes(ind, direct);
    }

    public Set<Set<ATermAppl>> getTypes(ATermAppl ind) {
        if (!this.isIndividual(ind)) {
            KnowledgeBase.handleUndefinedEntity(ind + " is not an individual!");
            return Collections.emptySet();
        }
        this.realize();
        return this.taxonomy.getTypes(ind);
    }

    public ATermAppl getType(ATermAppl ind) {
        if (!this.isIndividual(ind)) {
            KnowledgeBase.handleUndefinedEntity(ind + " is not an individual!");
            return null;
        }
        return this.abox.getIndividual(ind).getTypes(0).iterator().next();
    }

    public ATermAppl getType(ATermAppl ind, boolean direct) {
        if (!this.isIndividual(ind)) {
            KnowledgeBase.handleUndefinedEntity(ind + " is not an individual!");
            return null;
        }
        this.realize();
        Set<Set<ATermAppl>> setOfSets = this.taxonomy.getTypes(ind, direct);
        Set<ATermAppl> set = setOfSets.iterator().next();
        return set.iterator().next();
    }

    public Set<ATermAppl> getInstances(ATermAppl c) {
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        if (this.isRealized() && this.taxonomy.contains(c)) {
            return this.taxonomy.getInstances(c);
        }
        return new HashSet<ATermAppl>(this.retrieve(c, this.individuals));
    }

    public Set<ATermAppl> getInstances(ATermAppl c, boolean direct) {
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        if (!direct) {
            return this.getInstances(c);
        }
        if (ATermUtils.isPrimitive(c)) {
            this.realize();
            return this.taxonomy.getInstances(c, direct);
        }
        return Collections.emptySet();
    }

    public Set<ATermAppl> getEquivalentClasses(ATermAppl c) {
        if (!this.isClass(c = ATermUtils.normalize(c))) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        this.classify();
        if (!this.taxonomy.contains(c)) {
            this.builder.classify(c);
        }
        return this.taxonomy.getEquivalents(c);
    }

    public Set<ATermAppl> getAllEquivalentClasses(ATermAppl c) {
        if (!this.isClass(c = ATermUtils.normalize(c))) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        this.classify();
        if (!this.taxonomy.contains(c)) {
            this.builder.classify(c);
        }
        return this.taxonomy.getAllEquivalents(c);
    }

    public Set<Set<ATermAppl>> getSuperClasses(ATermAppl c) {
        return this.getSuperClasses(c, false);
    }

    public Set<Set<ATermAppl>> getSubClasses(ATermAppl c, boolean direct) {
        if (!this.isClass(c = ATermUtils.normalize(c))) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        this.classify();
        if (!this.taxonomy.contains(c)) {
            this.builder.classify(c);
        }
        return this.taxonomy.getSubs(c, direct);
    }

    public Set<Set<ATermAppl>> getSuperProperties(ATermAppl prop) {
        return this.getSuperProperties(prop, false);
    }

    public Set<Set<ATermAppl>> getSuperProperties(ATermAppl prop, boolean direct) {
        this.prepare();
        return this.rbox.getTaxonomy().getSupers(prop, direct);
    }

    public Set<Set<ATermAppl>> getSubProperties(ATermAppl prop) {
        return this.getSubProperties(prop, false);
    }

    public Set<Set<ATermAppl>> getSubProperties(ATermAppl prop, boolean direct) {
        this.prepare();
        return this.rbox.getTaxonomy().getSubs(prop, direct);
    }

    public Set<ATermAppl> getEquivalentProperties(ATermAppl prop) {
        this.prepare();
        Set<ATermAppl> eqs = this.rbox.getTaxonomy().getEquivalents(prop);
        return eqs;
    }

    public Set<ATermAppl> getAllEquivalentProperties(ATermAppl prop) {
        this.prepare();
        Set<ATermAppl> eqs = this.rbox.getTaxonomy().getAllEquivalents(prop);
        return eqs;
    }

    public Set<ATermAppl> getInverses(ATerm name) {
        ATermAppl invR = this.getInverse(name);
        if (invR != null) {
            Set<ATermAppl> inverses = this.getAllEquivalentProperties(invR);
            return inverses;
        }
        return Collections.emptySet();
    }

    public ATermAppl getInverse(ATerm name) {
        Role prop = this.rbox.getRole(name);
        if (prop == null) {
            KnowledgeBase.handleUndefinedEntity(name + " is not a property!");
            return null;
        }
        Role invProp = prop.getInverse();
        return invProp != null ? invProp.getName() : null;
    }

    public Set<ATermAppl> getDomains(ATermAppl name) {
        this.ensureConsistency();
        Set<ATermAppl> set = new HashSet<ATermAppl>();
        Role prop = this.rbox.getRole(name);
        if (prop == null) {
            KnowledgeBase.handleUndefinedEntity(name + " is not a property!");
            return Collections.emptySet();
        }
        ATermAppl domain = prop.getDomain();
        if (domain != null) {
            if (ATermUtils.isAnd(domain)) {
                set = ATermUtils.getPrimitives((ATermList)domain.getArgument(0));
            } else if (ATermUtils.isPrimitive(domain)) {
                set = Collections.singleton(domain);
            }
        }
        return set;
    }

    public Set<ATermAppl> getRanges(ATerm name) {
        this.ensureConsistency();
        Set<ATermAppl> set = Collections.emptySet();
        Role prop = this.rbox.getRole(name);
        if (prop == null) {
            KnowledgeBase.handleUndefinedEntity(name + " is not a property!");
            return set;
        }
        ATermAppl range = prop.getRange();
        if (range != null) {
            if (ATermUtils.isAnd(range)) {
                set = ATermUtils.getPrimitives((ATermList)range.getArgument(0));
            } else if (ATermUtils.isPrimitive(range)) {
                set = Collections.singleton(range);
            }
        }
        return set;
    }

    public Set<ATermAppl> getAllSames(ATermAppl name) {
        this.ensureConsistency();
        HashSet<ATermAppl> knowns = new HashSet<ATermAppl>();
        HashSet<ATermAppl> unknowns = new HashSet<ATermAppl>();
        Individual ind = this.abox.getPseudoModel().getIndividual(name);
        if (ind == null) {
            KnowledgeBase.handleUndefinedEntity(name + " is not an individual!");
            return Collections.emptySet();
        }
        if (ind.isMerged() && !ind.getMergeDependency(true).isIndependent()) {
            knowns.add(name);
            this.abox.getSames(ind.getSame(), unknowns, unknowns);
            unknowns.remove(name);
        } else {
            this.abox.getSames(ind.getSame(), knowns, unknowns);
        }
        for (ATermAppl other : unknowns) {
            if (!this.abox.isSameAs(name, other)) continue;
            knowns.add(other);
        }
        return knowns;
    }

    public Set<ATermAppl> getSames(ATermAppl name) {
        Set<ATermAppl> sames = this.getAllSames(name);
        sames.remove(name);
        return sames;
    }

    public QueryResults runQuery(String queryStr) {
        return QueryEngine.execRDQL(queryStr, this);
    }

    public List<ATermAppl> getDataPropertyValues(ATermAppl r, ATermAppl x, Datatype datatype) {
        this.ensureConsistency();
        Individual ind = this.abox.getIndividual(x);
        Role role = this.rbox.getRole(r);
        if (ind == null) {
            KnowledgeBase.handleUndefinedEntity(x + " is not an individual!");
            return Collections.emptyList();
        }
        if (role == null || !role.isDatatypeRole()) {
            KnowledgeBase.handleUndefinedEntity(r + " is not a known data property!");
            return Collections.emptyList();
        }
        return this.abox.getDataPropertyValues(x, role, datatype);
    }

    public Set<Role> getPossibleProperties(ATermAppl x) {
        this.ensureConsistency();
        Individual ind = this.abox.getIndividual(x);
        if (ind == null) {
            KnowledgeBase.handleUndefinedEntity(x + " is not an individual!");
            return Collections.emptySet();
        }
        return this.abox.getPossibleProperties(x);
    }

    public List<ATermAppl> getDataPropertyValues(ATermAppl r, ATermAppl x, String lang) {
        List<ATermAppl> values = this.getDataPropertyValues(r, x);
        if (lang == null) {
            return values;
        }
        ArrayList<ATermAppl> result = new ArrayList<ATermAppl>();
        for (ATermAppl lit : values) {
            String litLang = ((ATermAppl)lit.getArgument(1)).getName();
            if (!litLang.equals(lang)) continue;
            result.add(lit);
        }
        return result;
    }

    public List<ATermAppl> getDataPropertyValues(ATermAppl r, ATermAppl x) {
        return this.getDataPropertyValues(r, x, (Datatype)null);
    }

    public List<ATermAppl> getObjectPropertyValues(ATermAppl r, ATermAppl x) {
        this.ensureConsistency();
        Role role = this.rbox.getRole(r);
        if (role == null || !role.isObjectRole()) {
            KnowledgeBase.handleUndefinedEntity(r + " is not a known object property!");
            return Collections.emptyList();
        }
        HashSet<ATermAppl> knowns = new HashSet<ATermAppl>();
        HashSet<ATermAppl> unknowns = new HashSet<ATermAppl>();
        this.abox.getObjectPropertyValues(x, role, knowns, unknowns, true);
        if (!unknowns.isEmpty()) {
            ATermAppl valueX = ATermUtils.makeHasValue(role.getInverse().getName(), x);
            ATermAppl c = ATermUtils.normalize(valueX);
            this.binaryInstanceRetrieval(c, new ArrayList<ATermAppl>(unknowns), knowns);
        }
        return new ArrayList<ATermAppl>(knowns);
    }

    public List<ATermAppl> getPropertyValues(ATermAppl r, ATermAppl x) {
        Role role = this.rbox.getRole(r);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(r + " is not a known property!");
            return Collections.emptyList();
        }
        if (role.isObjectRole()) {
            return this.getObjectPropertyValues(r, x);
        }
        return this.getDataPropertyValues(r, x);
    }

    public List getIndividualsWithProperty(ATermAppl r, ATermAppl x) {
        Role role = this.rbox.getRole(r);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(r + " is not a known property!");
            return Collections.emptyList();
        }
        if (role.isObjectRole()) {
            return this.getIndividualsWithObjectProperty(r, x);
        }
        return this.getIndividualsWithDataProperty(r, x);
    }

    public List<ATermAppl> getIndividualsWithDataProperty(ATermAppl r, ATermAppl litValue) {
        this.ensureConsistency();
        Object value = this.getDatatypeReasoner().getValue(litValue);
        if (value == null) {
            KnowledgeBase.handleUndefinedEntity(litValue + " is not a valid literal value!");
            return Collections.emptyList();
        }
        ArrayList<ATermAppl> knowns = new ArrayList<ATermAppl>();
        ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            ATermAppl subj = ((Individual)i.next()).getName();
            Bool hasObviousValue = this.abox.hasObviousDataPropertyValue(subj, r, value);
            if (hasObviousValue.isUnknown()) {
                unknowns.add(subj);
                continue;
            }
            if (!hasObviousValue.isTrue()) continue;
            knowns.add(subj);
        }
        if (!unknowns.isEmpty()) {
            ATermAppl c = ATermUtils.normalize(ATermUtils.makeHasValue(r, litValue));
            this.binaryInstanceRetrieval(c, unknowns, knowns);
        }
        return knowns;
    }

    public List getIndividualsWithObjectProperty(ATermAppl r, ATermAppl o) {
        this.ensureConsistency();
        if (!this.isIndividual(o)) {
            KnowledgeBase.handleUndefinedEntity(o + " is not an individual!");
            return Collections.emptyList();
        }
        Role role = this.rbox.getRole(r);
        ATermAppl invR = role.getInverse().getName();
        return this.getObjectPropertyValues(invR, o);
    }

    public List<ATermAppl> getProperties(ATermAppl s, ATermAppl o) {
        Iterator<ATermAppl> i;
        if (!this.isIndividual(s)) {
            KnowledgeBase.handleUndefinedEntity(s + " is not an individual!");
            return Collections.emptyList();
        }
        if (!this.isIndividual(o)) {
            KnowledgeBase.handleUndefinedEntity(o + " is not an individual!");
            return Collections.emptyList();
        }
        ArrayList<ATermAppl> props = new ArrayList<ATermAppl>();
        Iterator<ATermAppl> iterator = i = ATermUtils.isLiteral(o) ? this.getDataProperties().iterator() : this.getObjectProperties().iterator();
        while (i.hasNext()) {
            ATermAppl p = i.next();
            if (!this.abox.hasPropertyValue(s, p, o)) continue;
            props.add(p);
        }
        return props;
    }

    public Map<ATermAppl, List<ATermAppl>> getPropertyValues(ATermAppl pred) {
        HashMap<ATermAppl, List<ATermAppl>> result = new HashMap<ATermAppl, List<ATermAppl>>();
        for (ATermAppl subj : this.retrieveIndividualsWithProperty(pred)) {
            List<ATermAppl> objects = this.getPropertyValues(pred, subj);
            if (objects.isEmpty()) continue;
            result.put(subj, objects);
        }
        return result;
    }

    public Set<ATermAppl> retrieve(ATermAppl d, Collection<ATermAppl> individuals) {
        this.ensureConsistency();
        ATermAppl c = ATermUtils.normalize(d);
        if (this.instances.containsKey(c)) {
            return this.instances.get(c);
        }
        if (this.isRealized() && this.taxonomy.contains(c)) {
            return this.getInstances(c);
        }
        Timer timer = this.timers.startTimer("retrieve");
        ATermAppl notC = ATermUtils.negate(c);
        ArrayList<ATermAppl> knowns = new ArrayList<ATermAppl>();
        if (!this.abox.isSatisfiable(notC)) {
            knowns.addAll(this.getIndividuals());
        } else if (this.abox.isSatisfiable(c)) {
            Set subs = Collections.emptySet();
            if (this.isClassified() && this.taxonomy.contains(c)) {
                subs = this.taxonomy.getSubs(c, false, true);
            }
            ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
            for (ATermAppl x : individuals) {
                Bool isType = this.abox.isKnownType(x, c, (Collection)subs);
                if (isType.isTrue()) {
                    knowns.add(x);
                    continue;
                }
                if (!isType.isUnknown()) continue;
                unknowns.add(x);
            }
            if (!unknowns.isEmpty() && this.abox.isType(unknowns, c)) {
                if (PelletOptions.USE_BINARY_INSTANCE_RETRIEVAL) {
                    this.binaryInstanceRetrieval(c, unknowns, knowns);
                } else {
                    this.linearInstanceRetrieval(c, unknowns, knowns);
                }
            }
        }
        timer.stop();
        Set<ATermAppl> result = Collections.unmodifiableSet(new HashSet(knowns));
        if (PelletOptions.CACHE_RETRIEVAL) {
            this.instances.put(c, result);
        }
        return result;
    }

    public List<ATermAppl> retrieveIndividualsWithProperty(ATermAppl r) {
        this.ensureConsistency();
        ArrayList<ATermAppl> result = new ArrayList<ATermAppl>();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            ATermAppl x = ((Individual)i.next()).getName();
            if (this.abox.hasObviousPropertyValue(x, r, null).isFalse()) continue;
            result.add(x);
        }
        return result;
    }

    public void linearInstanceRetrieval(ATermAppl c, List<ATermAppl> candidates, Collection<ATermAppl> results) {
        for (ATermAppl ind : candidates) {
            if (!this.abox.isType(ind, c)) continue;
            results.add(ind);
        }
    }

    public void binaryInstanceRetrieval(ATermAppl c, List<ATermAppl> candidates, Collection<ATermAppl> results) {
        if (candidates.isEmpty()) {
            return;
        }
        List<ATermAppl>[] partitions = this.partition(candidates);
        this.partitionInstanceRetrieval(c, partitions, results);
    }

    private void partitionInstanceRetrieval(ATermAppl c, List<ATermAppl>[] partitions, Collection<ATermAppl> results) {
        if (partitions[0].size() == 1) {
            ATermAppl i = partitions[0].get(0);
            this.binaryInstanceRetrieval(c, partitions[1], results);
            if (this.abox.isType(i, c)) {
                results.add(i);
            }
        } else if (!this.abox.isType(partitions[0], c)) {
            this.binaryInstanceRetrieval(c, partitions[1], results);
        } else if (!this.abox.isType(partitions[1], c)) {
            this.binaryInstanceRetrieval(c, partitions[0], results);
        } else {
            this.binaryInstanceRetrieval(c, partitions[0], results);
            this.binaryInstanceRetrieval(c, partitions[1], results);
        }
    }

    private List<ATermAppl>[] partition(List<ATermAppl> candidates) {
        List[] partitions = new List[2];
        int n = candidates.size();
        if (n <= 1) {
            partitions[0] = candidates;
            partitions[1] = new ArrayList();
        } else {
            partitions[0] = candidates.subList(0, n / 2);
            partitions[1] = candidates.subList(n / 2, n);
        }
        return partitions;
    }

    public void printClassTree() {
        this.classify();
        this.taxonomy.print();
    }

    public void printClassTree(OutputFormatter out) {
        this.classify();
        this.taxonomy.print(out);
    }

    public boolean doExplanation() {
        return this.abox.doExplanation();
    }

    public void setDoExplanation(boolean doExplanation) {
        this.abox.setDoExplanation(doExplanation);
    }

    public String getExplanation() {
        return this.abox.getExplanation();
    }

    public void setDoDependencyAxioms(boolean doDepAxioms) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting DoDependencyAxioms = " + doDepAxioms));
        }
    }

    public boolean getDoDependencyAxioms() {
        return false;
    }

    public Set<ATermAppl> getExplanationSet() {
        return this.abox.getExplanationSet();
    }

    public void setRBox(RBox rbox) {
        this.rbox = rbox;
    }

    public void setTBox(TBox tbox) {
        this.tbox = tbox;
    }

    CompletionStrategy chooseStrategy(ABox abox) {
        return this.chooseStrategy(abox, this.getExpressivity());
    }

    CompletionStrategy chooseStrategy(ABox abox, Expressivity expressivity) {
        if (this.getRules().size() > 0 && (expressivity.hasNominal() || abox.size() != 1 || !abox.getNodes().iterator().next().getName().equals(ATermUtils.CONCEPT_SAT_IND))) {
            if (PelletOptions.USE_CONTINUOUS_RULES) {
                return new ContinuousRulesStrategy(abox);
            }
            return new RuleStrategy(abox);
        }
        if (PelletOptions.DEFAULT_COMPLETION_STRATEGY != null) {
            Class[] types = new Class[]{ABox.class};
            Object[] args = new Object[]{abox};
            try {
                Constructor<? extends CompletionStrategy> cons = PelletOptions.DEFAULT_COMPLETION_STRATEGY.getConstructor(types);
                return cons.newInstance(args);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InternalReasonerException("Failed to create the default completion strategy defined in PelletOptions!");
            }
        }
        if (PelletOptions.USE_COMPLETION_STRATEGY) {
            boolean fullDatatypeReasoning;
            boolean emptyStrategy = abox.size() == 1 && abox.getIndIterator().next().getOutEdges().isEmpty();
            boolean bl = fullDatatypeReasoning = PelletOptions.USE_FULL_DATATYPE_REASONING && (expressivity.hasCardinalityD() || expressivity.hasKeys());
            if (!fullDatatypeReasoning) {
                if (expressivity.hasComplexSubRoles()) {
                    return new SROIQStrategy(abox);
                }
                if (expressivity.hasCardinalityQ()) {
                    return new SHOIQStrategy(abox);
                }
                if (expressivity.hasNominal()) {
                    if (expressivity.hasInverse()) {
                        return new SHOINStrategy(abox);
                    }
                    return new SHONStrategy(abox);
                }
                if (expressivity.hasInverse()) {
                    return new SHINStrategy(abox);
                }
                if (emptyStrategy && !expressivity.hasCardinalityD() && !expressivity.hasKeys()) {
                    return new EmptySHNStrategy(abox);
                }
                return new SHNStrategy(abox);
            }
        }
        return new SROIQStrategy(abox);
    }

    public String getOntology() {
        return "";
    }

    public void setOntology(String ontology) {
    }

    public void setTimeout(long timeout) {
        this.timers.mainTimer.setTimeout(timeout);
    }

    Role getRole(ATerm term) {
        return this.rbox.getRole(term);
    }

    public Taxonomy getTaxonomy() {
        this.classify();
        return this.taxonomy;
    }

    public TaxonomyBuilder getTaxonomyBuilder() {
        if (this.builder == null) {
            this.builder = new CDOptimizedTaxonomyBuilder();
            this.builder.setKB(this);
        }
        return this.builder;
    }

    public Taxonomy getRoleTaxonomy() {
        this.prepare();
        return this.rbox.getTaxonomy();
    }

    public SizeEstimate getSizeEstimate() {
        return this.estimate;
    }

    public void addRule(Rule rule) {
        this.status |= 1;
        if (this.rules == null) {
            this.rules = new UsableRuleFilter();
        }
        this.rules.add(rule);
        if (log.isDebugEnabled()) {
            log.debug((Object)("rule " + rule));
        }
    }

    public Set<Rule> getRules() {
        if (this.rules != null) {
            return this.rules.getRules();
        }
        return Collections.emptySet();
    }

    public void removeIndividual(ATermAppl c) {
        this.aboxDeletion = true;
        this.aboxAddition = true;
        this.abox.removeIndividual(c);
        this.individuals.remove(c);
    }

    protected boolean canUseIncConsistency() {
        if (this.expressivity == null) {
            return false;
        }
        boolean canUseIncConsistency = (!this.expressivity.hasNominal() || !this.expressivity.hasInverse()) && !this.isTBoxChanged() && !this.isRBoxChanged() && this.abox.getPseudoModel() != null && PelletOptions.USE_INCREMENTAL_CONSISTENCY && (!this.aboxDeletion && this.aboxAddition || this.aboxDeletion && PelletOptions.USE_INCREMENTAL_DELETION && (this.aboxAddition || !this.aboxAddition));
        return canUseIncConsistency;
    }

    protected void restoreDependencies() {
        for (ATermAppl next : this.deletedAssertions) {
            DependencyEntry entry = this.dependencyIndex.getDependencies(next);
            if (entry != null) {
                if (DependencyIndex.log.isDebugEnabled()) {
                    DependencyIndex.log.debug((Object)("Restoring dependencies for " + next));
                }
                this.restoreDependency(next, entry);
            }
            this.dependencyIndex.removeDependencies(next);
        }
    }

    protected DependencyIndex getDependencyIndex() {
        return this.dependencyIndex;
    }

    public Set<ATermAppl> getSyntacticAssertions() {
        return this.syntacticAssertions;
    }

    private void restoreDependency(ATermAppl assertion, DependencyEntry entry) {
        if (DependencyIndex.log.isDebugEnabled()) {
            DependencyIndex.log.debug((Object)"  Restoring Edge Dependencies:");
        }
        for (Edge edge : entry.getEdges()) {
            this.restoreEdge(assertion, edge);
        }
        if (DependencyIndex.log.isDebugEnabled()) {
            DependencyIndex.log.debug((Object)"  Restoring Type Dependencies:");
        }
        for (TypeDependency typeDependency : entry.getTypes()) {
            this.restoreType(assertion, typeDependency);
        }
        if (DependencyIndex.log.isDebugEnabled()) {
            DependencyIndex.log.debug((Object)("  Restoring Merge Dependencies: " + entry.getMerges()));
        }
        for (MergeDependency mergeDependency : entry.getMerges()) {
            this.restoreMerge(assertion, mergeDependency);
        }
        if (DependencyIndex.log.isDebugEnabled()) {
            DependencyIndex.log.debug((Object)("  Restoring Branch Add Dependencies: " + entry.getBranchAdds()));
        }
        for (BranchAddDependency branchAddDependency : entry.getBranchAdds()) {
            this.restoreBranchAdd(assertion, branchAddDependency);
        }
        if (DependencyIndex.log.isDebugEnabled()) {
            DependencyIndex.log.debug((Object)("  Restoring Branch Remove DS Dependencies: " + entry.getBranchAdds()));
        }
        for (CloseBranchDependency closeBranchDependency : entry.getCloseBranches()) {
            this.restoreCloseBranch(assertion, closeBranchDependency);
        }
        if (DependencyIndex.log.isDebugEnabled()) {
            DependencyIndex.log.debug((Object)("  Restoring clash dependency: " + entry.getClash()));
        }
        if (entry.getClash() != null) {
            this.restoreClash(assertion, entry.getClash());
        }
    }

    private void restoreEdge(ATermAppl assertion, Edge theEdge) {
        if (DependencyIndex.log.isDebugEnabled()) {
            DependencyIndex.log.debug((Object)("    Removing edge? " + theEdge));
        }
        if (theEdge == null) {
            return;
        }
        Individual subj = this.abox.getPseudoModel().getIndividual(theEdge.getFrom().getName());
        Node obj = this.abox.getPseudoModel().getNode(theEdge.getTo().getName());
        Role role = this.getRole(theEdge.getRole().getName());
        EdgeList edges = subj.getEdgesTo(obj, role);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            if (!edge.getRole().equals(role)) continue;
            DependencySet ds = edge.getDepends();
            ds.removeExplain(assertion);
            if (!ds.explain.isEmpty()) break;
            subj.removeEdge(edge);
            this.abox.updatedIndividuals.add(subj);
            if (obj instanceof Individual) {
                this.abox.updatedIndividuals.add((Individual)obj);
            }
            if (!DependencyIndex.log.isDebugEnabled()) break;
            DependencyIndex.log.debug((Object)"           Actually removed edge!");
            break;
        }
    }

    private void restoreType(ATermAppl assertion, TypeDependency type) {
        DependencySet ds;
        if (DependencyIndex.log.isDebugEnabled()) {
            if (this.abox.getPseudoModel().getNode(type.getInd()) instanceof Individual) {
                DependencyIndex.log.debug((Object)("    Removing type? " + type.getType() + " from " + this.abox.getPseudoModel().getIndividual(type.getInd()).debugString()));
            } else {
                DependencyIndex.log.debug((Object)("    Removing type? " + type.getType() + " from " + this.abox.getPseudoModel().getNode(type.getInd())));
            }
        }
        if ((ds = this.abox.getPseudoModel().getNode((ATerm)type.getInd()).depends.get(ATermUtils.normalize(type.getType()))) == null || type.getType() == ATermUtils.TOP) {
            return;
        }
        ds.removeExplain(assertion);
        if (ds.explain.isEmpty()) {
            this.abox.getPseudoModel().removeType(type.getInd(), type.getType());
            if (this.abox.getPseudoModel().getNode(type.getInd()) instanceof Individual) {
                Individual ind = this.abox.getPseudoModel().getIndividual(type.getInd());
                this.abox.updatedIndividuals.add(ind);
                for (Edge e : ind.getInEdges()) {
                    this.abox.updatedIndividuals.add(e.getFrom());
                }
                for (Edge e : ind.getOutEdges()) {
                    if (!(e.getTo() instanceof Individual)) continue;
                    this.abox.updatedIndividuals.add((Individual)e.getTo());
                }
            }
            if (DependencyIndex.log.isDebugEnabled()) {
                DependencyIndex.log.debug((Object)"           Actually removed type!");
            }
        }
    }

    private void restoreMerge(ATermAppl assertion, MergeDependency merge) {
        if (DependencyIndex.log.isDebugEnabled()) {
            DependencyIndex.log.debug((Object)("    Removing merge? " + merge.getInd() + " merged to " + merge.getmergedIntoInd()));
        }
        DependencySet ds = this.abox.getPseudoModel().getNode((ATerm)merge.getInd()).mergeDepends;
        ds.removeExplain(assertion);
        if (ds.explain.isEmpty()) {
            Node mergedToInd;
            Node ind;
            if (DependencyIndex.log.isDebugEnabled()) {
                DependencyIndex.log.debug((Object)"           Actually removing merge!");
            }
            if (!(ind = this.abox.getPseudoModel().getNode(merge.getInd())).isSame(mergedToInd = this.abox.getPseudoModel().getNode(merge.getmergedIntoInd()))) {
                throw new InternalReasonerException(" Restore merge error: " + ind + " not same as " + mergedToInd);
            }
            if (!ind.isPruned()) {
                throw new InternalReasonerException(" Restore merge error: " + ind + " not pruned");
            }
            ind.unprune(ind.pruned.branch);
            ind.undoSetSame();
            if (ind instanceof Individual) {
                this.abox.updatedIndividuals.add((Individual)ind);
            }
        }
    }

    private void restoreBranchAdd(ATermAppl assertion, BranchAddDependency branch) {
        if (DependencyIndex.log.isDebugEnabled()) {
            DependencyIndex.log.debug((Object)("    Removing branch add? " + branch.getBranch()));
        }
        DependencySet ds = branch.getBranch().termDepends;
        ds.removeExplain(assertion);
        if (ds.explain.isEmpty()) {
            if (DependencyIndex.log.isDebugEnabled()) {
                DependencyIndex.log.debug((Object)"           Actually removing branch!");
            }
            List brEffects = this.abox.getPseudoModel().completionQueue.branchEffects;
            HashSet allEffects = new HashSet();
            for (int i = branch.getBranch().branch; i < brEffects.size(); ++i) {
                allEffects.addAll((Set)brEffects.get(i));
            }
            for (ATermAppl nextATerm : allEffects) {
                int i;
                Node node = this.abox.getPseudoModel().getNode(nextATerm);
                Set<ATermAppl> types = node.getTypes();
                for (ATermAppl type : types) {
                    DependencySet tDS = node.getDepends(type);
                    if (tDS.branch > branch.getBranch().branch) {
                        --tDS.branch;
                    }
                    for (i = branch.getBranch().branch; i <= this.abox.getPseudoModel().getBranches().size(); ++i) {
                        if (!tDS.contains(i)) continue;
                        tDS.remove(i);
                        tDS.add(i - 1);
                    }
                }
                EdgeList edges = node.getInEdges();
                for (Edge edge : edges) {
                    if (edge.getDepends().branch > branch.getBranch().branch) {
                        --edge.getDepends().branch;
                    }
                    for (i = branch.getBranch().branch; i <= this.abox.getPseudoModel().getBranches().size(); ++i) {
                        if (!edge.getDepends().contains(i)) continue;
                        edge.getDepends().remove(i);
                        edge.getDepends().add(i - 1);
                    }
                }
            }
            this.abox.getPseudoModel().completionQueue.branchEffects.remove(branch.getBranch().branch);
            List<Branch> branches = this.abox.getPseudoModel().getBranches();
            for (int i = branch.getBranch().branch; i < branches.size(); ++i) {
                Branch br = branches.get(i);
                if (br.termDepends.branch > branch.getBranch().branch) {
                    --br.termDepends.branch;
                }
                for (int j = branch.getBranch().branch; j < this.abox.getPseudoModel().getBranches().size(); ++j) {
                    if (!br.termDepends.contains(j)) continue;
                    br.termDepends.remove(j);
                    br.termDepends.add(j - 1);
                }
                --br.branch;
            }
            branches.remove(branch.getBranch());
            this.abox.getPseudoModel().setBranch(this.abox.getPseudoModel().getBranch() - 1);
        }
    }

    private void restoreCloseBranch(ATermAppl assertion, CloseBranchDependency branch) {
        if (branch.getTheBranch().tryNext > -1) {
            if (DependencyIndex.log.isDebugEnabled()) {
                DependencyIndex.log.debug((Object)("    Undoing branch remove - branch " + branch.getBranch() + "  -  " + branch.getInd() + "   tryNext: " + branch.getTryNext()));
            }
            branch.getTheBranch().shiftTryNext(branch.getTryNext());
        }
    }

    private void restoreClash(ATermAppl assertion, ClashDependency clash) {
        if (DependencyIndex.log.isDebugEnabled()) {
            DependencyIndex.log.debug((Object)("    Restoring clash dependency clash: " + clash.getClash()));
        }
        clash.getClash().depends.removeExplain(assertion);
        if (clash.getClash().depends.explain.isEmpty() && clash.getClash().depends.isIndependent()) {
            if (DependencyIndex.log.isDebugEnabled()) {
                DependencyIndex.log.debug((Object)"           Actually removing clash!");
            }
            this.abox.getPseudoModel().setClash(null);
        }
    }

    protected static void handleUndefinedEntity(String s) {
        if (!PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
            throw new UndefinedEntityException(s);
        }
    }

    public Set<ATermAppl> getABoxAssertions(AssertionType assertionType) {
        Set assertions = (Set)this.aboxAssertions.get((Object)assertionType);
        if (assertions == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(assertions);
    }

    public Set<ATermAppl> getAboxMembershipAssertions() {
        return this.getABoxAssertions(AssertionType.TYPE);
    }

    public Set<ATermAppl> getAboxObjectRoleAssertions() {
        return this.getABoxAssertions(AssertionType.OBJ_ROLE);
    }

    public Set<ATermAppl> getAboxDataRoleAssertions() {
        return this.getABoxAssertions(AssertionType.DATA_ROLE);
    }

    class FullyDefinedClassVisitor
    extends ATermBaseVisitor {
        private boolean fullyDefined = true;

        FullyDefinedClassVisitor() {
        }

        public boolean isFullyDefined(ATermAppl term) {
            this.fullyDefined = true;
            this.visit(term);
            return this.fullyDefined;
        }

        private void visitQCR(ATermAppl term) {
            ATermAppl q;
            this.visitRestr(term);
            if (this.fullyDefined && !KnowledgeBase.this.isDatatype(q = (ATermAppl)term.getArgument(2))) {
                this.visit(q);
            }
        }

        private void visitQR(ATermAppl term) {
            ATermAppl q;
            this.visitRestr(term);
            if (this.fullyDefined && !KnowledgeBase.this.isDatatype(q = (ATermAppl)term.getArgument(1))) {
                this.visit(q);
            }
        }

        private void visitRestr(ATermAppl term) {
            this.fullyDefined = this.fullyDefined && KnowledgeBase.this.isProperty(term.getArgument(0));
        }

        public void visit(ATermAppl term) {
            if (term.equals(ATermUtils.TOP) || term.equals(ATermUtils.BOTTOM) || term.equals(ATermUtils.TOP_LIT) || term.equals(ATermUtils.BOTTOM_LIT)) {
                return;
            }
            super.visit(term);
        }

        public void visitAll(ATermAppl term) {
            this.visitQR(term);
        }

        public void visitAnd(ATermAppl term) {
            if (this.fullyDefined) {
                this.visitList((ATermList)term.getArgument(0));
            }
        }

        public void visitCard(ATermAppl term) {
            this.visitQCR(term);
        }

        public void visitHasValue(ATermAppl term) {
            this.visitQR(term);
        }

        public void visitLiteral(ATermAppl term) {
        }

        public void visitMax(ATermAppl term) {
            this.visitQCR(term);
        }

        public void visitMin(ATermAppl term) {
            this.visitQCR(term);
        }

        public void visitNot(ATermAppl term) {
            this.visit((ATermAppl)term.getArgument(0));
        }

        public void visitOneOf(ATermAppl term) {
            if (this.fullyDefined) {
                this.visitList((ATermList)term.getArgument(0));
            }
        }

        public void visitOr(ATermAppl term) {
            if (this.fullyDefined) {
                this.visitList((ATermList)term.getArgument(0));
            }
        }

        public void visitSelf(ATermAppl term) {
            this.visitRestr(term);
        }

        public void visitSome(ATermAppl term) {
            this.visitQR(term);
        }

        public void visitTerm(ATermAppl term) {
            boolean bl = this.fullyDefined = this.fullyDefined && KnowledgeBase.this.tbox.getClasses().contains(term);
            if (!this.fullyDefined) {
                return;
            }
        }

        public void visitValue(ATermAppl term) {
            ATermAppl nominal = (ATermAppl)term.getArgument(0);
            if (!ATermUtils.isLiteral(nominal)) {
                this.fullyDefined = this.fullyDefined && KnowledgeBase.this.individuals.contains(nominal);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AssertionType {
        TYPE,
        OBJ_ROLE,
        DATA_ROLE;

    }
}

