/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.progress.ConsoleProgressMonitor;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.mindswap.pellet.utils.progress.SilentProgressMonitor;
import org.mindswap.pellet.utils.progress.SwingProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletOptions {
    public static final Log log = LogFactory.getLog(PelletOptions.class);
    public static boolean SATURATE_TABLEAU = false;
    public static boolean USE_UNIQUE_NAME_ASSUMPTION = false;
    public static boolean TREAT_ALL_VARS_DISTINGUISHED = false;
    public static boolean USE_DISJUNCT_SORTING = !SATURATE_TABLEAU;
    public static MonitorType USE_CLASSIFICATION_MONITOR = MonitorType.NONE;
    public static final String NO_SORTING = "NO";
    public static final String OLDEST_FIRST = "OLDEST_FIRST";
    public static String USE_DISJUNCTION_SORTING = "OLDEST_FIRST";
    public static boolean USE_LOCAL_NAME = false;
    public static boolean USE_QNAME = false;
    public static boolean USE_ABSORPTION = true;
    public static boolean USE_ROLE_ABSORPTION = true;
    public static boolean USE_NOMINAL_ABSORPTION = true;
    public static boolean USE_HASVALUE_ABSORPTION = true;
    public static boolean USE_OPTIMIZEDINDIVIDUALS = false;
    public static boolean USE_BACKJUMPING = !SATURATE_TABLEAU & true;
    public static boolean USE_FULL_DATATYPE_REASONING = true;
    public static boolean AUTO_XML_SCHEMA_LOADING = false;
    public static boolean USE_CACHING = true;
    public static boolean USE_ADVANCED_CACHING = true;
    public static boolean CHECK_NOMINAL_EDGES = true;
    public static boolean USE_PSEUDO_MODEL = true;
    public static boolean USE_PSEUDO_NOMINALS = false;
    public static boolean IGNORE_INVERSES = false;
    public static boolean USE_COMPLETION_STRATEGY = !SATURATE_TABLEAU & true;
    public static boolean USE_CONTINUOUS_RULES = false;
    public static boolean USE_SEMANTIC_BRANCHING = !SATURATE_TABLEAU & true;
    public static Class<? extends CompletionStrategy> DEFAULT_COMPLETION_STRATEGY = null;
    public static boolean PRINT_SIZE = false;
    public static final String BNODE = "bNode";
    public static final String ANON = "anon";
    public static boolean COPY_ON_WRITE = true;
    public static boolean SILENT_UNDEFINED_ENTITY_HANDLING = true;
    public static boolean REALIZE_INDIVIDUAL_AT_A_TIME = false;
    public static boolean VALIDATE_ABOX = false;
    public static boolean PRINT_ABOX = false;
    public static final boolean DEPTH_FIRST = true;
    public static final boolean BREADTH_FIRST = false;
    public static boolean KEEP_ABOX_ASSERTIONS = false;
    public static boolean SEARCH_TYPE = true;
    public static boolean USE_BINARY_INSTANCE_RETRIEVAL = true;
    public static boolean SPLIT_QUERY = true;
    public static boolean SIMPLIFY_QUERY = true;
    public static boolean REORDER_QUERY = false;
    public static double SAMPLING_RATIO = 0.2;
    public static boolean FULL_SIZE_ESTIMATE = false;
    public static boolean CACHE_RETRIEVAL = false;
    public static boolean USE_TRACING = false;
    public static String DEFAULT_CONFIGURATION_FILE = "pellet.properties";
    public static boolean DOUBLE_CHECK_ENTAILMENTS = false;
    public static boolean FREEZE_BUILTIN_NAMESPACES = true;
    public static boolean IGNORE_DEPRECATED_TERMS = true;
    public static boolean IGNORE_UNSUPPORTED_AXIOMS = true;
    public static boolean DL_SAFE_RULES = true;
    public static boolean RETURN_DEDUCTIONS_GRAPH = false;
    public static boolean USE_COMPLETION_QUEUE;
    public static boolean USE_SMART_RESTORE;
    public static boolean USE_INCREMENTAL_CONSISTENCY;
    public static boolean USE_INCREMENTAL_DELETION;
    public static boolean MAINTAIN_COMPLETION_QUEUE;
    public static boolean USE_CD_CLASSIFICATION;

    private static void load(URL configFile) {
        log.info((Object)("Reading Pellet configuration file " + configFile));
        Properties properties = new Properties();
        try {
            properties.load(configFile.openStream());
            USE_UNIQUE_NAME_ASSUMPTION = PelletOptions.getBooleanProperty(properties, "USE_UNIQUE_NAME_ASSUMPTION", USE_UNIQUE_NAME_ASSUMPTION);
            USE_PSEUDO_NOMINALS = PelletOptions.getBooleanProperty(properties, "USE_PSEUDO_NOMINALS", USE_PSEUDO_NOMINALS);
            USE_CLASSIFICATION_MONITOR = PelletOptions.getEnumProperty(properties, "USE_CLASSIFICATION_MONITOR", USE_CLASSIFICATION_MONITOR);
            REALIZE_INDIVIDUAL_AT_A_TIME = PelletOptions.getBooleanProperty(properties, "REALIZE_INDIVIDUAL_AT_A_TIME", REALIZE_INDIVIDUAL_AT_A_TIME);
            FREEZE_BUILTIN_NAMESPACES = PelletOptions.getBooleanProperty(properties, "FREEZE_BUILTIN_NAMESPACES", FREEZE_BUILTIN_NAMESPACES);
            IGNORE_DEPRECATED_TERMS = PelletOptions.getBooleanProperty(properties, "IGNORE_DEPRECATED_TERMS", IGNORE_DEPRECATED_TERMS);
            IGNORE_UNSUPPORTED_AXIOMS = PelletOptions.getBooleanProperty(properties, "IGNORE_UNSUPPORTED_AXIOMS", IGNORE_UNSUPPORTED_AXIOMS);
            DL_SAFE_RULES = PelletOptions.getBooleanProperty(properties, "DL_SAFE_RULES", DL_SAFE_RULES);
            USE_CACHING = PelletOptions.getBooleanProperty(properties, "USE_CACHING", USE_CACHING);
            USE_ADVANCED_CACHING = PelletOptions.getBooleanProperty(properties, "USE_ADVANCED_CACHING", USE_ADVANCED_CACHING);
            SAMPLING_RATIO = PelletOptions.getDoubleProperty(properties, "SAMPLING_RATIO", SAMPLING_RATIO);
            FULL_SIZE_ESTIMATE = PelletOptions.getBooleanProperty(properties, "FULL_SIZE_ESTIMATE", FULL_SIZE_ESTIMATE);
            RETURN_DEDUCTIONS_GRAPH = PelletOptions.getBooleanProperty(properties, "RETURN_DEDUCTIONS_GRAPH", RETURN_DEDUCTIONS_GRAPH);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"Pellet configuration file cannot be found");
        }
        catch (IOException e) {
            log.error((Object)"I/O error while reading Pellet configuration file");
        }
    }

    private static boolean getBooleanProperty(Properties properties, String property, boolean defaultValue) {
        String value = properties.getProperty(property);
        if (value != null) {
            if ((value = value.trim()).equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
            log.error((Object)("Ignoring invalid value (" + value + ") for the configuration option " + property));
        }
        return defaultValue;
    }

    private static double getDoubleProperty(Properties properties, String property, double defaultValue) {
        String value = properties.getProperty(property);
        double doubleValue = defaultValue;
        if (value != null) {
            try {
                doubleValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Ignoring invalid double value (" + value + ") for the configuration option " + property));
            }
        }
        return doubleValue;
    }

    private static <T extends Enum<T>> T getEnumProperty(Properties properties, String property, T defaultValue) {
        String value = properties.getProperty(property);
        if (value != null) {
            value = value.trim().toUpperCase();
            try {
                return Enum.valueOf(defaultValue.getDeclaringClass(), value);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Ignoring invalid value (" + value + ") for the configuration option " + property));
            }
        }
        return defaultValue;
    }

    static {
        String configFile = System.getProperty("pellet.configuration");
        URL url = null;
        if (configFile == null) {
            url = PelletOptions.class.getClassLoader().getResource(DEFAULT_CONFIGURATION_FILE);
        } else {
            try {
                url = new URL(configFile);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
                url = PelletOptions.class.getClassLoader().getResource(configFile);
            }
            if (url == null) {
                log.error((Object)("Cannot file Pellet configuration file " + configFile));
            }
        }
        if (url != null) {
            PelletOptions.load(url);
        }
        USE_SMART_RESTORE = !(USE_COMPLETION_QUEUE = false);
        USE_INCREMENTAL_CONSISTENCY = false;
        USE_INCREMENTAL_DELETION = USE_INCREMENTAL_CONSISTENCY && USE_TRACING;
        MAINTAIN_COMPLETION_QUEUE = false;
        USE_CD_CLASSIFICATION = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MonitorType implements EnumFactory<ProgressMonitor>
    {
        CONSOLE(ConsoleProgressMonitor.class),
        SWING(SwingProgressMonitor.class),
        NONE(SilentProgressMonitor.class);

        private final Class<? extends ProgressMonitor> c;

        private MonitorType(Class<? extends ProgressMonitor> c) {
            this.c = c;
        }

        @Override
        public ProgressMonitor create() {
            try {
                return this.c.newInstance();
            }
            catch (InstantiationException e) {
                throw new InternalReasonerException(e);
            }
            catch (IllegalAccessException e) {
                throw new InternalReasonerException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface EnumFactory<T> {
        public T create();
    }
}

