/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.URIUtils;

public class OutputFormatter {
    PrintWriter out = null;
    QNameProvider qnames;
    boolean formatHTML;

    public OutputFormatter() {
        this(false);
    }

    public OutputFormatter(boolean formatHTML) {
        this(System.out, formatHTML);
    }

    public OutputFormatter(OutputStream out, boolean formatHTML) {
        this(new PrintWriter(out), formatHTML);
    }

    public OutputFormatter(Writer out, boolean formatHTML) {
        this.out = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
        this.formatHTML = formatHTML;
        this.qnames = new QNameProvider();
    }

    public boolean isFormatHTML() {
        return this.formatHTML;
    }

    public void setFormatHTML(boolean formatHTML) {
        this.formatHTML = formatHTML;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public void flush() {
        this.out.flush();
    }

    public OutputFormatter printTab() {
        if (this.formatHTML) {
            this.out.print("&nbsp;&nbsp;&nbsp;");
        } else {
            this.out.print("   ");
        }
        return this;
    }

    public OutputFormatter print(String s) {
        this.out.print(s);
        return this;
    }

    public OutputFormatter print(Object o) {
        this.out.print(o);
        return this;
    }

    public OutputFormatter print(boolean b) {
        this.out.print(b);
        return this;
    }

    public OutputFormatter println(Object o) {
        this.print(o);
        this.println();
        return this;
    }

    public OutputFormatter println(String s) {
        this.out.print(s);
        this.println();
        return this;
    }

    public OutputFormatter println() {
        this.printHTML("<br>");
        this.out.println();
        return this;
    }

    public OutputFormatter printParagraph() {
        if (this.formatHTML) {
            this.out.println("<p>");
        } else {
            this.out.println();
        }
        return this;
    }

    public OutputFormatter printURI(String uri) {
        String label;
        String string = label = this.qnames != null ? this.qnames.shortForm(uri) : URIUtils.getLocalName(uri);
        if (this.formatHTML) {
            this.printLink(uri, label);
        } else {
            this.print(label);
        }
        return this;
    }

    public OutputFormatter printLink(String uri) {
        if (this.formatHTML) {
            this.printLink(uri, uri);
        } else {
            this.out.print(uri);
        }
        return this;
    }

    public OutputFormatter printLink(String uri, String label) {
        if (this.formatHTML) {
            this.out.print("<a href=\"");
            this.out.print(uri);
            this.out.print("\">");
            this.out.print(label);
            this.out.print("</a>");
        } else {
            this.out.print(label + " (" + uri + ")");
        }
        return this;
    }

    public OutputFormatter printBold(String s) {
        return this.printInsideTag(s, "b");
    }

    public OutputFormatter printItalic(String s) {
        return this.printInsideTag(s, "i");
    }

    public OutputFormatter printInsideTag(String s, String tag) {
        if (this.formatHTML) {
            this.out.print("<");
            this.out.print(tag);
            this.out.print(">");
            this.out.print(s);
            this.out.print("</");
            this.out.print(tag);
            this.out.print(">");
        } else {
            this.out.print(s);
        }
        return this;
    }

    public OutputFormatter printHTML(String tag) {
        if (this.formatHTML) {
            this.out.print(tag);
        }
        return this;
    }

    public QNameProvider getQNames() {
        return this.qnames;
    }

    public void setQNames(QNameProvider qnames) {
        this.qnames = qnames;
    }
}

