/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import aterm.ATermAppl;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryExec;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.impl.BindingIterator;
import org.mindswap.pellet.query.impl.LiteralIterator;
import org.mindswap.pellet.query.impl.QueryResultsImpl;

public class SimpleQueryExec
implements QueryExec {
    public static Log log = LogFactory.getLog(QueryEngine.class);

    public boolean supports(Query q) {
        return !q.getDistObjVars().isEmpty();
    }

    public QueryResults exec(Query q) {
        QueryResultBinding b;
        boolean hasLiterals;
        QueryResultsImpl results = new QueryResultsImpl(q);
        KnowledgeBase kb = q.getKB();
        long satCount = kb.getABox().satisfiabilityCount;
        HashMap<ATermAppl, Set<ATermAppl>> varBindings = new HashMap<ATermAppl, Set<ATermAppl>>();
        for (ATermAppl currVar : q.getDistObjVars()) {
            ATermAppl rolledUpClass = q.rollUpTo(currVar);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Rolled up class " + rolledUpClass));
            }
            varBindings.put(currVar, kb.getInstances(rolledUpClass));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Var bindings: " + varBindings));
        }
        BindingIterator i = new BindingIterator(q, varBindings);
        boolean bl = hasLiterals = !q.getDistLitVars().isEmpty();
        if (hasLiterals) {
            while (i.hasNext()) {
                b = (QueryResultBinding)i.next();
                LiteralIterator l = new LiteralIterator(q, b);
                while (l.hasNext()) {
                    QueryResultBinding mappy = (QueryResultBinding)l.next();
                    boolean queryTrue = QueryEngine.execBoolean(q.apply(mappy));
                    if (!queryTrue) continue;
                    results.add(mappy);
                }
            }
        } else {
            while (i.hasNext()) {
                b = (QueryResultBinding)i.next();
                boolean queryTrue = q.getDistObjVars().size() == 1 || QueryEngine.execBoolean(q.apply(b));
                if (!queryTrue) continue;
                results.add(b);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Total satisfiability operations: " + (kb.getABox().satisfiabilityCount - satCount)));
        }
        return results;
    }
}

