/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rules;

import java.util.Collection;
import java.util.Collections;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.rules.BindingHelper;
import org.mindswap.pellet.rules.VariableBinding;
import org.mindswap.pellet.rules.VariableUtils;
import org.mindswap.pellet.rules.model.AtomDObject;
import org.mindswap.pellet.rules.model.AtomVariable;
import org.mindswap.pellet.rules.model.DataRangeAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRangeBindingHelper
implements BindingHelper {
    private DataRangeAtom atom;
    private boolean hasNext;

    public DataRangeBindingHelper(DataRangeAtom atom) {
        this.atom = atom;
        this.hasNext = false;
    }

    public Collection<AtomVariable> getBindableVars() {
        return Collections.emptySet();
    }

    public Collection<AtomVariable> getPrerequisiteVars() {
        return VariableUtils.getVars(this.atom);
    }

    @Override
    public void rebind(VariableBinding newBinding) {
        Literal dValue = newBinding.get((AtomDObject)this.atom.getArgument());
        if (dValue == null) {
            throw new InternalReasonerException("DataRangeBindingHelper cannot generate bindings for " + this.atom);
        }
        this.hasNext = ((Datatype)this.atom.getPredicate()).contains(dValue.getValue());
    }

    @Override
    public boolean selectNextBinding() {
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public void setCurrentBinding(VariableBinding currentBinding) {
    }

    public String toString() {
        return this.atom.toString();
    }
}

