/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rules;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.rules.builtins.BuiltIn;
import org.mindswap.pellet.rules.builtins.BuiltInRegistry;
import org.mindswap.pellet.rules.builtins.NoSuchBuiltIn;
import org.mindswap.pellet.rules.model.BuiltInAtom;
import org.mindswap.pellet.rules.model.ClassAtom;
import org.mindswap.pellet.rules.model.DataRangeAtom;
import org.mindswap.pellet.rules.model.DatavaluedPropertyAtom;
import org.mindswap.pellet.rules.model.DifferentIndividualsAtom;
import org.mindswap.pellet.rules.model.IndividualPropertyAtom;
import org.mindswap.pellet.rules.model.Rule;
import org.mindswap.pellet.rules.model.RuleAtom;
import org.mindswap.pellet.rules.model.RuleAtomVisitor;
import org.mindswap.pellet.rules.model.SameIndividualAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsableRuleFilter
implements Iterable<Rule> {
    static final Log log = KnowledgeBase.log;
    private BodyAtomFilter bodyFilter = new BodyAtomFilter();
    private HeadAtomFilter headFilter = new HeadAtomFilter();
    private Set<Rule> rules = new HashSet<Rule>();

    public boolean add(Rule rule) {
        for (RuleAtom atom : rule.getHead()) {
            atom.accept(this.headFilter);
            if (this.headFilter.isUsable()) continue;
            log.warn((Object)("Ignoring rule " + rule + ":" + this.headFilter.getMessage()));
            return false;
        }
        for (RuleAtom atom : rule.getBody()) {
            atom.accept(this.bodyFilter);
            if (this.bodyFilter.isUsable()) continue;
            log.warn((Object)("Ignoring rule " + rule + ":" + this.bodyFilter.getMessage()));
            return false;
        }
        return this.rules.add(rule);
    }

    public Set<Rule> getRules() {
        return Collections.unmodifiableSet(this.rules);
    }

    @Override
    public Iterator<Rule> iterator() {
        return this.rules.iterator();
    }

    private static class HeadAtomFilter
    implements RuleAtomVisitor {
        private boolean usable;
        private String usageMessage;

        private HeadAtomFilter() {
        }

        public String getMessage() {
            return this.usageMessage;
        }

        public boolean isUsable() {
            return this.usable;
        }

        public void visit(BuiltInAtom atom) {
            this.usable = false;
            this.usageMessage = "Builtin atoms in rule heads are not currently supported";
        }

        public void visit(ClassAtom atom) {
            this.usable = true;
        }

        public void visit(DataRangeAtom atom) {
            this.usable = false;
            this.usageMessage = "DataRange atoms in rule heads are not currently supported";
        }

        public void visit(DatavaluedPropertyAtom atom) {
            this.usable = true;
        }

        public void visit(DifferentIndividualsAtom atom) {
            this.usable = true;
        }

        public void visit(IndividualPropertyAtom atom) {
            this.usable = true;
        }

        public void visit(SameIndividualAtom atom) {
            this.usable = true;
        }
    }

    private static class BodyAtomFilter
    implements RuleAtomVisitor {
        private boolean usable;
        private String usageMessage;

        private BodyAtomFilter() {
        }

        public String getMessage() {
            return this.usageMessage;
        }

        public boolean isUsable() {
            return this.usable;
        }

        public void visit(BuiltInAtom atom) {
            BuiltIn builtin = BuiltInRegistry.instance.getBuiltIn((String)atom.getPredicate());
            if (builtin.equals(NoSuchBuiltIn.instance)) {
                this.usable = false;
                this.usageMessage = "No builtin for " + (String)atom.getPredicate();
            } else {
                this.usable = true;
            }
        }

        public void visit(ClassAtom atom) {
            this.usable = true;
        }

        public void visit(DataRangeAtom atom) {
            this.usable = true;
        }

        public void visit(DatavaluedPropertyAtom atom) {
            this.usable = true;
        }

        public void visit(DifferentIndividualsAtom atom) {
            this.usable = true;
        }

        public void visit(IndividualPropertyAtom atom) {
            this.usable = true;
        }

        public void visit(SameIndividualAtom atom) {
            this.usable = true;
        }
    }
}

