/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy;

import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.Expressivity;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.URIUtils;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.mindswap.pellet.utils.progress.SilentProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOptimizedTaxonomyBuilder
implements TaxonomyBuilder {
    protected static Log log = LogFactory.getLog(Taxonomy.class);
    private ProgressMonitor monitor = PelletOptions.USE_CLASSIFICATION_MONITOR.create();
    private static final byte PROPOGATE_UP = 1;
    private static final byte NO_PROPOGATE = 0;
    private static final byte PROPOGATE_DOWN = -1;
    protected Collection<ATermAppl> classes;
    private Map<ATermAppl, Set<ATermAppl>> toldDisjoints;
    private Map<ATermAppl, ATermList> unionClasses;
    private Set<ATermAppl> cyclicConcepts;
    protected Taxonomy toldTaxonomy;
    protected Taxonomy taxonomy;
    protected KnowledgeBase kb;
    private int count;
    private boolean useCD;
    private List<TaxonomyNode> markedNodes;
    private Map<ATermAppl, ConceptFlag> conceptFlags;

    @Override
    public void setKB(KnowledgeBase kb) {
        this.kb = kb;
    }

    @Override
    public void setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor == null ? new SilentProgressMonitor() : monitor;
    }

    @Override
    public Taxonomy classify() {
        Collection<ATermAppl> phaseTwo;
        List<ATermAppl> phaseOne;
        this.classes = this.kb.getClasses();
        if (this.kb.getClasses().isEmpty()) {
            this.taxonomy = new Taxonomy();
            return this.taxonomy;
        }
        if (log.isInfoEnabled()) {
            this.kb.timers.createTimer("classifySub");
            log.info((Object)("Classes: " + (this.classes.size() + 2) + " Individuals: " + this.kb.getIndividuals().size()));
        }
        this.prepare();
        if (log.isInfoEnabled()) {
            log.info((Object)"Starting classification...");
        }
        if (this.useCD) {
            phaseOne = new ArrayList<ATermAppl>();
            phaseTwo = new ArrayList<ATermAppl>();
            block3: for (ATermAppl c : this.classes) {
                switch (this.conceptFlags.get(c)) {
                    case COMPLETELY_DEFINED: 
                    case PRIMITIVE: 
                    case OTHER: {
                        phaseOne.add(c);
                        continue block3;
                    }
                }
                phaseTwo.add(c);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Using CD classification with phaseOne: " + phaseOne.size() + " phaseTwo: " + phaseTwo.size()));
            }
        } else {
            phaseOne = Collections.emptyList();
            phaseTwo = this.classes;
            if (log.isInfoEnabled()) {
                log.info((Object)"CD classification disabled");
            }
        }
        this.monitor.setProgressTitle("Classifying");
        this.monitor.setProgressLength(this.classes.size());
        this.monitor.taskStarted();
        for (ATermAppl c : phaseOne) {
            this.classify(c, false);
            this.monitor.incrementProgress();
            if (!this.monitor.isCanceled()) continue;
            this.classes = this.kb.getClasses();
            return null;
        }
        phaseOne = null;
        for (ATermAppl c : phaseTwo) {
            this.classify(c, true);
            this.monitor.incrementProgress();
            if (!this.monitor.isCanceled()) continue;
            this.classes = this.kb.getClasses();
            return null;
        }
        phaseTwo = null;
        this.monitor.taskFinished();
        if (log.isInfoEnabled()) {
            log.info((Object)("SubClass Count: " + this.kb.timers.getTimer("classifySub").getCount()));
            log.info((Object)("Satisfiability Count: " + (this.kb.getABox().satisfiabilityCount - (long)(2 * this.kb.getClasses().size()))));
        }
        this.classes = this.kb.getClasses();
        this.taxonomy.assertValid();
        return this.taxonomy;
    }

    private void prepare() {
        this.reset();
        this.computeToldInformation();
        this.createDefinitionOrder();
        this.computeConceptFlags();
    }

    private void reset() {
        this.count = 0;
        this.kb.prepare();
        Expressivity expr = this.kb.getExpressivity();
        TBox tbox = this.kb.getTBox();
        this.useCD = PelletOptions.USE_CD_CLASSIFICATION && tbox.getUC() == null && tbox.unfold(ATermUtils.TOP) == null && !expr.hasInverse() && !expr.hasNominal() && !expr.hasComplexSubRoles();
        this.classes = new ArrayList<ATermAppl>(this.kb.getClasses());
        this.toldDisjoints = new HashMap<ATermAppl, Set<ATermAppl>>();
        this.unionClasses = new HashMap<ATermAppl, ATermList>();
        this.markedNodes = new ArrayList<TaxonomyNode>(this.classes.size());
        this.taxonomy = new Taxonomy();
        this.toldTaxonomy = new Taxonomy(this.classes);
        this.cyclicConcepts = new HashSet<ATermAppl>();
        this.conceptFlags = new HashMap<ATermAppl, ConceptFlag>();
    }

    private void computeToldInformation() {
        TBox tbox = this.kb.getTBox();
        Collection<ATermAppl> axioms = tbox.getAxioms();
        for (ATermAppl axiom : axioms) {
            boolean reverseArgs;
            ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
            boolean equivalent = axiom.getAFun().equals(ATermUtils.EQCLASSFUN);
            Set<ATermAppl> explanation = tbox.getAxiomExplanation(axiom);
            boolean bl = reverseArgs = !ATermUtils.isPrimitive(c1) && ATermUtils.isPrimitive(c2);
            if (equivalent && reverseArgs) {
                this.addToldRelation(c2, c1, equivalent, explanation);
                continue;
            }
            this.addToldRelation(c1, c2, equivalent, explanation);
        }
        for (ATermAppl c : this.unionClasses.keySet()) {
            ATermList disj = this.unionClasses.get(c);
            List lca = this.toldTaxonomy.computeLCA(disj);
            for (ATermAppl d : lca) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Union subsumption " + this.getName(c) + " " + this.getName(d)));
                }
                this.addToldSubsumer(c, d);
            }
        }
        this.unionClasses = null;
        this.toldTaxonomy.assertValid();
    }

    private void createDefinitionOrder() {
        Timer t = this.kb.timers.startTimer("createDefinitionOrder");
        Taxonomy definitionOrderTaxonomy = new Taxonomy(this.classes);
        for (ATermAppl c : this.classes) {
            List<Pair<ATermAppl, Set<ATermAppl>>> desc = this.kb.getTBox().unfold(c);
            if (desc == null) continue;
            for (Pair<ATermAppl, Set<ATermAppl>> pair : desc) {
                Set<ATermAppl> usedByC = ATermUtils.findPrimitives((ATermAppl)pair.first, true, true);
                for (ATermAppl d : usedByC) {
                    if (c.equals(d)) continue;
                    TaxonomyNode cNode = definitionOrderTaxonomy.getNode(c);
                    TaxonomyNode dNode = definitionOrderTaxonomy.getNode(d);
                    if (cNode == null) {
                        throw new InternalReasonerException(c + " is not in the definition order");
                    }
                    if (cNode.equals(this.toldTaxonomy.getTop())) {
                        definitionOrderTaxonomy.merge(cNode, dNode);
                        continue;
                    }
                    dNode.addSub(cNode);
                    definitionOrderTaxonomy.removeCycles(cNode);
                }
            }
        }
        definitionOrderTaxonomy.assertValid();
        this.classes = definitionOrderTaxonomy.topologocialSort(true);
        this.cyclicConcepts = new HashSet<ATermAppl>();
        for (TaxonomyNode node : definitionOrderTaxonomy.getNodes()) {
            Set<ATermAppl> names = node.getEquivalents();
            if (names.size() <= 1) continue;
            this.cyclicConcepts.addAll(names);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cyclic concepts (" + this.cyclicConcepts.size() + "): " + this.cyclicConcepts));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sorted: " + this.classes));
        }
        t.stop();
    }

    private void computeConceptFlags() {
        if (!this.useCD) {
            return;
        }
        for (ATermAppl p : this.kb.getRBox().getRoleNames()) {
            for (ATermAppl c : this.kb.getDomains(p)) {
                this.conceptFlags.put(c, ConceptFlag.OTHER);
            }
        }
        TBox tbox = this.kb.getTBox();
        for (ATermAppl c : this.classes) {
            List<Pair<ATermAppl, Set<ATermAppl>>> desc = this.kb.getTBox().unfold(c);
            if (tbox.unfold(ATermUtils.makeNot(c)) != null || this.cyclicConcepts.contains(c)) {
                this.conceptFlags.put(c, ConceptFlag.NONPRIMITIVE);
                for (Pair<ATermAppl, Set<ATermAppl>> pair : desc) {
                    for (ATermAppl d : ATermUtils.findPrimitives((ATermAppl)pair.first)) {
                        ConceptFlag current = this.conceptFlags.get(d);
                        if (current != null && current != ConceptFlag.COMPLETELY_DEFINED) continue;
                        this.conceptFlags.put(d, ConceptFlag.PRIMITIVE);
                    }
                }
                continue;
            }
            boolean flagged = false;
            for (ATermAppl sup : this.toldTaxonomy.getSupers(c, true, true)) {
                ConceptFlag supFlag = this.conceptFlags.get(sup);
                if (supFlag != ConceptFlag.NONPRIMITIVE && supFlag != ConceptFlag.NONPRIMITIVE_TA) continue;
                this.conceptFlags.put(c, ConceptFlag.NONPRIMITIVE_TA);
                flagged = true;
                break;
            }
            if (flagged || this.conceptFlags.get(c) != null) continue;
            this.conceptFlags.put(c, this.isCDDesc(desc) ? ConceptFlag.COMPLETELY_DEFINED : ConceptFlag.PRIMITIVE);
        }
        if (log.isInfoEnabled()) {
            int cd = 0;
            int p = 0;
            int np = 0;
            int npta = 0;
            int other = 0;
            block13: for (ATermAppl c : this.classes) {
                switch (this.conceptFlags.get(c)) {
                    case COMPLETELY_DEFINED: {
                        ++cd;
                        continue block13;
                    }
                    case PRIMITIVE: {
                        ++p;
                        continue block13;
                    }
                    case NONPRIMITIVE: {
                        ++np;
                        continue block13;
                    }
                    case NONPRIMITIVE_TA: {
                        ++npta;
                        continue block13;
                    }
                    case OTHER: {
                        ++other;
                        continue block13;
                    }
                }
                log.warn((Object)(c.getName() + " has no classification flag"));
            }
            log.info((Object)("CD,P,NP,NPTA,O: " + cd + "," + p + "," + np + "," + npta + "," + other));
        }
    }

    private void clearMarks() {
        for (TaxonomyNode n : this.markedNodes) {
            n.mark = null;
        }
        this.markedNodes.clear();
    }

    private boolean isCDDesc(List<Pair<ATermAppl, Set<ATermAppl>>> desc) {
        if (desc != null) {
            for (Pair<ATermAppl, Set<ATermAppl>> pair : desc) {
                if (this.isCDDesc((ATermAppl)pair.first)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isCDDesc(ATermAppl desc) {
        ATermAppl negd;
        if (desc == null) {
            return true;
        }
        if (ATermUtils.isPrimitive(desc)) {
            return true;
        }
        if (ATermUtils.isAllValues(desc)) {
            return true;
        }
        if (ATermUtils.isAnd(desc)) {
            ATermList conj;
            boolean allCDConj = true;
            ATermList subConj = conj = (ATermList)desc.getArgument(0);
            while (allCDConj && !subConj.isEmpty()) {
                ATermAppl ci = (ATermAppl)subConj.getFirst();
                allCDConj = this.isCDDesc(ci);
                subConj = subConj.getNext();
            }
            return allCDConj;
        }
        return ATermUtils.isNot(desc) && ATermUtils.isPrimitive(negd = (ATermAppl)desc.getArgument(0));
    }

    private void addToldRelation(ATermAppl c, ATermAppl d, boolean equivalent, Set<ATermAppl> explanation) {
        ATermAppl negation;
        if (!(equivalent || c != ATermUtils.BOTTOM && d != ATermUtils.TOP)) {
            return;
        }
        if (!ATermUtils.isPrimitive(c)) {
            if (c.getAFun().equals(ATermUtils.ORFUN)) {
                ATermList list;
                ATermList disj = list = (ATermList)c.getArgument(0);
                while (!disj.isEmpty()) {
                    ATermAppl e = (ATermAppl)disj.getFirst();
                    this.addToldRelation(e, d, false, explanation);
                    disj = disj.getNext();
                }
            } else if (c.getAFun().equals(ATermUtils.NOTFUN) && ATermUtils.isPrimitive(d)) {
                ATermAppl negation2 = (ATermAppl)c.getArgument(0);
                this.addToldDisjoint(d, negation2);
                this.addToldDisjoint(negation2, d);
            }
        } else if (ATermUtils.isPrimitive(d)) {
            if (d.getName().startsWith("bNode")) {
                return;
            }
            if (!equivalent) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Preclassify (1) " + this.getName(c) + " " + this.getName(d)));
                }
                this.addToldSubsumer(c, d, explanation);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Preclassify (2) " + this.getName(c) + " " + this.getName(d)));
                }
                this.addToldEquivalent(c, d);
            }
        } else if (d.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList conj = (ATermList)d.getArgument(0);
            while (!conj.isEmpty()) {
                ATermAppl e = (ATermAppl)conj.getFirst();
                this.addToldRelation(c, e, false, explanation);
                conj = conj.getNext();
            }
        } else if (d.getAFun().equals(ATermUtils.ORFUN)) {
            ATermList list;
            boolean allPrimitive = true;
            ATermList disj = list = (ATermList)d.getArgument(0);
            while (!disj.isEmpty()) {
                ATermAppl e = (ATermAppl)disj.getFirst();
                if (ATermUtils.isPrimitive(e)) {
                    if (equivalent) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Preclassify (3) " + this.getName(c) + " " + this.getName(e)));
                        }
                        this.addToldSubsumer(e, c);
                    }
                } else {
                    allPrimitive = false;
                }
                disj = disj.getNext();
            }
            if (allPrimitive) {
                this.unionClasses.put(c, list);
            }
        } else if (d.equals(ATermUtils.BOTTOM)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Preclassify (4) " + this.getName(c) + " BOTTOM"));
            }
            this.addToldEquivalent(c, ATermUtils.BOTTOM);
        } else if (d.getAFun().equals(ATermUtils.NOTFUN) && ATermUtils.isPrimitive(negation = (ATermAppl)d.getArgument(0))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Preclassify (5) " + this.getName(c) + " not " + this.getName(negation)));
            }
            this.addToldDisjoint(c, negation);
            this.addToldDisjoint(negation, c);
        }
    }

    private void addToldEquivalent(ATermAppl c, ATermAppl d) {
        if (c.equals(d)) {
            return;
        }
        TaxonomyNode cNode = this.toldTaxonomy.getNode(c);
        TaxonomyNode dNode = this.toldTaxonomy.getNode(d);
        this.toldTaxonomy.merge(cNode, dNode);
    }

    private void addToldSubsumer(ATermAppl c, ATermAppl d) {
        this.addToldSubsumer(c, d, null);
    }

    private void addToldSubsumer(ATermAppl c, ATermAppl d, Set<ATermAppl> explanation) {
        TaxonomyNode cNode = this.toldTaxonomy.getNode(c);
        TaxonomyNode dNode = this.toldTaxonomy.getNode(d);
        if (cNode == null) {
            throw new InternalReasonerException(c + " is not in the definition order");
        }
        if (dNode == null) {
            throw new InternalReasonerException(d + " is not in the definition order");
        }
        if (cNode.equals(dNode)) {
            return;
        }
        if (cNode.equals(this.toldTaxonomy.getTop())) {
            this.toldTaxonomy.merge(cNode, dNode);
        } else {
            dNode.addSub(cNode);
            this.toldTaxonomy.removeCycles(cNode);
            if (explanation != null) {
                cNode.addSuperExplanation(dNode, explanation);
            }
        }
    }

    private void addToldDisjoint(ATermAppl c, ATermAppl d) {
        Set<ATermAppl> disjoints = this.toldDisjoints.get(c);
        if (disjoints == null) {
            disjoints = new HashSet<ATermAppl>();
            this.toldDisjoints.put(c, disjoints);
        }
        disjoints.add(d);
    }

    private void markToldSubsumers(ATermAppl c) {
        TaxonomyNode node = this.taxonomy.getNode(c);
        if (node != null) {
            boolean newMark = this.mark(node, Boolean.TRUE, (byte)1);
            if (!newMark) {
                return;
            }
        } else if (log.isInfoEnabled() && this.markedNodes.size() > 2) {
            log.warn((Object)("Told subsumer " + c + " is not classified yet"));
        }
        if (this.toldTaxonomy.contains(c)) {
            Set supers = this.toldTaxonomy.getSupers(c, true, true);
            for (ATermAppl sup : supers) {
                this.markToldSubsumers(sup);
            }
        }
    }

    private void markToldSubsumeds(ATermAppl c, Boolean b) {
        boolean newMark;
        TaxonomyNode node = this.taxonomy.getNode(c);
        if (node != null && !(newMark = this.mark(node, b, (byte)-1))) {
            return;
        }
        if (this.toldTaxonomy.contains(c)) {
            Set subs = this.toldTaxonomy.getSubs(c, true, true);
            for (ATermAppl sub : subs) {
                this.markToldSubsumeds(sub, b);
            }
        }
    }

    private void markToldDisjoints(Collection<ATermAppl> inputc, boolean topSearch) {
        HashSet<ATermAppl> cset = new HashSet<ATermAppl>();
        cset.addAll(inputc);
        for (ATermAppl c : inputc) {
            if (this.taxonomy.contains(c)) {
                cset.addAll(this.taxonomy.getSupers(c, false, true));
            }
            if (!this.toldTaxonomy.contains(c)) continue;
            cset.addAll(this.toldTaxonomy.getSupers(c, false, true));
        }
        HashSet<ATermAppl> disjoints = new HashSet<ATermAppl>();
        for (ATermAppl a : cset) {
            Set<ATermAppl> disj = this.toldDisjoints.get(a);
            if (disj == null) continue;
            disjoints.addAll(disj);
        }
        if (topSearch) {
            for (ATermAppl d : disjoints) {
                TaxonomyNode node = this.taxonomy.getNode(d);
                if (node == null) continue;
                this.mark(node, Boolean.FALSE, (byte)0);
            }
        } else {
            for (ATermAppl d : disjoints) {
                this.markToldSubsumeds(d, Boolean.FALSE);
            }
        }
    }

    private TaxonomyNode checkSatisfiability(ATermAppl c) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Satisfiable ");
        }
        Timer t = this.kb.timers.startTimer("classifySat");
        boolean isSatisfiable = this.kb.getABox().isSatisfiable(c, true);
        t.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)((isSatisfiable ? "true" : "*****FALSE*****") + " (" + t.getLast() + "ms)"));
        }
        if (!isSatisfiable) {
            this.taxonomy.addEquivalentNode(c, this.taxonomy.getBottom());
        }
        if (PelletOptions.USE_CACHING) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"...negation ");
            }
            t.start();
            ATermAppl notC = ATermUtils.makeNot(c);
            isSatisfiable = this.kb.getABox().isSatisfiable(notC, true);
            t.stop();
            if (!isSatisfiable) {
                this.taxonomy.addEquivalentNode(c, this.taxonomy.getTop());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(isSatisfiable + " (" + t.getLast() + "ms)"));
            }
        }
        return this.taxonomy.getNode(c);
    }

    @Override
    public void classify(ATermAppl c) {
        this.classify(c, true);
    }

    private TaxonomyNode classify(ATermAppl c, boolean requireTopSearch) {
        List<TaxonomyNode> subs;
        boolean skipBottomSearch;
        List<TaxonomyNode> supers;
        boolean skipTopSearch;
        TaxonomyNode node;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Classify (" + ++this.count + ") " + this.getName(c) + "..."));
        }
        if ((node = this.taxonomy.getNode(c)) != null) {
            return node;
        }
        node = this.checkSatisfiability(c);
        if (node != null) {
            return node;
        }
        this.clearMarks();
        ConceptFlag flag = this.conceptFlags.get(c);
        if (flag == null) {
            flag = ConceptFlag.OTHER;
        }
        boolean bl = skipTopSearch = !requireTopSearch && this.useCD && flag == ConceptFlag.COMPLETELY_DEFINED;
        if (skipTopSearch) {
            supers = this.getCDSupers(c);
            skipBottomSearch = true;
        } else {
            supers = this.doTopSearch(c);
            boolean bl2 = skipBottomSearch = this.useCD && flag == ConceptFlag.PRIMITIVE && flag == ConceptFlag.COMPLETELY_DEFINED;
        }
        if (skipBottomSearch) {
            subs = Collections.singletonList(this.taxonomy.getBottom());
        } else {
            TaxonomyNode supNode;
            ATermAppl sup;
            if (supers.size() == 1 && this.subsumes(c, sup = (supNode = supers.iterator().next()).getName())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.getName(c) + " = " + this.getName(sup)));
                }
                this.taxonomy.addEquivalentNode(c, supNode);
                return supNode;
            }
            subs = this.doBottomSearch(c, supers);
        }
        node = this.taxonomy.addNode(c);
        node.addSupers(supers);
        node.addSubs(subs);
        node.removeMultiplePaths();
        TaxonomyNode toldNode = this.toldTaxonomy.getNode(c);
        if (toldNode != null) {
            TaxonomyNode defOrder = this.toldTaxonomy.getNode(c);
            for (ATermAppl eq : defOrder.getEquivalents()) {
                this.taxonomy.addEquivalentNode(eq, node);
            }
            for (TaxonomyNode n : supers) {
                TaxonomyNode supTold = this.toldTaxonomy.getNode(n.getName());
                Set<Set<ATermAppl>> exps = toldNode.getSuperExplanations(supTold);
                if (exps == null) continue;
                for (Set<ATermAppl> exp : exps) {
                    node.addSuperExplanation(n, exp);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Subsumption Count: " + this.kb.getABox().satisfiabilityCount));
        }
        return node;
    }

    private List<TaxonomyNode> doBottomSearch(ATermAppl c, List<TaxonomyNode> supers) {
        HashSet<TaxonomyNode> searchFrom = new HashSet<TaxonomyNode>();
        for (TaxonomyNode sup : supers) {
            this.collectLeafs(sup, searchFrom);
        }
        if (searchFrom.isEmpty()) {
            return Collections.singletonList(this.taxonomy.getBottom());
        }
        this.clearMarks();
        this.mark(this.taxonomy.getTop(), Boolean.FALSE, (byte)0);
        this.taxonomy.getBottom().mark = Boolean.TRUE;
        this.markToldSubsumeds(c, Boolean.TRUE);
        for (TaxonomyNode sup : supers) {
            this.mark(sup, Boolean.FALSE, (byte)0);
        }
        log.debug((Object)"Bottom search...");
        ArrayList<TaxonomyNode> subs = new ArrayList<TaxonomyNode>();
        HashSet<TaxonomyNode> visited = new HashSet<TaxonomyNode>();
        for (TaxonomyNode n : searchFrom) {
            if (!this.subsumed(n, c)) continue;
            this.search(false, c, n, visited, subs);
        }
        if (subs.isEmpty()) {
            return Collections.singletonList(this.taxonomy.getBottom());
        }
        return subs;
    }

    private void collectLeafs(TaxonomyNode node, Collection<TaxonomyNode> leafs) {
        for (TaxonomyNode sub : node.getSubs()) {
            if (sub.isLeaf()) {
                leafs.add(sub);
                continue;
            }
            this.collectLeafs(sub, leafs);
        }
    }

    private List<TaxonomyNode> doTopSearch(ATermAppl c) {
        ArrayList<TaxonomyNode> supers = new ArrayList<TaxonomyNode>();
        this.mark(this.taxonomy.getTop(), Boolean.TRUE, (byte)0);
        this.taxonomy.getBottom().mark = Boolean.FALSE;
        this.markToldSubsumers(c);
        this.markToldDisjoints(Collections.singleton(c), true);
        log.debug((Object)"Top search...");
        this.search(true, c, this.taxonomy.getTop(), new HashSet<TaxonomyNode>(), supers);
        return supers;
    }

    private List<TaxonomyNode> getCDSupers(ATermAppl c) {
        ArrayList<TaxonomyNode> supers = new ArrayList<TaxonomyNode>();
        TaxonomyNode defOrder = this.toldTaxonomy.getNode(c);
        List<TaxonomyNode> cDefs = defOrder.getSupers();
        int nTS = cDefs.size();
        if (nTS > 1) {
            if (nTS == 2) {
                for (TaxonomyNode def : cDefs) {
                    if (def == this.toldTaxonomy.getTop()) continue;
                    TaxonomyNode parent = this.taxonomy.getNode(def.getName());
                    if (parent == null) {
                        throw new RuntimeException("CD classification of " + this.getName(c) + " failed, told subsumer " + this.getName(def.getName()) + " not classified");
                    }
                    supers.add(parent);
                    break;
                }
            } else {
                TaxonomyNode candidate;
                for (TaxonomyNode def : cDefs) {
                    if (def == this.toldTaxonomy.getTop()) continue;
                    candidate = this.taxonomy.getNode(def.getName());
                    if (candidate == null) {
                        throw new RuntimeException("CD classification of " + this.getName(c) + " failed, told subsumer " + this.getName(def.getName()) + " not classified");
                    }
                    for (TaxonomyNode ancestor : candidate.getSupers()) {
                        this.mark(ancestor, Boolean.TRUE, (byte)1);
                    }
                }
                for (TaxonomyNode def : cDefs) {
                    if (def == this.toldTaxonomy.getTop()) continue;
                    candidate = this.taxonomy.getNode(def.getName());
                    if (candidate.mark != null) continue;
                    supers.add(candidate);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("...completely defined by " + candidate.getName().getName()));
                }
            }
        }
        if (supers.isEmpty()) {
            supers.add(this.taxonomy.getTop());
        }
        return supers;
    }

    private Collection<TaxonomyNode> search(boolean topSearch, ATermAppl c, TaxonomyNode x, Set<TaxonomyNode> visited, List<TaxonomyNode> result) {
        ArrayList<TaxonomyNode> posSucc = new ArrayList<TaxonomyNode>();
        visited.add(x);
        List<TaxonomyNode> list = topSearch ? x.getSubs() : x.getSupers();
        for (TaxonomyNode next : list) {
            if (topSearch) {
                if (!this.subsumes(next, c)) continue;
                posSucc.add(next);
                continue;
            }
            if (!this.subsumed(next, c)) continue;
            posSucc.add(next);
        }
        if (posSucc.isEmpty()) {
            result.add(x);
        } else {
            for (TaxonomyNode y : posSucc) {
                if (visited.contains(y)) continue;
                this.search(topSearch, c, y, visited, result);
            }
        }
        return result;
    }

    private boolean subCheckWithCache(TaxonomyNode node, ATermAppl c, boolean topDown) {
        List<TaxonomyNode> others;
        Boolean cached = node.mark;
        if (cached != null) {
            return cached;
        }
        List<TaxonomyNode> list = others = topDown ? node.getSupers() : node.getSubs();
        if (others.size() > 1) {
            LinkedHashMap<TaxonomyNode, TaxonomyNode> visited = new LinkedHashMap<TaxonomyNode, TaxonomyNode>();
            visited.put(node, null);
            LinkedHashMap<TaxonomyNode, TaxonomyNode> toBeVisited = new LinkedHashMap<TaxonomyNode, TaxonomyNode>();
            for (TaxonomyNode n : others) {
                toBeVisited.put(n, node);
            }
            while (!toBeVisited.isEmpty()) {
                TaxonomyNode relative = (TaxonomyNode)toBeVisited.keySet().iterator().next();
                TaxonomyNode reachedFrom = (TaxonomyNode)toBeVisited.get(relative);
                Boolean ancestorMark = relative.mark;
                if (ancestorMark == Boolean.FALSE) {
                    TaxonomyNode n = reachedFrom;
                    while (n != null) {
                        this.mark(n, Boolean.FALSE, (byte)0);
                        n = (TaxonomyNode)visited.get(n);
                    }
                    return false;
                }
                if (ancestorMark == null) {
                    List<TaxonomyNode> moreRelatives = topDown ? relative.getSupers() : relative.getSubs();
                    for (TaxonomyNode n : moreRelatives) {
                        if (visited.keySet().contains(n) || toBeVisited.keySet().contains(n)) continue;
                        toBeVisited.put(n, relative);
                    }
                }
                toBeVisited.remove(relative);
                visited.put(relative, reachedFrom);
            }
        }
        boolean calcdMark = topDown ? this.subsumes(node.getName(), c) : this.subsumes(c, node.getName());
        this.mark(node, calcdMark, (byte)0);
        return calcdMark;
    }

    private boolean subsumes(TaxonomyNode node, ATermAppl c) {
        return this.subCheckWithCache(node, c, true);
    }

    private boolean subsumed(TaxonomyNode node, ATermAppl c) {
        return this.subCheckWithCache(node, c, false);
    }

    private boolean mark(TaxonomyNode node, Boolean value, byte propogate) {
        if (node.getEquivalents().contains(ATermUtils.BOTTOM)) {
            return true;
        }
        if (node.mark != null) {
            if (node.mark != value) {
                throw new RuntimeException("Inconsistent classification result " + node.getName() + " " + node.mark + " " + value);
            }
            return false;
        }
        node.mark = value;
        this.markedNodes.add(node);
        if (propogate != 0) {
            List<TaxonomyNode> others = propogate == 1 ? node.getSupers() : node.getSubs();
            for (TaxonomyNode n : others) {
                this.mark(n, value, propogate);
            }
        }
        return true;
    }

    private boolean subsumes(ATermAppl sup, ATermAppl sub) {
        long time = 0L;
        long count = 0L;
        if (log.isDebugEnabled()) {
            time = System.currentTimeMillis();
            count = this.kb.getABox().satisfiabilityCount;
            log.debug((Object)("Subsumption testing for [" + this.getName(sub) + "," + this.getName(sup) + "]..."));
        }
        Timer t = this.kb.timers.startTimer("classifySub");
        boolean result = this.kb.getABox().isSubClassOf(sub, sup);
        t.stop();
        if (log.isDebugEnabled()) {
            String sign = this.kb.getABox().satisfiabilityCount > count ? "+" : "-";
            time = System.currentTimeMillis() - time;
            log.debug((Object)(" done (" + (result ? "+" : "-") + ") (" + sign + time + "ms)"));
        }
        return result;
    }

    private void mark(Set<ATermAppl> set, Map<ATermAppl, Boolean> marked, Boolean value) {
        for (ATermAppl c : set) {
            marked.put(c, value);
        }
    }

    @Override
    public Taxonomy realize() {
        this.monitor.setProgressTitle("Realizing");
        return PelletOptions.REALIZE_INDIVIDUAL_AT_A_TIME ? this.realizeByIndividuals() : this.realizeByConcepts();
    }

    private Taxonomy realizeByIndividuals() {
        this.monitor.setProgressLength(this.kb.getIndividuals().size());
        this.monitor.taskStarted();
        IndividualIterator i = this.kb.getABox().getIndIterator();
        int count = 0;
        while (i.hasNext()) {
            Individual x = (Individual)i.next();
            this.monitor.incrementProgress();
            if (this.monitor.isCanceled()) {
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(count + ") Realizing " + this.getName(x.getName()) + " "));
            }
            HashMap<ATermAppl, Boolean> marked = new HashMap<ATermAppl, Boolean>();
            ArrayList<ATermAppl> obviousTypes = new ArrayList<ATermAppl>();
            ArrayList<ATermAppl> obviousNonTypes = new ArrayList<ATermAppl>();
            this.kb.getABox().getObviousTypes(x.getName(), obviousTypes, obviousNonTypes);
            for (ATermAppl c : obviousTypes) {
                if (!this.taxonomy.contains(c)) continue;
                this.mark(this.taxonomy.getAllEquivalents(c), marked, Boolean.TRUE);
                this.mark(this.taxonomy.getSupers(c, true, true), marked, Boolean.TRUE);
            }
            for (ATermAppl c : obviousNonTypes) {
                this.mark(this.taxonomy.getAllEquivalents(c), marked, Boolean.FALSE);
                this.mark(this.taxonomy.getSubs(c, true, true), marked, Boolean.FALSE);
            }
            this.realizeByIndividual(x.getName(), ATermUtils.TOP, marked);
            ++count;
        }
        this.monitor.taskFinished();
        return this.taxonomy;
    }

    private boolean realizeByIndividual(ATermAppl n, ATermAppl c, Map marked) {
        boolean isType;
        boolean realized = false;
        if (c.equals(ATermUtils.BOTTOM)) {
            return false;
        }
        if (marked.containsKey(c)) {
            isType = (Boolean)marked.get(c);
        } else {
            long time = 0L;
            long count = 0L;
            if (log.isDebugEnabled()) {
                time = System.currentTimeMillis();
                count = this.kb.getABox().consistencyCount;
                log.debug((Object)("Type checking for [" + this.getName(n) + ", " + this.getName(c) + "]..."));
            }
            Timer t = this.kb.timers.startTimer("classifyType");
            isType = this.kb.isType(n, c);
            t.stop();
            marked.put(c, isType ? Boolean.TRUE : Boolean.FALSE);
            if (log.isDebugEnabled()) {
                String sign = this.kb.getABox().consistencyCount > count ? "+" : "-";
                time = System.currentTimeMillis() - time;
                log.debug((Object)("done (" + (isType ? "+" : "-") + ") (" + sign + time + "ms)"));
            }
        }
        if (isType) {
            TaxonomyNode node = this.taxonomy.getNode(c);
            for (TaxonomyNode sub : node.getSubs()) {
                ATermAppl d = sub.getName();
                realized = this.realizeByIndividual(n, d, marked) || realized;
            }
            if (!realized) {
                this.taxonomy.getNode(c).addInstance(n);
                realized = true;
            }
        }
        return realized;
    }

    private Taxonomy realizeByConcepts() {
        this.monitor.setProgressLength(this.classes.size() + 2);
        this.monitor.taskStarted();
        this.realizeByConcept(ATermUtils.TOP, this.kb.getIndividuals());
        if (this.monitor.isCanceled()) {
            return null;
        }
        this.monitor.taskFinished();
        return this.taxonomy;
    }

    private Set realizeByConcept(ATermAppl c, Collection individuals) {
        if (c.equals(ATermUtils.BOTTOM)) {
            return SetUtils.EMPTY_SET;
        }
        this.monitor.incrementProgress();
        if (this.monitor.isCanceled()) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Realizing concept " + c));
        }
        HashSet<ATermAppl> instances = new HashSet<ATermAppl>(this.kb.retrieve(c, individuals));
        HashSet<ATermAppl> mostSpecificInstances = new HashSet<ATermAppl>(instances);
        if (!instances.isEmpty()) {
            TaxonomyNode node = this.taxonomy.getNode(c);
            for (TaxonomyNode sub : node.getSubs()) {
                ATermAppl d = sub.getName();
                Set subInstances = this.realizeByConcept(d, instances);
                mostSpecificInstances.removeAll(subInstances);
            }
            if (!mostSpecificInstances.isEmpty()) {
                node.setInstances(mostSpecificInstances);
            }
        }
        return instances;
    }

    public void printStats() {
        int numClasses = this.classes.size();
        System.out.println("Num of Classes: " + numClasses + " Pairs: " + numClasses * numClasses + " Subsumption Count: " + this.kb.getABox().satisfiabilityCount);
    }

    private String getName(ATermAppl c) {
        if (c.equals(ATermUtils.TOP)) {
            return "owl:Thing";
        }
        if (c.equals(ATermUtils.BOTTOM)) {
            return "owl:Nothing";
        }
        if (ATermUtils.isPrimitive(c)) {
            return URIUtils.getLocalName(c.getName());
        }
        return c.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConceptFlag {
        COMPLETELY_DEFINED,
        PRIMITIVE,
        NONPRIMITIVE,
        NONPRIMITIVE_TA,
        OTHER;

    }
}

