/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.inctest;

import aterm.ATermAppl;
import com.hp.hpl.jena.rdf.model.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.test.utils.TestUtils;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public class IncConsistencyTestUnitTest {
    static double ITERS = 50.0;
    static boolean USE_REG_REASONER = true;
    static String[] DEFAULT_FILES = new String[]{"OUBM", "http://www.mindswap.org/~chris/tmp/univ-bench-lite-3dept.owl"};

    public static void main(String[] args) throws Exception {
        String[] files = DEFAULT_FILES;
        boolean formatHTML = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-html")) {
                formatHTML = true;
                continue;
            }
            System.err.println("Unknown option " + args[i]);
        }
        for (int k = 0; k < 1; ++k) {
            List<String> cols = Arrays.asList("Name", "OWL Species", "DL Expressivity", "Triples", "Classes", "Properties", "Individuals", "Loading", "Initial Consistency", "Avg. Reg. Consistency", "Avg. Inc Consistency", "Total");
            TableData table = new TableData(cols);
            for (int i = 0; i < files.length; i += 2) {
                try {
                    String name = files[i];
                    String file = files[i + 1];
                    System.out.println("\nStarting test: " + file);
                    ArrayList<Object> list = new ArrayList<Object>();
                    if (formatHTML) {
                        list.add("<a href=\"" + file + "\">" + name + "</a>");
                    } else {
                        list.add(name);
                    }
                    System.gc();
                    System.gc();
                    System.gc();
                    ModelReader reader = new ModelReader();
                    Model model = reader.read(file);
                    Timer t = new Timer("timer");
                    System.out.println("  Loading reasoner");
                    OWLReasoner reasoner = new OWLReasoner();
                    t.start();
                    reasoner.load(model);
                    PelletOptions.USE_INCREMENTAL_CONSISTENCY = false;
                    PelletOptions.USE_COMPLETION_QUEUE = true;
                    if (USE_REG_REASONER) {
                        reasoner.isConsistent();
                    }
                    t.stop();
                    long iCons = reasoner.getKB().timers.getTimer("consistency").getTotal();
                    reasoner.getKB().timers.getTimer("consistency").reset();
                    System.out.println("  Loading incremental reasoner");
                    reader = new ModelReader();
                    Model incModel = reader.read(file);
                    OWLReasoner incReasoner = new OWLReasoner();
                    incReasoner.load(incModel);
                    PelletOptions.USE_INCREMENTAL_CONSISTENCY = false;
                    PelletOptions.USE_COMPLETION_QUEUE = true;
                    incReasoner.isConsistent();
                    incReasoner.getKB().timers.getTimer("consistency").reset();
                    boolean err = false;
                    long total = 0L;
                    long largest = 0L;
                    long incTotal = 0L;
                    long incLargest = 0L;
                    boolean isIncCon = true;
                    boolean isCon = true;
                    ATermAppl ind1 = null;
                    ATermAppl ind2 = null;
                    ATermAppl clazz = null;
                    ATermAppl prop = null;
                    System.out.println("  Starting test...");
                    int j = 0;
                    while ((double)j < ITERS) {
                        Random rand = new Random(System.currentTimeMillis());
                        boolean type = rand.nextBoolean();
                        if (type) {
                            long cons;
                            clazz = TestUtils.selectRandomConcept(reasoner.getKB());
                            boolean neg = rand.nextBoolean();
                            if (neg) {
                                clazz = ATermUtils.makeNot(clazz);
                            }
                            if (reasoner.getKB().getIndividuals().size() > 10) {
                                ind1 = TestUtils.selectRandomIndividual(reasoner.getKB());
                            } else {
                                ind1 = IncConsistencyTestUnitTest.term("http://www.example#ind" + j);
                                reasoner.getKB().addIndividual(ind1);
                                incReasoner.getKB().addIndividual(ind1);
                            }
                            System.out.println(" Adding type " + clazz + " to node: " + ind1);
                            System.out.println("   Ind existing types " + incReasoner.getKB().getABox().getIndividual(ind1).getTypes());
                            System.out.println("Reg test");
                            reasoner.getKB().timers.getTimer("consistency").reset();
                            reasoner.getKB().addType(ind1, clazz);
                            PelletOptions.USE_INCREMENTAL_CONSISTENCY = false;
                            if (USE_REG_REASONER) {
                                isCon = reasoner.isConsistent();
                            }
                            if ((cons = reasoner.getKB().timers.getTimer("consistency").getTotal()) > largest) {
                                largest = cons;
                            }
                            total += cons;
                            System.out.println("Reg: " + cons);
                            System.out.println("Inc. test");
                            incReasoner.getKB().timers.getTimer("consistency").reset();
                            PelletOptions.USE_INCREMENTAL_CONSISTENCY = true;
                            incReasoner.getKB().addType(ind1, clazz);
                            isIncCon = incReasoner.isConsistent();
                            long incCons = incReasoner.getKB().timers.getTimer("consistency").getTotal();
                            if (incCons > incLargest) {
                                incLargest = incCons;
                            }
                            incTotal += incCons;
                            System.out.println("  Inc: " + incCons);
                            if (isCon != isIncCon && USE_REG_REASONER) {
                                System.out.println("Normal consistency check: " + isCon + "   Inc. consistency check: " + isIncCon);
                                break;
                            }
                        } else {
                            long cons;
                            prop = TestUtils.selectRandomObjectProperty(reasoner.getKB());
                            if (reasoner.getKB().getIndividuals().size() > 10) {
                                ind1 = TestUtils.selectRandomIndividual(reasoner.getKB());
                                ind2 = TestUtils.selectRandomIndividual(reasoner.getKB());
                            } else {
                                ind1 = IncConsistencyTestUnitTest.term("http://www.example#ind" + j);
                                ind2 = IncConsistencyTestUnitTest.term("http://www.example#indb" + j);
                                reasoner.getKB().addIndividual(ind1);
                                incReasoner.getKB().addIndividual(ind1);
                                reasoner.getKB().addIndividual(ind2);
                                incReasoner.getKB().addIndividual(ind2);
                            }
                            System.out.println(" Adding role " + prop + " to nodes: " + ind1 + ", " + ind2);
                            System.out.println("   Subject existing types " + incReasoner.getKB().getABox().getIndividual(ind1).getTypes());
                            System.out.println("   Object existing types " + incReasoner.getKB().getABox().getIndividual(ind2).getTypes());
                            System.out.println("Reg test");
                            PelletOptions.USE_INCREMENTAL_CONSISTENCY = false;
                            reasoner.getKB().timers.getTimer("consistency").reset();
                            reasoner.getKB().addPropertyValue(prop, ind1, ind2);
                            if (USE_REG_REASONER) {
                                isCon = reasoner.isConsistent();
                            }
                            if ((cons = reasoner.getKB().timers.getTimer("consistency").getTotal()) > largest) {
                                largest = cons;
                            }
                            total += cons;
                            System.out.println("RegR: " + cons);
                            System.out.println("Inc. test");
                            incReasoner.getKB().timers.getTimer("consistency").reset();
                            PelletOptions.USE_INCREMENTAL_CONSISTENCY = true;
                            incReasoner.getKB().addPropertyValue(prop, ind1, ind2);
                            isIncCon = incReasoner.isConsistent();
                            long incCons = incReasoner.getKB().timers.getTimer("consistency").getTotal();
                            if (incCons > incLargest) {
                                incLargest = incCons;
                            }
                            incTotal += incCons;
                            System.out.println("  IncR: " + incCons);
                            if (isCon != isIncCon && USE_REG_REASONER) {
                                System.out.println("Normal consistency check: " + isCon + "   Inc. consistency check: " + isIncCon);
                                break;
                            }
                        }
                        System.out.print(".");
                        ++j;
                    }
                    double avg = (double)total / ITERS;
                    double incAvg = (double)incTotal / ITERS;
                    list.add(reasoner.getSpecies().toString());
                    list.add(reasoner.getKB().getExpressivity());
                    list.add(new Long(model.size()));
                    KnowledgeBase kb = reasoner.getKB();
                    list.add(new Long(kb.getClasses().size()));
                    list.add(new Long(kb.getProperties().size()));
                    list.add(new Long(kb.getIndividuals().size()));
                    t.start();
                    t.stop();
                    Timers timers = reasoner.getKB().timers;
                    list.add(new Double((double)(timers.getTimer("Loading").getTotal() + timers.getTimer("preprocessing").getTotal()) / 1000.0));
                    list.add(new Double((double)iCons / 1000.0));
                    list.add(new Double(avg / 1000.0));
                    list.add(new Double(incAvg / 1000.0));
                    list.add(new Double((double)t.getTotal() / 1000.0));
                    table.add(list);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            System.out.println();
            table.print(System.out, formatHTML);
        }
    }

    public static ATermAppl term(String s) {
        return ATermUtils.makeTermAppl(s);
    }
}

