/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.core.ontology;

import ch.uzh.ifi.attempto.acewiki.core.ontology.Concept;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Ontology;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.ape.Gender;
import ch.uzh.ifi.attempto.ape.LexiconEntry;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Individual
extends OntologyElement {
    private String word = "";
    private String abbrev = null;
    private boolean wordDefArt = false;
    private boolean abbrevDefArt = false;
    private List<Concept> conceptsCache;
    private long conceptsCacheStateID = -1L;

    @Override
    public String[] getWords() {
        if (this.abbrev == null) {
            if (this.wordDefArt) {
                return new String[]{"the " + this.word, this.word, "the " + this.word, this.word};
            }
            return new String[]{this.word, this.word, this.word, this.word};
        }
        if (this.wordDefArt) {
            if (this.abbrevDefArt) {
                return new String[]{"the " + this.word, this.word, "the " + this.abbrev, this.abbrev};
            }
            return new String[]{"the " + this.word, this.word, this.abbrev, this.abbrev};
        }
        if (this.abbrevDefArt) {
            return new String[]{this.word, this.word, "the " + this.abbrev, this.abbrev};
        }
        return new String[]{this.word, this.word, this.abbrev, this.abbrev};
    }

    @Override
    public String getHeadword() {
        if (this.abbrev == null) {
            return this.getPrettyWord(1);
        }
        return this.getPrettyWord(1) + " (" + this.getPrettyWord(3) + ")";
    }

    @Override
    public String[] getIndexEntries() {
        return new String[]{this.getHeadword(), this.getPrettyWord(3)};
    }

    @Override
    protected void changeWords(String ... stringArray) {
        if (stringArray.length == 1) {
            this.word = stringArray[0];
            this.wordDefArt = false;
            this.abbrev = null;
            this.abbrevDefArt = false;
        } else if (stringArray.length == 2) {
            this.word = stringArray[1];
            this.wordDefArt = stringArray[0].startsWith("the ");
            this.abbrev = null;
            this.abbrevDefArt = false;
        } else if (stringArray[2] == null || stringArray[0].equals(stringArray[2])) {
            this.word = stringArray[1];
            this.wordDefArt = stringArray[0].startsWith("the ");
            this.abbrev = null;
            this.abbrevDefArt = false;
        } else {
            this.word = stringArray[1];
            this.wordDefArt = stringArray[0].startsWith("the ");
            this.abbrev = stringArray[3];
            this.abbrevDefArt = stringArray[2].startsWith("the ");
        }
    }

    @Override
    List<LexiconEntry> getLexiconEntries() {
        ArrayList<LexiconEntry> arrayList = new ArrayList<LexiconEntry>();
        if (this.wordDefArt) {
            arrayList.add(LexiconEntry.createPropernameDefSgEntry((String)this.word, (String)this.word, (Gender)Gender.NEUTRAL));
        } else {
            arrayList.add(LexiconEntry.createPropernameSgEntry((String)this.word, (String)this.word, (Gender)Gender.NEUTRAL));
        }
        if (this.abbrev != null) {
            if (this.abbrevDefArt) {
                arrayList.add(LexiconEntry.createPropernameDefSgEntry((String)this.abbrev, (String)this.word, (Gender)Gender.NEUTRAL));
            } else {
                arrayList.add(LexiconEntry.createPropernameSgEntry((String)this.abbrev, (String)this.word, (Gender)Gender.NEUTRAL));
            }
        }
        return arrayList;
    }

    @Override
    public String getType() {
        return "Proper Name";
    }

    @Override
    public String getInternalType() {
        return "propername";
    }

    public boolean hasDefiniteArticle() {
        return this.wordDefArt;
    }

    public boolean hasDefiniteArticle(int n) {
        if (n == 0) {
            return this.wordDefArt;
        }
        if (n == 2) {
            return this.abbrevDefArt;
        }
        return false;
    }

    public String getAbbreviation() {
        if (this.abbrev == null) {
            return null;
        }
        return this.abbrev.replace("_", " ");
    }

    @Override
    public String getURISuffix() {
        return "#" + this.word;
    }

    public synchronized List<Concept> getConcepts() {
        Ontology ontology = this.getOntology();
        if (this.conceptsCacheStateID != ontology.getStateID()) {
            this.conceptsCache = ontology.getConcepts(this);
            this.conceptsCacheStateID = ontology.getStateID();
        }
        return new ArrayList<Concept>(this.conceptsCache);
    }

    public boolean areConceptsCached() {
        return this.conceptsCacheStateID == this.getOntology().getStateID();
    }
}

