/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.core.ontology;

import ch.uzh.ifi.attempto.acewiki.core.ontology.Individual;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Ontology;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.core.text.OntologyTextElement;
import ch.uzh.ifi.attempto.acewiki.core.text.TextElemFactory;
import ch.uzh.ifi.attempto.ape.ACEParserResult;
import ch.uzh.ifi.attempto.ape.APELocal;
import ch.uzh.ifi.attempto.ape.Lexicon;
import ch.uzh.ifi.attempto.ape.LexiconEntry;
import ch.uzh.ifi.attempto.ape.MessageContainer;
import ch.uzh.ifi.attempto.ape.OutputType;
import ch.uzh.ifi.attempto.preditor.text.BasicTextElement;
import ch.uzh.ifi.attempto.preditor.text.TextContainer;
import ch.uzh.ifi.attempto.preditor.text.TextElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sentence {
    private String text;
    private Ontology ontology;
    private OntologyElement owner;
    private boolean integrated = false;
    private TextContainer textContainer;
    private ACEParserResult parserResult;
    private String owlxml;
    private Boolean reasonerParticipant;
    private Boolean isOWL;
    private Boolean isOWLSWRL;
    private OWLOntology owlOntology;
    private List<Individual> answerCache;
    private long answerCacheStateID = -1L;

    public Sentence(String string, OntologyElement ontologyElement) {
        this.ontology = null;
        this.owner = ontologyElement;
        this.setText(string);
    }

    public Sentence(String string, Ontology ontology) {
        this.ontology = ontology;
        this.owner = null;
        this.setText(string);
    }

    public static List<Sentence> generateSentences(TextContainer textContainer, OntologyElement ontologyElement) {
        ArrayList<Sentence> arrayList = new ArrayList<Sentence>();
        TextContainer textContainer2 = new TextContainer();
        for (TextElement textElement : textContainer.getTextElements()) {
            textContainer2.addElement(textElement);
            if (!textElement.getText().matches("[.?]")) continue;
            arrayList.add(new Sentence(Sentence.getUnderscoredText(textContainer2), ontologyElement));
            textContainer2 = new TextContainer();
        }
        return arrayList;
    }

    static Sentence loadSentence(String string, OntologyElement ontologyElement) {
        Sentence sentence = new Sentence(string.substring(2), ontologyElement);
        sentence.setIntegrated(string.charAt(0) == '|');
        return sentence;
    }

    private Ontology getOntology() {
        if (this.ontology == null) {
            this.ontology = this.owner.getOntology();
        }
        return this.ontology;
    }

    public List<TextElement> getTextElements() {
        if (this.textContainer == null) {
            this.tokenize();
        }
        this.textContainer.updateConnections();
        return this.textContainer.getTextElements();
    }

    public OntologyElement getOwner() {
        return this.owner;
    }

    private void setText(String string) {
        this.text = string.replaceFirst("\\s+$", "");
    }

    public String getText() {
        if (this.textContainer == null) {
            this.tokenize();
        }
        return Sentence.getUnderscoredText(this.textContainer);
    }

    public String getPrettyText() {
        return this.textContainer.getText();
    }

    public ACEParserResult getParserResult() {
        if (this.parserResult == null) {
            this.parse();
        }
        return this.parserResult;
    }

    public String getOWLXML() {
        if (this.owlxml == null) {
            this.parse();
        }
        return this.owlxml;
    }

    public boolean isReasonerParticipant() {
        if (this.reasonerParticipant == null) {
            this.parse();
        }
        return this.reasonerParticipant;
    }

    public boolean isOWL() {
        if (this.isOWL == null) {
            this.parse();
        }
        return this.isOWL;
    }

    public boolean isOWLSWRL() {
        if (this.isOWLSWRL == null) {
            this.parse();
        }
        return this.isOWLSWRL;
    }

    public OWLOntology getOWLOntology() {
        if (this.owlxml == null) {
            this.parse();
        }
        return this.owlOntology;
    }

    private void tokenize() {
        this.textContainer = new TextContainer();
        String string = "&" + this.text + "&";
        string = string.replaceAll(" ", "&");
        string = string.replaceAll("\\.", "&.&");
        string = string.replaceAll("\\?", "&?&");
        string = string.replaceAll("&of&", " of&");
        string = string.replaceAll("&by&", " by&");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string.split("&")));
        while (arrayList.contains("")) {
            arrayList.remove("");
        }
        this.toString();
        for (String string2 : arrayList) {
            String string3;
            Individual individual;
            Object object;
            if (string2.startsWith("<")) {
                try {
                    long l = new Long(string2.substring(1, string2.indexOf(",")));
                    int n = new Integer(string2.substring(string2.indexOf(",") + 1, string2.indexOf(">")));
                    OntologyElement ontologyElement = this.getOntology().get(l);
                    object = TextElemFactory.createTextElement(ontologyElement, n);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Could not resolve link: " + string2, exception);
                }
                if (object != null) {
                    this.textContainer.addElement((TextElement)object);
                    continue;
                }
                throw new RuntimeException("Could not resolve link: " + string2);
            }
            object = this.getOntology().get(string2);
            if (object == null) {
                this.textContainer.addElement((TextElement)new BasicTextElement(string2));
                continue;
            }
            int n = Arrays.asList(((OntologyElement)object).getWords()).indexOf(string2);
            if (object instanceof Individual && (individual = (Individual)object).hasDefiniteArticle(n - 1) && this.textContainer.getTextElementsCount() > 0 && ((string3 = this.textContainer.getTextElement(this.textContainer.getTextElementsCount() - 1).getText()).equals("the") || string3.equals("The"))) {
                this.textContainer.removeLastElement();
                --n;
            }
            this.textContainer.addElement((TextElement)TextElemFactory.createTextElement((OntologyElement)object, n));
        }
    }

    synchronized void parse() {
        String string;
        APELocal.getInstance().setURI(this.getOntology().getURI());
        APELocal.getInstance().setClexEnabled(false);
        Lexicon lexicon = new Lexicon();
        for (TextElement textElement : this.getTextElements()) {
            if (!(textElement instanceof OntologyTextElement)) continue;
            OntologyElement ontologyElement = ((OntologyTextElement)textElement).getOntologyElement();
            for (LexiconEntry lexiconEntry : ontologyElement.getLexiconEntries()) {
                lexicon.addEntry(lexiconEntry);
            }
        }
        this.parserResult = APELocal.getInstance().getMultiOutput(this.getText(), lexicon, new OutputType[]{OutputType.PARAPHRASE1, OutputType.SYNTAX, OutputType.SYNTAXPP, OutputType.OWLXML, OutputType.OWLRDF, OutputType.DRSPP});
        MessageContainer messageContainer = this.parserResult.getMessageContainer();
        this.owlxml = this.parserResult.get(OutputType.OWLXML);
        if (this.owlxml != null) {
            long l = (long)this.getText().hashCode() - Integer.MIN_VALUE;
            this.owlxml = this.owlxml.replace("URI=\"" + this.ontology.getURI() + "\">", "URI=\"" + this.ontology.getURI() + "/" + l + "\">");
        }
        this.reasonerParticipant = messageContainer.getMessages("owl").size() == 0 && this.owlxml.indexOf("<swrl:Imp>") < 0 && this.owlxml.indexOf("<ObjectExistsSelf>") < 0 && this.owlxml.indexOf("<TransitiveObjectProperty>") < 0 && this.owlxml.indexOf("<SubObjectPropertyChain>") < 0 && this.owlxml.length() > 0;
        this.isOWL = messageContainer.getMessages("owl").size() == 0 && this.owlxml.indexOf("<swrl:Imp>") < 0 && this.owlxml.length() > 0;
        this.isOWLSWRL = messageContainer.getMessages("owl").size() == 0 && this.owlxml.length() > 0;
        this.owlOntology = null;
        if (this.isOWL.booleanValue()) {
            try {
                this.owlOntology = this.getOntology().readOWLOntology(this.owlxml);
                if (this.owlOntology.isEmpty()) {
                    this.reasonerParticipant = false;
                    this.isOWL = false;
                    this.isOWLSWRL = false;
                }
            }
            catch (OWLOntologyCreationException oWLOntologyCreationException) {
                oWLOntologyCreationException.printStackTrace();
            }
        }
        if (this.isQuestion()) {
            this.reasonerParticipant = false;
        }
        if ((string = messageContainer.toString()).length() > 0) {
            System.err.println("Parser messages: " + string);
        }
    }

    public int reassert() {
        int n = this.getOntology().commitSentence(this);
        this.getOntology().save(this.owner);
        return n;
    }

    public boolean isIntegrated() {
        return this.integrated;
    }

    void setIntegrated(boolean bl) {
        this.integrated = bl;
    }

    public boolean isQuestion() {
        return this.text.substring(this.text.length() - 1).equals("?");
    }

    public boolean isInferred() {
        return this.owner == null;
    }

    public boolean contains(OntologyElement ontologyElement, int n) {
        if (this.textContainer == null) {
            this.tokenize();
        }
        for (TextElement textElement : this.textContainer.getTextElements()) {
            if (!(textElement instanceof OntologyTextElement)) continue;
            OntologyTextElement ontologyTextElement = (OntologyTextElement)textElement;
            if (ontologyElement == ontologyTextElement.getOntologyElement() && n == -1) {
                return true;
            }
            if (ontologyElement != ontologyTextElement.getOntologyElement() || n != ontologyTextElement.getWordNumber()) continue;
            return true;
        }
        return false;
    }

    public boolean contains(OntologyElement ontologyElement) {
        return this.contains(ontologyElement, -1);
    }

    public synchronized List<Individual> getAnswer() {
        if (!this.isQuestion()) {
            return null;
        }
        Ontology ontology = this.getOntology();
        if (this.answerCacheStateID != ontology.getStateID()) {
            this.answerCache = ontology.getAnswer(this);
            this.answerCacheStateID = ontology.getStateID();
        }
        if (this.answerCache == null) {
            return null;
        }
        return new ArrayList<Individual>(this.answerCache);
    }

    public boolean isAnswerCached() {
        if (!this.isQuestion()) {
            return false;
        }
        return this.answerCacheStateID == this.getOntology().getStateID();
    }

    private static String getUnderscoredText(TextContainer textContainer) {
        String string = "";
        for (TextElement textElement : textContainer.getTextElements()) {
            if (textElement instanceof OntologyTextElement) {
                string = string + " " + ((OntologyTextElement)textElement).getUnderscoredText();
                continue;
            }
            if (textElement.getText().matches("[.?]")) {
                string = string + textElement.getText();
                continue;
            }
            string = string + " " + textElement.getText();
        }
        if (string.length() > 0) {
            string = string.substring(1);
        }
        return string;
    }

    String serialize() {
        if (this.textContainer == null) {
            this.tokenize();
        }
        String string = this.integrated ? "|" : "#";
        for (TextElement textElement : this.textContainer.getTextElements()) {
            if (textElement instanceof OntologyTextElement) {
                OntologyTextElement ontologyTextElement = (OntologyTextElement)textElement;
                string = string + " <" + ontologyTextElement.getOntologyElement().getId() + "," + ontologyTextElement.getWordNumber() + ">";
                continue;
            }
            string = string + " " + textElement.getText();
        }
        return string + "\n";
    }

    public String toString() {
        return this.getText();
    }
}

