/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.editor;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.core.text.OntologyTextElement;
import ch.uzh.ifi.attempto.acewiki.core.text.TextElemFactory;
import ch.uzh.ifi.attempto.echocomp.GeneralButton;
import ch.uzh.ifi.attempto.echocomp.Label;
import ch.uzh.ifi.attempto.echocomp.MessageWindow;
import ch.uzh.ifi.attempto.echocomp.SolidLabel;
import ch.uzh.ifi.attempto.echocomp.TextField;
import ch.uzh.ifi.attempto.echocomp.WindowPane;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ContentPane;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nextapp.echo2.app.layout.GridLayoutData;

public abstract class FormPane
extends ContentPane
implements ActionListener {
    private Wiki wiki;
    private ActionListener actionListener;
    private Column column;
    private WindowPane window;
    private Grid iconRow;
    private GeneralButton okButton;
    private GeneralButton cancelButton;

    protected FormPane(WindowPane windowPane, Wiki wiki, ActionListener actionListener) {
        this.window = windowPane;
        this.wiki = wiki;
        this.actionListener = actionListener;
        Grid grid = new Grid(1);
        grid.setRowHeight(0, new Extent(330));
        grid.setRowHeight(1, new Extent(30));
        this.column = new Column();
        this.column.setInsets(new Insets(10, 20, 0, 0));
        this.column.setCellSpacing(new Extent(10));
        GridLayoutData gridLayoutData = new GridLayoutData();
        gridLayoutData.setAlignment(new Alignment(3, 6));
        this.column.setLayoutData((LayoutData)gridLayoutData);
        grid.add((Component)this.column);
        this.iconRow = new Grid(2);
        this.iconRow.setRowHeight(0, new Extent(110));
        this.iconRow.setColumnWidth(0, new Extent(100));
        this.iconRow.setInsets(new Insets(0, 0, 10, 20));
        this.column.add((Component)this.iconRow);
        Row row = new Row();
        row.setInsets(new Insets(10, 0, 0, 0));
        row.add((Component)new Label("* required field", 2, 11));
        grid.add((Component)row);
        Row row2 = new Row();
        row2.setAlignment(new Alignment(5, 4));
        row2.setInsets(new Insets(10, 10, 10, 10));
        row2.setCellSpacing(new Extent(5));
        this.okButton = new GeneralButton("OK", 70, (ActionListener)this);
        row2.add((Component)this.okButton);
        this.cancelButton = new GeneralButton("Cancel", 70, (ActionListener)this);
        row2.add((Component)this.cancelButton);
        grid.add((Component)row2);
        this.add((Component)grid);
    }

    protected Wiki getWiki() {
        return this.wiki;
    }

    protected abstract void save();

    protected void finished(OntologyElement ontologyElement) {
        this.finished(ontologyElement, 0);
    }

    protected void finished(OntologyElement ontologyElement, int n) {
        this.window.setVisible(false);
        this.dispose();
        OntologyTextElement ontologyTextElement = TextElemFactory.createTextElement(ontologyElement, n);
        this.actionListener.actionPerformed(new ActionEvent((Object)ontologyTextElement, ""));
    }

    protected void addRow(String string, Component component, String string2, boolean bl) {
        Grid grid = new Grid(3);
        grid.setInsets(new Insets(0, 0, 5, 0));
        grid.setColumnWidth(0, new Extent(140));
        grid.add((Component)new SolidLabel(string, 2));
        if (component instanceof TextField) {
            ((TextField)component).setWidth(new Extent(530));
        }
        grid.add(component);
        if (bl) {
            grid.add((Component)new Label("*", 2, 11));
        } else {
            grid.add((Component)new Label());
        }
        grid.add((Component)new Label());
        grid.add((Component)new Label(string2, 2, 11));
        this.column.add((Component)grid);
    }

    protected void setIconRow(String string, String string2) {
        this.iconRow.removeAll();
        this.iconRow.add((Component)new Label((ImageReference)new ResourceImageReference("ch/uzh/ifi/attempto/acewiki/gui/img/" + string + ".png")));
        this.iconRow.add((Component)new Label(string2, 2));
    }

    protected void showErrorMessage(String string) {
        this.wiki.showWindow((WindowPane)new MessageWindow("Error", string, this.window, new String[]{"OK"}));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton) {
            this.window.setVisible(false);
            this.dispose();
        } else {
            this.save();
        }
    }

    protected static String normalize(String string) {
        return string.replaceAll("\\s", "_").replaceAll("(_)+", "_").replaceAll("^_", "").replaceAll("_$", "");
    }

    protected static boolean isValidString(String string) {
        if (string.length() == 0) {
            return true;
        }
        boolean bl = true;
        for (byte by : string.getBytes()) {
            if (bl) {
                bl = false;
                if (by >= 97 && by <= 122 || by >= 65 && by <= 90) continue;
                return false;
            }
            if (by >= 97 && by <= 122 || by >= 65 && by <= 90 || by >= 48 && by <= 57 || by == 45 || by == 95) continue;
            return false;
        }
        return true;
    }
}

