/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.editor;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Individual;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.gui.editor.FormPane;
import ch.uzh.ifi.attempto.acewiki.gui.editor.WordEditorWindow;
import ch.uzh.ifi.attempto.ape.FunctionWords;
import ch.uzh.ifi.attempto.echocomp.CheckBox;
import ch.uzh.ifi.attempto.echocomp.TextField;
import ch.uzh.ifi.attempto.echocomp.WindowPane;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionListener;

public class ProperNameForm
extends FormPane {
    private static final long serialVersionUID = 7860047859937196093L;
    private TextField nameField = new TextField((ActionListener)this);
    private CheckBox nameDefArtCheckBox = new CheckBox();
    private TextField abbrevField = new TextField((ActionListener)this);
    private CheckBox abbrevDefArtCheckBox = new CheckBox();
    private Individual ind;

    public ProperNameForm(Individual individual, WindowPane windowPane, Wiki wiki, ActionListener actionListener) {
        super(windowPane, wiki, actionListener);
        this.ind = individual;
        this.setIconRow("individual", "Every proper name represents a certain individual. The country \"Switzerland\", the person \"Bob Dylan\", the river \"Nile\", and the organization \"United Nations\" are typical examples. Some proper names are used with \"the\" (\"the Nile\", \"the United Nations\") and others are not (\"Switzerland\", \"Bob Dylan\"). Proper names can have an abbreviation that has the same meaning as the longer proper name.");
        this.addRow("proper name", (Component)this.nameField, "examples: Switzerland, Bob Dylan, Nile, United Nations", true);
        this.addRow("... used with \"the\"", (Component)this.nameDefArtCheckBox, "examples: the Nile, the United Nations", false);
        this.addRow("abbreviation", (Component)this.abbrevField, "examples: CH, UN", false);
        this.addRow("... used with \"the\"", (Component)this.abbrevDefArtCheckBox, "example: the UN", false);
        this.nameField.setText(individual.getPrettyWord(1));
        this.nameDefArtCheckBox.setSelected(individual.hasDefiniteArticle(0));
        this.abbrevField.setText(individual.getAbbreviation());
        this.abbrevDefArtCheckBox.setSelected(individual.hasDefiniteArticle(2));
        ApplicationInstance.getActive().setFocusedComponent((Component)this.nameField);
    }

    public static WordEditorWindow createCreatorWindow(Wiki wiki, ActionListener actionListener) {
        WordEditorWindow wordEditorWindow = WordEditorWindow.createCreatorWindow();
        wordEditorWindow.addTab(new ProperNameForm(new Individual(), wordEditorWindow, wiki, actionListener));
        return wordEditorWindow;
    }

    public static WordEditorWindow createEditorWindow(Individual individual, Wiki wiki) {
        WordEditorWindow wordEditorWindow = WordEditorWindow.createEditorWindow();
        wordEditorWindow.addTab(new ProperNameForm(individual, wordEditorWindow, wiki, wiki));
        return wordEditorWindow;
    }

    protected void save() {
        Wiki wiki = this.getWiki();
        String string = ProperNameForm.normalize(this.nameField.getText());
        String string2 = ProperNameForm.normalize(this.abbrevField.getText());
        boolean bl = this.nameDefArtCheckBox.isSelected();
        boolean bl2 = this.abbrevDefArtCheckBox.isSelected();
        if (string.toLowerCase().startsWith("the_")) {
            string = string.substring(4);
            bl = true;
        }
        if (string2.toLowerCase().startsWith("the_")) {
            string2 = string2.substring(4);
            bl2 = true;
        }
        String string3 = string.replace("_", " ");
        String string4 = string2.replace("_", " ");
        if (string.equals("")) {
            wiki.log("edit", "error: no word defined");
            this.showErrorMessage("No proper name defined: Please specify a name.");
            return;
        }
        if (!ProperNameForm.isValidString(string) || !ProperNameForm.isValidString(string2)) {
            wiki.log("edit", "error: word contains invalid character");
            this.showErrorMessage("Invalid character: Only a-z, A-Z, 0-9, -, and spaces are allowed, and the first character must be one of a-z A-Z.");
            return;
        }
        if (FunctionWords.isFunctionWord((String)string)) {
            wiki.log("edit", "error: word is predefined");
            this.showErrorMessage("'" + string3 + "' is a predefined word and cannot be used here.");
            return;
        }
        if (FunctionWords.isFunctionWord((String)string2)) {
            wiki.log("edit", "error: word is predefined");
            this.showErrorMessage("'" + string4 + "' is a predefined word and cannot be used here.");
            return;
        }
        if (string2.length() >= string.length()) {
            wiki.log("edit", "error: abbreviation is not shorter than the full proper name");
            this.showErrorMessage("The abbreviation has to be shorter than the full proper name.");
            return;
        }
        OntologyElement ontologyElement = wiki.getOntology().get(string);
        if (ontologyElement != null && ontologyElement != this.ind) {
            wiki.log("edit", "error: word is already used");
            this.showErrorMessage("The word '" + string3 + "' is already used. Please use a different one.");
            return;
        }
        ontologyElement = wiki.getOntology().get(string2);
        if (ontologyElement != null && ontologyElement != this.ind) {
            wiki.log("edit", "error: word is already used");
            this.showErrorMessage("The word '" + string4 + "' is already used. Please use a different one.");
            return;
        }
        String string5 = string;
        if (bl) {
            string5 = "the " + string;
        }
        String string6 = string2;
        if (string2.equals("")) {
            string2 = null;
            string6 = null;
        } else if (bl2) {
            string6 = "the " + string2;
        }
        this.ind.setWords(string5, string, string6, string2);
        wiki.log("edit", "proper name: " + string5 + " / " + string6);
        if (this.ind.getOntology() == null) {
            this.ind.registerAt(this.getWiki().getOntology());
        }
        this.finished(this.ind);
    }

    public String toString() {
        return "Proper Name";
    }
}

