/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.editor;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Ontology;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.core.ontology.VerbRole;
import ch.uzh.ifi.attempto.acewiki.gui.editor.FormPane;
import ch.uzh.ifi.attempto.acewiki.gui.editor.WordEditorWindow;
import ch.uzh.ifi.attempto.ape.FunctionWords;
import ch.uzh.ifi.attempto.echocomp.TextField;
import ch.uzh.ifi.attempto.echocomp.WindowPane;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionListener;

public class VerbForm
extends FormPane {
    private static final long serialVersionUID = 5050205540719470842L;
    private TextField thirdSgField = new TextField((ActionListener)this);
    private TextField infField = new TextField((ActionListener)this);
    private TextField pastPartField = new TextField((ActionListener)this);
    private VerbRole verbRole;
    private int wordNumber;

    public VerbForm(VerbRole verbRole, int n, WindowPane windowPane, Wiki wiki, ActionListener actionListener) {
        super(windowPane, wiki, actionListener);
        this.verbRole = verbRole;
        this.wordNumber = n;
        this.setIconRow("role", "Every verb represents a certain relation between things. For example, the verb \"owns\" relates persons to their possessions. Every verb has a third singular form, a bare infinitive form, and an optional past participle form.");
        this.addRow("third singular", (Component)this.thirdSgField, "examples: owns, applies to, touches", true);
        this.addRow("bare infinitive", (Component)this.infField, "examples: own, apply to, touch", true);
        this.addRow("past participle", (Component)this.pastPartField, "examples: owned, applied to, touched", false);
        this.thirdSgField.setText(verbRole.getPrettyWord(0));
        this.infField.setText(verbRole.getPrettyWord(1));
        this.pastPartField.setText(verbRole.getPrettyPastPart());
        ApplicationInstance.getActive().setFocusedComponent((Component)this.thirdSgField);
    }

    public static WordEditorWindow createCreatorWindow(int n, Wiki wiki, ActionListener actionListener) {
        WordEditorWindow wordEditorWindow = WordEditorWindow.createCreatorWindow();
        wordEditorWindow.addTab(new VerbForm(new VerbRole(), n, wordEditorWindow, wiki, actionListener));
        return wordEditorWindow;
    }

    public static WordEditorWindow createEditorWindow(VerbRole verbRole, Wiki wiki) {
        WordEditorWindow wordEditorWindow = WordEditorWindow.createEditorWindow();
        wordEditorWindow.addTab(new VerbForm(verbRole, 0, wordEditorWindow, wiki, wiki));
        return wordEditorWindow;
    }

    protected void save() {
        Wiki wiki = this.getWiki();
        String string = VerbForm.normalize(this.thirdSgField.getText());
        String string2 = VerbForm.normalize(this.infField.getText());
        String string3 = VerbForm.normalize(this.pastPartField.getText());
        if (string3.toLowerCase().endsWith("_by")) {
            string3 = string3.substring(0, string3.length() - 3);
        }
        String string4 = string.replace("_", " ");
        String string5 = string2.replace("_", " ");
        String string6 = string3.replace("_", " ");
        Ontology ontology = wiki.getOntology();
        if (string.equals("")) {
            wiki.log("edit", "error: no third singular defined");
            this.showErrorMessage("No third singular defined: Please define the third singular form.");
            return;
        }
        if (string2.equals("")) {
            wiki.log("edit", "error: no infinitive defined");
            this.showErrorMessage("No bare infinitive defined: Please define the bare infinitive form.");
            return;
        }
        if (string3.equals("") && this.wordNumber == 2) {
            wiki.log("edit", "error: no past participle defined");
            this.showErrorMessage("No past participle defined: Please define the past participle form.");
            return;
        }
        if (string3.equals("") && !ontology.getReferences(this.verbRole, 2).isEmpty()) {
            wiki.log("edit", "error: cannot remove past participle");
            this.showErrorMessage("The past participle form cannot be removed because there are sentences that are using it.");
            return;
        }
        if (!(VerbForm.isValidString(string) && VerbForm.isValidString(string2) && VerbForm.isValidString(string3))) {
            wiki.log("edit", "error: word contains invalid character");
            this.showErrorMessage("Invalid character used: Only a-z, A-Z, 0-9, -, and spaces are allowed, and the first character must be one of a-z A-Z.");
            return;
        }
        if (FunctionWords.isFunctionWord((String)string)) {
            wiki.log("edit", "error: word is predefined");
            this.showErrorMessage("'" + string4 + "' is a predefined word and cannot be used here.");
            return;
        }
        if (FunctionWords.isFunctionWord((String)string2)) {
            wiki.log("edit", "error: word is predefined");
            this.showErrorMessage("'" + string5 + "' is a predefined word and cannot be used here.");
            return;
        }
        if (FunctionWords.isFunctionWord((String)string3)) {
            wiki.log("edit", "error: word is predefined");
            this.showErrorMessage("'" + string6 + "' is a predefined word and cannot be used here.");
            return;
        }
        if (string.equals(string2)) {
            wiki.log("edit", "error: the singular and plural forms have to be distinct.");
            this.showErrorMessage("The singular and plural forms have to be distinct.");
            return;
        }
        OntologyElement ontologyElement = ontology.get(string);
        if (ontologyElement != null && ontologyElement != this.verbRole) {
            wiki.log("edit", "error: word is already used");
            this.showErrorMessage("The word '" + string4 + "' is already used. Please use a different one.");
            return;
        }
        OntologyElement ontologyElement2 = ontology.get(string2);
        if (ontologyElement2 != null && ontologyElement2 != this.verbRole) {
            wiki.log("edit", "error: word is already used");
            this.showErrorMessage("The word '" + string5 + "' is already used. Please use a different one.");
            return;
        }
        OntologyElement ontologyElement3 = ontology.get(string3);
        if (ontologyElement3 != null && ontologyElement3 != this.verbRole) {
            wiki.log("edit", "error: word is already used");
            this.showErrorMessage("The word '" + string6 + "' is already used. Please use a different one.");
            return;
        }
        if (string3.equals("")) {
            string3 = null;
        }
        this.verbRole.setWords(string, string2, string3);
        wiki.log("edit", "verb: " + string + " / " + string2 + " / " + string3);
        if (this.verbRole.getOntology() == null) {
            this.verbRole.registerAt(this.getWiki().getOntology());
        }
        this.finished(this.verbRole, this.wordNumber);
    }

    public String toString() {
        return "Verb";
    }
}

