/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.page;

import ch.uzh.ifi.attempto.acewiki.core.ontology.Concept;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Individual;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Sentence;
import ch.uzh.ifi.attempto.acewiki.gui.IndexBar;
import ch.uzh.ifi.attempto.acewiki.gui.TextRow;
import ch.uzh.ifi.attempto.acewiki.gui.Title;
import ch.uzh.ifi.attempto.acewiki.gui.page.ConceptPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.HierarchyPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.ReferencesPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.WikiPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.WordPage;
import ch.uzh.ifi.attempto.echocomp.DelayedComponent;
import ch.uzh.ifi.attempto.echocomp.Label;
import ch.uzh.ifi.attempto.echocomp.SolidLabel;
import ch.uzh.ifi.attempto.echocomp.VSpace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class IndividualsPage
extends WikiPage
implements ActionListener {
    private static final long serialVersionUID = 4273564259160715684L;
    private static final int pageSize = 20;
    private ConceptPage page;
    private Column individualsColumn = new Column();
    private int chosenPage = 0;

    public IndividualsPage(ConceptPage conceptPage) {
        super(conceptPage.getWiki(), new Title(conceptPage.getOntologyElement().getHeadword(), "- Individuals"));
        this.page = conceptPage;
        this.addTab("Article", this);
        this.addTab("Noun", this);
        this.addTab("References", this);
        this.addSelectedTab("Individuals");
        this.addTab("Hierarchy", this);
        this.add((Component)new VSpace(18));
        this.add((Component)this.individualsColumn);
    }

    protected void doUpdate() {
        this.getTitle().setText(this.page.getOntologyElement().getHeadword());
        this.individualsColumn.removeAll();
        Column column = new Column();
        column.setInsets(new Insets(10, 0, 0, 0));
        column.add((Component)new Label((ImageReference)new ResourceImageReference("ch/uzh/ifi/attempto/acewiki/gui/img/wait.gif")));
        if (((Concept)this.page.getOntologyElement()).areIndividualsCached()) {
            this.individualsColumn.add((Component)new IndividualsComponent());
        } else {
            this.individualsColumn.add((Component)new DelayedComponent((Component)column){
                private static final long serialVersionUID = -992569061632136205L;

                public Component initComponent() {
                    return new IndividualsComponent();
                }
            });
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("Article".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: article");
            this.getWiki().showPage(this.page);
        } else if ("Noun".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: word");
            this.getWiki().showPage(new WordPage(this.page));
        } else if ("References".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: references");
            this.getWiki().showPage(new ReferencesPage(this.page));
        } else if ("Hierarchy".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: hierarchy");
            this.getWiki().showPage(new HierarchyPage(this.page));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof IndividualsPage) {
            return this.page.equals((Object)((IndividualsPage)((Object)object)).page);
        }
        return false;
    }

    public boolean isExpired() {
        return this.page.isExpired();
    }

    public String toString() {
        return "-IND- " + this.page.getOntologyElement().getWord();
    }

    private class IndividualsComponent
    extends Column
    implements ActionListener {
        private static final long serialVersionUID = -2897618204616741456L;
        private Column sentencesColumn = new Column();
        private IndexBar indexBar = new IndexBar("Page:", 0, this);
        private ArrayList<Sentence> sentences;

        public IndividualsComponent() {
            this.add((Component)this.indexBar);
            this.sentencesColumn.setInsets(new Insets(10, 2, 5, 20));
            this.sentencesColumn.setCellSpacing(new Extent(2));
            this.add((Component)this.sentencesColumn);
            Concept concept = (Concept)IndividualsPage.this.page.getOntologyElement();
            List<Individual> list = concept.getIndividuals();
            this.sentences = new ArrayList();
            Comparator<Individual> comparator = new Comparator<Individual>(){

                @Override
                public int compare(Individual individual, Individual individual2) {
                    return individual.getWord(2).compareTo(individual2.getWord(2));
                }
            };
            Collections.sort(list, comparator);
            for (Individual individual : list) {
                this.sentences.add(new Sentence(individual.getWord(2) + " is a " + concept.getWord() + ".", concept.getOntology()));
            }
            if (this.sentences.size() == 0) {
                this.indexBar.setVisible(false);
                this.sentencesColumn.add((Component)new SolidLabel("(no individual found)", 2, 10));
            } else {
                int n = (this.sentences.size() - 1) / 20 + 1;
                if (IndividualsPage.this.chosenPage > n) {
                    IndividualsPage.this.chosenPage = 0;
                }
                this.indexBar.setNumbers(n);
                this.indexBar.setActiveButton(IndividualsPage.this.chosenPage);
                this.updatePage();
            }
        }

        private void updatePage() {
            this.sentencesColumn.removeAll();
            this.indexBar.setVisible(this.sentences.size() > 20);
            int n = this.sentences.size();
            if (n > (IndividualsPage.this.chosenPage + 1) * 20) {
                n = (IndividualsPage.this.chosenPage + 1) * 20;
            }
            for (int i = IndividualsPage.this.chosenPage * 20; i < n; ++i) {
                Row row = new Row();
                row.add((Component)new TextRow(this.sentences.get(i), IndividualsPage.this));
                this.sentencesColumn.add((Component)row);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.indexBar) {
                IndividualsPage.this.chosenPage = Integer.parseInt(actionEvent.getActionCommand()) - 1;
                IndividualsPage.this.log("page", "pressed: page " + (IndividualsPage.this.chosenPage + 1));
                this.updatePage();
            }
        }
    }
}

