/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.page;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.gui.IndexBar;
import ch.uzh.ifi.attempto.acewiki.gui.ListItem;
import ch.uzh.ifi.attempto.acewiki.gui.Title;
import ch.uzh.ifi.attempto.acewiki.gui.WikiLink;
import ch.uzh.ifi.attempto.acewiki.gui.page.WikiPage;
import ch.uzh.ifi.attempto.echocomp.GeneralButton;
import ch.uzh.ifi.attempto.echocomp.SolidLabel;
import ch.uzh.ifi.attempto.echocomp.TextField;
import ch.uzh.ifi.attempto.echocomp.VSpace;
import java.util.ArrayList;
import java.util.Collections;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class SearchPage
extends WikiPage
implements ActionListener {
    private static final long serialVersionUID = 7192145568847087174L;
    private static final int pageSize = 20;
    private int chosenPage = 0;
    private ArrayList<OntologyElement> searchResult;
    private Column resultColumn = new Column();
    private IndexBar indexBar;
    private TextField textField;

    public SearchPage(Wiki wiki, String string) {
        super(wiki, new Title("Search", true));
        this.addTab("Main Page", this);
        this.addTab("Index", this);
        this.addSelectedTab("Search");
        this.add((Component)new VSpace(15));
        this.addHeadline("Search word");
        this.add((Component)new VSpace(10));
        Row row = new Row();
        row.setInsets(new Insets(10, 0));
        row.setCellSpacing(new Extent(5));
        this.textField = new TextField((ActionListener)this);
        row.add((Component)this.textField);
        this.textField.setWidth(new Extent(300));
        this.textField.addActionListener((ActionListener)this);
        this.textField.setText(string);
        row.add((Component)new GeneralButton("Search", (ActionListener)this));
        this.add((Component)row);
        this.add((Component)new VSpace(15));
        this.addHeadline("Results");
        this.add((Component)new VSpace(10));
        this.indexBar = new IndexBar("Page:", 0, this);
        this.add((Component)this.indexBar);
        this.resultColumn.setInsets(new Insets(10, 2, 5, 20));
        this.resultColumn.setCellSpacing(new Extent(2));
        this.add((Component)this.resultColumn);
        this.update();
    }

    protected void doUpdate() {
        ApplicationInstance.getActive().setFocusedComponent((Component)this.textField);
        this.resultColumn.removeAll();
        if (this.textField.getText().length() == 0) {
            this.indexBar.setVisible(false);
            this.resultColumn.add((Component)new SolidLabel("(enter a search text)", 2, 10));
            return;
        }
        ArrayList<OntologyElement> arrayList = new ArrayList<OntologyElement>(this.getWiki().getOntologyElements());
        Collections.sort(arrayList);
        this.searchResult = new ArrayList();
        block0: for (OntologyElement ontologyElement : arrayList) {
            for (String string : ontologyElement.getWords()) {
                if (string == null || !string.toLowerCase().replace("_", " ").contains(this.textField.getText().toLowerCase().replace("_", " "))) continue;
                this.searchResult.add(ontologyElement);
                continue block0;
            }
        }
        if (this.searchResult.size() == 0) {
            this.indexBar.setVisible(false);
            this.resultColumn.add((Component)new SolidLabel("(nothing found)", 2, 10));
        } else {
            int n = (this.searchResult.size() - 1) / 20 + 1;
            if (this.chosenPage > n) {
                this.chosenPage = 0;
            }
            this.indexBar.setNumbers(n);
            this.indexBar.setActiveButton(this.chosenPage);
            this.updatePage();
        }
    }

    private void updatePage() {
        this.resultColumn.removeAll();
        this.indexBar.setVisible(this.searchResult.size() > 20);
        int n = this.searchResult.size();
        if (n > (this.chosenPage + 1) * 20) {
            n = (this.chosenPage + 1) * 20;
        }
        for (int i = this.chosenPage * 20; i < n; ++i) {
            this.resultColumn.add((Component)new ListItem(new Component[]{new WikiLink(this.searchResult.get(i), this.getWiki())}));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.indexBar) {
            this.chosenPage = Integer.parseInt(actionEvent.getActionCommand()) - 1;
            this.log("page", "pressed: page " + (this.chosenPage + 1));
            this.updatePage();
        } else if ("Main Page".equals(actionEvent.getActionCommand())) {
            this.getWiki().showStartPage();
        } else if ("Index".equals(actionEvent.getActionCommand())) {
            this.getWiki().showIndexPage();
        } else {
            this.log("page", "search for " + this.textField.getText());
            this.update();
        }
    }

    public boolean equals(Object object) {
        return object instanceof SearchPage;
    }

    public String toString() {
        return "-SEARCH-";
    }
}

