/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.page;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Individual;
import ch.uzh.ifi.attempto.acewiki.core.ontology.NounConcept;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OfRole;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Sentence;
import ch.uzh.ifi.attempto.acewiki.core.ontology.TrAdjRole;
import ch.uzh.ifi.attempto.acewiki.core.ontology.VerbRole;
import ch.uzh.ifi.attempto.acewiki.gui.Title;
import ch.uzh.ifi.attempto.acewiki.gui.editor.NounForm;
import ch.uzh.ifi.attempto.acewiki.gui.editor.NounOfForm;
import ch.uzh.ifi.attempto.acewiki.gui.editor.ProperNameForm;
import ch.uzh.ifi.attempto.acewiki.gui.editor.TrAdjForm;
import ch.uzh.ifi.attempto.acewiki.gui.editor.VerbForm;
import ch.uzh.ifi.attempto.acewiki.gui.page.ArticlePage;
import ch.uzh.ifi.attempto.acewiki.gui.page.AssignmentsPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.ConceptPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.HierarchyPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.IndividualPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.IndividualsPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.ReferencesPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.WikiPage;
import ch.uzh.ifi.attempto.echocomp.HSpace;
import ch.uzh.ifi.attempto.echocomp.Label;
import ch.uzh.ifi.attempto.echocomp.MessageWindow;
import ch.uzh.ifi.attempto.echocomp.SmallButton;
import ch.uzh.ifi.attempto.echocomp.SolidLabel;
import ch.uzh.ifi.attempto.echocomp.VSpace;
import ch.uzh.ifi.attempto.echocomp.WindowPane;
import java.util.List;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class WordPage
extends WikiPage
implements ActionListener {
    private static final long serialVersionUID = 5800290686564822519L;
    private ArticlePage page;
    private SmallButton editButton = new SmallButton("edit...", (ActionListener)this);
    private SmallButton delButton = new SmallButton("delete...", (ActionListener)this);
    private Column textColumn = new Column();

    public WordPage(ArticlePage articlePage) {
        super(articlePage.getWiki(), new Title(articlePage.getOntologyElement().getHeadword(), "- " + articlePage.getOntologyElement().getType()));
        this.page = articlePage;
        this.addTab("Article", this);
        this.addSelectedTab(articlePage.getOntologyElement().getType());
        this.addTab("References", this);
        if (articlePage instanceof ConceptPage) {
            this.addTab("Individuals", this);
            this.addTab("Hierarchy", this);
        }
        if (articlePage instanceof IndividualPage) {
            this.addTab("Assignments", this);
        }
        this.add((Component)new VSpace(10));
        this.textColumn.setInsets(new Insets(10, 10, 5, 20));
        this.textColumn.setCellSpacing(new Extent(5));
        this.add((Component)this.textColumn);
    }

    protected void doUpdate() {
        OntologyElement ontologyElement;
        this.getTitle().setText(this.page.getOntologyElement().getHeadword());
        this.textColumn.removeAll();
        Grid grid = new Grid(2);
        grid.setRowHeight(0, new Extent(110));
        grid.setColumnWidth(0, new Extent(100));
        grid.setInsets(new Insets(0, 0, 0, 10));
        this.textColumn.add((Component)grid);
        Grid grid2 = new Grid(2);
        grid2.setInsets(new Insets(5, 1, 20, 2));
        grid2.setBorder(new Border(1, Color.DARKGRAY, 1));
        grid2.setBackground(new Color(245, 245, 245));
        this.textColumn.add((Component)grid2);
        OntologyElement ontologyElement2 = this.page.getOntologyElement();
        if (ontologyElement2 instanceof Individual) {
            ontologyElement = (Individual)ontologyElement2;
            grid.add((Component)new Label((ImageReference)new ResourceImageReference("ch/uzh/ifi/attempto/acewiki/gui/img/individual.png")));
            grid.add((Component)new Label("\"" + ontologyElement.getPrettyWord(1) + "\" is a proper name and represents an individual. " + "There is exactly one thing that has the name \"" + ontologyElement.getPrettyWord(1) + "\". " + "This proper name is used " + (((Individual)ontologyElement).hasDefiniteArticle() ? "with \"the\": \"" + ontologyElement.getPrettyWord(0) + "\"." : "without \"the\".") + " " + (((Individual)ontologyElement).getAbbreviation() != null ? "This proper name has an abbreviation: \"" + ontologyElement.getPrettyWord(2) + "\"." : ""), 2));
            grid2.add((Component)new SolidLabel("word class", 3, 11));
            grid2.add((Component)new SolidLabel("proper name", 2));
            grid2.add((Component)new SolidLabel("word", 3, 11));
            grid2.add((Component)new SolidLabel(ontologyElement.getPrettyWord(1)));
            grid2.add((Component)new SolidLabel("... used with \"the\"", 3, 11));
            grid2.add((Component)new SolidLabel(((Individual)ontologyElement).hasDefiniteArticle(0) ? "yes" : "no", 2));
            grid2.add((Component)new SolidLabel("abbreviation", 3, 11));
            grid2.add((Component)new SolidLabel(((Individual)ontologyElement).getAbbreviation()));
            grid2.add((Component)new SolidLabel("... used with \"the\"", 3, 11));
            if (((Individual)ontologyElement).getAbbreviation() == null) {
                grid2.add((Component)new SolidLabel());
            } else {
                grid2.add((Component)new SolidLabel(((Individual)ontologyElement).hasDefiniteArticle(2) ? "yes" : "no", 2));
            }
        } else if (ontologyElement2 instanceof NounConcept) {
            ontologyElement = (NounConcept)ontologyElement2;
            String string = ontologyElement.getPrettyWord(0);
            String string2 = ontologyElement.getPrettyWord(1);
            grid.add((Component)new Label((ImageReference)new ResourceImageReference("ch/uzh/ifi/attempto/acewiki/gui/img/concept.png")));
            grid.add((Component)new Label("\"" + string + "\" is a noun and represents a type of things. " + "It stands for all things that are " + string2 + ". " + "The singular form is \"" + string + "\" and the plural form is \"" + string2 + "\".", 2));
            grid2.add((Component)new SolidLabel("word class", 3, 11));
            grid2.add((Component)new SolidLabel("noun", 2));
            grid2.add((Component)new SolidLabel("singular", 3, 11));
            grid2.add((Component)new SolidLabel(string));
            grid2.add((Component)new SolidLabel("plural", 3, 11));
            grid2.add((Component)new SolidLabel(string2));
        } else if (ontologyElement2 instanceof VerbRole) {
            ontologyElement = (VerbRole)ontologyElement2;
            String string = ontologyElement.getPrettyWord(0);
            String string3 = ontologyElement.getPrettyWord(1);
            String string4 = ((VerbRole)ontologyElement).getPrettyPastPart();
            grid.add((Component)new Label((ImageReference)new ResourceImageReference("ch/uzh/ifi/attempto/acewiki/gui/img/role.png")));
            grid.add((Component)new Label("\"" + string3 + "\" is a verb and represents a relation between things. " + "It represents the fact that certain things " + string3 + " other things. " + "The third singular form is \"" + string + "\", the bare infinitive form is \"" + string3 + "\", " + "and the past participle form is " + (string4 == null ? "undefined" : "\"" + string4 + "\"") + ".", 2));
            grid2.add((Component)new SolidLabel("word class", 3, 11));
            grid2.add((Component)new SolidLabel("verb", 2));
            grid2.add((Component)new SolidLabel("third singular", 3, 11));
            grid2.add((Component)new SolidLabel(string));
            grid2.add((Component)new SolidLabel("bare infinitive", 3, 11));
            grid2.add((Component)new SolidLabel(string3));
            grid2.add((Component)new SolidLabel("past participle", 3, 11));
            grid2.add((Component)new SolidLabel(string4));
        } else if (ontologyElement2 instanceof OfRole) {
            ontologyElement = (OfRole)ontologyElement2;
            grid.add((Component)new Label((ImageReference)new ResourceImageReference("ch/uzh/ifi/attempto/acewiki/gui/img/role.png")));
            grid.add((Component)new Label("\"" + ((OfRole)ontologyElement).getPrettyNoun() + " of\" is an of-construct and represents a relation between things. " + "It represents the fact that certain things are a " + ((OfRole)ontologyElement).getPrettyNoun() + " of other things. " + "It consists of the noun \"" + ((OfRole)ontologyElement).getPrettyNoun() + "\" plus the preposition \"of\".", 2));
            grid2.add((Component)new SolidLabel("word class", 3, 11));
            grid2.add((Component)new SolidLabel("of-construct", 2));
            grid2.add((Component)new SolidLabel("noun", 3, 11));
            grid2.add((Component)new SolidLabel(((OfRole)ontologyElement).getPrettyNoun()));
        } else if (ontologyElement2 instanceof TrAdjRole) {
            ontologyElement = (TrAdjRole)ontologyElement2;
            grid.add((Component)new Label((ImageReference)new ResourceImageReference("ch/uzh/ifi/attempto/acewiki/gui/img/role.png")));
            grid.add((Component)new Label("\"" + ontologyElement.getPrettyWord(0) + "\" is a transitive adjective and represents a relation between things. " + "It represents the fact that certain things are " + ontologyElement.getPrettyWord(0) + " other things. ", 2));
            grid2.add((Component)new SolidLabel("word class", 3, 11));
            grid2.add((Component)new SolidLabel("transitive adjective", 2));
            grid2.add((Component)new SolidLabel("word", 3, 11));
            grid2.add((Component)new SolidLabel(ontologyElement.getPrettyWord(0)));
        }
        this.textColumn.add((Component)new VSpace());
        ontologyElement = new Row();
        ontologyElement.add((Component)this.editButton);
        ontologyElement.add((Component)new HSpace());
        ontologyElement.add((Component)this.delButton);
        this.textColumn.add((Component)ontologyElement);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Wiki wiki = this.getWiki();
        if ("Article".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: article");
            wiki.showPage(this.page);
        } else if ("References".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: references");
            wiki.showPage(new ReferencesPage(this.page));
        } else if ("Individuals".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: individuals");
            wiki.showPage(new IndividualsPage((ConceptPage)this.page));
        } else if ("Hierarchy".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: hierarchy");
            wiki.showPage(new HierarchyPage((ConceptPage)this.page));
        } else if ("Assignments".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: assignments");
            wiki.showPage(new AssignmentsPage((IndividualPage)this.page));
        } else if (actionEvent.getSource() == this.delButton) {
            this.log("page", "pressed: delete");
            OntologyElement ontologyElement = this.page.getOntologyElement();
            List<Sentence> list = wiki.getOntology().getReferences(ontologyElement);
            for (Sentence sentence : ontologyElement.getSentences()) {
                list.remove(sentence);
            }
            if (!list.isEmpty()) {
                this.log("page", "error: cannot delete article with references");
                wiki.showWindow((WindowPane)new MessageWindow("Error", "This article cannot be deleted, because other articles refer to it.", null, (ActionListener)this, new String[]{"OK"}));
            } else {
                this.log("page", "delete confirmation");
                wiki.showWindow((WindowPane)new MessageWindow("Delete", "Do you really want to delete this word and all the content of its article?", null, (ActionListener)this, new String[]{"Yes", "No"}));
            }
        } else if (actionEvent.getSource() instanceof MessageWindow && actionEvent.getActionCommand().equals("Yes")) {
            this.log("page", "delete confirmed");
            wiki.getOntology().remove(this.page.getOntologyElement());
            wiki.showStartPage();
        } else if (actionEvent.getSource() == this.editButton) {
            this.log("page", "pressed: edit word");
            if (this.page instanceof ConceptPage) {
                wiki.showWindow(NounForm.createEditorWindow((NounConcept)this.page.getOntologyElement(), wiki));
            } else if (this.page instanceof IndividualPage) {
                wiki.showWindow(ProperNameForm.createEditorWindow((Individual)this.page.getOntologyElement(), wiki));
            } else if (this.page.getOntologyElement() instanceof OfRole) {
                wiki.showWindow(NounOfForm.createEditorWindow((OfRole)this.page.getOntologyElement(), wiki));
            } else if (this.page.getOntologyElement() instanceof VerbRole) {
                wiki.showWindow(VerbForm.createEditorWindow((VerbRole)this.page.getOntologyElement(), wiki));
            } else if (this.page.getOntologyElement() instanceof TrAdjRole) {
                wiki.showWindow(TrAdjForm.createEditorWindow((TrAdjRole)this.page.getOntologyElement(), wiki));
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WordPage) {
            return this.page.equals((Object)((WordPage)((Object)object)).page);
        }
        return false;
    }

    public boolean isExpired() {
        return this.page.isExpired();
    }

    public String toString() {
        return "-WORD- " + this.page.getOntologyElement().getWord();
    }
}

