/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.ape;

import ch.uzh.ifi.attempto.ape.ACEParser;
import ch.uzh.ifi.attempto.ape.ACEParserException;
import ch.uzh.ifi.attempto.ape.ACEParserResult;
import ch.uzh.ifi.attempto.ape.Lexicon;
import ch.uzh.ifi.attempto.ape.OutputType;
import ch.uzh.ifi.attempto.ape.PrologUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class APESocket
extends ACEParser {
    private String host;
    private int port;

    public APESocket(String string, int n) {
        this.host = string;
        this.port = n;
    }

    public APESocket(int n) {
        this("localhost", n);
    }

    public ACEParserResult getMultiOutput(String string, Lexicon lexicon, OutputType ... outputTypeArray) {
        String string2 = "";
        if (lexicon != null) {
            string2 = ",ulextext=" + PrologUtils.escape(lexicon.toString());
        }
        String string3 = "text=" + PrologUtils.escape(string) + string2 + this.getOptions();
        for (OutputType outputType : outputTypeArray) {
            string3 = string3 + "," + outputType.toMultiFlag() + "=on";
        }
        return new ACEParserResult(this.getParserResponseAsString(string3));
    }

    public String getSoloOutput(String string, Lexicon lexicon, OutputType outputType) throws ACEParserException {
        String string2 = "";
        if (lexicon != null) {
            string2 = ",ulextext=" + PrologUtils.escape(lexicon.toString());
        }
        String string3 = "text=" + PrologUtils.escape(string) + string2 + ",solo=" + outputType.toSoloFlag() + this.getOptions();
        return APESocket.checkForErrors(this.getParserResponseAsString(string3));
    }

    private String getParserResponseAsString(String string) {
        PrintWriter printWriter;
        BufferedReader bufferedReader;
        Socket socket;
        try {
            socket = new Socket(this.host, this.port);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("Accessing APE socket failed: " + unknownHostException.getMessage());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Accessing APE socket failed: " + iOException.getMessage());
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Accessing APE socket failed: " + iOException.getMessage());
        }
        try {
            printWriter = new PrintWriter(socket.getOutputStream(), true);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Accessing APE socket failed: " + iOException.getMessage());
        }
        printWriter.println("get([" + string + "]).");
        String string2 = "";
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null && !string3.equals("APESERVERSTREAMEND")) {
                string2 = string2 + string3;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Accessing APE socket failed: " + iOException.getMessage());
        }
        try {
            printWriter.close();
            bufferedReader.close();
            socket.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Accessing APE socket failed: " + iOException.getMessage());
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        APESocket aPESocket = new APESocket(5000);
        String string = null;
        try {
            string = aPESocket.getSoloOutput("Every dog's friend is an an animal.", OutputType.PARAPHRASE1);
        }
        catch (ACEParserException aCEParserException) {
            System.out.println(aCEParserException.getMessageContainer().toString());
        }
        if (string != null) {
            System.out.println(string);
        }
        aPESocket.setGuessingEnabled(true);
        ACEParserResult aCEParserResult = aPESocket.getMultiOutput("Every dooog's friend is an animal.", OutputType.PARAPHRASE1);
        System.out.println(aCEParserResult.get(OutputType.PARAPHRASE1));
    }
}

