/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.ape;

import ch.uzh.ifi.attempto.ape.ACEParser;
import ch.uzh.ifi.attempto.ape.ACEParserException;
import ch.uzh.ifi.attempto.ape.ACEParserResult;
import ch.uzh.ifi.attempto.ape.Lexicon;
import ch.uzh.ifi.attempto.ape.OutputType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;

public class APEWebservice
extends ACEParser {
    private String wsUrl;
    private NameValuePair uri = new NameValuePair("uri", "");
    private NameValuePair text = new NameValuePair("text", "");
    private NameValuePair ulextext = new NameValuePair("ulextext", "");
    private NameValuePair solo = new NameValuePair("solo", "owlxml");
    private NameValuePair guess = new NameValuePair("guess", "off");
    private NameValuePair noclex = new NameValuePair("noclex", "off");

    public APEWebservice(String string) {
        this.wsUrl = string;
    }

    public void setWebserviceUrl(String string) {
        this.wsUrl = string;
    }

    public String getSoloOutput(String string, Lexicon lexicon, OutputType outputType) throws ACEParserException {
        this.setText(string);
        this.setUlex(lexicon);
        this.setSolo(outputType);
        return APEWebservice.checkForErrors(this.getParserResponseAsString(new NameValuePair[]{this.text, this.ulextext, this.solo, this.uri, this.guess, this.noclex}));
    }

    public ACEParserResult getMultiOutput(String string, Lexicon lexicon, OutputType ... outputTypeArray) {
        NameValuePair[] nameValuePairArray = new NameValuePair[outputTypeArray.length + 5];
        this.setText(string);
        this.setUlex(lexicon);
        nameValuePairArray[0] = this.text;
        nameValuePairArray[1] = this.ulextext;
        nameValuePairArray[2] = this.uri;
        nameValuePairArray[3] = this.guess;
        nameValuePairArray[4] = this.noclex;
        int n = 5;
        for (OutputType outputType : outputTypeArray) {
            nameValuePairArray[n] = new NameValuePair(outputType.toMultiFlag(), "on");
            ++n;
        }
        return new ACEParserResult(this.getParserResponseAsString(nameValuePairArray));
    }

    public void setURI(String string) {
        super.setURI(string);
        this.uri.setValue(this.getURI());
    }

    public void setGuessingEnabled(boolean bl) {
        super.setGuessingEnabled(bl);
        if (this.isGuessingEnabled()) {
            this.guess.setValue("on");
        } else {
            this.guess.setValue("off");
        }
    }

    public void setClexEnabled(boolean bl) {
        super.setClexEnabled(bl);
        if (this.isClexEnabled()) {
            this.noclex.setValue("off");
        } else {
            this.noclex.setValue("on");
        }
    }

    private void setUlex(Lexicon lexicon) {
        if (lexicon == null) {
            this.ulextext.setValue("");
        } else {
            this.ulextext.setValue(lexicon.toString());
        }
    }

    private void setText(String string) {
        this.text.setValue(string);
    }

    private void setSolo(OutputType outputType) {
        this.solo.setValue(outputType.toSoloFlag());
    }

    private String getParserResponseAsString(NameValuePair[] nameValuePairArray) {
        String string;
        block6: {
            HttpClient httpClient = new HttpClient();
            PostMethod postMethod = new PostMethod(this.wsUrl);
            postMethod.setRequestBody(nameValuePairArray);
            string = null;
            try {
                int n = httpClient.executeMethod((HttpMethod)postMethod);
                if (n == 200) {
                    string = this.inputStreamAsString(postMethod.getResponseBodyAsStream());
                    break block6;
                }
                throw new RuntimeException("HTTP request failed: " + postMethod.getStatusLine() + ": " + this.wsUrl);
            }
            catch (Exception exception) {
                throw new RuntimeException("Accessing APE webservice failed: " + exception.getMessage());
            }
            finally {
                postMethod.releaseConnection();
            }
        }
        return string;
    }

    private String inputStreamAsString(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }
}

