/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.extras.webcontainer;

import java.util.StringTokenizer;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.extras.app.menu.AbstractMenuComponent;
import nextapp.echo2.extras.app.menu.ItemModel;
import nextapp.echo2.extras.app.menu.MenuModel;
import nextapp.echo2.extras.app.menu.MenuStateModel;
import nextapp.echo2.extras.app.menu.OptionModel;
import nextapp.echo2.extras.app.menu.RadioOptionModel;
import nextapp.echo2.extras.app.menu.SeparatorModel;
import nextapp.echo2.extras.app.menu.ToggleOptionModel;
import nextapp.echo2.extras.webcontainer.ExtrasUtil;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.image.ImageTools;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

abstract class AbstractMenuPeer
implements ActionProcessor,
ComponentSynchronizePeer,
ImageRenderSupport {
    static final String IMAGE_PREFIX = "/nextapp/echo2/extras/webcontainer/resource/image/";
    static final ImageReference DEFAULT_ICON_SUBMENU_LEFT = new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/ArrowLeft.gif");
    static final ImageReference DEFAULT_ICON_SUBMENU_RIGHT = new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/ArrowRight.gif");
    static final ImageReference DEFAULT_ICON_TOGGLE_OFF = new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/ToggleOff.gif");
    static final ImageReference DEFAULT_ICON_TOGGLE_ON = new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/ToggleOn.gif");
    static final ImageReference DEFAULT_ICON_RADIO_OFF = new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/RadioOff.gif");
    static final ImageReference DEFAULT_ICON_RADIO_ON = new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/RadioOn.gif");
    static final String IMAGE_ID_BACKGROUND = "background";
    static final String IMAGE_ID_DISABLED_BACKGROUND = "disabledBackground";
    static final String IMAGE_ID_MENU_BACKGROUND = "menuBackground";
    static final String IMAGE_ID_MENU_ITEM_PREFIX = "menuItem.";
    static final String IMAGE_ID_SELECTION_BACKGROUND = "selectionBackground";
    static final String IMAGE_ID_SUBMENU_LEFT = "submenuLeft";
    static final String IMAGE_ID_SUBMENU_RIGHT = "submenuRight";
    static final String IMAGE_ID_TOGGLE_OFF = "toggleOff";
    static final String IMAGE_ID_TOGGLE_ON = "toggleOn";
    static final String IMAGE_ID_RADIO_OFF = "radioOff";
    static final String IMAGE_ID_RADIO_ON = "radioOn";
    public static final Service MENU_SERVICE = JavaScriptService.forResource((String)"Echo2Extras.Menu", (String)"/nextapp/echo2/extras/webcontainer/resource/js/Menu.js");
    PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    public String getContainerId(Component component) {
        throw new UnsupportedOperationException("Component does not support children.");
    }

    public ImageReference getImage(Component component, String imageId) {
        if (IMAGE_ID_SUBMENU_RIGHT.equals(imageId)) {
            return DEFAULT_ICON_SUBMENU_RIGHT;
        }
        if (IMAGE_ID_SUBMENU_LEFT.equals(imageId)) {
            return DEFAULT_ICON_SUBMENU_LEFT;
        }
        if (IMAGE_ID_TOGGLE_OFF.equals(imageId)) {
            return DEFAULT_ICON_TOGGLE_OFF;
        }
        if (IMAGE_ID_TOGGLE_ON.equals(imageId)) {
            return DEFAULT_ICON_TOGGLE_ON;
        }
        if (IMAGE_ID_RADIO_OFF.equals(imageId)) {
            return DEFAULT_ICON_RADIO_OFF;
        }
        if (IMAGE_ID_RADIO_ON.equals(imageId)) {
            return DEFAULT_ICON_RADIO_ON;
        }
        if (imageId.startsWith(IMAGE_ID_MENU_ITEM_PREFIX)) {
            String itemPath = imageId.substring(IMAGE_ID_MENU_ITEM_PREFIX.length());
            ItemModel itemModel = this.getItemModel((AbstractMenuComponent)component, itemPath);
            if (itemModel instanceof MenuModel) {
                return ((MenuModel)itemModel).getIcon();
            }
            if (itemModel instanceof OptionModel) {
                return ((OptionModel)itemModel).getIcon();
            }
            return null;
        }
        return null;
    }

    ItemModel getItemModelById(AbstractMenuComponent menu, String id) {
        return this.getItemModelById(menu.getModel(), id);
    }

    private ItemModel getItemModelById(MenuModel menuModel, String id) {
        int size = menuModel.getItemCount();
        for (int i = 0; i < size; ++i) {
            ItemModel itemModel = menuModel.getItem(i);
            if (id.equals(itemModel.getId())) {
                return itemModel;
            }
            if (!(itemModel instanceof MenuModel) || (itemModel = this.getItemModelById((MenuModel)itemModel, id)) == null) continue;
            return itemModel;
        }
        return null;
    }

    ItemModel getItemModel(AbstractMenuComponent menu, String itemPath) {
        MenuModel itemModel = menu.getModel();
        StringTokenizer st = new StringTokenizer(itemPath, ".");
        while (st.hasMoreTokens()) {
            int index = Integer.parseInt(st.nextToken());
            itemModel = itemModel.getItem(index);
        }
        return itemModel;
    }

    String getItemPath(MenuModel menuModel, ItemModel targetItemModel) {
        StringBuffer out = new StringBuffer();
        this.getItemPath(menuModel, targetItemModel, out);
        return out.length() == 0 ? null : out.toString();
    }

    void getItemPath(MenuModel menuModel, ItemModel targetItemModel, StringBuffer out) {
        int itemCount = menuModel.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            ItemModel currentItemModel = menuModel.getItem(i);
            if (targetItemModel.equals(currentItemModel)) {
                out.append(i);
                return;
            }
            if (currentItemModel instanceof MenuModel) {
                this.getItemPath((MenuModel)currentItemModel, targetItemModel, out);
            }
            if (out.length() == 0) continue;
            out.insert(0, i + ".");
            return;
        }
    }

    public void processAction(ContainerInstance ci, Component component, Element element) {
        AbstractMenuComponent menu = (AbstractMenuComponent)component;
        String actionName = element.getAttribute("name");
        String actionValue = element.getAttribute("value");
        if ("select".equals(actionName)) {
            ItemModel itemModel = this.getItemModel((AbstractMenuComponent)component, actionValue);
            if (!(itemModel instanceof MenuModel) && !(itemModel instanceof OptionModel)) {
                return;
            }
            ci.getUpdateManager().getClientUpdateManager().setComponentAction((Component)menu, "select", (Object)itemModel);
        }
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(ExtrasUtil.JS_EXTRAS_UTIL_SERVICE.getId());
        serverMessage.addLibrary(MENU_SERVICE.getId());
        AbstractMenuComponent menu = (AbstractMenuComponent)component;
        this.renderInitDirective(rc, (Component)menu, targetId);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(ExtrasUtil.JS_EXTRAS_UTIL_SERVICE.getId());
        serverMessage.addLibrary(MENU_SERVICE.getId());
        this.renderDisposeDirective(rc, (Component)((AbstractMenuComponent)component));
    }

    abstract void renderInitDirective(RenderContext var1, Component var2, String var3);

    abstract void renderDisposeDirective(RenderContext var1, Component var2);

    void renderModel(RenderContext rc, AbstractMenuComponent menu, MenuModel menuModel, Element parentElement) {
        Document document = rc.getServerMessage().getDocument();
        Element menuModelElement = document.createElement("menu");
        MenuStateModel stateModel = menu.getStateModel();
        if (menuModel.getText() != null) {
            menuModelElement.setAttribute("text", menuModel.getText());
        }
        if (menuModel.getIcon() != null) {
            String itemPath = this.getItemPath(menu.getModel(), (ItemModel)menuModel);
            menuModelElement.setAttribute("icon", ImageTools.getUri((RenderContext)rc, (ImageRenderSupport)this, (Component)menu, (String)(IMAGE_ID_MENU_ITEM_PREFIX + itemPath)));
        }
        if (menuModel.getId() != null && !stateModel.isEnabled(menuModel.getId())) {
            menuModelElement.setAttribute("enabled", "false");
        }
        int length = menuModel.getItemCount();
        for (int i = 0; i < length; ++i) {
            ItemModel itemModel = menuModel.getItem(i);
            if (itemModel instanceof MenuModel) {
                this.renderModel(rc, menu, (MenuModel)itemModel, menuModelElement);
                continue;
            }
            if (itemModel instanceof OptionModel) {
                Element optionModelElement = document.createElement("option");
                OptionModel optionModel = (OptionModel)itemModel;
                if (optionModel.getId() != null && !stateModel.isEnabled(optionModel.getId())) {
                    optionModelElement.setAttribute("enabled", "false");
                }
                if (optionModel instanceof ToggleOptionModel) {
                    if (optionModel instanceof RadioOptionModel) {
                        optionModelElement.setAttribute("type", "radio");
                    } else {
                        optionModelElement.setAttribute("type", "toggle");
                    }
                    if (stateModel != null && stateModel.isSelected(((ToggleOptionModel)optionModel).getId())) {
                        optionModelElement.setAttribute("selected", "true");
                    }
                } else {
                    optionModelElement.setAttribute("type", "default");
                }
                if (optionModel.getText() != null) {
                    optionModelElement.setAttribute("text", optionModel.getText());
                }
                if (optionModel.getIcon() != null) {
                    String itemPath = this.getItemPath(menu.getModel(), (ItemModel)optionModel);
                    optionModelElement.setAttribute("icon", ImageTools.getUri((RenderContext)rc, (ImageRenderSupport)this, (Component)menu, (String)(IMAGE_ID_MENU_ITEM_PREFIX + itemPath)));
                }
                menuModelElement.appendChild(optionModelElement);
                continue;
            }
            if (!(itemModel instanceof SeparatorModel)) continue;
            menuModelElement.appendChild(document.createElement("separator"));
        }
        parentElement.appendChild(menuModelElement);
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        if (this.partialUpdateManager.canProcess(rc, update)) {
            this.partialUpdateManager.process(rc, update);
        } else {
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId((Component)update.getParent()));
            this.renderAdd(rc, update, targetId, update.getParent());
        }
        return true;
    }

    static {
        WebRenderServlet.getServiceRegistry().add(MENU_SERVICE);
    }
}

