/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.chartparser;

import ch.uzh.ifi.attempto.chartparser.Nonterminal;
import ch.uzh.ifi.attempto.chartparser.StringEntity;
import ch.uzh.ifi.attempto.chartparser.StringRef;
import ch.uzh.ifi.attempto.chartparser.Terminal;
import ch.uzh.ifi.attempto.chartparser.UnificationFailedException;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Category {
    private static int skNumber = 0;
    private final String name;
    private HashMap<String, StringRef> features = new HashMap();

    public Category(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setFeature(String string, StringRef stringRef) {
        this.features.put(string, stringRef);
    }

    public StringRef getFeature(String string) {
        StringRef stringRef = this.features.get(string);
        if (stringRef == null) {
            stringRef = new StringRef();
            this.features.put(string, stringRef);
        }
        return stringRef;
    }

    public void unify(Category category) throws UnificationFailedException {
        if (!this.name.equals(category.name)) {
            throw new UnificationFailedException();
        }
        for (String string : this.features.keySet()) {
            this.getFeature(string).unify(category.getFeature(string));
        }
        for (String string : category.features.keySet()) {
            this.getFeature(string).unify(category.getFeature(string));
        }
    }

    public void tryToUnify(Category category) throws UnificationFailedException {
        if (!this.name.equals(category.name)) {
            throw new UnificationFailedException();
        }
        for (String string : this.features.keySet()) {
            this.features.get(string).unify(category.getFeature(string));
        }
    }

    public void skolemize() {
        for (String string : this.features.keySet()) {
            StringRef stringRef = this.features.get(string);
            if (stringRef.getString() != null) continue;
            try {
                stringRef.unify(new StringRef("$SK" + skNumber++));
            }
            catch (UnificationFailedException unificationFailedException) {}
        }
    }

    public Category deepCopy() {
        return this.deepCopy(new HashMap<Integer, StringEntity>());
    }

    public Category deepCopy(HashMap<Integer, StringEntity> hashMap) {
        Category category = this instanceof Terminal ? new Terminal(this.name) : new Nonterminal(this.name);
        for (String string : this.features.keySet()) {
            StringRef stringRef = this.features.get(string);
            StringEntity stringEntity = hashMap.get(stringRef.getID());
            if (stringEntity != null) {
                category.setFeature(string, stringEntity.newStringRef());
                continue;
            }
            StringRef stringRef2 = new StringRef(stringRef.getString());
            category.setFeature(string, stringRef2);
            hashMap.put(stringRef.getID(), stringRef2.getStringEntity());
        }
        return category;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Category)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public String toString() {
        String string = this.name;
        Set<String> set = this.features.keySet();
        if (set.size() > 0) {
            string = string + "(";
        }
        for (String string2 : this.features.keySet()) {
            StringRef stringRef = this.features.get(string2);
            string = string + string2 + ":";
            string = stringRef.getString() == null ? string + stringRef.getID() : string + stringRef.getString();
            string = string + ",";
        }
        if (set.size() > 0) {
            string = string.substring(0, string.length() - 1) + ")";
        }
        return string;
    }
}

