/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.chartparser;

import ch.uzh.ifi.attempto.chartparser.Category;
import ch.uzh.ifi.attempto.chartparser.Chart;
import ch.uzh.ifi.attempto.chartparser.Edge;
import ch.uzh.ifi.attempto.chartparser.Grammar;
import ch.uzh.ifi.attempto.chartparser.Nonterminal;
import ch.uzh.ifi.attempto.chartparser.Rule;
import ch.uzh.ifi.attempto.chartparser.StringEntity;
import ch.uzh.ifi.attempto.chartparser.Terminal;
import ch.uzh.ifi.attempto.chartparser.UnificationFailedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartParser {
    private final Grammar grammar;
    private final Chart chart = new Chart();
    private final ArrayList<Terminal> tokens = new ArrayList();
    private boolean debug;

    public ChartParser(Grammar grammar) {
        this.grammar = grammar;
        this.init(grammar.getStartCategory());
        this.completeAndPredict();
    }

    public void debug(boolean bl) {
        this.debug = bl;
    }

    public void addToken(String string) {
        Terminal terminal = new Terminal(string);
        this.tokens.add(terminal);
        Edge edge = new Edge(this.tokens.size() - 1, this.tokens.size(), terminal, true);
        this.chart.addEdge(edge);
        if (this.debug) {
            System.err.println("SCANNER: " + edge);
        }
        this.completeAndPredict();
    }

    public void addTokens(List<String> list) {
        for (String string : list) {
            this.addToken(string);
        }
    }

    public void removeToken() {
        this.chart.removeEdgesWithEndPos(this.tokens.size());
        this.tokens.remove(this.tokens.size() - 1);
    }

    public void removeAllTokens() {
        this.tokens.clear();
        this.chart.clear();
        this.init(this.grammar.getStartCategory());
        this.completeAndPredict();
    }

    public List<Terminal> getTokens() {
        return new ArrayList<Terminal>(this.tokens);
    }

    public List<Terminal> nextTokens() {
        ArrayList<Terminal> arrayList = new ArrayList<Terminal>();
        if (this.debug) {
            System.err.print("LOOKING FORWARD:");
        }
        for (Edge edge : this.chart.getEdgesByEndPos(this.tokens.size(), true)) {
            Terminal terminal;
            if (!edge.isActive() || !(edge.getNextActive() instanceof Terminal) || arrayList.contains(terminal = (Terminal)edge.getNextActive())) continue;
            if (this.debug) {
                System.err.print(" " + terminal);
            }
            arrayList.add(terminal);
        }
        if (this.debug) {
            System.err.println();
        }
        return arrayList;
    }

    public boolean[] getAccessiblePositions(String string) {
        boolean[] blArray = new boolean[this.tokens.size()];
        ArrayList<ArrayList<Edge>> arrayList = new ArrayList<ArrayList<Edge>>();
        for (Edge object2 : this.chart.getEdgesByEndPosAndActCat(this.tokens.size(), string, false)) {
            if (!object2.isActive()) continue;
            ArrayList<Edge> arrayList2 = new ArrayList<Edge>();
            arrayList2.add(object2.deepCopy());
            this.collectActivePaths(0, arrayList2, arrayList);
        }
        for (ArrayList arrayList3 : arrayList) {
            for (Edge edge : arrayList3) {
                this.scanForAccessiblePositions(edge, blArray, new ArrayList<Edge>());
            }
        }
        return blArray;
    }

    private void scanForAccessiblePositions(Edge edge, boolean[] blArray, ArrayList<Edge> arrayList) {
        if (edge.getStartPos() == edge.getEndPos()) {
            return;
        }
        if (edge.getBody().length == 0 && edge.getHead() instanceof Terminal) {
            blArray[edge.getStartPos()] = true;
            return;
        }
        for (Edge edge2 : edge.getLinks()) {
            if (!edge2.isAccessible() || arrayList.contains(edge2)) continue;
            arrayList.add(edge2);
            this.scanForAccessiblePositions(edge2, blArray, arrayList);
        }
    }

    private void collectActivePaths(int n, ArrayList<Edge> arrayList, ArrayList<ArrayList<Edge>> arrayList2) {
        Object object;
        Object object2;
        Edge edge = arrayList.get(arrayList.size() - 1);
        if (edge.getStartPos() == n) {
            arrayList2.add(arrayList);
            return;
        }
        if (edge.getStartPos() < n) {
            return;
        }
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (Edge edge2 : this.chart.getEdgesByEndPosAndActCat(edge.getStartPos(), edge.getHead().getName(), false)) {
            object2 = new Category[edge2.getProgress() + 1];
            System.arraycopy(edge2.getBody(), 0, object2, 0, edge2.getProgress() + 1);
            object = new Edge(edge2.getStartPos(), edge2.getEndPos(), edge2.getHead(), (Category[])object2, edge2.getProgress(), true);
            ((Edge)object).addLinksFrom(edge2);
            boolean edge4 = true;
            for (Edge edge3 : arrayList3) {
                if (!edge3.subsumes((Edge)object)) continue;
                edge4 = false;
                break;
            }
            if (!edge4) continue;
            for (Edge edge5 : arrayList3) {
                if (!((Edge)object).subsumes(edge5)) continue;
                arrayList3.remove(edge5);
            }
            arrayList3.add(object);
        }
        for (Edge edge6 : arrayList3) {
            try {
                object2 = edge6.deepCopy();
                object = this.copyEdgeList(arrayList);
                Edge edge7 = ((ArrayList)object).get(arrayList.size() - 1);
                edge7.getHead().unify(((Edge)object2).getNextActive());
                ((ArrayList)object).add((Edge)object2);
                this.collectActivePaths(n, (ArrayList<Edge>)object, arrayList2);
            }
            catch (UnificationFailedException unificationFailedException) {}
        }
    }

    private ArrayList<Edge> copyEdgeList(ArrayList<Edge> arrayList) {
        ArrayList<Edge> arrayList2 = new ArrayList<Edge>();
        HashMap<Integer, StringEntity> hashMap = new HashMap<Integer, StringEntity>();
        for (Edge edge : arrayList) {
            arrayList2.add(edge.deepCopy(hashMap));
        }
        return arrayList2;
    }

    private void init(Nonterminal nonterminal) {
        for (Rule rule : this.grammar.getRulesByHeadName(nonterminal.getName())) {
            try {
                Nonterminal nonterminal2 = (Nonterminal)nonterminal.deepCopy();
                Rule rule2 = rule.deepCopy();
                nonterminal2.unify(rule2.getHead());
                Edge edge = new Edge(0, 0, rule2.getHead(), rule2.getBody(), rule2.isAccessible());
                this.chart.addEdge(edge);
                if (!this.debug) continue;
                System.err.println("INIT: " + rule + "  >>>  " + edge);
            }
            catch (UnificationFailedException unificationFailedException) {}
        }
    }

    private void completeAndPredict() {
        int n = 0;
        do {
            this.complete();
        } while ((n = this.predict()) > 0);
    }

    private int predict() {
        Object object;
        int n = 0;
        for (Edge object2 : this.chart.getEdgesByEndPos(this.tokens.size(), true)) {
            object = object2.getNextActive();
            if (object == null) continue;
            if (this.debug) {
                System.err.println("PREDICT FOR EDGE: " + object2);
            }
            this.predict((Category)object);
        }
        for (Rule rule : this.grammar.getEpsilonRules()) {
            object = new Edge(this.tokens.size(), this.tokens.size(), rule.getHead(), rule.isAccessible());
            boolean bl = this.chart.addEdge((Edge)object);
            if (bl) {
                ++n;
            }
            if (!this.debug) continue;
            System.err.println("EDGE FOR EPSILON RULE: " + object);
        }
        return n;
    }

    private void predict(Category category) {
        for (Rule rule : this.grammar.getRulesByHeadName(category.getName())) {
            if (rule.hasEmptyBody()) continue;
            try {
                boolean bl;
                Category category2 = category.deepCopy();
                Rule rule2 = rule.deepCopy();
                category2.unify(rule2.getHead());
                int n = this.tokens.size();
                Edge edge = new Edge(n, n, rule2.getHead(), rule2.getBody(), rule2.isAccessible());
                if (this.debug) {
                    System.err.println("PREDICTOR: " + rule + "  >>>  " + edge);
                }
                if (!(bl = this.chart.addEdge(edge))) continue;
                if (this.debug) {
                    System.err.println("PREDICT FOR EDGE: " + edge);
                }
                this.predict(edge.getNextActive());
            }
            catch (UnificationFailedException unificationFailedException) {}
        }
    }

    private void complete() {
        for (Edge edge : this.chart.getEdgesByEndPosAndActCat(this.tokens.size(), null, true)) {
            if (this.debug) {
                System.err.println("COMPLETE FOR EDGE: " + edge);
            }
            this.complete(edge.getStartPos(), edge);
        }
    }

    private void complete(int n, Edge edge) {
        Category category = edge.getHead();
        for (Edge edge2 : this.chart.getEdgesByEndPosAndActCat(n, category.getName(), n == this.tokens.size())) {
            if (!edge2.isActive()) continue;
            try {
                boolean bl;
                Category category2 = category.deepCopy();
                Edge edge3 = edge2.deepCopy();
                category2.unify(edge3.getNextActive());
                edge3.step(this.tokens.size(), edge);
                if (this.debug) {
                    System.err.println("COMPLETOR: " + edge2 + "  >>>  " + edge3);
                }
                if (!(bl = this.chart.addEdge(edge3)) || edge3.isActive()) continue;
                this.complete(edge3.getStartPos(), edge3);
            }
            catch (UnificationFailedException unificationFailedException) {}
        }
    }
}

