/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.chartparser;

import ch.uzh.ifi.attempto.chartparser.Category;
import ch.uzh.ifi.attempto.chartparser.StringEntity;
import ch.uzh.ifi.attempto.chartparser.UnificationFailedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Edge {
    private int startPos;
    private int endPos;
    private Category head;
    private Category[] body;
    private int progress;
    private boolean accessible;
    private HashSet<Edge> links = new HashSet();

    private Edge() {
    }

    public Edge(int n, int n2, Category category, Category[] categoryArray, int n3, boolean bl) {
        this.accessible = bl;
        this.startPos = n;
        this.endPos = n2;
        this.head = category;
        this.body = (Category[])categoryArray.clone();
        this.progress = n3;
    }

    public Edge(int n, int n2, Category category, Category[] categoryArray, boolean bl) {
        this.accessible = bl;
        this.startPos = n;
        this.endPos = n2;
        this.head = category;
        this.body = (Category[])categoryArray.clone();
        this.progress = 0;
    }

    public Edge(int n, int n2, Category category, boolean bl) {
        this.accessible = bl;
        this.startPos = n;
        this.endPos = n2;
        this.head = category;
        this.body = new Category[0];
        this.progress = 0;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public Category getHead() {
        return this.head;
    }

    public Category[] getBody() {
        return this.body;
    }

    public int getProgress() {
        return this.progress;
    }

    public Set<Edge> getLinks() {
        return this.links;
    }

    public boolean isActive() {
        return this.body.length > this.progress;
    }

    public boolean isAccessible() {
        return this.accessible;
    }

    public Category getNextActive() {
        if (!this.isActive()) {
            return null;
        }
        return this.body[this.progress];
    }

    public void step(int n, Edge edge) {
        if (!this.isActive()) {
            throw new RuntimeException("Passive edge");
        }
        this.links.add(edge);
        ++this.progress;
        this.endPos = n;
    }

    public String toString() {
        String string = "<" + this.startPos + "," + this.endPos + "> " + this.head + " ";
        string = this.accessible ? string + "=>" : string + "~>";
        for (int i = 0; i < this.body.length; ++i) {
            if (i == this.progress) {
                string = string + " .";
            }
            string = string + " " + this.body[i];
        }
        if (!this.isActive()) {
            string = string + " .";
        }
        return string;
    }

    public Edge deepCopy() {
        return this.deepCopy(new HashMap<Integer, StringEntity>());
    }

    public Edge deepCopy(HashMap<Integer, StringEntity> hashMap) {
        Edge edge = new Edge();
        edge.startPos = this.startPos;
        edge.endPos = this.endPos;
        edge.progress = this.progress;
        edge.accessible = this.accessible;
        edge.head = this.head.deepCopy(hashMap);
        edge.body = new Category[this.body.length];
        for (int i = 0; i < this.body.length; ++i) {
            edge.body[i] = this.body[i].deepCopy(hashMap);
        }
        edge.addLinksFrom(this);
        return edge;
    }

    public void addLinksFrom(Edge edge) {
        this.links = new HashSet<Edge>(edge.links);
    }

    public void skolemize() {
        this.head.skolemize();
        for (Category category : this.body) {
            category.skolemize();
        }
    }

    public void unify(Edge edge) throws UnificationFailedException {
        if (this.accessible != edge.accessible) {
            throw new UnificationFailedException();
        }
        if (this.body.length != edge.body.length) {
            throw new UnificationFailedException();
        }
        if (this.progress != edge.progress) {
            throw new UnificationFailedException();
        }
        this.head.unify(edge.head);
        for (int i = 0; i < this.body.length; ++i) {
            this.body[i].unify(edge.body[i]);
        }
    }

    public void tryToUnify(Edge edge) throws UnificationFailedException {
        if (this.accessible != edge.accessible) {
            throw new UnificationFailedException();
        }
        if (this.body.length != edge.body.length) {
            throw new UnificationFailedException();
        }
        if (this.progress != edge.progress) {
            throw new UnificationFailedException();
        }
        this.head.tryToUnify(edge.head);
        for (int i = 0; i < this.body.length; ++i) {
            this.body[i].tryToUnify(edge.body[i]);
        }
    }

    public boolean isSimilar(Edge edge) {
        if (this.accessible != edge.accessible) {
            return false;
        }
        if (this.startPos != edge.startPos) {
            return false;
        }
        if (this.endPos != edge.endPos) {
            return false;
        }
        if (!this.head.getName().equals(edge.head.getName())) {
            return false;
        }
        if (this.body.length != edge.body.length || this.progress != edge.progress) {
            return false;
        }
        for (int i = 0; i < this.body.length; ++i) {
            if (this.body[i].getName().equals(edge.body[i].getName())) continue;
            return false;
        }
        return true;
    }

    public boolean subsumes(Edge edge) {
        if (!this.isSimilar(edge)) {
            return false;
        }
        Edge edge2 = this.deepCopy();
        Edge edge3 = edge.deepCopy();
        edge3.skolemize();
        try {
            edge2.tryToUnify(edge3);
            return true;
        }
        catch (UnificationFailedException unificationFailedException) {
            return false;
        }
    }
}

