// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.acewiki;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.webcontainer.WebContainerServlet;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Ontology;
import ch.uzh.ifi.attempto.ape.APELocal;

/**
 * This servlet class is used by the web server to start AceWiki.
 * In order to run the AceWiki servlet, a web application archive (WAR) file has to be created.
 * See the <a href="{@docRoot}/README.txt">README file of the Attempto Java Packages</a> and the
 * <a href="{@docRoot}/ch/uzh/ifi/attempto/acewiki/web.xml">web.xml example file</a>.
 *<p>
 * SWI Prolog needs to be installed on the server and you need to have a compiled version of the Attempto APE
 * distribution. See the documentation of {@link APELocal} for more information.
 * 
 * @author Tobias Kuhn
 */
public class AceWikiServlet extends WebContainerServlet {
	
	private static final long serialVersionUID = -7342857942059126499L;
	
	/**
	 * Creates a new AceWiki servlet object.
	 */
	public AceWikiServlet() {
	}
	
	public ApplicationInstance newApplicationInstance() {
		String ontologyName = getInitParameter("ontology");
		String baseURI = getInitParameter("baseuri");
		String title = getInitParameter("title");
		String description = getInitParameter("description");
		String loginString = getInitParameter("login");
		int login;
		
		if (loginString == null) loginString = "no";
		if (loginString.equals("yes") || loginString.equals("pw")) {
			login = AceWikiApp.PW_LOGIN;
		} else if (loginString.equals("nonpw")) {
			login = AceWikiApp.NONPW_LOGIN;
		} else {
			login = AceWikiApp.NO_LOGIN;
		}
		
		if (!APELocal.isInitialized()) {
			String prologCommand = getServletContext().getInitParameter("prologcommand");
			String apeCommand = getServletContext().getInitParameter("apecommand");
			if (prologCommand == null) prologCommand = "swipl";
			if (apeCommand == null) apeCommand = "ape.exe";
			APELocal.init(prologCommand, apeCommand);
		}
		
		Ontology ontology = Ontology.loadOntology(ontologyName, baseURI);
		
		Logger.log("syst", "syst", 0, "appl", "new application instance: " + ontologyName);
		return new AceWikiApp(ontology, title, description, login);
	}
	
	protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		try {
			super.process(request, response);
		} catch (RuntimeException ex) {
			Logger.log("syst", "syst", 0, "fail", "fatal error: " + ex);
			ex.printStackTrace();
			throw ex;
		} catch (IOException ex) {
			Logger.log("syst", "syst", 0, "fail", "fatal error: " + ex);
			ex.printStackTrace();
			throw ex;
		} catch (ServletException ex) {
			Logger.log("syst", "syst", 0, "fail", "fatal error: " + ex);
			ex.printStackTrace();
			throw ex;
		}
	}
	
	// This was a try to support specific URLs for each wiki articles:
	/*
	protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		String pageParameter = request.getParameter("page");
		if (app != null && pageParameter != null) {
			final OntologyElement oe = app.getWiki().getOntology().get(request.getParameter("page"));
			if (taskQueue == null) {
				taskQueue = app.createTaskQueue();
			}
			if (oe != null) {
				app.enqueueTask(taskQueue, new Runnable() {
					public void run() {
						app.getWiki().showPage(oe);
					}
				});
				try {wait(500);} catch (Exception ex) {}
			}
		}
		
		super.process(request, response);
	}
	*/

}