// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

/**
 * This package contains the grammar that is used by AceWiki. The actual grammar is stored in the
 * Prolog file "grammar.pl". On the basis of this file, the {@link ch.uzh.ifi.attempto.chartparser.Grammar}-class
 * {@link ch.uzh.ifi.attempto.acewiki.core.grammar.StandardGrammar} and the Prolog DCG grammar "dcg.pl" are
 * automatically generated.
 * <p>
 * The script "reduce_dcg" is used to reduce the DCG grammar in a way that it keeps all its complexity but loses
 * some syntactic sugar. The reduced grammar is stored in "dcg_r.pl". This reduced grammar is only used for
 * regression testing. The script "generate_sentences" uses this grammar and generates all sentences up to a
 * certain length. Those sentences are stored in "sentences.txt" which enables to track changes.
 * 
 * @author Tobias Kuhn
 */
package ch.uzh.ifi.attempto.acewiki.core.grammar;
