// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.acewiki.core.text;

import ch.uzh.ifi.attempto.acewiki.core.ontology.NounConcept;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.preditor.text.NounTextElement;

/**
 * This is a subclass of NounTextElement that links to an ontology element.
 * 
 * @author Tobias Kuhn
 */
class NounTextElem extends NounTextElement implements OntologyTextElement {

	private NounConcept nounConcept;
	
	NounTextElem(NounConcept nounConcept) {
		super("", "NOUN");
		this.nounConcept = nounConcept;
	}
	
	public String getUnderscoredText() {
		return nounConcept.getWord();
	}
	
	public String getText() {
		return nounConcept.getPrettyWord(0);
	}
	
	public int getWordNumber() {
		return 0;
	}

	public OntologyElement getOntologyElement() {
		return nounConcept;
	}
	
	public boolean equals(Object obj) {
		if (obj instanceof NounTextElem) {
			return (nounConcept == ((NounTextElem) obj).nounConcept);
		}
		return false;
	}
	
}
